# Generated by Django 2.2.9 on 2020-07-16 22:53

import api_basebone.core.fields
from django.db import migrations, models


def update_value_json(apps, schema_editor):
    print('更新update_value_json')
    Setting = apps.get_app_config('bsm_config').get_model('Setting')
    manager = Setting.objects.using(schema_editor.connection.alias)
    settings = manager.all()
    updata_settings = []
    for setting in settings:
        if setting.value:
            bool_mapping = {'True': True, 'False': False }
            setting.value_json = {"value": bool_mapping[setting.value] if setting.value in bool_mapping else setting.value }
            updata_settings.append(setting)
    manager.bulk_update(updata_settings, ['value_json'])


class Migration(migrations.Migration):

    dependencies = [
        ('bsm_config', '0024_setting_extra_data'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='setting',
            name='display_name',
        ),
        migrations.RemoveField(
            model_name='setting',
            name='extra_data',
        ),
        migrations.RemoveField(
            model_name='setting',
            name='help_text',
        ),
        migrations.RemoveField(
            model_name='setting',
            name='is_admin',
        ),
        migrations.RemoveField(
            model_name='setting',
            name='type',
        ),
        migrations.AddField(
            model_name='setting',
            name='groups',
            field=api_basebone.core.fields.JSONField(default=[], verbose_name='指定角色可看'),
        ),
        migrations.AddField(
            model_name='setting',
            name='value_json',
            field=api_basebone.core.fields.JSONField(default={}, verbose_name='配置值'),
        ),
        migrations.AlterField(
            model_name='setting',
            name='key',
            field=models.CharField(max_length=100, unique=True, verbose_name='配置键'),
        ),
        migrations.RunPython(update_value_json, reverse_code=migrations.RunPython.noop)
    ]
