# Generated by Django 2.1.3 on 2019-09-10 08:36

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('api_basebone', '0002_auto_20190524_1155'),
    ]

    operations = [
        migrations.CreateModel(
            name='Api',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.SlugField(unique=True, verbose_name='接口标识')),
                ('app', models.CharField(max_length=50, verbose_name='app名字')),
                ('model', models.CharField(max_length=50, verbose_name='数据模型名字')),
                ('operation', models.CharField(choices=[('list', '查看'), ('create', '新建'), ('update', '全部更新'), ('replace', '部分更新'), ('delete', '删除'), ('batch_update', '批量更新'), ('batch_delete', '批量删除'), ('func', '云函数')], max_length=20, verbose_name='操作')),
                ('ordering', models.CharField(blank=True, default='', max_length=50, verbose_name='排序')),
                ('func_name', models.CharField(blank=True, default='', max_length=50, verbose_name='云函数名称')),
            ],
            options={
                'verbose_name': 'Api接口模型',
                'verbose_name_plural': 'Api接口模型',
            },
        ),
        migrations.CreateModel(
            name='Field',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200, verbose_name='字段名')),
                ('value', models.CharField(max_length=100, verbose_name='赋值')),
                ('api', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='api_basebone.Api', verbose_name='api')),
            ],
            options={
                'verbose_name': 'API的字段',
                'verbose_name_plural': 'API的字段',
            },
        ),
        migrations.CreateModel(
            name='Filter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.IntegerField(choices=[('CONTAINER', '容器'), ('CHILD', '单一条件')], verbose_name='条件类型')),
                ('name', models.CharField(max_length=50, verbose_name='条件字段名')),
                ('operator', models.CharField(choices=[('and', '与'), ('or', '或'), ('>', '大于'), ('>=', '大于等于'), ('<', '小于'), ('<=', '小于等于'), ('=', '等于'), ('in', '在列表范围内'), ('startswith', '以某字符串开始'), ('endswith', '以某字符串结束'), ('contains', '包含'), ('icontains', '包含（无视大小写）'), ('between', '起止范围'), ('isnull', '为空')], max_length=20, verbose_name='条件判断符')),
                ('value', models.CharField(max_length=100, verbose_name='条件值')),
                ('api', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api_basebone.Api', verbose_name='api')),
                ('parenet', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api_basebone.Filter', verbose_name='parenet')),
            ],
            options={
                'verbose_name': 'API的查询条件',
                'verbose_name_plural': 'API的查询条件',
            },
        ),
        migrations.CreateModel(
            name='Parameter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, verbose_name='参数名')),
                ('desc', models.CharField(max_length=100, verbose_name='备注')),
                ('type', models.CharField(max_length=100, verbose_name='参数类型')),
                ('required', models.BooleanField(default=True, verbose_name='是否必填')),
                ('default', models.CharField(default='', max_length=50, null=True, verbose_name='默认值')),
                ('api', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='api_basebone.Api', verbose_name='api')),
            ],
            options={
                'verbose_name': '参数',
                'verbose_name_plural': '参数',
            },
        ),
    ]
