# coding: utf-8

"""
    IGVF Project API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 61.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class AnalysisStep(BaseModel):
    """
    A step in a computational analysis workflow. For example, a sequence alignment step that represents the phase of the computational analysis in which sequenced reads are being aligned to the reference genome.
    """ # noqa: E501
    release_timestamp: Optional[StrictStr] = Field(default=None, description="The date the object was released.")
    status: Optional[StrictStr] = Field(default=None, description="The status of the metadata object.")
    lab: Optional[StrictStr] = Field(default=None, description="Lab associated with the submission.")
    award: Optional[StrictStr] = Field(default=None, description="Grant associated with the submission.")
    schema_version: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The version of the JSON schema that the server uses to validate the object.")
    uuid: Optional[StrictStr] = Field(default=None, description="The unique identifier associated with every object.")
    notes: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="DACC internal notes.")
    aliases: Optional[List[Annotated[str, Field(strict=True)]]] = Field(default=None, description="Lab specific identifiers to reference an object.")
    creation_timestamp: Optional[StrictStr] = Field(default=None, description="The date the object was created.")
    submitted_by: Optional[StrictStr] = Field(default=None, description="The user who submitted the object.")
    submitter_comment: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Additional information specified by the submitter to be displayed as a comment on the portal.")
    description: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="A plain text description of the object.")
    analysis_step_types: Optional[List[StrictStr]] = Field(default=None, description="The classification of the software.")
    step_label: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Unique lowercased label of the analysis step that includes the relevant assays, the software used, and the purpose of the step, e.g. rampage-grit-peak-calling-step")
    title: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The preferred viewable name of the analysis step, likely the same as the step label.")
    workflow: Optional[StrictStr] = Field(default=None, description="The computational workflow in which this analysis step belongs.")
    parents: Optional[List[StrictStr]] = Field(default=None, description="The precursor steps.")
    input_content_types: Optional[List[StrictStr]] = Field(default=None, description="The content types used as input for the analysis step.")
    output_content_types: Optional[List[StrictStr]] = Field(default=None, description="The content types produced as output by the analysis step.")
    id: Optional[StrictStr] = Field(default=None, alias="@id")
    type: Optional[List[StrictStr]] = Field(default=None, alias="@type")
    summary: Optional[StrictStr] = Field(default=None, description="A summary of the object.")
    name: Optional[StrictStr] = Field(default=None, description="Full name of the analysis step.")
    analysis_step_versions: Optional[List[StrictStr]] = Field(default=None, description="The analysis step versions associated with this analysis step.")
    __properties: ClassVar[List[str]] = ["release_timestamp", "status", "lab", "award", "schema_version", "uuid", "notes", "aliases", "creation_timestamp", "submitted_by", "submitter_comment", "description", "analysis_step_types", "step_label", "title", "workflow", "parents", "input_content_types", "output_content_types", "@id", "@type", "summary", "name", "analysis_step_versions"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['archived', 'deleted', 'in progress', 'preview', 'released']):
            raise ValueError("must be one of enum values ('archived', 'deleted', 'in progress', 'preview', 'released')")
        return value

    @field_validator('schema_version')
    def schema_version_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\d+(\.\d+)*$", value):
            raise ValueError(r"must validate the regular expression /^\d+(\.\d+)*$/")
        return value

    @field_validator('notes')
    def notes_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(\S+(\s|\S)*\S+|\S)$", value):
            raise ValueError(r"must validate the regular expression /^(\S+(\s|\S)*\S+|\S)$/")
        return value

    @field_validator('submitter_comment')
    def submitter_comment_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(\S+(\s|\S)*\S+|\S)$", value):
            raise ValueError(r"must validate the regular expression /^(\S+(\s|\S)*\S+|\S)$/")
        return value

    @field_validator('description')
    def description_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(\S+(\s|\S)*\S+|\S)$", value):
            raise ValueError(r"must validate the regular expression /^(\S+(\s|\S)*\S+|\S)$/")
        return value

    @field_validator('analysis_step_types')
    def analysis_step_types_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['alignment', 'barcode counting', 'barcode mapping generation', 'base calling', 'cell to feature barcode mapping', 'counts normalization', 'demultiplexing', 'differential expression analysis', 'file format conversion', 'filtering', 'interaction calling', 'merging', 'peak calling', 'quantification', 'signal generation', 'signal normalization', 'spatial feature detection', 'UMI quantification', 'variant annotation']):
                raise ValueError("each list item must be one of ('alignment', 'barcode counting', 'barcode mapping generation', 'base calling', 'cell to feature barcode mapping', 'counts normalization', 'demultiplexing', 'differential expression analysis', 'file format conversion', 'filtering', 'interaction calling', 'merging', 'peak calling', 'quantification', 'signal generation', 'signal normalization', 'spatial feature detection', 'UMI quantification', 'variant annotation')")
        return value

    @field_validator('step_label')
    def step_label_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-z0-9-]+-step$", value):
            raise ValueError(r"must validate the regular expression /^[a-z0-9-]+-step$/")
        return value

    @field_validator('title')
    def title_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z\d_().,-]+(?:\s[a-zA-Z\d_().,-]+)*[step|Step]$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z\d_().,-]+(?:\s[a-zA-Z\d_().,-]+)*[step|Step]$/")
        return value

    @field_validator('input_content_types')
    def input_content_types_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['MPRA sequence designs', 'Nanopore reads', 'PacBio subreads', 'SNP effect matrix', 'alignments', 'barcode onlist', 'barcode to TF overexpression mapping', 'barcode to element mapping', 'barcode to hashtag mapping', 'barcode to sample mapping', 'barcode to variant mapping', 'bin paired count', 'biological_context', 'cell hashing barcodes', 'coding variant effects', 'coding_variants', 'complexes', 'complexes_complexes', 'complexes_proteins', 'complexes_terms', 'contact matrix', 'control signal', 'detected tissue', 'differential chromatin contact quantifications', 'differential element quantifications', 'differential gene expression quantifications', 'differential transcript expression quantifications', 'diseases_genes', 'documentation (readme)', 'drugs', 'edge weights', 'editing templates', 'element quantifications', 'elements reference', 'elements_genes', 'exclusion list', 'external source data', 'fiducial alignment', 'filtered feature barcode matrix', 'fold change over control', 'fragments', 'gene quantifications', 'genes', 'genes_genes', 'genes_pathways', 'genes_terms', 'genes_transcripts', 'genome reference', 'go_terms_proteins', 'graph structure', 'guide RNA sequences', 'guide quantifications', 'high resolution tissue', 'inclusion list', 'loci', 'low resolution tissue', 'model parameters', 'motifs', 'motifs_proteins', 'ontology_terms', 'ontology_terms_ontology_terms', 'pathways', 'pathways_pathways', 'peak quantifications', 'peaks', 'position weight matrix', 'prime editing guide RNA sequences', 'protein to protein interaction score', 'proteins', 'proteins_proteins', 'raw feature barcode matrix', 'raw signal', 'read-depth signal', 'reads', 'regulatory_regions', 'regulatory_regions_genes', 'regulatory_regions_genes_biosamples', 'regulatory_regions_genes_biosamples_donors', 'regulatory_regions_genes_biosamples_treatments_chebi', 'regulatory_regions_genes_biosamples_treatments_proteins', 'regulatory_regions_regulatory_regions', 'reporter elements', 'reporter experiment', 'reporter genomic element effects', 'reporter genomic variant effects', 'reporter variants', 'sample sort parameters', 'scale factors', 'seqspec', 'sequence barcodes', 'signal', 'signal of all reads', 'signal of unique reads', 'signal p-value', 'sparse gene count matrix', 'sparse peak count matrix', 'sparse transcript count matrix', 'spike-ins', 'studies', 'studies_variants', 'studies_variants_phenotypes', 'tissue positions', 'transcript quantifications', 'transcriptome alignments', 'transcriptome annotations', 'transcriptome reference', 'transcripts', 'transcripts_proteins', 'unfiltered global differential expression', 'unfiltered local differential expression', 'variant binding effects', 'variant effects', 'variant functional predictions', 'variant localization impacts', 'variant to element mapping', 'variants', 'variants_coding_variants', 'variants_diseases', 'variants_diseases_genes', 'variants_drugs', 'variants_drugs_genes', 'variants_genes', 'variants_genes_terms', 'variants_phenotypes', 'variants_phenotypes_studies', 'variants_proteins', 'variants_proteins_biosamples', 'variants_proteins_phenotypes', 'variants_proteins_terms', 'variants_regulatory_regions', 'variants_variants', 'vector sequences']):
                raise ValueError("each list item must be one of ('MPRA sequence designs', 'Nanopore reads', 'PacBio subreads', 'SNP effect matrix', 'alignments', 'barcode onlist', 'barcode to TF overexpression mapping', 'barcode to element mapping', 'barcode to hashtag mapping', 'barcode to sample mapping', 'barcode to variant mapping', 'bin paired count', 'biological_context', 'cell hashing barcodes', 'coding variant effects', 'coding_variants', 'complexes', 'complexes_complexes', 'complexes_proteins', 'complexes_terms', 'contact matrix', 'control signal', 'detected tissue', 'differential chromatin contact quantifications', 'differential element quantifications', 'differential gene expression quantifications', 'differential transcript expression quantifications', 'diseases_genes', 'documentation (readme)', 'drugs', 'edge weights', 'editing templates', 'element quantifications', 'elements reference', 'elements_genes', 'exclusion list', 'external source data', 'fiducial alignment', 'filtered feature barcode matrix', 'fold change over control', 'fragments', 'gene quantifications', 'genes', 'genes_genes', 'genes_pathways', 'genes_terms', 'genes_transcripts', 'genome reference', 'go_terms_proteins', 'graph structure', 'guide RNA sequences', 'guide quantifications', 'high resolution tissue', 'inclusion list', 'loci', 'low resolution tissue', 'model parameters', 'motifs', 'motifs_proteins', 'ontology_terms', 'ontology_terms_ontology_terms', 'pathways', 'pathways_pathways', 'peak quantifications', 'peaks', 'position weight matrix', 'prime editing guide RNA sequences', 'protein to protein interaction score', 'proteins', 'proteins_proteins', 'raw feature barcode matrix', 'raw signal', 'read-depth signal', 'reads', 'regulatory_regions', 'regulatory_regions_genes', 'regulatory_regions_genes_biosamples', 'regulatory_regions_genes_biosamples_donors', 'regulatory_regions_genes_biosamples_treatments_chebi', 'regulatory_regions_genes_biosamples_treatments_proteins', 'regulatory_regions_regulatory_regions', 'reporter elements', 'reporter experiment', 'reporter genomic element effects', 'reporter genomic variant effects', 'reporter variants', 'sample sort parameters', 'scale factors', 'seqspec', 'sequence barcodes', 'signal', 'signal of all reads', 'signal of unique reads', 'signal p-value', 'sparse gene count matrix', 'sparse peak count matrix', 'sparse transcript count matrix', 'spike-ins', 'studies', 'studies_variants', 'studies_variants_phenotypes', 'tissue positions', 'transcript quantifications', 'transcriptome alignments', 'transcriptome annotations', 'transcriptome reference', 'transcripts', 'transcripts_proteins', 'unfiltered global differential expression', 'unfiltered local differential expression', 'variant binding effects', 'variant effects', 'variant functional predictions', 'variant localization impacts', 'variant to element mapping', 'variants', 'variants_coding_variants', 'variants_diseases', 'variants_diseases_genes', 'variants_drugs', 'variants_drugs_genes', 'variants_genes', 'variants_genes_terms', 'variants_phenotypes', 'variants_phenotypes_studies', 'variants_proteins', 'variants_proteins_biosamples', 'variants_proteins_phenotypes', 'variants_proteins_terms', 'variants_regulatory_regions', 'variants_variants', 'vector sequences')")
        return value

    @field_validator('output_content_types')
    def output_content_types_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['MPRA sequence designs', 'Nanopore reads', 'PacBio subreads', 'SNP effect matrix', 'alignments', 'barcode onlist', 'barcode to TF overexpression mapping', 'barcode to element mapping', 'barcode to hashtag mapping', 'barcode to sample mapping', 'barcode to variant mapping', 'bin paired count', 'biological_context', 'cell hashing barcodes', 'coding variant effects', 'coding_variants', 'complexes', 'complexes_complexes', 'complexes_proteins', 'complexes_terms', 'contact matrix', 'control signal', 'detected tissue', 'differential chromatin contact quantifications', 'differential element quantifications', 'differential gene expression quantifications', 'differential transcript expression quantifications', 'diseases_genes', 'documentation (readme)', 'drugs', 'edge weights', 'editing templates', 'element quantifications', 'elements reference', 'elements_genes', 'exclusion list', 'external source data', 'fiducial alignment', 'filtered feature barcode matrix', 'fold change over control', 'fragments', 'gene quantifications', 'genes', 'genes_genes', 'genes_pathways', 'genes_terms', 'genes_transcripts', 'genome reference', 'go_terms_proteins', 'graph structure', 'guide RNA sequences', 'guide quantifications', 'high resolution tissue', 'inclusion list', 'loci', 'low resolution tissue', 'model parameters', 'motifs', 'motifs_proteins', 'ontology_terms', 'ontology_terms_ontology_terms', 'pathways', 'pathways_pathways', 'peak quantifications', 'peaks', 'position weight matrix', 'prime editing guide RNA sequences', 'protein to protein interaction score', 'proteins', 'proteins_proteins', 'raw feature barcode matrix', 'raw signal', 'read-depth signal', 'reads', 'regulatory_regions', 'regulatory_regions_genes', 'regulatory_regions_genes_biosamples', 'regulatory_regions_genes_biosamples_donors', 'regulatory_regions_genes_biosamples_treatments_chebi', 'regulatory_regions_genes_biosamples_treatments_proteins', 'regulatory_regions_regulatory_regions', 'reporter elements', 'reporter experiment', 'reporter genomic element effects', 'reporter genomic variant effects', 'reporter variants', 'sample sort parameters', 'scale factors', 'seqspec', 'sequence barcodes', 'signal', 'signal of all reads', 'signal of unique reads', 'signal p-value', 'sparse gene count matrix', 'sparse peak count matrix', 'sparse transcript count matrix', 'spike-ins', 'studies', 'studies_variants', 'studies_variants_phenotypes', 'tissue positions', 'transcript quantifications', 'transcriptome alignments', 'transcriptome annotations', 'transcriptome reference', 'transcripts', 'transcripts_proteins', 'unfiltered global differential expression', 'unfiltered local differential expression', 'variant binding effects', 'variant effects', 'variant functional predictions', 'variant localization impacts', 'variant to element mapping', 'variants', 'variants_coding_variants', 'variants_diseases', 'variants_diseases_genes', 'variants_drugs', 'variants_drugs_genes', 'variants_genes', 'variants_genes_terms', 'variants_phenotypes', 'variants_phenotypes_studies', 'variants_proteins', 'variants_proteins_biosamples', 'variants_proteins_phenotypes', 'variants_proteins_terms', 'variants_regulatory_regions', 'variants_variants', 'vector sequences']):
                raise ValueError("each list item must be one of ('MPRA sequence designs', 'Nanopore reads', 'PacBio subreads', 'SNP effect matrix', 'alignments', 'barcode onlist', 'barcode to TF overexpression mapping', 'barcode to element mapping', 'barcode to hashtag mapping', 'barcode to sample mapping', 'barcode to variant mapping', 'bin paired count', 'biological_context', 'cell hashing barcodes', 'coding variant effects', 'coding_variants', 'complexes', 'complexes_complexes', 'complexes_proteins', 'complexes_terms', 'contact matrix', 'control signal', 'detected tissue', 'differential chromatin contact quantifications', 'differential element quantifications', 'differential gene expression quantifications', 'differential transcript expression quantifications', 'diseases_genes', 'documentation (readme)', 'drugs', 'edge weights', 'editing templates', 'element quantifications', 'elements reference', 'elements_genes', 'exclusion list', 'external source data', 'fiducial alignment', 'filtered feature barcode matrix', 'fold change over control', 'fragments', 'gene quantifications', 'genes', 'genes_genes', 'genes_pathways', 'genes_terms', 'genes_transcripts', 'genome reference', 'go_terms_proteins', 'graph structure', 'guide RNA sequences', 'guide quantifications', 'high resolution tissue', 'inclusion list', 'loci', 'low resolution tissue', 'model parameters', 'motifs', 'motifs_proteins', 'ontology_terms', 'ontology_terms_ontology_terms', 'pathways', 'pathways_pathways', 'peak quantifications', 'peaks', 'position weight matrix', 'prime editing guide RNA sequences', 'protein to protein interaction score', 'proteins', 'proteins_proteins', 'raw feature barcode matrix', 'raw signal', 'read-depth signal', 'reads', 'regulatory_regions', 'regulatory_regions_genes', 'regulatory_regions_genes_biosamples', 'regulatory_regions_genes_biosamples_donors', 'regulatory_regions_genes_biosamples_treatments_chebi', 'regulatory_regions_genes_biosamples_treatments_proteins', 'regulatory_regions_regulatory_regions', 'reporter elements', 'reporter experiment', 'reporter genomic element effects', 'reporter genomic variant effects', 'reporter variants', 'sample sort parameters', 'scale factors', 'seqspec', 'sequence barcodes', 'signal', 'signal of all reads', 'signal of unique reads', 'signal p-value', 'sparse gene count matrix', 'sparse peak count matrix', 'sparse transcript count matrix', 'spike-ins', 'studies', 'studies_variants', 'studies_variants_phenotypes', 'tissue positions', 'transcript quantifications', 'transcriptome alignments', 'transcriptome annotations', 'transcriptome reference', 'transcripts', 'transcripts_proteins', 'unfiltered global differential expression', 'unfiltered local differential expression', 'variant binding effects', 'variant effects', 'variant functional predictions', 'variant localization impacts', 'variant to element mapping', 'variants', 'variants_coding_variants', 'variants_diseases', 'variants_diseases_genes', 'variants_drugs', 'variants_drugs_genes', 'variants_genes', 'variants_genes_terms', 'variants_phenotypes', 'variants_phenotypes_studies', 'variants_proteins', 'variants_proteins_biosamples', 'variants_proteins_phenotypes', 'variants_proteins_terms', 'variants_regulatory_regions', 'variants_variants', 'vector sequences')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AnalysisStep from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AnalysisStep from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "release_timestamp": obj.get("release_timestamp"),
            "status": obj.get("status"),
            "lab": obj.get("lab"),
            "award": obj.get("award"),
            "schema_version": obj.get("schema_version"),
            "uuid": obj.get("uuid"),
            "notes": obj.get("notes"),
            "aliases": obj.get("aliases"),
            "creation_timestamp": obj.get("creation_timestamp"),
            "submitted_by": obj.get("submitted_by"),
            "submitter_comment": obj.get("submitter_comment"),
            "description": obj.get("description"),
            "analysis_step_types": obj.get("analysis_step_types"),
            "step_label": obj.get("step_label"),
            "title": obj.get("title"),
            "workflow": obj.get("workflow"),
            "parents": obj.get("parents"),
            "input_content_types": obj.get("input_content_types"),
            "output_content_types": obj.get("output_content_types"),
            "@id": obj.get("@id"),
            "@type": obj.get("@type"),
            "summary": obj.get("summary"),
            "name": obj.get("name"),
            "analysis_step_versions": obj.get("analysis_step_versions")
        })
        return _obj


