# igvf-async-client
**Unless you have a specific need for an async Python client, you are probably looking for the [synchronous IGVF Python client](https://github.com/IGVF-DACC/igvf-python-client).**

The Python client is autogenerated based on this [IGVF OpenAPI specification](https://igvf-dacc.github.io/igvf-client-openapi-spec/), which exposes `search`, `collection`, and other read endpoints from the [IGVF Data Portal](https://data.igvf.org).

*Note while the API endpoints are relatively stable, the underlying data model is still evolving, and changing fields/types can cause breaking changes. The latest version of the client reflects the latest version of the schema used by the API.*

- API version: 61.1.0
- Package version: 61.1.0
- Generator version: 7.8.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage

Pip install:

```sh
$ pip install igvf-async-client
```

Or clone the repo and and install:
```sh
$ git clone https://github.com/IGVF-DACC/igvf-async-python-client
$ cd igvf-async-python-client
$ pip install -e .
```

Then import the package:
```python
$ python -m asyncio
>>> import igvf_async_client
```

### Examples

(Must use an async runtime, e.g. `$ python -m asyncio`.)

```python
from igvf_async_client import AsyncIgvfApi

api = AsyncIgvfApi()

# Search for Software that matches query `abc`.
r = await api.search(query='abc', type=['Software'])

# Print total number of results and list of results in `@graph`.
print(r.total)
print(r.graph)

# Pull first item, unwrap to underlying Software item with `actual_instance`.
software_item = r.graph[0].actual_instance

# Print Software item and specific fields.
print(software_item)
print(software_item.id)
print(software_item.description)

# Get the Lab item based on the lab @id in the Software item.
lab = await api.get_by_id(software_item.lab)

# Print lab and specific field.
print(lab)
print(lab.title)
```

See other examples in [async_example.ipynb](async_example.ipynb) and [test_endpoint.py](test/test_endpoint.py)

Refer to the documentation for a full specification of endpoint inputs and outputs and model fields.

## Documentation for API Endpoints

### **General Endpoints**

All URIs are relative to *https://api.data.igvf.org*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AsyncIgvfApi* | [**search**](docs/AsyncIgvfApi.md#search) | **GET** /search | Search for items on the IGVF Data Portal.
*AsyncIgvfApi* | [**schemas**](docs/AsyncIgvfApi.md#schemas) | **GET** /profiles | Retrieve JSON schemas for all item types
*AsyncIgvfApi* | [**schema_for_item_type**](docs/AsyncIgvfApi.md#schema_for_item_type) | **GET** /profiles/{item_type} | Retrieve JSON schema for item type
*AsyncIgvfApi* | [**report**](docs/AsyncIgvfApi.md#report) | **GET** /multireport.tsv | Generate a TSV file report based on search query. All results are returned.
*AsyncIgvfApi* | [**get_by_id**](docs/AsyncIgvfApi.md#get_by_id) | **GET** /{resource_id} | Get item information
*AsyncIgvfApi* | [**download**](docs/AsyncIgvfApi.md#download) | **GET** /{file_id}/@@download | Download file.
*AsyncIgvfApi* | [**batch_download**](docs/AsyncIgvfApi.md#batch_download) | **GET** /batch-download | List files to download based on search query. All results are returned.

### **Collection Endpoints**

All URIs are relative to *https://api.data.igvf.org*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AsyncIgvfApi* | [**access_keys**](docs/AsyncIgvfApi.md#access_keys) | **GET** /access-keys/@@listing | List items in the AccessKey collection.
*AsyncIgvfApi* | [**alignment_files**](docs/AsyncIgvfApi.md#alignment_files) | **GET** /alignment-files/@@listing | List items in the AlignmentFile collection.
*AsyncIgvfApi* | [**analysis_sets**](docs/AsyncIgvfApi.md#analysis_sets) | **GET** /analysis-sets/@@listing | List items in the AnalysisSet collection.
*AsyncIgvfApi* | [**analysis_step_versions**](docs/AsyncIgvfApi.md#analysis_step_versions) | **GET** /analysis-step-versions/@@listing | List items in the AnalysisStepVersion collection.
*AsyncIgvfApi* | [**analysis_steps**](docs/AsyncIgvfApi.md#analysis_steps) | **GET** /analysis-steps/@@listing | List items in the AnalysisStep collection.
*AsyncIgvfApi* | [**assay_terms**](docs/AsyncIgvfApi.md#assay_terms) | **GET** /assay-terms/@@listing | List items in the AssayTerm collection.
*AsyncIgvfApi* | [**auxiliary_sets**](docs/AsyncIgvfApi.md#auxiliary_sets) | **GET** /auxiliary-sets/@@listing | List items in the AuxiliarySet collection.
*AsyncIgvfApi* | [**awards**](docs/AsyncIgvfApi.md#awards) | **GET** /awards/@@listing | List items in the Award collection.
*AsyncIgvfApi* | [**biomarkers**](docs/AsyncIgvfApi.md#biomarkers) | **GET** /biomarkers/@@listing | List items in the Biomarker collection.
*AsyncIgvfApi* | [**configuration_files**](docs/AsyncIgvfApi.md#configuration_files) | **GET** /configuration-files/@@listing | List items in the ConfigurationFile collection.
*AsyncIgvfApi* | [**construct_library_sets**](docs/AsyncIgvfApi.md#construct_library_sets) | **GET** /construct-library-sets/@@listing | List items in the ConstructLibrarySet collection.
*AsyncIgvfApi* | [**crispr_modifications**](docs/AsyncIgvfApi.md#crispr_modifications) | **GET** /crispr-modifications/@@listing | List items in the CrisprModification collection.
*AsyncIgvfApi* | [**curated_sets**](docs/AsyncIgvfApi.md#curated_sets) | **GET** /curated-sets/@@listing | List items in the CuratedSet collection.
*AsyncIgvfApi* | [**degron_modifications**](docs/AsyncIgvfApi.md#degron_modifications) | **GET** /degron-modifications/@@listing | List items in the DegronModification collection.
*AsyncIgvfApi* | [**documents**](docs/AsyncIgvfApi.md#documents) | **GET** /documents/@@listing | List items in the Document collection.
*AsyncIgvfApi* | [**genes**](docs/AsyncIgvfApi.md#genes) | **GET** /genes/@@listing | List items in the Gene collection.
*AsyncIgvfApi* | [**genome_browser_annotation_files**](docs/AsyncIgvfApi.md#genome_browser_annotation_files) | **GET** /genome-browser-annotation-files/@@listing | List items in the GenomeBrowserAnnotationFile collection.
*AsyncIgvfApi* | [**human_donors**](docs/AsyncIgvfApi.md#human_donors) | **GET** /human-donors/@@listing | List items in the HumanDonor collection.
*AsyncIgvfApi* | [**image_files**](docs/AsyncIgvfApi.md#image_files) | **GET** /image-files/@@listing | List items in the ImageFile collection.
*AsyncIgvfApi* | [**images**](docs/AsyncIgvfApi.md#images) | **GET** /images/@@listing | List items in the Image collection.
*AsyncIgvfApi* | [**in_vitro_systems**](docs/AsyncIgvfApi.md#in_vitro_systems) | **GET** /in-vitro-systems/@@listing | List items in the InVitroSystem collection.
*AsyncIgvfApi* | [**index_files**](docs/AsyncIgvfApi.md#index_files) | **GET** /index-files/@@listing | List items in the IndexFile collection.
*AsyncIgvfApi* | [**institutional_certificates**](docs/AsyncIgvfApi.md#institutional_certificates) | **GET** /institutional-certificates/@@listing | List items in the InstitutionalCertificate collection.
*AsyncIgvfApi* | [**labs**](docs/AsyncIgvfApi.md#labs) | **GET** /labs/@@listing | List items in the Lab collection.
*AsyncIgvfApi* | [**matrix_files**](docs/AsyncIgvfApi.md#matrix_files) | **GET** /matrix-files/@@listing | List items in the MatrixFile collection.
*AsyncIgvfApi* | [**measurement_sets**](docs/AsyncIgvfApi.md#measurement_sets) | **GET** /measurement-sets/@@listing | List items in the MeasurementSet collection.
*AsyncIgvfApi* | [**model_files**](docs/AsyncIgvfApi.md#model_files) | **GET** /model-files/@@listing | List items in the ModelFile collection.
*AsyncIgvfApi* | [**model_sets**](docs/AsyncIgvfApi.md#model_sets) | **GET** /model-sets/@@listing | List items in the ModelSet collection.
*AsyncIgvfApi* | [**multiplexed_samples**](docs/AsyncIgvfApi.md#multiplexed_samples) | **GET** /multiplexed-samples/@@listing | List items in the MultiplexedSample collection.
*AsyncIgvfApi* | [**open_reading_frames**](docs/AsyncIgvfApi.md#open_reading_frames) | **GET** /open-reading-frames/@@listing | List items in the OpenReadingFrame collection.
*AsyncIgvfApi* | [**pages**](docs/AsyncIgvfApi.md#pages) | **GET** /pages/@@listing | List items in the Page collection.
*AsyncIgvfApi* | [**phenotype_terms**](docs/AsyncIgvfApi.md#phenotype_terms) | **GET** /phenotype-terms/@@listing | List items in the PhenotypeTerm collection.
*AsyncIgvfApi* | [**phenotypic_features**](docs/AsyncIgvfApi.md#phenotypic_features) | **GET** /phenotypic-features/@@listing | List items in the PhenotypicFeature collection.
*AsyncIgvfApi* | [**platform_terms**](docs/AsyncIgvfApi.md#platform_terms) | **GET** /platform-terms/@@listing | List items in the PlatformTerm collection.
*AsyncIgvfApi* | [**prediction_sets**](docs/AsyncIgvfApi.md#prediction_sets) | **GET** /prediction-sets/@@listing | List items in the PredictionSet collection.
*AsyncIgvfApi* | [**primary_cells**](docs/AsyncIgvfApi.md#primary_cells) | **GET** /primary-cells/@@listing | List items in the PrimaryCell collection.
*AsyncIgvfApi* | [**publications**](docs/AsyncIgvfApi.md#publications) | **GET** /publications/@@listing | List items in the Publication collection.
*AsyncIgvfApi* | [**reference_files**](docs/AsyncIgvfApi.md#reference_files) | **GET** /reference-files/@@listing | List items in the ReferenceFile collection.
*AsyncIgvfApi* | [**rodent_donors**](docs/AsyncIgvfApi.md#rodent_donors) | **GET** /rodent-donors/@@listing | List items in the RodentDonor collection.
*AsyncIgvfApi* | [**sample_terms**](docs/AsyncIgvfApi.md#sample_terms) | **GET** /sample-terms/@@listing | List items in the SampleTerm collection.
*AsyncIgvfApi* | [**sequence_files**](docs/AsyncIgvfApi.md#sequence_files) | **GET** /sequence-files/@@listing | List items in the SequenceFile collection.
*AsyncIgvfApi* | [**signal_files**](docs/AsyncIgvfApi.md#signal_files) | **GET** /signal-files/@@listing | List items in the SignalFile collection.
*AsyncIgvfApi* | [**software**](docs/AsyncIgvfApi.md#software) | **GET** /software/@@listing | List items in the Software collection.
*AsyncIgvfApi* | [**software_versions**](docs/AsyncIgvfApi.md#software_versions) | **GET** /software-versions/@@listing | List items in the SoftwareVersion collection.
*AsyncIgvfApi* | [**sources**](docs/AsyncIgvfApi.md#sources) | **GET** /sources/@@listing | List items in the Source collection.
*AsyncIgvfApi* | [**tabular_files**](docs/AsyncIgvfApi.md#tabular_files) | **GET** /tabular-files/@@listing | List items in the TabularFile collection.
*AsyncIgvfApi* | [**technical_samples**](docs/AsyncIgvfApi.md#technical_samples) | **GET** /technical-samples/@@listing | List items in the TechnicalSample collection.
*AsyncIgvfApi* | [**tissues**](docs/AsyncIgvfApi.md#tissues) | **GET** /tissues/@@listing | List items in the Tissue collection.
*AsyncIgvfApi* | [**treatments**](docs/AsyncIgvfApi.md#treatments) | **GET** /treatments/@@listing | List items in the Treatment collection.
*AsyncIgvfApi* | [**users**](docs/AsyncIgvfApi.md#users) | **GET** /users/@@listing | List items in the User collection.
*AsyncIgvfApi* | [**whole_organisms**](docs/AsyncIgvfApi.md#whole_organisms) | **GET** /whole-organisms/@@listing | List items in the WholeOrganism collection.
*AsyncIgvfApi* | [**workflows**](docs/AsyncIgvfApi.md#workflows) | **GET** /workflows/@@listing | List items in the Workflow collection.

## Documentation for Models

 - [AccessKey](docs/AccessKey.md)
 - [AccessKeyResults](docs/AccessKeyResults.md)
 - [AlignmentFile](docs/AlignmentFile.md)
 - [AlignmentFileResults](docs/AlignmentFileResults.md)
 - [AnalysisSet](docs/AnalysisSet.md)
 - [AnalysisSetResults](docs/AnalysisSetResults.md)
 - [AnalysisStep](docs/AnalysisStep.md)
 - [AnalysisStepResults](docs/AnalysisStepResults.md)
 - [AnalysisStepVersion](docs/AnalysisStepVersion.md)
 - [AnalysisStepVersionResults](docs/AnalysisStepVersionResults.md)
 - [AssayTerm](docs/AssayTerm.md)
 - [AssayTermResults](docs/AssayTermResults.md)
 - [Attachment](docs/Attachment.md)
 - [Attachment1](docs/Attachment1.md)
 - [AuxiliarySet](docs/AuxiliarySet.md)
 - [AuxiliarySetResults](docs/AuxiliarySetResults.md)
 - [Award](docs/Award.md)
 - [AwardResults](docs/AwardResults.md)
 - [Biomarker](docs/Biomarker.md)
 - [BiomarkerResults](docs/BiomarkerResults.md)
 - [ConfigurationFile](docs/ConfigurationFile.md)
 - [ConfigurationFileResults](docs/ConfigurationFileResults.md)
 - [ConstructLibrarySet](docs/ConstructLibrarySet.md)
 - [ConstructLibrarySetResults](docs/ConstructLibrarySetResults.md)
 - [CrisprModification](docs/CrisprModification.md)
 - [CrisprModificationResults](docs/CrisprModificationResults.md)
 - [CuratedSet](docs/CuratedSet.md)
 - [CuratedSetResults](docs/CuratedSetResults.md)
 - [DegronModification](docs/DegronModification.md)
 - [DegronModificationResults](docs/DegronModificationResults.md)
 - [Document](docs/Document.md)
 - [DocumentResults](docs/DocumentResults.md)
 - [Gene](docs/Gene.md)
 - [GeneLocation](docs/GeneLocation.md)
 - [GeneLocation1](docs/GeneLocation1.md)
 - [GeneResults](docs/GeneResults.md)
 - [GenomeBrowserAnnotationFile](docs/GenomeBrowserAnnotationFile.md)
 - [GenomeBrowserAnnotationFileResults](docs/GenomeBrowserAnnotationFileResults.md)
 - [HumanDonor](docs/HumanDonor.md)
 - [HumanDonorResults](docs/HumanDonorResults.md)
 - [Image](docs/Image.md)
 - [ImageFile](docs/ImageFile.md)
 - [ImageFileResults](docs/ImageFileResults.md)
 - [ImageResults](docs/ImageResults.md)
 - [InVitroSystem](docs/InVitroSystem.md)
 - [InVitroSystemResults](docs/InVitroSystemResults.md)
 - [IndexFile](docs/IndexFile.md)
 - [IndexFileResults](docs/IndexFileResults.md)
 - [InstitutionalCertificate](docs/InstitutionalCertificate.md)
 - [InstitutionalCertificateResults](docs/InstitutionalCertificateResults.md)
 - [Item](docs/Item.md)
 - [ItemType](docs/ItemType.md)
 - [Lab](docs/Lab.md)
 - [LabResults](docs/LabResults.md)
 - [Limit](docs/Limit.md)
 - [Locus](docs/Locus.md)
 - [Locus1](docs/Locus1.md)
 - [MatrixFile](docs/MatrixFile.md)
 - [MatrixFileResults](docs/MatrixFileResults.md)
 - [MeasurementSet](docs/MeasurementSet.md)
 - [MeasurementSetResults](docs/MeasurementSetResults.md)
 - [ModelFile](docs/ModelFile.md)
 - [ModelFileResults](docs/ModelFileResults.md)
 - [ModelSet](docs/ModelSet.md)
 - [ModelSetResults](docs/ModelSetResults.md)
 - [MultiplexedSample](docs/MultiplexedSample.md)
 - [MultiplexedSampleResults](docs/MultiplexedSampleResults.md)
 - [NoResultsResponse](docs/NoResultsResponse.md)
 - [NoResultsResponseColumnsValue](docs/NoResultsResponseColumnsValue.md)
 - [NoResultsResponseFacetGroupsInner](docs/NoResultsResponseFacetGroupsInner.md)
 - [NoResultsResponseFacetsInner](docs/NoResultsResponseFacetsInner.md)
 - [NoResultsResponseFacetsInnerTermsInner](docs/NoResultsResponseFacetsInnerTermsInner.md)
 - [NoResultsResponseFiltersInner](docs/NoResultsResponseFiltersInner.md)
 - [NoResultsResponseSortValue](docs/NoResultsResponseSortValue.md)
 - [OpenReadingFrame](docs/OpenReadingFrame.md)
 - [OpenReadingFrameResults](docs/OpenReadingFrameResults.md)
 - [Page](docs/Page.md)
 - [PageLayout](docs/PageLayout.md)
 - [PageLayoutComponents](docs/PageLayoutComponents.md)
 - [PageResults](docs/PageResults.md)
 - [PhenotypeTerm](docs/PhenotypeTerm.md)
 - [PhenotypeTermResults](docs/PhenotypeTermResults.md)
 - [PhenotypicFeature](docs/PhenotypicFeature.md)
 - [PhenotypicFeatureResults](docs/PhenotypicFeatureResults.md)
 - [PlatformTerm](docs/PlatformTerm.md)
 - [PlatformTermResults](docs/PlatformTermResults.md)
 - [PredictionSet](docs/PredictionSet.md)
 - [PredictionSetResults](docs/PredictionSetResults.md)
 - [PrimaryCell](docs/PrimaryCell.md)
 - [PrimaryCellResults](docs/PrimaryCellResults.md)
 - [Publication](docs/Publication.md)
 - [PublicationResults](docs/PublicationResults.md)
 - [ReferenceFile](docs/ReferenceFile.md)
 - [ReferenceFileResults](docs/ReferenceFileResults.md)
 - [RelatedDonor](docs/RelatedDonor.md)
 - [RodentDonor](docs/RodentDonor.md)
 - [RodentDonorResults](docs/RodentDonorResults.md)
 - [SampleTerm](docs/SampleTerm.md)
 - [SampleTermResults](docs/SampleTermResults.md)
 - [SearchFacet](docs/SearchFacet.md)
 - [SearchResultItem](docs/SearchResultItem.md)
 - [SearchResults](docs/SearchResults.md)
 - [SequenceFile](docs/SequenceFile.md)
 - [SequenceFileResults](docs/SequenceFileResults.md)
 - [SignalFile](docs/SignalFile.md)
 - [SignalFileResults](docs/SignalFileResults.md)
 - [Software](docs/Software.md)
 - [SoftwareResults](docs/SoftwareResults.md)
 - [SoftwareVersion](docs/SoftwareVersion.md)
 - [SoftwareVersionResults](docs/SoftwareVersionResults.md)
 - [Source](docs/Source.md)
 - [SourceResults](docs/SourceResults.md)
 - [TabularFile](docs/TabularFile.md)
 - [TabularFileResults](docs/TabularFileResults.md)
 - [TechnicalSample](docs/TechnicalSample.md)
 - [TechnicalSampleResults](docs/TechnicalSampleResults.md)
 - [Tile](docs/Tile.md)
 - [Tissue](docs/Tissue.md)
 - [TissueResults](docs/TissueResults.md)
 - [Treatment](docs/Treatment.md)
 - [TreatmentResults](docs/TreatmentResults.md)
 - [User](docs/User.md)
 - [UserResults](docs/UserResults.md)
 - [WholeOrganism](docs/WholeOrganism.md)
 - [WholeOrganismResults](docs/WholeOrganismResults.md)
 - [Workflow](docs/Workflow.md)
 - [WorkflowResults](docs/WorkflowResults.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="basicAuth"></a>
### basicAuth

- **Type**: HTTP basic authentication


## Author




## Optional authorization
```python
import os

from igvf_async_client import Configuration
from igvf_async_client import ApiClient
from igvf_async_client import AsyncIgvfApi

config = Configuration(
    access_key = os.environ["IGVF_ACCESS_KEY"],
    secret_access_key = os.environ["IGVF_SECRET_ACCESS_KEY"]
)

client = ApiClient(config)

api = AsyncIgvfApi(client)
```