# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AppMonitorConfiguration',
    'AppMonitorTag',
]

@pulumi.output_type
class AppMonitorConfiguration(dict):
    """
    AppMonitor configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCookies":
            suggest = "allow_cookies"
        elif key == "enableXRay":
            suggest = "enable_x_ray"
        elif key == "excludedPages":
            suggest = "excluded_pages"
        elif key == "favoritePages":
            suggest = "favorite_pages"
        elif key == "guestRoleArn":
            suggest = "guest_role_arn"
        elif key == "identityPoolId":
            suggest = "identity_pool_id"
        elif key == "includedPages":
            suggest = "included_pages"
        elif key == "sessionSampleRate":
            suggest = "session_sample_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppMonitorConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppMonitorConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppMonitorConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_cookies: Optional[bool] = None,
                 enable_x_ray: Optional[bool] = None,
                 excluded_pages: Optional[Sequence[str]] = None,
                 favorite_pages: Optional[Sequence[str]] = None,
                 guest_role_arn: Optional[str] = None,
                 identity_pool_id: Optional[str] = None,
                 included_pages: Optional[Sequence[str]] = None,
                 session_sample_rate: Optional[float] = None,
                 telemetries: Optional[Sequence['AppMonitorTelemetry']] = None):
        """
        AppMonitor configuration
        :param bool allow_cookies: If you set this to true, the RUM web client sets two cookies, a session cookie and a user cookie. The cookies allow the RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.
        :param bool enable_x_ray: If you set this to true, RUM enables xray tracing for the user sessions that RUM samples. RUM adds an xray trace header to allowed HTTP requests. It also records an xray segment for allowed HTTP requests. You can see traces and segments from these user sessions in the xray console and the CW ServiceLens console.
        :param Sequence[str] excluded_pages: A list of URLs in your website or application to exclude from RUM data collection. You can't include both ExcludedPages and IncludedPages in the same operation.
        :param Sequence[str] favorite_pages: A list of pages in the RUM console that are to be displayed with a favorite icon.
        :param str guest_role_arn: The ARN of the guest IAM role that is attached to the identity pool that is used to authorize the sending of data to RUM.
        :param str identity_pool_id: The ID of the identity pool that is used to authorize the sending of data to RUM.
        :param Sequence[str] included_pages: If this app monitor is to collect data from only certain pages in your application, this structure lists those pages. You can't include both ExcludedPages and IncludedPages in the same operation.
        :param float session_sample_rate: Specifies the percentage of user sessions to use for RUM data collection. Choosing a higher percentage gives you more data but also incurs more costs. The number you specify is the percentage of user sessions that will be used. If you omit this parameter, the default of 10 is used.
        :param Sequence['AppMonitorTelemetry'] telemetries: An array that lists the types of telemetry data that this app monitor is to collect.
        """
        if allow_cookies is not None:
            pulumi.set(__self__, "allow_cookies", allow_cookies)
        if enable_x_ray is not None:
            pulumi.set(__self__, "enable_x_ray", enable_x_ray)
        if excluded_pages is not None:
            pulumi.set(__self__, "excluded_pages", excluded_pages)
        if favorite_pages is not None:
            pulumi.set(__self__, "favorite_pages", favorite_pages)
        if guest_role_arn is not None:
            pulumi.set(__self__, "guest_role_arn", guest_role_arn)
        if identity_pool_id is not None:
            pulumi.set(__self__, "identity_pool_id", identity_pool_id)
        if included_pages is not None:
            pulumi.set(__self__, "included_pages", included_pages)
        if session_sample_rate is not None:
            pulumi.set(__self__, "session_sample_rate", session_sample_rate)
        if telemetries is not None:
            pulumi.set(__self__, "telemetries", telemetries)

    @property
    @pulumi.getter(name="allowCookies")
    def allow_cookies(self) -> Optional[bool]:
        """
        If you set this to true, the RUM web client sets two cookies, a session cookie and a user cookie. The cookies allow the RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.
        """
        return pulumi.get(self, "allow_cookies")

    @property
    @pulumi.getter(name="enableXRay")
    def enable_x_ray(self) -> Optional[bool]:
        """
        If you set this to true, RUM enables xray tracing for the user sessions that RUM samples. RUM adds an xray trace header to allowed HTTP requests. It also records an xray segment for allowed HTTP requests. You can see traces and segments from these user sessions in the xray console and the CW ServiceLens console.
        """
        return pulumi.get(self, "enable_x_ray")

    @property
    @pulumi.getter(name="excludedPages")
    def excluded_pages(self) -> Optional[Sequence[str]]:
        """
        A list of URLs in your website or application to exclude from RUM data collection. You can't include both ExcludedPages and IncludedPages in the same operation.
        """
        return pulumi.get(self, "excluded_pages")

    @property
    @pulumi.getter(name="favoritePages")
    def favorite_pages(self) -> Optional[Sequence[str]]:
        """
        A list of pages in the RUM console that are to be displayed with a favorite icon.
        """
        return pulumi.get(self, "favorite_pages")

    @property
    @pulumi.getter(name="guestRoleArn")
    def guest_role_arn(self) -> Optional[str]:
        """
        The ARN of the guest IAM role that is attached to the identity pool that is used to authorize the sending of data to RUM.
        """
        return pulumi.get(self, "guest_role_arn")

    @property
    @pulumi.getter(name="identityPoolId")
    def identity_pool_id(self) -> Optional[str]:
        """
        The ID of the identity pool that is used to authorize the sending of data to RUM.
        """
        return pulumi.get(self, "identity_pool_id")

    @property
    @pulumi.getter(name="includedPages")
    def included_pages(self) -> Optional[Sequence[str]]:
        """
        If this app monitor is to collect data from only certain pages in your application, this structure lists those pages. You can't include both ExcludedPages and IncludedPages in the same operation.
        """
        return pulumi.get(self, "included_pages")

    @property
    @pulumi.getter(name="sessionSampleRate")
    def session_sample_rate(self) -> Optional[float]:
        """
        Specifies the percentage of user sessions to use for RUM data collection. Choosing a higher percentage gives you more data but also incurs more costs. The number you specify is the percentage of user sessions that will be used. If you omit this parameter, the default of 10 is used.
        """
        return pulumi.get(self, "session_sample_rate")

    @property
    @pulumi.getter
    def telemetries(self) -> Optional[Sequence['AppMonitorTelemetry']]:
        """
        An array that lists the types of telemetry data that this app monitor is to collect.
        """
        return pulumi.get(self, "telemetries")


@pulumi.output_type
class AppMonitorTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param str value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "value")


