# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'BotAliasAudioLogDestinationArgs',
    'BotAliasAudioLogSettingArgs',
    'BotAliasCloudWatchLogGroupLogDestinationArgs',
    'BotAliasCodeHookSpecificationArgs',
    'BotAliasConversationLogSettingsArgs',
    'BotAliasLambdaCodeHookArgs',
    'BotAliasLocaleSettingsItemArgs',
    'BotAliasLocaleSettingsArgs',
    'BotAliasS3BucketLogDestinationArgs',
    'BotAliasTagArgs',
    'BotAliasTextLogDestinationArgs',
    'BotAliasTextLogSettingArgs',
    'BotButtonArgs',
    'BotCustomPayloadArgs',
    'BotDialogCodeHookSettingArgs',
    'BotExternalSourceSettingArgs',
    'BotFulfillmentCodeHookSettingArgs',
    'BotFulfillmentStartResponseSpecificationArgs',
    'BotFulfillmentUpdateResponseSpecificationArgs',
    'BotFulfillmentUpdatesSpecificationArgs',
    'BotGrammarSlotTypeSettingArgs',
    'BotGrammarSlotTypeSourceArgs',
    'BotImageResponseCardArgs',
    'BotInputContextArgs',
    'BotIntentClosingSettingArgs',
    'BotIntentConfirmationSettingArgs',
    'BotIntentArgs',
    'BotKendraConfigurationArgs',
    'BotLocaleArgs',
    'BotMessageGroupArgs',
    'BotMessageArgs',
    'BotMultipleValuesSettingArgs',
    'BotObfuscationSettingArgs',
    'BotOutputContextArgs',
    'BotPlainTextMessageArgs',
    'BotPostFulfillmentStatusSpecificationArgs',
    'BotPromptSpecificationArgs',
    'BotResponseSpecificationArgs',
    'BotS3LocationArgs',
    'BotSSMLMessageArgs',
    'BotSampleUtteranceArgs',
    'BotSampleValueArgs',
    'BotSlotDefaultValueSpecificationArgs',
    'BotSlotDefaultValueArgs',
    'BotSlotPriorityArgs',
    'BotSlotTypeValueArgs',
    'BotSlotTypeArgs',
    'BotSlotValueElicitationSettingArgs',
    'BotSlotValueRegexFilterArgs',
    'BotSlotValueSelectionSettingArgs',
    'BotSlotArgs',
    'BotStillWaitingResponseSpecificationArgs',
    'BotTagArgs',
    'BotVersionLocaleDetailsArgs',
    'BotVersionLocaleSpecificationArgs',
    'BotVoiceSettingsArgs',
    'BotWaitAndContinueSpecificationArgs',
    'DataPrivacyPropertiesArgs',
    'ResourcePolicyPolicyArgs',
    'SentimentAnalysisSettingsPropertiesArgs',
]

@pulumi.input_type
class BotAliasAudioLogDestinationArgs:
    def __init__(__self__, *,
                 s3_bucket: Optional[pulumi.Input['BotAliasS3BucketLogDestinationArgs']] = None):
        """
        The location of audio log files collected when conversation logging is enabled for a bot.
        """
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional[pulumi.Input['BotAliasS3BucketLogDestinationArgs']]:
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: Optional[pulumi.Input['BotAliasS3BucketLogDestinationArgs']]):
        pulumi.set(self, "s3_bucket", value)


@pulumi.input_type
class BotAliasAudioLogSettingArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['BotAliasAudioLogDestinationArgs'],
                 enabled: pulumi.Input[bool]):
        """
        Settings for logging audio of conversations between Amazon Lex and a user. You specify whether to log audio and the Amazon S3 bucket where the audio file is stored.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input['BotAliasAudioLogDestinationArgs']:
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['BotAliasAudioLogDestinationArgs']):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class BotAliasCloudWatchLogGroupLogDestinationArgs:
    def __init__(__self__, *,
                 cloud_watch_log_group_arn: pulumi.Input[str],
                 log_prefix: pulumi.Input[str]):
        """
        :param pulumi.Input[str] cloud_watch_log_group_arn: A string used to identify this tag
        :param pulumi.Input[str] log_prefix: A string containing the value for the tag
        """
        pulumi.set(__self__, "cloud_watch_log_group_arn", cloud_watch_log_group_arn)
        pulumi.set(__self__, "log_prefix", log_prefix)

    @property
    @pulumi.getter(name="cloudWatchLogGroupArn")
    def cloud_watch_log_group_arn(self) -> pulumi.Input[str]:
        """
        A string used to identify this tag
        """
        return pulumi.get(self, "cloud_watch_log_group_arn")

    @cloud_watch_log_group_arn.setter
    def cloud_watch_log_group_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloud_watch_log_group_arn", value)

    @property
    @pulumi.getter(name="logPrefix")
    def log_prefix(self) -> pulumi.Input[str]:
        """
        A string containing the value for the tag
        """
        return pulumi.get(self, "log_prefix")

    @log_prefix.setter
    def log_prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_prefix", value)


@pulumi.input_type
class BotAliasCodeHookSpecificationArgs:
    def __init__(__self__, *,
                 lambda_code_hook: pulumi.Input['BotAliasLambdaCodeHookArgs']):
        """
        Contains information about code hooks that Amazon Lex calls during a conversation.
        """
        pulumi.set(__self__, "lambda_code_hook", lambda_code_hook)

    @property
    @pulumi.getter(name="lambdaCodeHook")
    def lambda_code_hook(self) -> pulumi.Input['BotAliasLambdaCodeHookArgs']:
        return pulumi.get(self, "lambda_code_hook")

    @lambda_code_hook.setter
    def lambda_code_hook(self, value: pulumi.Input['BotAliasLambdaCodeHookArgs']):
        pulumi.set(self, "lambda_code_hook", value)


@pulumi.input_type
class BotAliasConversationLogSettingsArgs:
    def __init__(__self__, *,
                 audio_log_settings: Optional[pulumi.Input[Sequence[pulumi.Input['BotAliasAudioLogSettingArgs']]]] = None,
                 text_log_settings: Optional[pulumi.Input[Sequence[pulumi.Input['BotAliasTextLogSettingArgs']]]] = None):
        """
        Contains information about code hooks that Amazon Lex calls during a conversation.
        """
        if audio_log_settings is not None:
            pulumi.set(__self__, "audio_log_settings", audio_log_settings)
        if text_log_settings is not None:
            pulumi.set(__self__, "text_log_settings", text_log_settings)

    @property
    @pulumi.getter(name="audioLogSettings")
    def audio_log_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BotAliasAudioLogSettingArgs']]]]:
        return pulumi.get(self, "audio_log_settings")

    @audio_log_settings.setter
    def audio_log_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BotAliasAudioLogSettingArgs']]]]):
        pulumi.set(self, "audio_log_settings", value)

    @property
    @pulumi.getter(name="textLogSettings")
    def text_log_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BotAliasTextLogSettingArgs']]]]:
        return pulumi.get(self, "text_log_settings")

    @text_log_settings.setter
    def text_log_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BotAliasTextLogSettingArgs']]]]):
        pulumi.set(self, "text_log_settings", value)


@pulumi.input_type
class BotAliasLambdaCodeHookArgs:
    def __init__(__self__, *,
                 code_hook_interface_version: pulumi.Input[str],
                 lambda_arn: pulumi.Input[str]):
        """
        Contains information about code hooks that Amazon Lex calls during a conversation.
        :param pulumi.Input[str] code_hook_interface_version: The version of the request-response that you want Amazon Lex to use to invoke your Lambda function.
        :param pulumi.Input[str] lambda_arn: The Amazon Resource Name (ARN) of the Lambda function.
        """
        pulumi.set(__self__, "code_hook_interface_version", code_hook_interface_version)
        pulumi.set(__self__, "lambda_arn", lambda_arn)

    @property
    @pulumi.getter(name="codeHookInterfaceVersion")
    def code_hook_interface_version(self) -> pulumi.Input[str]:
        """
        The version of the request-response that you want Amazon Lex to use to invoke your Lambda function.
        """
        return pulumi.get(self, "code_hook_interface_version")

    @code_hook_interface_version.setter
    def code_hook_interface_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "code_hook_interface_version", value)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the Lambda function.
        """
        return pulumi.get(self, "lambda_arn")

    @lambda_arn.setter
    def lambda_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "lambda_arn", value)


@pulumi.input_type
class BotAliasLocaleSettingsItemArgs:
    def __init__(__self__, *,
                 bot_alias_locale_setting: Optional[pulumi.Input['BotAliasLocaleSettingsArgs']] = None,
                 locale_id: Optional[pulumi.Input[str]] = None):
        """
        A locale setting in alias
        :param pulumi.Input[str] locale_id: A string used to identify the locale
        """
        if bot_alias_locale_setting is not None:
            pulumi.set(__self__, "bot_alias_locale_setting", bot_alias_locale_setting)
        if locale_id is not None:
            pulumi.set(__self__, "locale_id", locale_id)

    @property
    @pulumi.getter(name="botAliasLocaleSetting")
    def bot_alias_locale_setting(self) -> Optional[pulumi.Input['BotAliasLocaleSettingsArgs']]:
        return pulumi.get(self, "bot_alias_locale_setting")

    @bot_alias_locale_setting.setter
    def bot_alias_locale_setting(self, value: Optional[pulumi.Input['BotAliasLocaleSettingsArgs']]):
        pulumi.set(self, "bot_alias_locale_setting", value)

    @property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> Optional[pulumi.Input[str]]:
        """
        A string used to identify the locale
        """
        return pulumi.get(self, "locale_id")

    @locale_id.setter
    def locale_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locale_id", value)


@pulumi.input_type
class BotAliasLocaleSettingsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 code_hook_specification: Optional[pulumi.Input['BotAliasCodeHookSpecificationArgs']] = None):
        """
        You can use this parameter to specify a specific Lambda function to run different functions in different locales.
        :param pulumi.Input[bool] enabled: Whether the Lambda code hook is enabled
        """
        pulumi.set(__self__, "enabled", enabled)
        if code_hook_specification is not None:
            pulumi.set(__self__, "code_hook_specification", code_hook_specification)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether the Lambda code hook is enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="codeHookSpecification")
    def code_hook_specification(self) -> Optional[pulumi.Input['BotAliasCodeHookSpecificationArgs']]:
        return pulumi.get(self, "code_hook_specification")

    @code_hook_specification.setter
    def code_hook_specification(self, value: Optional[pulumi.Input['BotAliasCodeHookSpecificationArgs']]):
        pulumi.set(self, "code_hook_specification", value)


@pulumi.input_type
class BotAliasS3BucketLogDestinationArgs:
    def __init__(__self__, *,
                 log_prefix: pulumi.Input[str],
                 s3_bucket_arn: pulumi.Input[str],
                 kms_key_arn: Optional[pulumi.Input[str]] = None):
        """
        Specifies an Amazon S3 bucket for logging audio conversations
        :param pulumi.Input[str] log_prefix: The Amazon S3 key of the deployment package.
        :param pulumi.Input[str] s3_bucket_arn: The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored.
        :param pulumi.Input[str] kms_key_arn: The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key for encrypting audio log files stored in an S3 bucket.
        """
        pulumi.set(__self__, "log_prefix", log_prefix)
        pulumi.set(__self__, "s3_bucket_arn", s3_bucket_arn)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="logPrefix")
    def log_prefix(self) -> pulumi.Input[str]:
        """
        The Amazon S3 key of the deployment package.
        """
        return pulumi.get(self, "log_prefix")

    @log_prefix.setter
    def log_prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_prefix", value)

    @property
    @pulumi.getter(name="s3BucketArn")
    def s3_bucket_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are stored.
        """
        return pulumi.get(self, "s3_bucket_arn")

    @s3_bucket_arn.setter
    def s3_bucket_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_bucket_arn", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key for encrypting audio log files stored in an S3 bucket.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)


@pulumi.input_type
class BotAliasTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A label for tagging Lex resources
        :param pulumi.Input[str] key: A string used to identify this tag
        :param pulumi.Input[str] value: A string containing the value for the tag
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        A string used to identify this tag
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        A string containing the value for the tag
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class BotAliasTextLogDestinationArgs:
    def __init__(__self__, *,
                 cloud_watch: Optional[pulumi.Input['BotAliasCloudWatchLogGroupLogDestinationArgs']] = None):
        """
        Defines the Amazon CloudWatch Logs destination log group for conversation text logs.
        """
        if cloud_watch is not None:
            pulumi.set(__self__, "cloud_watch", cloud_watch)

    @property
    @pulumi.getter(name="cloudWatch")
    def cloud_watch(self) -> Optional[pulumi.Input['BotAliasCloudWatchLogGroupLogDestinationArgs']]:
        return pulumi.get(self, "cloud_watch")

    @cloud_watch.setter
    def cloud_watch(self, value: Optional[pulumi.Input['BotAliasCloudWatchLogGroupLogDestinationArgs']]):
        pulumi.set(self, "cloud_watch", value)


@pulumi.input_type
class BotAliasTextLogSettingArgs:
    def __init__(__self__, *,
                 destination: Optional[pulumi.Input['BotAliasTextLogDestinationArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Contains information about code hooks that Amazon Lex calls during a conversation.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['BotAliasTextLogDestinationArgs']]:
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['BotAliasTextLogDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class BotButtonArgs:
    def __init__(__self__, *,
                 text: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A button to use on a response card used to gather slot values from a user.
        :param pulumi.Input[str] text: The text that appears on the button.
        :param pulumi.Input[str] value: The value returned to Amazon Lex when the user chooses this button.
        """
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def text(self) -> pulumi.Input[str]:
        """
        The text that appears on the button.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: pulumi.Input[str]):
        pulumi.set(self, "text", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value returned to Amazon Lex when the user chooses this button.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class BotCustomPayloadArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str]):
        """
        A message in a custom format defined by the client application.
        :param pulumi.Input[str] value: The string that is sent to your application.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The string that is sent to your application.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class BotDialogCodeHookSettingArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool]):
        """
        Settings that determine the Lambda function that Amazon Lex uses for processing user responses.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class BotExternalSourceSettingArgs:
    def __init__(__self__, *,
                 grammar_slot_type_setting: Optional[pulumi.Input['BotGrammarSlotTypeSettingArgs']] = None):
        """
        Provides information about the external source of the slot type's definition.
        """
        if grammar_slot_type_setting is not None:
            pulumi.set(__self__, "grammar_slot_type_setting", grammar_slot_type_setting)

    @property
    @pulumi.getter(name="grammarSlotTypeSetting")
    def grammar_slot_type_setting(self) -> Optional[pulumi.Input['BotGrammarSlotTypeSettingArgs']]:
        return pulumi.get(self, "grammar_slot_type_setting")

    @grammar_slot_type_setting.setter
    def grammar_slot_type_setting(self, value: Optional[pulumi.Input['BotGrammarSlotTypeSettingArgs']]):
        pulumi.set(self, "grammar_slot_type_setting", value)


@pulumi.input_type
class BotFulfillmentCodeHookSettingArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 fulfillment_updates_specification: Optional[pulumi.Input['BotFulfillmentUpdatesSpecificationArgs']] = None,
                 post_fulfillment_status_specification: Optional[pulumi.Input['BotPostFulfillmentStatusSpecificationArgs']] = None):
        """
        Settings that determine if a Lambda function should be invoked to fulfill a specific intent.
        """
        pulumi.set(__self__, "enabled", enabled)
        if fulfillment_updates_specification is not None:
            pulumi.set(__self__, "fulfillment_updates_specification", fulfillment_updates_specification)
        if post_fulfillment_status_specification is not None:
            pulumi.set(__self__, "post_fulfillment_status_specification", post_fulfillment_status_specification)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="fulfillmentUpdatesSpecification")
    def fulfillment_updates_specification(self) -> Optional[pulumi.Input['BotFulfillmentUpdatesSpecificationArgs']]:
        return pulumi.get(self, "fulfillment_updates_specification")

    @fulfillment_updates_specification.setter
    def fulfillment_updates_specification(self, value: Optional[pulumi.Input['BotFulfillmentUpdatesSpecificationArgs']]):
        pulumi.set(self, "fulfillment_updates_specification", value)

    @property
    @pulumi.getter(name="postFulfillmentStatusSpecification")
    def post_fulfillment_status_specification(self) -> Optional[pulumi.Input['BotPostFulfillmentStatusSpecificationArgs']]:
        return pulumi.get(self, "post_fulfillment_status_specification")

    @post_fulfillment_status_specification.setter
    def post_fulfillment_status_specification(self, value: Optional[pulumi.Input['BotPostFulfillmentStatusSpecificationArgs']]):
        pulumi.set(self, "post_fulfillment_status_specification", value)


@pulumi.input_type
class BotFulfillmentStartResponseSpecificationArgs:
    def __init__(__self__, *,
                 delay_in_seconds: pulumi.Input[int],
                 message_groups: pulumi.Input[Sequence[pulumi.Input['BotMessageGroupArgs']]],
                 allow_interrupt: Optional[pulumi.Input[bool]] = None):
        """
        Provides settings for a message that is sent to the user when a fulfillment Lambda function starts running.
        :param pulumi.Input[int] delay_in_seconds: The delay between when the Lambda fulfillment function starts running and the start message is played. If the Lambda function returns before the delay is over, the start message isn't played.
        :param pulumi.Input[bool] allow_interrupt: Determines whether the user can interrupt the start message while it is playing.
        """
        pulumi.set(__self__, "delay_in_seconds", delay_in_seconds)
        pulumi.set(__self__, "message_groups", message_groups)
        if allow_interrupt is not None:
            pulumi.set(__self__, "allow_interrupt", allow_interrupt)

    @property
    @pulumi.getter(name="delayInSeconds")
    def delay_in_seconds(self) -> pulumi.Input[int]:
        """
        The delay between when the Lambda fulfillment function starts running and the start message is played. If the Lambda function returns before the delay is over, the start message isn't played.
        """
        return pulumi.get(self, "delay_in_seconds")

    @delay_in_seconds.setter
    def delay_in_seconds(self, value: pulumi.Input[int]):
        pulumi.set(self, "delay_in_seconds", value)

    @property
    @pulumi.getter(name="messageGroups")
    def message_groups(self) -> pulumi.Input[Sequence[pulumi.Input['BotMessageGroupArgs']]]:
        return pulumi.get(self, "message_groups")

    @message_groups.setter
    def message_groups(self, value: pulumi.Input[Sequence[pulumi.Input['BotMessageGroupArgs']]]):
        pulumi.set(self, "message_groups", value)

    @property
    @pulumi.getter(name="allowInterrupt")
    def allow_interrupt(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether the user can interrupt the start message while it is playing.
        """
        return pulumi.get(self, "allow_interrupt")

    @allow_interrupt.setter
    def allow_interrupt(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_interrupt", value)


@pulumi.input_type
class BotFulfillmentUpdateResponseSpecificationArgs:
    def __init__(__self__, *,
                 frequency_in_seconds: pulumi.Input[int],
                 message_groups: pulumi.Input[Sequence[pulumi.Input['BotMessageGroupArgs']]],
                 allow_interrupt: Optional[pulumi.Input[bool]] = None):
        """
        Provides settings for a message that is sent periodically to the user while a fulfillment Lambda function is running.
        :param pulumi.Input[int] frequency_in_seconds: The frequency that a message is sent to the user. When the period ends, Amazon Lex chooses a message from the message groups and plays it to the user. If the fulfillment Lambda returns before the first period ends, an update message is not played to the user.
        :param pulumi.Input[bool] allow_interrupt: Determines whether the user can interrupt an update message while it is playing.
        """
        pulumi.set(__self__, "frequency_in_seconds", frequency_in_seconds)
        pulumi.set(__self__, "message_groups", message_groups)
        if allow_interrupt is not None:
            pulumi.set(__self__, "allow_interrupt", allow_interrupt)

    @property
    @pulumi.getter(name="frequencyInSeconds")
    def frequency_in_seconds(self) -> pulumi.Input[int]:
        """
        The frequency that a message is sent to the user. When the period ends, Amazon Lex chooses a message from the message groups and plays it to the user. If the fulfillment Lambda returns before the first period ends, an update message is not played to the user.
        """
        return pulumi.get(self, "frequency_in_seconds")

    @frequency_in_seconds.setter
    def frequency_in_seconds(self, value: pulumi.Input[int]):
        pulumi.set(self, "frequency_in_seconds", value)

    @property
    @pulumi.getter(name="messageGroups")
    def message_groups(self) -> pulumi.Input[Sequence[pulumi.Input['BotMessageGroupArgs']]]:
        return pulumi.get(self, "message_groups")

    @message_groups.setter
    def message_groups(self, value: pulumi.Input[Sequence[pulumi.Input['BotMessageGroupArgs']]]):
        pulumi.set(self, "message_groups", value)

    @property
    @pulumi.getter(name="allowInterrupt")
    def allow_interrupt(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether the user can interrupt an update message while it is playing.
        """
        return pulumi.get(self, "allow_interrupt")

    @allow_interrupt.setter
    def allow_interrupt(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_interrupt", value)


@pulumi.input_type
class BotFulfillmentUpdatesSpecificationArgs:
    def __init__(__self__, *,
                 active: pulumi.Input[bool],
                 start_response: Optional[pulumi.Input['BotFulfillmentStartResponseSpecificationArgs']] = None,
                 timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 update_response: Optional[pulumi.Input['BotFulfillmentUpdateResponseSpecificationArgs']] = None):
        """
        Provides information for updating the user on the progress of fulfilling an intent.
        :param pulumi.Input[bool] active: Determines whether fulfillment updates are sent to the user. When this field is true, updates are sent.
        :param pulumi.Input[int] timeout_in_seconds: The length of time that the fulfillment Lambda function should run before it times out.
        """
        pulumi.set(__self__, "active", active)
        if start_response is not None:
            pulumi.set(__self__, "start_response", start_response)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if update_response is not None:
            pulumi.set(__self__, "update_response", update_response)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Input[bool]:
        """
        Determines whether fulfillment updates are sent to the user. When this field is true, updates are sent.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: pulumi.Input[bool]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="startResponse")
    def start_response(self) -> Optional[pulumi.Input['BotFulfillmentStartResponseSpecificationArgs']]:
        return pulumi.get(self, "start_response")

    @start_response.setter
    def start_response(self, value: Optional[pulumi.Input['BotFulfillmentStartResponseSpecificationArgs']]):
        pulumi.set(self, "start_response", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The length of time that the fulfillment Lambda function should run before it times out.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @property
    @pulumi.getter(name="updateResponse")
    def update_response(self) -> Optional[pulumi.Input['BotFulfillmentUpdateResponseSpecificationArgs']]:
        return pulumi.get(self, "update_response")

    @update_response.setter
    def update_response(self, value: Optional[pulumi.Input['BotFulfillmentUpdateResponseSpecificationArgs']]):
        pulumi.set(self, "update_response", value)


@pulumi.input_type
class BotGrammarSlotTypeSettingArgs:
    def __init__(__self__, *,
                 source: Optional[pulumi.Input['BotGrammarSlotTypeSourceArgs']] = None):
        """
        Settings required for a slot type based on a grammar that you provide.
        """
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['BotGrammarSlotTypeSourceArgs']]:
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['BotGrammarSlotTypeSourceArgs']]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class BotGrammarSlotTypeSourceArgs:
    def __init__(__self__, *,
                 s3_bucket_name: pulumi.Input[str],
                 s3_object_key: pulumi.Input[str],
                 kms_key_arn: Optional[pulumi.Input[str]] = None):
        """
        Describes the Amazon S3 bucket name and location for the grammar that is the source for the slot type.
        :param pulumi.Input[str] s3_bucket_name: The name of the S3 bucket that contains the grammar source.
        :param pulumi.Input[str] s3_object_key: The path to the grammar in the S3 bucket.
        :param pulumi.Input[str] kms_key_arn: The Amazon KMS key required to decrypt the contents of the grammar, if any.
        """
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        pulumi.set(__self__, "s3_object_key", s3_object_key)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> pulumi.Input[str]:
        """
        The name of the S3 bucket that contains the grammar source.
        """
        return pulumi.get(self, "s3_bucket_name")

    @s3_bucket_name.setter
    def s3_bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_bucket_name", value)

    @property
    @pulumi.getter(name="s3ObjectKey")
    def s3_object_key(self) -> pulumi.Input[str]:
        """
        The path to the grammar in the S3 bucket.
        """
        return pulumi.get(self, "s3_object_key")

    @s3_object_key.setter
    def s3_object_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_object_key", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon KMS key required to decrypt the contents of the grammar, if any.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)


@pulumi.input_type
class BotImageResponseCardArgs:
    def __init__(__self__, *,
                 title: pulumi.Input[str],
                 buttons: Optional[pulumi.Input[Sequence[pulumi.Input['BotButtonArgs']]]] = None,
                 image_url: Optional[pulumi.Input[str]] = None,
                 subtitle: Optional[pulumi.Input[str]] = None):
        """
        A message that defines a response card that the client application can show to the user.
        :param pulumi.Input[str] title: The title to display on the response card.
        :param pulumi.Input[Sequence[pulumi.Input['BotButtonArgs']]] buttons: A list of buttons that should be displayed on the response card.
        :param pulumi.Input[str] image_url: The URL of an image to display on the response card.
        :param pulumi.Input[str] subtitle: The subtitle to display on the response card.
        """
        pulumi.set(__self__, "title", title)
        if buttons is not None:
            pulumi.set(__self__, "buttons", buttons)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if subtitle is not None:
            pulumi.set(__self__, "subtitle", subtitle)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        The title to display on the response card.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def buttons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BotButtonArgs']]]]:
        """
        A list of buttons that should be displayed on the response card.
        """
        return pulumi.get(self, "buttons")

    @buttons.setter
    def buttons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BotButtonArgs']]]]):
        pulumi.set(self, "buttons", value)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of an image to display on the response card.
        """
        return pulumi.get(self, "image_url")

    @image_url.setter
    def image_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_url", value)

    @property
    @pulumi.getter
    def subtitle(self) -> Optional[pulumi.Input[str]]:
        """
        The subtitle to display on the response card.
        """
        return pulumi.get(self, "subtitle")

    @subtitle.setter
    def subtitle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subtitle", value)


@pulumi.input_type
class BotInputContextArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        InputContext specified for the intent.
        :param pulumi.Input[str] name: The name of the context.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the context.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class BotIntentClosingSettingArgs:
    def __init__(__self__, *,
                 closing_response: pulumi.Input['BotResponseSpecificationArgs'],
                 is_active: Optional[pulumi.Input[bool]] = None):
        """
        Response that Amazon Lex sends to the user when the intent is closed.
        """
        pulumi.set(__self__, "closing_response", closing_response)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)

    @property
    @pulumi.getter(name="closingResponse")
    def closing_response(self) -> pulumi.Input['BotResponseSpecificationArgs']:
        return pulumi.get(self, "closing_response")

    @closing_response.setter
    def closing_response(self, value: pulumi.Input['BotResponseSpecificationArgs']):
        pulumi.set(self, "closing_response", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_active", value)


@pulumi.input_type
class BotIntentConfirmationSettingArgs:
    def __init__(__self__, *,
                 declination_response: pulumi.Input['BotResponseSpecificationArgs'],
                 prompt_specification: pulumi.Input['BotPromptSpecificationArgs'],
                 is_active: Optional[pulumi.Input[bool]] = None):
        """
        Prompts that Amazon Lex sends to the user to confirm the completion of an intent.
        """
        pulumi.set(__self__, "declination_response", declination_response)
        pulumi.set(__self__, "prompt_specification", prompt_specification)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)

    @property
    @pulumi.getter(name="declinationResponse")
    def declination_response(self) -> pulumi.Input['BotResponseSpecificationArgs']:
        return pulumi.get(self, "declination_response")

    @declination_response.setter
    def declination_response(self, value: pulumi.Input['BotResponseSpecificationArgs']):
        pulumi.set(self, "declination_response", value)

    @property
    @pulumi.getter(name="promptSpecification")
    def prompt_specification(self) -> pulumi.Input['BotPromptSpecificationArgs']:
        return pulumi.get(self, "prompt_specification")

    @prompt_specification.setter
    def prompt_specification(self, value: pulumi.Input['BotPromptSpecificationArgs']):
        pulumi.set(self, "prompt_specification", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_active", value)


@pulumi.input_type
class BotIntentArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 dialog_code_hook: Optional[pulumi.Input['BotDialogCodeHookSettingArgs']] = None,
                 fulfillment_code_hook: Optional[pulumi.Input['BotFulfillmentCodeHookSettingArgs']] = None,
                 input_contexts: Optional[pulumi.Input[Sequence[pulumi.Input['BotInputContextArgs']]]] = None,
                 intent_closing_setting: Optional[pulumi.Input['BotIntentClosingSettingArgs']] = None,
                 intent_confirmation_setting: Optional[pulumi.Input['BotIntentConfirmationSettingArgs']] = None,
                 kendra_configuration: Optional[pulumi.Input['BotKendraConfigurationArgs']] = None,
                 output_contexts: Optional[pulumi.Input[Sequence[pulumi.Input['BotOutputContextArgs']]]] = None,
                 parent_intent_signature: Optional[pulumi.Input[str]] = None,
                 sample_utterances: Optional[pulumi.Input[Sequence[pulumi.Input['BotSampleUtteranceArgs']]]] = None,
                 slot_priorities: Optional[pulumi.Input[Sequence[pulumi.Input['BotSlotPriorityArgs']]]] = None,
                 slots: Optional[pulumi.Input[Sequence[pulumi.Input['BotSlotArgs']]]] = None):
        """
        An intent represents an action that the user wants to perform. You create a bot to support one or more related intents.
        :param pulumi.Input[Sequence[pulumi.Input['BotSlotArgs']]] slots: List of slots
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dialog_code_hook is not None:
            pulumi.set(__self__, "dialog_code_hook", dialog_code_hook)
        if fulfillment_code_hook is not None:
            pulumi.set(__self__, "fulfillment_code_hook", fulfillment_code_hook)
        if input_contexts is not None:
            pulumi.set(__self__, "input_contexts", input_contexts)
        if intent_closing_setting is not None:
            pulumi.set(__self__, "intent_closing_setting", intent_closing_setting)
        if intent_confirmation_setting is not None:
            pulumi.set(__self__, "intent_confirmation_setting", intent_confirmation_setting)
        if kendra_configuration is not None:
            pulumi.set(__self__, "kendra_configuration", kendra_configuration)
        if output_contexts is not None:
            pulumi.set(__self__, "output_contexts", output_contexts)
        if parent_intent_signature is not None:
            pulumi.set(__self__, "parent_intent_signature", parent_intent_signature)
        if sample_utterances is not None:
            pulumi.set(__self__, "sample_utterances", sample_utterances)
        if slot_priorities is not None:
            pulumi.set(__self__, "slot_priorities", slot_priorities)
        if slots is not None:
            pulumi.set(__self__, "slots", slots)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dialogCodeHook")
    def dialog_code_hook(self) -> Optional[pulumi.Input['BotDialogCodeHookSettingArgs']]:
        return pulumi.get(self, "dialog_code_hook")

    @dialog_code_hook.setter
    def dialog_code_hook(self, value: Optional[pulumi.Input['BotDialogCodeHookSettingArgs']]):
        pulumi.set(self, "dialog_code_hook", value)

    @property
    @pulumi.getter(name="fulfillmentCodeHook")
    def fulfillment_code_hook(self) -> Optional[pulumi.Input['BotFulfillmentCodeHookSettingArgs']]:
        return pulumi.get(self, "fulfillment_code_hook")

    @fulfillment_code_hook.setter
    def fulfillment_code_hook(self, value: Optional[pulumi.Input['BotFulfillmentCodeHookSettingArgs']]):
        pulumi.set(self, "fulfillment_code_hook", value)

    @property
    @pulumi.getter(name="inputContexts")
    def input_contexts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BotInputContextArgs']]]]:
        return pulumi.get(self, "input_contexts")

    @input_contexts.setter
    def input_contexts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BotInputContextArgs']]]]):
        pulumi.set(self, "input_contexts", value)

    @property
    @pulumi.getter(name="intentClosingSetting")
    def intent_closing_setting(self) -> Optional[pulumi.Input['BotIntentClosingSettingArgs']]:
        return pulumi.get(self, "intent_closing_setting")

    @intent_closing_setting.setter
    def intent_closing_setting(self, value: Optional[pulumi.Input['BotIntentClosingSettingArgs']]):
        pulumi.set(self, "intent_closing_setting", value)

    @property
    @pulumi.getter(name="intentConfirmationSetting")
    def intent_confirmation_setting(self) -> Optional[pulumi.Input['BotIntentConfirmationSettingArgs']]:
        return pulumi.get(self, "intent_confirmation_setting")

    @intent_confirmation_setting.setter
    def intent_confirmation_setting(self, value: Optional[pulumi.Input['BotIntentConfirmationSettingArgs']]):
        pulumi.set(self, "intent_confirmation_setting", value)

    @property
    @pulumi.getter(name="kendraConfiguration")
    def kendra_configuration(self) -> Optional[pulumi.Input['BotKendraConfigurationArgs']]:
        return pulumi.get(self, "kendra_configuration")

    @kendra_configuration.setter
    def kendra_configuration(self, value: Optional[pulumi.Input['BotKendraConfigurationArgs']]):
        pulumi.set(self, "kendra_configuration", value)

    @property
    @pulumi.getter(name="outputContexts")
    def output_contexts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BotOutputContextArgs']]]]:
        return pulumi.get(self, "output_contexts")

    @output_contexts.setter
    def output_contexts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BotOutputContextArgs']]]]):
        pulumi.set(self, "output_contexts", value)

    @property
    @pulumi.getter(name="parentIntentSignature")
    def parent_intent_signature(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "parent_intent_signature")

    @parent_intent_signature.setter
    def parent_intent_signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_intent_signature", value)

    @property
    @pulumi.getter(name="sampleUtterances")
    def sample_utterances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BotSampleUtteranceArgs']]]]:
        return pulumi.get(self, "sample_utterances")

    @sample_utterances.setter
    def sample_utterances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BotSampleUtteranceArgs']]]]):
        pulumi.set(self, "sample_utterances", value)

    @property
    @pulumi.getter(name="slotPriorities")
    def slot_priorities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BotSlotPriorityArgs']]]]:
        return pulumi.get(self, "slot_priorities")

    @slot_priorities.setter
    def slot_priorities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BotSlotPriorityArgs']]]]):
        pulumi.set(self, "slot_priorities", value)

    @property
    @pulumi.getter
    def slots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BotSlotArgs']]]]:
        """
        List of slots
        """
        return pulumi.get(self, "slots")

    @slots.setter
    def slots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BotSlotArgs']]]]):
        pulumi.set(self, "slots", value)


@pulumi.input_type
class BotKendraConfigurationArgs:
    def __init__(__self__, *,
                 kendra_index: pulumi.Input[str],
                 query_filter_string: Optional[pulumi.Input[str]] = None,
                 query_filter_string_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for searching a Amazon Kendra index specified for the intent.
        :param pulumi.Input[bool] query_filter_string_enabled: Determines whether the AMAZON.KendraSearchIntent intent uses a custom query string to query the Amazon Kendra index.
        """
        pulumi.set(__self__, "kendra_index", kendra_index)
        if query_filter_string is not None:
            pulumi.set(__self__, "query_filter_string", query_filter_string)
        if query_filter_string_enabled is not None:
            pulumi.set(__self__, "query_filter_string_enabled", query_filter_string_enabled)

    @property
    @pulumi.getter(name="kendraIndex")
    def kendra_index(self) -> pulumi.Input[str]:
        return pulumi.get(self, "kendra_index")

    @kendra_index.setter
    def kendra_index(self, value: pulumi.Input[str]):
        pulumi.set(self, "kendra_index", value)

    @property
    @pulumi.getter(name="queryFilterString")
    def query_filter_string(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "query_filter_string")

    @query_filter_string.setter
    def query_filter_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_filter_string", value)

    @property
    @pulumi.getter(name="queryFilterStringEnabled")
    def query_filter_string_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether the AMAZON.KendraSearchIntent intent uses a custom query string to query the Amazon Kendra index.
        """
        return pulumi.get(self, "query_filter_string_enabled")

    @query_filter_string_enabled.setter
    def query_filter_string_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "query_filter_string_enabled", value)


@pulumi.input_type
class BotLocaleArgs:
    def __init__(__self__, *,
                 locale_id: pulumi.Input[str],
                 nlu_confidence_threshold: pulumi.Input[float],
                 description: Optional[pulumi.Input[str]] = None,
                 intents: Optional[pulumi.Input[Sequence[pulumi.Input['BotIntentArgs']]]] = None,
                 slot_types: Optional[pulumi.Input[Sequence[pulumi.Input['BotSlotTypeArgs']]]] = None,
                 voice_settings: Optional[pulumi.Input['BotVoiceSettingsArgs']] = None):
        """
        A locale in the bot, which contains the intents and slot types that the bot uses in conversations with users in the specified language and locale.
        :param pulumi.Input[Sequence[pulumi.Input['BotIntentArgs']]] intents: List of intents
        :param pulumi.Input[Sequence[pulumi.Input['BotSlotTypeArgs']]] slot_types: List of SlotTypes
        """
        pulumi.set(__self__, "locale_id", locale_id)
        pulumi.set(__self__, "nlu_confidence_threshold", nlu_confidence_threshold)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if intents is not None:
            pulumi.set(__self__, "intents", intents)
        if slot_types is not None:
            pulumi.set(__self__, "slot_types", slot_types)
        if voice_settings is not None:
            pulumi.set(__self__, "voice_settings", voice_settings)

    @property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "locale_id")

    @locale_id.setter
    def locale_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "locale_id", value)

    @property
    @pulumi.getter(name="nluConfidenceThreshold")
    def nlu_confidence_threshold(self) -> pulumi.Input[float]:
        return pulumi.get(self, "nlu_confidence_threshold")

    @nlu_confidence_threshold.setter
    def nlu_confidence_threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "nlu_confidence_threshold", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def intents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BotIntentArgs']]]]:
        """
        List of intents
        """
        return pulumi.get(self, "intents")

    @intents.setter
    def intents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BotIntentArgs']]]]):
        pulumi.set(self, "intents", value)

    @property
    @pulumi.getter(name="slotTypes")
    def slot_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BotSlotTypeArgs']]]]:
        """
        List of SlotTypes
        """
        return pulumi.get(self, "slot_types")

    @slot_types.setter
    def slot_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BotSlotTypeArgs']]]]):
        pulumi.set(self, "slot_types", value)

    @property
    @pulumi.getter(name="voiceSettings")
    def voice_settings(self) -> Optional[pulumi.Input['BotVoiceSettingsArgs']]:
        return pulumi.get(self, "voice_settings")

    @voice_settings.setter
    def voice_settings(self, value: Optional[pulumi.Input['BotVoiceSettingsArgs']]):
        pulumi.set(self, "voice_settings", value)


@pulumi.input_type
class BotMessageGroupArgs:
    def __init__(__self__, *,
                 message: pulumi.Input['BotMessageArgs'],
                 variations: Optional[pulumi.Input[Sequence[pulumi.Input['BotMessageArgs']]]] = None):
        """
        One or more messages that Amazon Lex can send to the user.
        :param pulumi.Input[Sequence[pulumi.Input['BotMessageArgs']]] variations: Message variations to send to the user.
        """
        pulumi.set(__self__, "message", message)
        if variations is not None:
            pulumi.set(__self__, "variations", variations)

    @property
    @pulumi.getter
    def message(self) -> pulumi.Input['BotMessageArgs']:
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: pulumi.Input['BotMessageArgs']):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def variations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BotMessageArgs']]]]:
        """
        Message variations to send to the user.
        """
        return pulumi.get(self, "variations")

    @variations.setter
    def variations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BotMessageArgs']]]]):
        pulumi.set(self, "variations", value)


@pulumi.input_type
class BotMessageArgs:
    def __init__(__self__, *,
                 custom_payload: Optional[pulumi.Input['BotCustomPayloadArgs']] = None,
                 image_response_card: Optional[pulumi.Input['BotImageResponseCardArgs']] = None,
                 plain_text_message: Optional[pulumi.Input['BotPlainTextMessageArgs']] = None,
                 s_sml_message: Optional[pulumi.Input['BotSSMLMessageArgs']] = None):
        """
        The primary message that Amazon Lex should send to the user.
        """
        if custom_payload is not None:
            pulumi.set(__self__, "custom_payload", custom_payload)
        if image_response_card is not None:
            pulumi.set(__self__, "image_response_card", image_response_card)
        if plain_text_message is not None:
            pulumi.set(__self__, "plain_text_message", plain_text_message)
        if s_sml_message is not None:
            pulumi.set(__self__, "s_sml_message", s_sml_message)

    @property
    @pulumi.getter(name="customPayload")
    def custom_payload(self) -> Optional[pulumi.Input['BotCustomPayloadArgs']]:
        return pulumi.get(self, "custom_payload")

    @custom_payload.setter
    def custom_payload(self, value: Optional[pulumi.Input['BotCustomPayloadArgs']]):
        pulumi.set(self, "custom_payload", value)

    @property
    @pulumi.getter(name="imageResponseCard")
    def image_response_card(self) -> Optional[pulumi.Input['BotImageResponseCardArgs']]:
        return pulumi.get(self, "image_response_card")

    @image_response_card.setter
    def image_response_card(self, value: Optional[pulumi.Input['BotImageResponseCardArgs']]):
        pulumi.set(self, "image_response_card", value)

    @property
    @pulumi.getter(name="plainTextMessage")
    def plain_text_message(self) -> Optional[pulumi.Input['BotPlainTextMessageArgs']]:
        return pulumi.get(self, "plain_text_message")

    @plain_text_message.setter
    def plain_text_message(self, value: Optional[pulumi.Input['BotPlainTextMessageArgs']]):
        pulumi.set(self, "plain_text_message", value)

    @property
    @pulumi.getter(name="sSMLMessage")
    def s_sml_message(self) -> Optional[pulumi.Input['BotSSMLMessageArgs']]:
        return pulumi.get(self, "s_sml_message")

    @s_sml_message.setter
    def s_sml_message(self, value: Optional[pulumi.Input['BotSSMLMessageArgs']]):
        pulumi.set(self, "s_sml_message", value)


@pulumi.input_type
class BotMultipleValuesSettingArgs:
    def __init__(__self__, *,
                 allow_multiple_values: Optional[pulumi.Input[bool]] = None):
        """
        Indicates whether a slot can return multiple values.
        """
        if allow_multiple_values is not None:
            pulumi.set(__self__, "allow_multiple_values", allow_multiple_values)

    @property
    @pulumi.getter(name="allowMultipleValues")
    def allow_multiple_values(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_multiple_values")

    @allow_multiple_values.setter
    def allow_multiple_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_multiple_values", value)


@pulumi.input_type
class BotObfuscationSettingArgs:
    def __init__(__self__, *,
                 obfuscation_setting_type: pulumi.Input['BotObfuscationSettingObfuscationSettingType']):
        """
        Determines whether Amazon Lex obscures slot values in conversation logs.
        :param pulumi.Input['BotObfuscationSettingObfuscationSettingType'] obfuscation_setting_type: Value that determines whether Amazon Lex obscures slot values in conversation logs. The default is to obscure the values.
        """
        pulumi.set(__self__, "obfuscation_setting_type", obfuscation_setting_type)

    @property
    @pulumi.getter(name="obfuscationSettingType")
    def obfuscation_setting_type(self) -> pulumi.Input['BotObfuscationSettingObfuscationSettingType']:
        """
        Value that determines whether Amazon Lex obscures slot values in conversation logs. The default is to obscure the values.
        """
        return pulumi.get(self, "obfuscation_setting_type")

    @obfuscation_setting_type.setter
    def obfuscation_setting_type(self, value: pulumi.Input['BotObfuscationSettingObfuscationSettingType']):
        pulumi.set(self, "obfuscation_setting_type", value)


@pulumi.input_type
class BotOutputContextArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 time_to_live_in_seconds: pulumi.Input[int],
                 turns_to_live: pulumi.Input[int]):
        """
        A session context that is activated when an intent is fulfilled.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "time_to_live_in_seconds", time_to_live_in_seconds)
        pulumi.set(__self__, "turns_to_live", turns_to_live)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="timeToLiveInSeconds")
    def time_to_live_in_seconds(self) -> pulumi.Input[int]:
        return pulumi.get(self, "time_to_live_in_seconds")

    @time_to_live_in_seconds.setter
    def time_to_live_in_seconds(self, value: pulumi.Input[int]):
        pulumi.set(self, "time_to_live_in_seconds", value)

    @property
    @pulumi.getter(name="turnsToLive")
    def turns_to_live(self) -> pulumi.Input[int]:
        return pulumi.get(self, "turns_to_live")

    @turns_to_live.setter
    def turns_to_live(self, value: pulumi.Input[int]):
        pulumi.set(self, "turns_to_live", value)


@pulumi.input_type
class BotPlainTextMessageArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str]):
        """
        A message in plain text format.
        :param pulumi.Input[str] value: The message to send to the user.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The message to send to the user.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class BotPostFulfillmentStatusSpecificationArgs:
    def __init__(__self__, *,
                 failure_response: Optional[pulumi.Input['BotResponseSpecificationArgs']] = None,
                 success_response: Optional[pulumi.Input['BotResponseSpecificationArgs']] = None,
                 timeout_response: Optional[pulumi.Input['BotResponseSpecificationArgs']] = None):
        """
        Provides information for updating the user on the progress of fulfilling an intent.
        """
        if failure_response is not None:
            pulumi.set(__self__, "failure_response", failure_response)
        if success_response is not None:
            pulumi.set(__self__, "success_response", success_response)
        if timeout_response is not None:
            pulumi.set(__self__, "timeout_response", timeout_response)

    @property
    @pulumi.getter(name="failureResponse")
    def failure_response(self) -> Optional[pulumi.Input['BotResponseSpecificationArgs']]:
        return pulumi.get(self, "failure_response")

    @failure_response.setter
    def failure_response(self, value: Optional[pulumi.Input['BotResponseSpecificationArgs']]):
        pulumi.set(self, "failure_response", value)

    @property
    @pulumi.getter(name="successResponse")
    def success_response(self) -> Optional[pulumi.Input['BotResponseSpecificationArgs']]:
        return pulumi.get(self, "success_response")

    @success_response.setter
    def success_response(self, value: Optional[pulumi.Input['BotResponseSpecificationArgs']]):
        pulumi.set(self, "success_response", value)

    @property
    @pulumi.getter(name="timeoutResponse")
    def timeout_response(self) -> Optional[pulumi.Input['BotResponseSpecificationArgs']]:
        return pulumi.get(self, "timeout_response")

    @timeout_response.setter
    def timeout_response(self, value: Optional[pulumi.Input['BotResponseSpecificationArgs']]):
        pulumi.set(self, "timeout_response", value)


@pulumi.input_type
class BotPromptSpecificationArgs:
    def __init__(__self__, *,
                 max_retries: pulumi.Input[int],
                 message_groups_list: pulumi.Input[Sequence[pulumi.Input['BotMessageGroupArgs']]],
                 allow_interrupt: Optional[pulumi.Input[bool]] = None):
        """
        Prompts the user to confirm the intent.
        :param pulumi.Input[bool] allow_interrupt: Indicates whether the user can interrupt a speech prompt from the bot.
        """
        pulumi.set(__self__, "max_retries", max_retries)
        pulumi.set(__self__, "message_groups_list", message_groups_list)
        if allow_interrupt is not None:
            pulumi.set(__self__, "allow_interrupt", allow_interrupt)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> pulumi.Input[int]:
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter(name="messageGroupsList")
    def message_groups_list(self) -> pulumi.Input[Sequence[pulumi.Input['BotMessageGroupArgs']]]:
        return pulumi.get(self, "message_groups_list")

    @message_groups_list.setter
    def message_groups_list(self, value: pulumi.Input[Sequence[pulumi.Input['BotMessageGroupArgs']]]):
        pulumi.set(self, "message_groups_list", value)

    @property
    @pulumi.getter(name="allowInterrupt")
    def allow_interrupt(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the user can interrupt a speech prompt from the bot.
        """
        return pulumi.get(self, "allow_interrupt")

    @allow_interrupt.setter
    def allow_interrupt(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_interrupt", value)


@pulumi.input_type
class BotResponseSpecificationArgs:
    def __init__(__self__, *,
                 message_groups_list: pulumi.Input[Sequence[pulumi.Input['BotMessageGroupArgs']]],
                 allow_interrupt: Optional[pulumi.Input[bool]] = None):
        """
        A list of message groups that Amazon Lex uses to respond the user input.
        :param pulumi.Input[bool] allow_interrupt: Indicates whether the user can interrupt a speech prompt from the bot.
        """
        pulumi.set(__self__, "message_groups_list", message_groups_list)
        if allow_interrupt is not None:
            pulumi.set(__self__, "allow_interrupt", allow_interrupt)

    @property
    @pulumi.getter(name="messageGroupsList")
    def message_groups_list(self) -> pulumi.Input[Sequence[pulumi.Input['BotMessageGroupArgs']]]:
        return pulumi.get(self, "message_groups_list")

    @message_groups_list.setter
    def message_groups_list(self, value: pulumi.Input[Sequence[pulumi.Input['BotMessageGroupArgs']]]):
        pulumi.set(self, "message_groups_list", value)

    @property
    @pulumi.getter(name="allowInterrupt")
    def allow_interrupt(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the user can interrupt a speech prompt from the bot.
        """
        return pulumi.get(self, "allow_interrupt")

    @allow_interrupt.setter
    def allow_interrupt(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_interrupt", value)


@pulumi.input_type
class BotS3LocationArgs:
    def __init__(__self__, *,
                 s3_bucket: pulumi.Input[str],
                 s3_object_key: pulumi.Input[str],
                 s3_object_version: Optional[pulumi.Input[str]] = None):
        """
        S3 location of bot definitions zip file, if it's not defined inline in CloudFormation.
        :param pulumi.Input[str] s3_bucket: An Amazon S3 bucket in the same AWS Region as your function. The bucket can be in a different AWS account.
        :param pulumi.Input[str] s3_object_key: The Amazon S3 key of the deployment package.
        :param pulumi.Input[str] s3_object_version: For versioned objects, the version of the deployment package object to use. If not specified, the current object version will be used.
        """
        pulumi.set(__self__, "s3_bucket", s3_bucket)
        pulumi.set(__self__, "s3_object_key", s3_object_key)
        if s3_object_version is not None:
            pulumi.set(__self__, "s3_object_version", s3_object_version)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> pulumi.Input[str]:
        """
        An Amazon S3 bucket in the same AWS Region as your function. The bucket can be in a different AWS account.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_bucket", value)

    @property
    @pulumi.getter(name="s3ObjectKey")
    def s3_object_key(self) -> pulumi.Input[str]:
        """
        The Amazon S3 key of the deployment package.
        """
        return pulumi.get(self, "s3_object_key")

    @s3_object_key.setter
    def s3_object_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "s3_object_key", value)

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> Optional[pulumi.Input[str]]:
        """
        For versioned objects, the version of the deployment package object to use. If not specified, the current object version will be used.
        """
        return pulumi.get(self, "s3_object_version")

    @s3_object_version.setter
    def s3_object_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_object_version", value)


@pulumi.input_type
class BotSSMLMessageArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str]):
        """
        A message in Speech Synthesis Markup Language (SSML).
        :param pulumi.Input[str] value: The SSML text that defines the prompt.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The SSML text that defines the prompt.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class BotSampleUtteranceArgs:
    def __init__(__self__, *,
                 utterance: pulumi.Input[str]):
        """
        A sample utterance that invokes an intent or respond to a slot elicitation prompt.
        """
        pulumi.set(__self__, "utterance", utterance)

    @property
    @pulumi.getter
    def utterance(self) -> pulumi.Input[str]:
        return pulumi.get(self, "utterance")

    @utterance.setter
    def utterance(self, value: pulumi.Input[str]):
        pulumi.set(self, "utterance", value)


@pulumi.input_type
class BotSampleValueArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str]):
        """
        Defines one of the values for a slot type.
        :param pulumi.Input[str] value: The value that can be used for a slot type.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value that can be used for a slot type.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class BotSlotDefaultValueSpecificationArgs:
    def __init__(__self__, *,
                 default_value_list: pulumi.Input[Sequence[pulumi.Input['BotSlotDefaultValueArgs']]]):
        """
        A list of values that Amazon Lex should use as the default value for a slot.
        :param pulumi.Input[Sequence[pulumi.Input['BotSlotDefaultValueArgs']]] default_value_list: A list of slot default values
        """
        pulumi.set(__self__, "default_value_list", default_value_list)

    @property
    @pulumi.getter(name="defaultValueList")
    def default_value_list(self) -> pulumi.Input[Sequence[pulumi.Input['BotSlotDefaultValueArgs']]]:
        """
        A list of slot default values
        """
        return pulumi.get(self, "default_value_list")

    @default_value_list.setter
    def default_value_list(self, value: pulumi.Input[Sequence[pulumi.Input['BotSlotDefaultValueArgs']]]):
        pulumi.set(self, "default_value_list", value)


@pulumi.input_type
class BotSlotDefaultValueArgs:
    def __init__(__self__, *,
                 default_value: pulumi.Input[str]):
        """
        The default value to use when a user doesn't provide a value for a slot.
        :param pulumi.Input[str] default_value: The default value to use when a user doesn't provide a value for a slot.
        """
        pulumi.set(__self__, "default_value", default_value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> pulumi.Input[str]:
        """
        The default value to use when a user doesn't provide a value for a slot.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_value", value)


@pulumi.input_type
class BotSlotPriorityArgs:
    def __init__(__self__, *,
                 priority: pulumi.Input[int],
                 slot_name: pulumi.Input[str]):
        """
        The priority that Amazon Lex should use when eliciting slot values from a user.
        :param pulumi.Input[str] slot_name: The name of the slot.
        """
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "slot_name", slot_name)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="slotName")
    def slot_name(self) -> pulumi.Input[str]:
        """
        The name of the slot.
        """
        return pulumi.get(self, "slot_name")

    @slot_name.setter
    def slot_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "slot_name", value)


@pulumi.input_type
class BotSlotTypeValueArgs:
    def __init__(__self__, *,
                 sample_value: pulumi.Input['BotSampleValueArgs'],
                 synonyms: Optional[pulumi.Input[Sequence[pulumi.Input['BotSampleValueArgs']]]] = None):
        """
        Value that the slot type can take.
        """
        pulumi.set(__self__, "sample_value", sample_value)
        if synonyms is not None:
            pulumi.set(__self__, "synonyms", synonyms)

    @property
    @pulumi.getter(name="sampleValue")
    def sample_value(self) -> pulumi.Input['BotSampleValueArgs']:
        return pulumi.get(self, "sample_value")

    @sample_value.setter
    def sample_value(self, value: pulumi.Input['BotSampleValueArgs']):
        pulumi.set(self, "sample_value", value)

    @property
    @pulumi.getter
    def synonyms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BotSampleValueArgs']]]]:
        return pulumi.get(self, "synonyms")

    @synonyms.setter
    def synonyms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BotSampleValueArgs']]]]):
        pulumi.set(self, "synonyms", value)


@pulumi.input_type
class BotSlotTypeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 external_source_setting: Optional[pulumi.Input['BotExternalSourceSettingArgs']] = None,
                 parent_slot_type_signature: Optional[pulumi.Input[str]] = None,
                 slot_type_values: Optional[pulumi.Input[Sequence[pulumi.Input['BotSlotTypeValueArgs']]]] = None,
                 value_selection_setting: Optional[pulumi.Input['BotSlotValueSelectionSettingArgs']] = None):
        """
        A custom, extended built-in or a grammar slot type.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_source_setting is not None:
            pulumi.set(__self__, "external_source_setting", external_source_setting)
        if parent_slot_type_signature is not None:
            pulumi.set(__self__, "parent_slot_type_signature", parent_slot_type_signature)
        if slot_type_values is not None:
            pulumi.set(__self__, "slot_type_values", slot_type_values)
        if value_selection_setting is not None:
            pulumi.set(__self__, "value_selection_setting", value_selection_setting)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalSourceSetting")
    def external_source_setting(self) -> Optional[pulumi.Input['BotExternalSourceSettingArgs']]:
        return pulumi.get(self, "external_source_setting")

    @external_source_setting.setter
    def external_source_setting(self, value: Optional[pulumi.Input['BotExternalSourceSettingArgs']]):
        pulumi.set(self, "external_source_setting", value)

    @property
    @pulumi.getter(name="parentSlotTypeSignature")
    def parent_slot_type_signature(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "parent_slot_type_signature")

    @parent_slot_type_signature.setter
    def parent_slot_type_signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_slot_type_signature", value)

    @property
    @pulumi.getter(name="slotTypeValues")
    def slot_type_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BotSlotTypeValueArgs']]]]:
        return pulumi.get(self, "slot_type_values")

    @slot_type_values.setter
    def slot_type_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BotSlotTypeValueArgs']]]]):
        pulumi.set(self, "slot_type_values", value)

    @property
    @pulumi.getter(name="valueSelectionSetting")
    def value_selection_setting(self) -> Optional[pulumi.Input['BotSlotValueSelectionSettingArgs']]:
        return pulumi.get(self, "value_selection_setting")

    @value_selection_setting.setter
    def value_selection_setting(self, value: Optional[pulumi.Input['BotSlotValueSelectionSettingArgs']]):
        pulumi.set(self, "value_selection_setting", value)


@pulumi.input_type
class BotSlotValueElicitationSettingArgs:
    def __init__(__self__, *,
                 slot_constraint: pulumi.Input['BotSlotConstraint'],
                 default_value_specification: Optional[pulumi.Input['BotSlotDefaultValueSpecificationArgs']] = None,
                 prompt_specification: Optional[pulumi.Input['BotPromptSpecificationArgs']] = None,
                 sample_utterances: Optional[pulumi.Input[Sequence[pulumi.Input['BotSampleUtteranceArgs']]]] = None,
                 wait_and_continue_specification: Optional[pulumi.Input['BotWaitAndContinueSpecificationArgs']] = None):
        """
        Settings that you can use for eliciting a slot value.
        :param pulumi.Input['BotSlotConstraint'] slot_constraint: Specifies whether the slot is required or optional.
        :param pulumi.Input['BotSlotDefaultValueSpecificationArgs'] default_value_specification: A list of default values for a slot.
        :param pulumi.Input['BotPromptSpecificationArgs'] prompt_specification: The prompt that Amazon Lex uses to elicit the slot value from the user.
        :param pulumi.Input[Sequence[pulumi.Input['BotSampleUtteranceArgs']]] sample_utterances: If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy.
        :param pulumi.Input['BotWaitAndContinueSpecificationArgs'] wait_and_continue_specification: Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input.
        """
        pulumi.set(__self__, "slot_constraint", slot_constraint)
        if default_value_specification is not None:
            pulumi.set(__self__, "default_value_specification", default_value_specification)
        if prompt_specification is not None:
            pulumi.set(__self__, "prompt_specification", prompt_specification)
        if sample_utterances is not None:
            pulumi.set(__self__, "sample_utterances", sample_utterances)
        if wait_and_continue_specification is not None:
            pulumi.set(__self__, "wait_and_continue_specification", wait_and_continue_specification)

    @property
    @pulumi.getter(name="slotConstraint")
    def slot_constraint(self) -> pulumi.Input['BotSlotConstraint']:
        """
        Specifies whether the slot is required or optional.
        """
        return pulumi.get(self, "slot_constraint")

    @slot_constraint.setter
    def slot_constraint(self, value: pulumi.Input['BotSlotConstraint']):
        pulumi.set(self, "slot_constraint", value)

    @property
    @pulumi.getter(name="defaultValueSpecification")
    def default_value_specification(self) -> Optional[pulumi.Input['BotSlotDefaultValueSpecificationArgs']]:
        """
        A list of default values for a slot.
        """
        return pulumi.get(self, "default_value_specification")

    @default_value_specification.setter
    def default_value_specification(self, value: Optional[pulumi.Input['BotSlotDefaultValueSpecificationArgs']]):
        pulumi.set(self, "default_value_specification", value)

    @property
    @pulumi.getter(name="promptSpecification")
    def prompt_specification(self) -> Optional[pulumi.Input['BotPromptSpecificationArgs']]:
        """
        The prompt that Amazon Lex uses to elicit the slot value from the user.
        """
        return pulumi.get(self, "prompt_specification")

    @prompt_specification.setter
    def prompt_specification(self, value: Optional[pulumi.Input['BotPromptSpecificationArgs']]):
        pulumi.set(self, "prompt_specification", value)

    @property
    @pulumi.getter(name="sampleUtterances")
    def sample_utterances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BotSampleUtteranceArgs']]]]:
        """
        If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy.
        """
        return pulumi.get(self, "sample_utterances")

    @sample_utterances.setter
    def sample_utterances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BotSampleUtteranceArgs']]]]):
        pulumi.set(self, "sample_utterances", value)

    @property
    @pulumi.getter(name="waitAndContinueSpecification")
    def wait_and_continue_specification(self) -> Optional[pulumi.Input['BotWaitAndContinueSpecificationArgs']]:
        """
        Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input.
        """
        return pulumi.get(self, "wait_and_continue_specification")

    @wait_and_continue_specification.setter
    def wait_and_continue_specification(self, value: Optional[pulumi.Input['BotWaitAndContinueSpecificationArgs']]):
        pulumi.set(self, "wait_and_continue_specification", value)


@pulumi.input_type
class BotSlotValueRegexFilterArgs:
    def __init__(__self__, *,
                 pattern: pulumi.Input[str]):
        """
        A regular expression used to validate the value of a slot.
        :param pulumi.Input[str] pattern: Regex pattern
        """
        pulumi.set(__self__, "pattern", pattern)

    @property
    @pulumi.getter
    def pattern(self) -> pulumi.Input[str]:
        """
        Regex pattern
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "pattern", value)


@pulumi.input_type
class BotSlotValueSelectionSettingArgs:
    def __init__(__self__, *,
                 resolution_strategy: pulumi.Input['BotSlotValueResolutionStrategy'],
                 regex_filter: Optional[pulumi.Input['BotSlotValueRegexFilterArgs']] = None):
        """
        Contains settings used by Amazon Lex to select a slot value.
        """
        pulumi.set(__self__, "resolution_strategy", resolution_strategy)
        if regex_filter is not None:
            pulumi.set(__self__, "regex_filter", regex_filter)

    @property
    @pulumi.getter(name="resolutionStrategy")
    def resolution_strategy(self) -> pulumi.Input['BotSlotValueResolutionStrategy']:
        return pulumi.get(self, "resolution_strategy")

    @resolution_strategy.setter
    def resolution_strategy(self, value: pulumi.Input['BotSlotValueResolutionStrategy']):
        pulumi.set(self, "resolution_strategy", value)

    @property
    @pulumi.getter(name="regexFilter")
    def regex_filter(self) -> Optional[pulumi.Input['BotSlotValueRegexFilterArgs']]:
        return pulumi.get(self, "regex_filter")

    @regex_filter.setter
    def regex_filter(self, value: Optional[pulumi.Input['BotSlotValueRegexFilterArgs']]):
        pulumi.set(self, "regex_filter", value)


@pulumi.input_type
class BotSlotArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 slot_type_name: pulumi.Input[str],
                 value_elicitation_setting: pulumi.Input['BotSlotValueElicitationSettingArgs'],
                 description: Optional[pulumi.Input[str]] = None,
                 multiple_values_setting: Optional[pulumi.Input['BotMultipleValuesSettingArgs']] = None,
                 obfuscation_setting: Optional[pulumi.Input['BotObfuscationSettingArgs']] = None):
        """
        A slot is a variable needed to fulfill an intent, where an intent can require zero or more slots.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "slot_type_name", slot_type_name)
        pulumi.set(__self__, "value_elicitation_setting", value_elicitation_setting)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if multiple_values_setting is not None:
            pulumi.set(__self__, "multiple_values_setting", multiple_values_setting)
        if obfuscation_setting is not None:
            pulumi.set(__self__, "obfuscation_setting", obfuscation_setting)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="slotTypeName")
    def slot_type_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "slot_type_name")

    @slot_type_name.setter
    def slot_type_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "slot_type_name", value)

    @property
    @pulumi.getter(name="valueElicitationSetting")
    def value_elicitation_setting(self) -> pulumi.Input['BotSlotValueElicitationSettingArgs']:
        return pulumi.get(self, "value_elicitation_setting")

    @value_elicitation_setting.setter
    def value_elicitation_setting(self, value: pulumi.Input['BotSlotValueElicitationSettingArgs']):
        pulumi.set(self, "value_elicitation_setting", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="multipleValuesSetting")
    def multiple_values_setting(self) -> Optional[pulumi.Input['BotMultipleValuesSettingArgs']]:
        return pulumi.get(self, "multiple_values_setting")

    @multiple_values_setting.setter
    def multiple_values_setting(self, value: Optional[pulumi.Input['BotMultipleValuesSettingArgs']]):
        pulumi.set(self, "multiple_values_setting", value)

    @property
    @pulumi.getter(name="obfuscationSetting")
    def obfuscation_setting(self) -> Optional[pulumi.Input['BotObfuscationSettingArgs']]:
        return pulumi.get(self, "obfuscation_setting")

    @obfuscation_setting.setter
    def obfuscation_setting(self, value: Optional[pulumi.Input['BotObfuscationSettingArgs']]):
        pulumi.set(self, "obfuscation_setting", value)


@pulumi.input_type
class BotStillWaitingResponseSpecificationArgs:
    def __init__(__self__, *,
                 frequency_in_seconds: pulumi.Input[int],
                 message_groups_list: pulumi.Input[Sequence[pulumi.Input['BotMessageGroupArgs']]],
                 timeout_in_seconds: pulumi.Input[int],
                 allow_interrupt: Optional[pulumi.Input[bool]] = None):
        """
        StillWaitingResponseSpecification.
        :param pulumi.Input[bool] allow_interrupt: Indicates whether the user can interrupt a speech prompt from the bot.
        """
        pulumi.set(__self__, "frequency_in_seconds", frequency_in_seconds)
        pulumi.set(__self__, "message_groups_list", message_groups_list)
        pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if allow_interrupt is not None:
            pulumi.set(__self__, "allow_interrupt", allow_interrupt)

    @property
    @pulumi.getter(name="frequencyInSeconds")
    def frequency_in_seconds(self) -> pulumi.Input[int]:
        return pulumi.get(self, "frequency_in_seconds")

    @frequency_in_seconds.setter
    def frequency_in_seconds(self, value: pulumi.Input[int]):
        pulumi.set(self, "frequency_in_seconds", value)

    @property
    @pulumi.getter(name="messageGroupsList")
    def message_groups_list(self) -> pulumi.Input[Sequence[pulumi.Input['BotMessageGroupArgs']]]:
        return pulumi.get(self, "message_groups_list")

    @message_groups_list.setter
    def message_groups_list(self, value: pulumi.Input[Sequence[pulumi.Input['BotMessageGroupArgs']]]):
        pulumi.set(self, "message_groups_list", value)

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> pulumi.Input[int]:
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: pulumi.Input[int]):
        pulumi.set(self, "timeout_in_seconds", value)

    @property
    @pulumi.getter(name="allowInterrupt")
    def allow_interrupt(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the user can interrupt a speech prompt from the bot.
        """
        return pulumi.get(self, "allow_interrupt")

    @allow_interrupt.setter
    def allow_interrupt(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_interrupt", value)


@pulumi.input_type
class BotTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair for tagging Lex resources
        :param pulumi.Input[str] key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param pulumi.Input[str] value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class BotVersionLocaleDetailsArgs:
    def __init__(__self__, *,
                 source_bot_version: pulumi.Input[str]):
        """
        The version of a bot used for a bot locale.
        """
        pulumi.set(__self__, "source_bot_version", source_bot_version)

    @property
    @pulumi.getter(name="sourceBotVersion")
    def source_bot_version(self) -> pulumi.Input[str]:
        return pulumi.get(self, "source_bot_version")

    @source_bot_version.setter
    def source_bot_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_bot_version", value)


@pulumi.input_type
class BotVersionLocaleSpecificationArgs:
    def __init__(__self__, *,
                 bot_version_locale_details: pulumi.Input['BotVersionLocaleDetailsArgs'],
                 locale_id: pulumi.Input[str]):
        pulumi.set(__self__, "bot_version_locale_details", bot_version_locale_details)
        pulumi.set(__self__, "locale_id", locale_id)

    @property
    @pulumi.getter(name="botVersionLocaleDetails")
    def bot_version_locale_details(self) -> pulumi.Input['BotVersionLocaleDetailsArgs']:
        return pulumi.get(self, "bot_version_locale_details")

    @bot_version_locale_details.setter
    def bot_version_locale_details(self, value: pulumi.Input['BotVersionLocaleDetailsArgs']):
        pulumi.set(self, "bot_version_locale_details", value)

    @property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "locale_id")

    @locale_id.setter
    def locale_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "locale_id", value)


@pulumi.input_type
class BotVoiceSettingsArgs:
    def __init__(__self__, *,
                 voice_id: pulumi.Input[str]):
        """
        Settings for using an Amazon Polly voice to communicate with a user.
        :param pulumi.Input[str] voice_id: The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.
        """
        pulumi.set(__self__, "voice_id", voice_id)

    @property
    @pulumi.getter(name="voiceId")
    def voice_id(self) -> pulumi.Input[str]:
        """
        The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.
        """
        return pulumi.get(self, "voice_id")

    @voice_id.setter
    def voice_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "voice_id", value)


@pulumi.input_type
class BotWaitAndContinueSpecificationArgs:
    def __init__(__self__, *,
                 continue_response: pulumi.Input['BotResponseSpecificationArgs'],
                 waiting_response: pulumi.Input['BotResponseSpecificationArgs'],
                 is_active: Optional[pulumi.Input[bool]] = None,
                 still_waiting_response: Optional[pulumi.Input['BotStillWaitingResponseSpecificationArgs']] = None):
        """
        The prompts that Amazon Lex uses while a bot is waiting for customer input.
        :param pulumi.Input['BotResponseSpecificationArgs'] continue_response: The response that Amazon Lex sends to indicate that the bot is ready to continue the conversation.
        :param pulumi.Input['BotResponseSpecificationArgs'] waiting_response: The response that Amazon Lex sends to indicate that the bot is waiting for the conversation to continue.
        :param pulumi.Input[bool] is_active: Specifies whether the bot will wait for a user to respond.
        :param pulumi.Input['BotStillWaitingResponseSpecificationArgs'] still_waiting_response: The response that Amazon Lex sends periodically to the user to indicate that the bot is still waiting for input from the user.
        """
        pulumi.set(__self__, "continue_response", continue_response)
        pulumi.set(__self__, "waiting_response", waiting_response)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if still_waiting_response is not None:
            pulumi.set(__self__, "still_waiting_response", still_waiting_response)

    @property
    @pulumi.getter(name="continueResponse")
    def continue_response(self) -> pulumi.Input['BotResponseSpecificationArgs']:
        """
        The response that Amazon Lex sends to indicate that the bot is ready to continue the conversation.
        """
        return pulumi.get(self, "continue_response")

    @continue_response.setter
    def continue_response(self, value: pulumi.Input['BotResponseSpecificationArgs']):
        pulumi.set(self, "continue_response", value)

    @property
    @pulumi.getter(name="waitingResponse")
    def waiting_response(self) -> pulumi.Input['BotResponseSpecificationArgs']:
        """
        The response that Amazon Lex sends to indicate that the bot is waiting for the conversation to continue.
        """
        return pulumi.get(self, "waiting_response")

    @waiting_response.setter
    def waiting_response(self, value: pulumi.Input['BotResponseSpecificationArgs']):
        pulumi.set(self, "waiting_response", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the bot will wait for a user to respond.
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter(name="stillWaitingResponse")
    def still_waiting_response(self) -> Optional[pulumi.Input['BotStillWaitingResponseSpecificationArgs']]:
        """
        The response that Amazon Lex sends periodically to the user to indicate that the bot is still waiting for input from the user.
        """
        return pulumi.get(self, "still_waiting_response")

    @still_waiting_response.setter
    def still_waiting_response(self, value: Optional[pulumi.Input['BotStillWaitingResponseSpecificationArgs']]):
        pulumi.set(self, "still_waiting_response", value)


@pulumi.input_type
class DataPrivacyPropertiesArgs:
    def __init__(__self__, *,
                 child_directed: pulumi.Input[bool]):
        """
        Data privacy setting of the Bot.
        """
        pulumi.set(__self__, "child_directed", child_directed)

    @property
    @pulumi.getter(name="childDirected")
    def child_directed(self) -> pulumi.Input[bool]:
        return pulumi.get(self, "child_directed")

    @child_directed.setter
    def child_directed(self, value: pulumi.Input[bool]):
        pulumi.set(self, "child_directed", value)


@pulumi.input_type
class ResourcePolicyPolicyArgs:
    def __init__(__self__):
        """
        A resource policy to add to the resource. The policy is a JSON structure following the IAM syntax that contains one or more statements that define the policy.
        """
        pass


@pulumi.input_type
class SentimentAnalysisSettingsPropertiesArgs:
    def __init__(__self__, *,
                 detect_sentiment: pulumi.Input[bool]):
        """
        Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
        :param pulumi.Input[bool] detect_sentiment: Enable to call Amazon Comprehend for Sentiment natively within Lex
        """
        pulumi.set(__self__, "detect_sentiment", detect_sentiment)

    @property
    @pulumi.getter(name="detectSentiment")
    def detect_sentiment(self) -> pulumi.Input[bool]:
        """
        Enable to call Amazon Comprehend for Sentiment natively within Lex
        """
        return pulumi.get(self, "detect_sentiment")

    @detect_sentiment.setter
    def detect_sentiment(self, value: pulumi.Input[bool]):
        pulumi.set(self, "detect_sentiment", value)


