# nomad-pilot-cli
This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing. Developed by [Samarkand Global](https://www.samarkand.global/) in partnership with [SF Express](https://www.sf-express.com/), [eSinotrans](http://air.esinotrans.com/), [sto](http://sto-express.co.uk/). Read the documentation online at [Nomad API Suite](https://api.samarkand.io/).
- Install for node with `npm install nomad_pilot_cli`
- Install for python with `pip install nomad-pilot-cli`
- Install for Maven users `groupId, com.gitlab.samarkand-nomad; artifactId, nomad-pilot-cli`

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.44.2
- Package version: 1.44.2
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import nomad_pilot_cli
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import nomad_pilot_cli
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import nomad_pilot_cli
from nomad_pilot_cli.rest import ApiException
from pprint import pprint

configuration = nomad_pilot_cli.Configuration()
# Configure API key authorization: ca_key
configuration.api_key['x-ca-key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['x-ca-key'] = 'Bearer'

# Defining host is optional and default to https://nomad.samarkand-global.cn/pilot
configuration.host = "https://nomad.samarkand-global.cn/pilot"
# Enter a context with an instance of the API client
with nomad_pilot_cli.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = nomad_pilot_cli.BatchApi(api_client)
    carrier = 'carrier_example' # str | The carrier name
batch_id = 'batch_id_example' # str | The batch name returned from the create batch method
inline_object = nomad_pilot_cli.InlineObject() # InlineObject | 

    try:
        # batch
        api_response = api_instance.add_parcel(carrier, batch_id, inline_object)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling BatchApi->add_parcel: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://nomad.samarkand-global.cn/pilot*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BatchApi* | [**add_parcel**](docs/BatchApi.md#add_parcel) | **POST** /ship/{carrier}/batch/{batch_id}/add-to-batch | batch
*BatchApi* | [**create_batch**](docs/BatchApi.md#create_batch) | **POST** /ship/{carrier}/create-batch | batch
*BatchApi* | [**remove_parcel**](docs/BatchApi.md#remove_parcel) | **POST** /ship/{carrier}/batch/{batch_id}/remove-from-batch | batch
*BatchApi* | [**scan_batch**](docs/BatchApi.md#scan_batch) | **POST** /ship/{carrier}/batch/{batch_id}/create-scan-form | batch
*CallbackApi* | [**callback**](docs/CallbackApi.md#callback) | **POST** /callback/{store} | callback
*CarriersApi* | [**query_carrier**](docs/CarriersApi.md#query_carrier) | **GET** /carriers/ | queryCarrier
*FreightForwardApi* | [**freight_forward**](docs/FreightForwardApi.md#freight_forward) | **POST** /freight-forward/{carrier} | freightForward
*FreightForwardApi* | [**put_freight_forward_product**](docs/FreightForwardApi.md#put_freight_forward_product) | **PUT** /freight-forward/product/{carrier} | freightForward
*FreightForwardApi* | [**query_freight_forward**](docs/FreightForwardApi.md#query_freight_forward) | **GET** /freight-forward/{carrier} | queryFreightForward
*QuickShipApi* | [**quick_ship**](docs/QuickShipApi.md#quick_ship) | **POST** /quick-ship/{carrier} | quickShip
*ShipApi* | [**cancel_ship**](docs/ShipApi.md#cancel_ship) | **DELETE** /ship/{carrier}/order/{seller_order_ref} | cancelShip
*ShipApi* | [**put_ship**](docs/ShipApi.md#put_ship) | **PUT** /ship/{carrier} | ship
*ShipApi* | [**query_ship**](docs/ShipApi.md#query_ship) | **GET** /ship/{carrier}/order/{seller_order_ref} | queryShip
*ShipApi* | [**ship**](docs/ShipApi.md#ship) | **POST** /ship/{carrier} | ship
*ShipConfirmApi* | [**ship_confirm**](docs/ShipConfirmApi.md#ship_confirm) | **POST** /ship/{carrier}/confirm | shipConfirm


## Documentation For Models

 - [Address](docs/Address.md)
 - [AddressRequired](docs/AddressRequired.md)
 - [AddressShip](docs/AddressShip.md)
 - [ApiResponse](docs/ApiResponse.md)
 - [ApiResponseCallback](docs/ApiResponseCallback.md)
 - [ApiResponseConnectorResponse](docs/ApiResponseConnectorResponse.md)
 - [ApiResponseData](docs/ApiResponseData.md)
 - [ApiResponseGeneral](docs/ApiResponseGeneral.md)
 - [CallbackBody](docs/CallbackBody.md)
 - [Dimension](docs/Dimension.md)
 - [Goldjet](docs/Goldjet.md)
 - [HaikuDeliveryOrder](docs/HaikuDeliveryOrder.md)
 - [InlineObject](docs/InlineObject.md)
 - [InlineObject1](docs/InlineObject1.md)
 - [Pack](docs/Pack.md)
 - [PackBased](docs/PackBased.md)
 - [Package](docs/Package.md)
 - [PackageFreight](docs/PackageFreight.md)
 - [PackageItem](docs/PackageItem.md)
 - [PackageItemQuick](docs/PackageItemQuick.md)
 - [PackageItems](docs/PackageItems.md)
 - [PackageItemsQuick](docs/PackageItemsQuick.md)
 - [PackagePut](docs/PackagePut.md)
 - [PackagePutRequired](docs/PackagePutRequired.md)
 - [PackageQuick](docs/PackageQuick.md)
 - [PackageRequired](docs/PackageRequired.md)
 - [PackageUpdate](docs/PackageUpdate.md)
 - [PackageUpdateRequired](docs/PackageUpdateRequired.md)
 - [ProductFreight](docs/ProductFreight.md)


## Documentation For Authorization


## ca_key

- **Type**: API key
- **API key parameter name**: x-ca-key
- **Location**: HTTP header


## ca_stage

- **Type**: API key
- **API key parameter name**: x-ca-stage
- **Location**: HTTP header


## Author

paul@samarkand.global


