# coding: utf-8

"""
    File Service v2

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from istari_digital_client.models.image_config import ImageConfig
from istari_digital_client.models.json_path_config import JsonPathConfig
from istari_digital_client.models.media_config import MediaConfig
from istari_digital_client.models.model3_d_config import Model3DConfig
from istari_digital_client.models.pdf_config import PDFConfig
from typing import Optional, Set
from typing_extensions import Self

class ViewConfig(BaseModel):
    """
    View configuration for resource links in documents.
    """ # noqa: E501
    var_json: Optional[JsonPathConfig] = Field(default=None, alias="json")
    image: Optional[ImageConfig] = None
    model3d: Optional[Model3DConfig] = None
    pdf: Optional[PDFConfig] = None
    media: Optional[MediaConfig] = None
    __properties: ClassVar[List[str]] = ["json", "image", "model3d", "pdf", "media"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """
        Return the string representation of the model using field aliases.

        This method serializes the model to a JSON-formatted string, respecting any defined aliases
        for fields instead of their original attribute names.
        """

        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """
        Return the JSON string representation of the model using field aliases.

        This method serializes the model into a JSON-formatted string, using aliases for field names
        where defined instead of their raw attribute names.
        """

        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """
        Create an instance of the model from a JSON string.

        This method deserializes the given JSON string into a model instance. It expects the
        string to match the model's schema, using field aliases where applicable.

        :param json_str: JSON string representing the model.
        :type json_str: str
        """

        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """
        Return the dictionary representation of the model using field aliases.

        This method differs from calling `self.model_dump(by_alias=True)` in the following way:

        - Fields with a value of `None` are included in the output only if they are nullable and
          were explicitly set during model initialization. All other `None` fields are omitted.
        """

        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of var_json
        if self.var_json:
            _dict['json'] = self.var_json.to_dict()
        # override the default output from pydantic by calling `to_dict()` of image
        if self.image:
            _dict['image'] = self.image.to_dict()
        # override the default output from pydantic by calling `to_dict()` of model3d
        if self.model3d:
            _dict['model3d'] = self.model3d.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pdf
        if self.pdf:
            _dict['pdf'] = self.pdf.to_dict()
        # override the default output from pydantic by calling `to_dict()` of media
        if self.media:
            _dict['media'] = self.media.to_dict()
        # set to None if var_json (nullable) is None
        # and model_fields_set contains the field
        if self.var_json is None and "var_json" in self.model_fields_set:
            _dict['json'] = None

        # set to None if image (nullable) is None
        # and model_fields_set contains the field
        if self.image is None and "image" in self.model_fields_set:
            _dict['image'] = None

        # set to None if model3d (nullable) is None
        # and model_fields_set contains the field
        if self.model3d is None and "model3d" in self.model_fields_set:
            _dict['model3d'] = None

        # set to None if pdf (nullable) is None
        # and model_fields_set contains the field
        if self.pdf is None and "pdf" in self.model_fields_set:
            _dict['pdf'] = None

        # set to None if media (nullable) is None
        # and model_fields_set contains the field
        if self.media is None and "media" in self.model_fields_set:
            _dict['media'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ViewConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "json": JsonPathConfig.from_dict(obj["json"]) if obj.get("json") is not None else None,
            "image": ImageConfig.from_dict(obj["image"]) if obj.get("image") is not None else None,
            "model3d": Model3DConfig.from_dict(obj["model3d"]) if obj.get("model3d") is not None else None,
            "pdf": PDFConfig.from_dict(obj["pdf"]) if obj.get("pdf") is not None else None,
            "media": MediaConfig.from_dict(obj["media"]) if obj.get("media") is not None else None
        })
        return _obj
