# coding: utf-8

"""
    File Service v2

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from istari_digital_client.models.control_tag import ControlTag
from istari_digital_client.models.personal_access_token import PersonalAccessToken
from istari_digital_client.models.user_state import UserState
from istari_digital_client.models.user_type import UserType
from typing import Optional, Set
from typing_extensions import Self

class User(BaseModel):
    """
    User Dataclass that combines info from UserEntity and UserInfo.
    """ # noqa: E501
    id: StrictStr
    created: datetime
    provider_name: StrictStr
    provider_user_id: StrictStr
    user_type: UserType
    personal_access_tokens: List[PersonalAccessToken]
    provider_user_state: Optional[UserState] = None
    user_name: Optional[StrictStr] = None
    display_name: Optional[StrictStr] = None
    first_name: Optional[StrictStr] = None
    last_name: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    machine_name: Optional[StrictStr] = None
    machine_description: Optional[StrictStr] = None
    control_tags: Optional[List[ControlTag]] = None
    provider_tenant_id: Optional[StrictStr] = None
    tenant_id: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "created", "provider_name", "provider_user_id", "user_type", "personal_access_tokens", "provider_user_state", "user_name", "display_name", "first_name", "last_name", "email", "machine_name", "machine_description", "control_tags", "provider_tenant_id", "tenant_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """
        Return the string representation of the model using field aliases.

        This method serializes the model to a JSON-formatted string, respecting any defined aliases
        for fields instead of their original attribute names.
        """

        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """
        Return the JSON string representation of the model using field aliases.

        This method serializes the model into a JSON-formatted string, using aliases for field names
        where defined instead of their raw attribute names.
        """

        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """
        Create an instance of the model from a JSON string.

        This method deserializes the given JSON string into a model instance. It expects the
        string to match the model's schema, using field aliases where applicable.

        :param json_str: JSON string representing the model.
        :type json_str: str
        """

        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """
        Return the dictionary representation of the model using field aliases.

        This method differs from calling `self.model_dump(by_alias=True)` in the following way:

        - Fields with a value of `None` are included in the output only if they are nullable and
          were explicitly set during model initialization. All other `None` fields are omitted.
        """

        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in personal_access_tokens (list)
        _items = []
        if self.personal_access_tokens:
            for _item_personal_access_tokens in self.personal_access_tokens:
                if _item_personal_access_tokens:
                    _items.append(_item_personal_access_tokens.to_dict())
            _dict['personal_access_tokens'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in control_tags (list)
        _items = []
        if self.control_tags:
            for _item_control_tags in self.control_tags:
                if _item_control_tags:
                    _items.append(_item_control_tags.to_dict())
            _dict['control_tags'] = _items
        # set to None if provider_user_state (nullable) is None
        # and model_fields_set contains the field
        if self.provider_user_state is None and "provider_user_state" in self.model_fields_set:
            _dict['provider_user_state'] = None

        # set to None if user_name (nullable) is None
        # and model_fields_set contains the field
        if self.user_name is None and "user_name" in self.model_fields_set:
            _dict['user_name'] = None

        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['display_name'] = None

        # set to None if first_name (nullable) is None
        # and model_fields_set contains the field
        if self.first_name is None and "first_name" in self.model_fields_set:
            _dict['first_name'] = None

        # set to None if last_name (nullable) is None
        # and model_fields_set contains the field
        if self.last_name is None and "last_name" in self.model_fields_set:
            _dict['last_name'] = None

        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if machine_name (nullable) is None
        # and model_fields_set contains the field
        if self.machine_name is None and "machine_name" in self.model_fields_set:
            _dict['machine_name'] = None

        # set to None if machine_description (nullable) is None
        # and model_fields_set contains the field
        if self.machine_description is None and "machine_description" in self.model_fields_set:
            _dict['machine_description'] = None

        # set to None if provider_tenant_id (nullable) is None
        # and model_fields_set contains the field
        if self.provider_tenant_id is None and "provider_tenant_id" in self.model_fields_set:
            _dict['provider_tenant_id'] = None

        # set to None if tenant_id (nullable) is None
        # and model_fields_set contains the field
        if self.tenant_id is None and "tenant_id" in self.model_fields_set:
            _dict['tenant_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of User from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created": obj.get("created"),
            "provider_name": obj.get("provider_name"),
            "provider_user_id": obj.get("provider_user_id"),
            "user_type": obj.get("user_type"),
            "personal_access_tokens": [PersonalAccessToken.from_dict(_item) for _item in obj["personal_access_tokens"]] if obj.get("personal_access_tokens") is not None else None,
            "provider_user_state": obj.get("provider_user_state"),
            "user_name": obj.get("user_name"),
            "display_name": obj.get("display_name"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "email": obj.get("email"),
            "machine_name": obj.get("machine_name"),
            "machine_description": obj.get("machine_description"),
            "control_tags": [ControlTag.from_dict(_item) for _item in obj["control_tags"]] if obj.get("control_tags") is not None else None,
            "provider_tenant_id": obj.get("provider_tenant_id"),
            "tenant_id": obj.get("tenant_id")
        })
        return _obj
