# coding: utf-8

"""
    File Service v2

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from istari_digital_client.models.object_store_sha import ObjectStoreSha
from typing import Optional, Set
from typing_extensions import Self

class TokenWithProperties(BaseModel):
    """
    :class:`Token` is a subclass of :class:`Base` and represents a token used to store file information.
    """ # noqa: E501
    id: StrictStr
    created: datetime
    sha: StrictStr
    salt: StrictStr
    name: StrictStr
    extension: StrictStr
    size: StrictInt
    description: Optional[StrictStr] = None
    mime: Optional[StrictStr] = None
    version_name: Optional[StrictStr] = None
    external_identifier: Optional[StrictStr] = None
    display_name: Optional[StrictStr] = None
    object_store_sha: Optional[ObjectStoreSha] = None
    __properties: ClassVar[List[str]] = ["id", "created", "sha", "salt", "name", "extension", "size", "description", "mime", "version_name", "external_identifier", "display_name", "object_store_sha"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """
        Return the string representation of the model using field aliases.

        This method serializes the model to a JSON-formatted string, respecting any defined aliases
        for fields instead of their original attribute names.
        """

        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """
        Return the JSON string representation of the model using field aliases.

        This method serializes the model into a JSON-formatted string, using aliases for field names
        where defined instead of their raw attribute names.
        """

        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """
        Create an instance of the model from a JSON string.

        This method deserializes the given JSON string into a model instance. It expects the
        string to match the model's schema, using field aliases where applicable.

        :param json_str: JSON string representing the model.
        :type json_str: str
        """

        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """
        Return the dictionary representation of the model using field aliases.

        This method differs from calling `self.model_dump(by_alias=True)` in the following way:

        - Fields with a value of `None` are included in the output only if they are nullable and
          were explicitly set during model initialization. All other `None` fields are omitted.
        """

        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of object_store_sha
        if self.object_store_sha:
            _dict['object_store_sha'] = self.object_store_sha.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if mime (nullable) is None
        # and model_fields_set contains the field
        if self.mime is None and "mime" in self.model_fields_set:
            _dict['mime'] = None

        # set to None if version_name (nullable) is None
        # and model_fields_set contains the field
        if self.version_name is None and "version_name" in self.model_fields_set:
            _dict['version_name'] = None

        # set to None if external_identifier (nullable) is None
        # and model_fields_set contains the field
        if self.external_identifier is None and "external_identifier" in self.model_fields_set:
            _dict['external_identifier'] = None

        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['display_name'] = None

        # set to None if object_store_sha (nullable) is None
        # and model_fields_set contains the field
        if self.object_store_sha is None and "object_store_sha" in self.model_fields_set:
            _dict['object_store_sha'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TokenWithProperties from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created": obj.get("created"),
            "sha": obj.get("sha"),
            "salt": obj.get("salt"),
            "name": obj.get("name"),
            "extension": obj.get("extension"),
            "size": obj.get("size"),
            "description": obj.get("description"),
            "mime": obj.get("mime"),
            "version_name": obj.get("version_name"),
            "external_identifier": obj.get("external_identifier"),
            "display_name": obj.get("display_name"),
            "object_store_sha": ObjectStoreSha.from_dict(obj["object_store_sha"]) if obj.get("object_store_sha") is not None else None
        })
        return _obj
