# coding: utf-8

"""
    File Service v2

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Tenant(BaseModel):
    """
    Class representing a tenant object.  This class is used to store information about tenants, combining what's stored in the registry and what's stored in the authn provider.  Attributes ---------- provider_tenant_id (str): The provider's tenant id. provider_name (str): The provider's name/type (e.g. Zitadel or Okta). name (str): The tenant name (comes from ProviderTenant object). state (str): The tenant state (comes from ProviderTenant object). primary_domain (str): The primary domain used by the tenant (comes from ProviderTenant object). object_store_id (UUID): The object store id associated with the tenant. If None the default object store is used.
    """ # noqa: E501
    id: StrictStr
    created: datetime
    provider_tenant_id: StrictStr
    provider_name: StrictStr
    state: Optional[StrictStr] = None
    primary_domain: Optional[StrictStr] = None
    object_store_id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    label: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "created", "provider_tenant_id", "provider_name", "state", "primary_domain", "object_store_id", "name", "label"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """
        Return the string representation of the model using field aliases.

        This method serializes the model to a JSON-formatted string, respecting any defined aliases
        for fields instead of their original attribute names.
        """

        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """
        Return the JSON string representation of the model using field aliases.

        This method serializes the model into a JSON-formatted string, using aliases for field names
        where defined instead of their raw attribute names.
        """

        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """
        Create an instance of the model from a JSON string.

        This method deserializes the given JSON string into a model instance. It expects the
        string to match the model's schema, using field aliases where applicable.

        :param json_str: JSON string representing the model.
        :type json_str: str
        """

        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """
        Return the dictionary representation of the model using field aliases.

        This method differs from calling `self.model_dump(by_alias=True)` in the following way:

        - Fields with a value of `None` are included in the output only if they are nullable and
          were explicitly set during model initialization. All other `None` fields are omitted.
        """

        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if state (nullable) is None
        # and model_fields_set contains the field
        if self.state is None and "state" in self.model_fields_set:
            _dict['state'] = None

        # set to None if primary_domain (nullable) is None
        # and model_fields_set contains the field
        if self.primary_domain is None and "primary_domain" in self.model_fields_set:
            _dict['primary_domain'] = None

        # set to None if object_store_id (nullable) is None
        # and model_fields_set contains the field
        if self.object_store_id is None and "object_store_id" in self.model_fields_set:
            _dict['object_store_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Tenant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created": obj.get("created"),
            "provider_tenant_id": obj.get("provider_tenant_id"),
            "provider_name": obj.get("provider_name"),
            "state": obj.get("state"),
            "primary_domain": obj.get("primary_domain"),
            "object_store_id": obj.get("object_store_id"),
            "name": obj.get("name"),
            "label": obj.get("label")
        })
        return _obj
