# coding: utf-8

"""
    File Service v2

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from istari_digital_client.models.view_config import ViewConfig
from typing import Optional, Set
from typing_extensions import Self

class ResourceLinkAttrs(BaseModel):
    """
    Attributes for istariResourceLink nodes in ProseMirror documents.
    """ # noqa: E501
    resource_type: Optional[StrictStr] = Field(default=None, alias="resourceType")
    resource_id: Optional[StrictStr] = Field(default=None, alias="resourceId")
    pinned_revision_id: Optional[StrictStr] = Field(default=None, alias="pinnedRevisionId")
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    view_config: Optional[ViewConfig] = Field(default=None, alias="viewConfig")
    __properties: ClassVar[List[str]] = ["resourceType", "resourceId", "pinnedRevisionId", "displayName", "viewConfig"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """
        Return the string representation of the model using field aliases.

        This method serializes the model to a JSON-formatted string, respecting any defined aliases
        for fields instead of their original attribute names.
        """

        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """
        Return the JSON string representation of the model using field aliases.

        This method serializes the model into a JSON-formatted string, using aliases for field names
        where defined instead of their raw attribute names.
        """

        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """
        Create an instance of the model from a JSON string.

        This method deserializes the given JSON string into a model instance. It expects the
        string to match the model's schema, using field aliases where applicable.

        :param json_str: JSON string representing the model.
        :type json_str: str
        """

        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """
        Return the dictionary representation of the model using field aliases.

        This method differs from calling `self.model_dump(by_alias=True)` in the following way:

        - Fields with a value of `None` are included in the output only if they are nullable and
          were explicitly set during model initialization. All other `None` fields are omitted.
        """

        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of view_config
        if self.view_config:
            _dict['viewConfig'] = self.view_config.to_dict()
        # set to None if resource_type (nullable) is None
        # and model_fields_set contains the field
        if self.resource_type is None and "resource_type" in self.model_fields_set:
            _dict['resourceType'] = None

        # set to None if resource_id (nullable) is None
        # and model_fields_set contains the field
        if self.resource_id is None and "resource_id" in self.model_fields_set:
            _dict['resourceId'] = None

        # set to None if pinned_revision_id (nullable) is None
        # and model_fields_set contains the field
        if self.pinned_revision_id is None and "pinned_revision_id" in self.model_fields_set:
            _dict['pinnedRevisionId'] = None

        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['displayName'] = None

        # set to None if view_config (nullable) is None
        # and model_fields_set contains the field
        if self.view_config is None and "view_config" in self.model_fields_set:
            _dict['viewConfig'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ResourceLinkAttrs from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "resourceType": obj.get("resourceType"),
            "resourceId": obj.get("resourceId"),
            "pinnedRevisionId": obj.get("pinnedRevisionId"),
            "displayName": obj.get("displayName"),
            "viewConfig": ViewConfig.from_dict(obj["viewConfig"]) if obj.get("viewConfig") is not None else None
        })
        return _obj
