# coding: utf-8

"""
    File Service v2

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from istari_digital_client.models.resource_link_attrs import ResourceLinkAttrs
from typing import Optional, Set
from typing_extensions import Self

class ProseMirrorNode(BaseModel):
    """
    Base structure for ProseMirror nodes.  Note: content field uses Any for recursive node structures. This is intentional as ProseMirror documents have arbitrary nesting depth. —keeping this model as documentation of the ProseMirror JSON structure.
    """ # noqa: E501
    type: StrictStr
    content: Optional[List[Any]] = None
    attrs: Optional[ResourceLinkAttrs] = None
    text: Optional[StrictStr] = None
    marks: Optional[List[Dict[str, Any]]] = None
    __properties: ClassVar[List[str]] = ["type", "content", "attrs", "text", "marks"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """
        Return the string representation of the model using field aliases.

        This method serializes the model to a JSON-formatted string, respecting any defined aliases
        for fields instead of their original attribute names.
        """

        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """
        Return the JSON string representation of the model using field aliases.

        This method serializes the model into a JSON-formatted string, using aliases for field names
        where defined instead of their raw attribute names.
        """

        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """
        Create an instance of the model from a JSON string.

        This method deserializes the given JSON string into a model instance. It expects the
        string to match the model's schema, using field aliases where applicable.

        :param json_str: JSON string representing the model.
        :type json_str: str
        """

        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """
        Return the dictionary representation of the model using field aliases.

        This method differs from calling `self.model_dump(by_alias=True)` in the following way:

        - Fields with a value of `None` are included in the output only if they are nullable and
          were explicitly set during model initialization. All other `None` fields are omitted.
        """

        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of attrs
        if self.attrs:
            _dict['attrs'] = self.attrs.to_dict()
        # set to None if content (nullable) is None
        # and model_fields_set contains the field
        if self.content is None and "content" in self.model_fields_set:
            _dict['content'] = None

        # set to None if attrs (nullable) is None
        # and model_fields_set contains the field
        if self.attrs is None and "attrs" in self.model_fields_set:
            _dict['attrs'] = None

        # set to None if text (nullable) is None
        # and model_fields_set contains the field
        if self.text is None and "text" in self.model_fields_set:
            _dict['text'] = None

        # set to None if marks (nullable) is None
        # and model_fields_set contains the field
        if self.marks is None and "marks" in self.model_fields_set:
            _dict['marks'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProseMirrorNode from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "content": obj.get("content"),
            "attrs": ResourceLinkAttrs.from_dict(obj["attrs"]) if obj.get("attrs") is not None else None,
            "text": obj.get("text"),
            "marks": obj.get("marks")
        })
        return _obj
