# coding: utf-8

"""
    File Service v2

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from istari_digital_client.models.module_author_manifest import ModuleAuthorManifest
from istari_digital_client.models.module_type import ModuleType
from istari_digital_client.models.new_function_manifest import NewFunctionManifest
from typing import Optional, Set
from typing_extensions import Self

class NewModuleManifest(BaseModel):
    """
    NewModuleManifest
    """ # noqa: E501
    module_name: StrictStr
    module_version: StrictStr
    module_type: ModuleType
    module_checksum: StrictStr
    internal: StrictBool
    operating_systems: List[StrictStr]
    agent_version: StrictStr
    authors: List[ModuleAuthorManifest]
    functions: Dict[str, List[NewFunctionManifest]]
    module_display_name: Optional[StrictStr] = None
    tool_display_name: Optional[StrictStr] = None
    tool: Optional[StrictStr] = None
    tool_versions: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["module_name", "module_version", "module_type", "module_checksum", "internal", "operating_systems", "agent_version", "authors", "functions", "module_display_name", "tool_display_name", "tool", "tool_versions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """
        Return the string representation of the model using field aliases.

        This method serializes the model to a JSON-formatted string, respecting any defined aliases
        for fields instead of their original attribute names.
        """

        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """
        Return the JSON string representation of the model using field aliases.

        This method serializes the model into a JSON-formatted string, using aliases for field names
        where defined instead of their raw attribute names.
        """

        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """
        Create an instance of the model from a JSON string.

        This method deserializes the given JSON string into a model instance. It expects the
        string to match the model's schema, using field aliases where applicable.

        :param json_str: JSON string representing the model.
        :type json_str: str
        """

        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """
        Return the dictionary representation of the model using field aliases.

        This method differs from calling `self.model_dump(by_alias=True)` in the following way:

        - Fields with a value of `None` are included in the output only if they are nullable and
          were explicitly set during model initialization. All other `None` fields are omitted.
        """

        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in authors (list)
        _items = []
        if self.authors:
            for _item_authors in self.authors:
                if _item_authors:
                    _items.append(_item_authors.to_dict())
            _dict['authors'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in functions (dict of array)
        _field_dict_of_array = {}
        if self.functions:
            for _key_functions in self.functions:
                if self.functions[_key_functions] is not None:
                    _field_dict_of_array[_key_functions] = [
                        _item.to_dict() for _item in self.functions[_key_functions]
                    ]
            _dict['functions'] = _field_dict_of_array
        # set to None if module_display_name (nullable) is None
        # and model_fields_set contains the field
        if self.module_display_name is None and "module_display_name" in self.model_fields_set:
            _dict['module_display_name'] = None

        # set to None if tool_display_name (nullable) is None
        # and model_fields_set contains the field
        if self.tool_display_name is None and "tool_display_name" in self.model_fields_set:
            _dict['tool_display_name'] = None

        # set to None if tool (nullable) is None
        # and model_fields_set contains the field
        if self.tool is None and "tool" in self.model_fields_set:
            _dict['tool'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NewModuleManifest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "module_name": obj.get("module_name"),
            "module_version": obj.get("module_version"),
            "module_type": obj.get("module_type"),
            "module_checksum": obj.get("module_checksum"),
            "internal": obj.get("internal"),
            "operating_systems": obj.get("operating_systems"),
            "agent_version": obj.get("agent_version"),
            "authors": [ModuleAuthorManifest.from_dict(_item) for _item in obj["authors"]] if obj.get("authors") is not None else None,
            "functions": dict(
                (_k,
                        [NewFunctionManifest.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("functions", {}).items()
            ),
            "module_display_name": obj.get("module_display_name"),
            "tool_display_name": obj.get("tool_display_name"),
            "tool": obj.get("tool"),
            "tool_versions": obj.get("tool_versions")
        })
        return _obj
