# coding: utf-8

"""
    File Service v2

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from istari_digital_client.models.function import Function
from istari_digital_client.models.module_type import ModuleType
from istari_digital_client.models.module_version import ModuleVersion
from typing import Optional, Set
from typing_extensions import Self

class Module(BaseModel):
    """
    Module
    """ # noqa: E501
    id: StrictStr
    created: datetime
    name: StrictStr
    module_type: ModuleType
    internal: StrictBool
    tool: Optional[StrictStr] = None
    module_versions: Optional[List[ModuleVersion]] = None
    functions: Optional[List[Function]] = None
    __properties: ClassVar[List[str]] = ["id", "created", "name", "module_type", "internal", "tool", "module_versions", "functions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """
        Return the string representation of the model using field aliases.

        This method serializes the model to a JSON-formatted string, respecting any defined aliases
        for fields instead of their original attribute names.
        """

        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """
        Return the JSON string representation of the model using field aliases.

        This method serializes the model into a JSON-formatted string, using aliases for field names
        where defined instead of their raw attribute names.
        """

        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """
        Create an instance of the model from a JSON string.

        This method deserializes the given JSON string into a model instance. It expects the
        string to match the model's schema, using field aliases where applicable.

        :param json_str: JSON string representing the model.
        :type json_str: str
        """

        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """
        Return the dictionary representation of the model using field aliases.

        This method differs from calling `self.model_dump(by_alias=True)` in the following way:

        - Fields with a value of `None` are included in the output only if they are nullable and
          were explicitly set during model initialization. All other `None` fields are omitted.
        """

        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in module_versions (list)
        _items = []
        if self.module_versions:
            for _item_module_versions in self.module_versions:
                if _item_module_versions:
                    _items.append(_item_module_versions.to_dict())
            _dict['module_versions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in functions (list)
        _items = []
        if self.functions:
            for _item_functions in self.functions:
                if _item_functions:
                    _items.append(_item_functions.to_dict())
            _dict['functions'] = _items
        # set to None if tool (nullable) is None
        # and model_fields_set contains the field
        if self.tool is None and "tool" in self.model_fields_set:
            _dict['tool'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Module from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created": obj.get("created"),
            "name": obj.get("name"),
            "module_type": obj.get("module_type"),
            "internal": obj.get("internal"),
            "tool": obj.get("tool"),
            "module_versions": [ModuleVersion.from_dict(_item) for _item in obj["module_versions"]] if obj.get("module_versions") is not None else None,
            "functions": [Function.from_dict(_item) for _item in obj["functions"]] if obj.get("functions") is not None else None
        })
        return _obj
