# coding: utf-8

"""
    File Service v2

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from istari_digital_client.models.function_status import FunctionStatus
from istari_digital_client.models.operating_system import OperatingSystem
from istari_digital_client.models.tool_version import ToolVersion
from typing import Optional, Set
from typing_extensions import Self

class FunctionVersion(BaseModel):
    """
    FunctionVersion
    """ # noqa: E501
    id: StrictStr
    created: datetime
    name: StrictStr
    version: StrictStr
    module_name: StrictStr
    module_version: StrictStr
    entrypoint: StrictStr
    function_schema: Optional[StrictStr]
    run_command: StrictStr
    created_by_id: StrictStr
    status: FunctionStatus
    tool_name: Optional[StrictStr] = None
    tool_display_name: Optional[StrictStr] = None
    tool_versions: Optional[List[ToolVersion]] = None
    operating_systems: Optional[List[OperatingSystem]] = None
    __properties: ClassVar[List[str]] = ["id", "created", "name", "version", "module_name", "module_version", "entrypoint", "function_schema", "run_command", "created_by_id", "status", "tool_name", "tool_display_name", "tool_versions", "operating_systems"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """
        Return the string representation of the model using field aliases.

        This method serializes the model to a JSON-formatted string, respecting any defined aliases
        for fields instead of their original attribute names.
        """

        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """
        Return the JSON string representation of the model using field aliases.

        This method serializes the model into a JSON-formatted string, using aliases for field names
        where defined instead of their raw attribute names.
        """

        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """
        Create an instance of the model from a JSON string.

        This method deserializes the given JSON string into a model instance. It expects the
        string to match the model's schema, using field aliases where applicable.

        :param json_str: JSON string representing the model.
        :type json_str: str
        """

        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """
        Return the dictionary representation of the model using field aliases.

        This method differs from calling `self.model_dump(by_alias=True)` in the following way:

        - Fields with a value of `None` are included in the output only if they are nullable and
          were explicitly set during model initialization. All other `None` fields are omitted.
        """

        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tool_versions (list)
        _items = []
        if self.tool_versions:
            for _item_tool_versions in self.tool_versions:
                if _item_tool_versions:
                    _items.append(_item_tool_versions.to_dict())
            _dict['tool_versions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in operating_systems (list)
        _items = []
        if self.operating_systems:
            for _item_operating_systems in self.operating_systems:
                if _item_operating_systems:
                    _items.append(_item_operating_systems.to_dict())
            _dict['operating_systems'] = _items
        # set to None if function_schema (nullable) is None
        # and model_fields_set contains the field
        if self.function_schema is None and "function_schema" in self.model_fields_set:
            _dict['function_schema'] = None

        # set to None if tool_name (nullable) is None
        # and model_fields_set contains the field
        if self.tool_name is None and "tool_name" in self.model_fields_set:
            _dict['tool_name'] = None

        # set to None if tool_display_name (nullable) is None
        # and model_fields_set contains the field
        if self.tool_display_name is None and "tool_display_name" in self.model_fields_set:
            _dict['tool_display_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FunctionVersion from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created": obj.get("created"),
            "name": obj.get("name"),
            "version": obj.get("version"),
            "module_name": obj.get("module_name"),
            "module_version": obj.get("module_version"),
            "entrypoint": obj.get("entrypoint"),
            "function_schema": obj.get("function_schema"),
            "run_command": obj.get("run_command"),
            "created_by_id": obj.get("created_by_id"),
            "status": FunctionStatus.from_dict(obj["status"]) if obj.get("status") is not None else None,
            "tool_name": obj.get("tool_name"),
            "tool_display_name": obj.get("tool_display_name"),
            "tool_versions": [ToolVersion.from_dict(_item) for _item in obj["tool_versions"]] if obj.get("tool_versions") is not None else None,
            "operating_systems": [OperatingSystem.from_dict(_item) for _item in obj["operating_systems"]] if obj.get("operating_systems") is not None else None
        })
        return _obj
