# coding: utf-8

"""
    File Service v2

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from istari_digital_client.models.control_tag import ControlTag
from istari_digital_client.models.control_tagging_status import ControlTaggingStatus
from typing import Optional, Set
from typing_extensions import Self

class FileControlTagging(BaseModel):
    """
    A control assignment to a file.
    """ # noqa: E501
    id: StrictStr
    created: datetime
    created_by_id: StrictStr
    control_tag: ControlTag
    status: ControlTaggingStatus
    reason: Optional[StrictStr]
    inherited_from_resource_id: Optional[StrictStr]
    inherited_from_resource_type: Optional[StrictStr]
    file_id: StrictStr
    __properties: ClassVar[List[str]] = ["id", "created", "created_by_id", "control_tag", "status", "reason", "inherited_from_resource_id", "inherited_from_resource_type", "file_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """
        Return the string representation of the model using field aliases.

        This method serializes the model to a JSON-formatted string, respecting any defined aliases
        for fields instead of their original attribute names.
        """

        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """
        Return the JSON string representation of the model using field aliases.

        This method serializes the model into a JSON-formatted string, using aliases for field names
        where defined instead of their raw attribute names.
        """

        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """
        Create an instance of the model from a JSON string.

        This method deserializes the given JSON string into a model instance. It expects the
        string to match the model's schema, using field aliases where applicable.

        :param json_str: JSON string representing the model.
        :type json_str: str
        """

        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """
        Return the dictionary representation of the model using field aliases.

        This method differs from calling `self.model_dump(by_alias=True)` in the following way:

        - Fields with a value of `None` are included in the output only if they are nullable and
          were explicitly set during model initialization. All other `None` fields are omitted.
        """

        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of control_tag
        if self.control_tag:
            _dict['control_tag'] = self.control_tag.to_dict()
        # set to None if reason (nullable) is None
        # and model_fields_set contains the field
        if self.reason is None and "reason" in self.model_fields_set:
            _dict['reason'] = None

        # set to None if inherited_from_resource_id (nullable) is None
        # and model_fields_set contains the field
        if self.inherited_from_resource_id is None and "inherited_from_resource_id" in self.model_fields_set:
            _dict['inherited_from_resource_id'] = None

        # set to None if inherited_from_resource_type (nullable) is None
        # and model_fields_set contains the field
        if self.inherited_from_resource_type is None and "inherited_from_resource_type" in self.model_fields_set:
            _dict['inherited_from_resource_type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FileControlTagging from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created": obj.get("created"),
            "created_by_id": obj.get("created_by_id"),
            "control_tag": ControlTag.from_dict(obj["control_tag"]) if obj.get("control_tag") is not None else None,
            "status": obj.get("status"),
            "reason": obj.get("reason"),
            "inherited_from_resource_id": obj.get("inherited_from_resource_id"),
            "inherited_from_resource_type": obj.get("inherited_from_resource_type"),
            "file_id": obj.get("file_id")
        })
        return _obj
