# coding: utf-8

"""
    File Service v2

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from istari_digital_client.models.content import Content
from typing import Optional, Set
from typing_extensions import Self

class CreateDocumentRequest(BaseModel):
    """
    Request for creating a new document with flexible parameters.  This provides an elegant API for document creation. The simplest usage requires only a configuration ID and name - the backend handles all file operations, content storage, and revision management automatically.  **Design Philosophy:** The content being stored as JSON is an implementation detail that users don't need to know about. Just provide your ProseMirror content as a Python dict or JSON string, and the system handles the rest.  Attributes ----------     configuration_id: The system configuration this document belongs to     name: Document name (e.g., \"Requirements Document\", \"Design Specs\")     content: Optional ProseMirror content as dict or JSON string.             If omitted, creates an empty document with default structure.             The backend automatically handles JSON serialization and storage.     description: Optional description or notes about the document  Examples --------     Create an empty document (simplest usage):     >>> request = CreateDocumentRequest(     ...     configuration_id=UUID(\"9f5276f1-5b0c-4217-bce2-73132360613a\"),     ...     name=\"My Document\"     ... )      Create a document with content:         >>> request = CreateDocumentRequest(         ...     configuration_id=UUID(\"9f5276f1-5b0c-4217-bce2-73132360613a\"),         ...     name=\"Requirements\",         ...     content={\"type\": \"doc\", \"content\": [         ...         {\"type\": \"paragraph\", \"content\": [         ...             {\"type\": \"text\", \"text\": \"Initial requirements\"}         ...         ]}         ...     ]},         ...     description=\"Q2 2025 project requirements\"         ... )      Create with content as JSON string:         >>> request = CreateDocumentRequest(         ...     configuration_id=config_id,         ...     name=\"Design Doc\",         ...     content='{\"type\": \"doc\", \"content\": []}'     ... )
    """ # noqa: E501
    configuration_id: StrictStr
    name: StrictStr
    content: Optional[Content] = None
    description: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["configuration_id", "name", "content", "description"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """
        Return the string representation of the model using field aliases.

        This method serializes the model to a JSON-formatted string, respecting any defined aliases
        for fields instead of their original attribute names.
        """

        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """
        Return the JSON string representation of the model using field aliases.

        This method serializes the model into a JSON-formatted string, using aliases for field names
        where defined instead of their raw attribute names.
        """

        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """
        Create an instance of the model from a JSON string.

        This method deserializes the given JSON string into a model instance. It expects the
        string to match the model's schema, using field aliases where applicable.

        :param json_str: JSON string representing the model.
        :type json_str: str
        """

        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """
        Return the dictionary representation of the model using field aliases.

        This method differs from calling `self.model_dump(by_alias=True)` in the following way:

        - Fields with a value of `None` are included in the output only if they are nullable and
          were explicitly set during model initialization. All other `None` fields are omitted.
        """

        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of content
        if self.content:
            _dict['content'] = self.content.to_dict()
        # set to None if content (nullable) is None
        # and model_fields_set contains the field
        if self.content is None and "content" in self.model_fields_set:
            _dict['content'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateDocumentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "configuration_id": obj.get("configuration_id"),
            "name": obj.get("name"),
            "content": Content.from_dict(obj["content"]) if obj.get("content") is not None else None,
            "description": obj.get("description")
        })
        return _obj
