# coding: utf-8

"""
    File Service v2

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from istari_digital_client.models.control_tag_status import ControlTagStatus
from istari_digital_client.models.upstream_remote_info import UpstreamRemoteInfo
from typing import Optional, Set
from typing_extensions import Self

class ControlTag(BaseModel):
    """
    A control (essentially a tag) that is assigned to resource, files, and users.  To have access to a resource or file that has one or more controls assigned, the user must have been assigned all the controls applied to the item.
    """ # noqa: E501
    id: StrictStr
    created: datetime
    created_by_id: StrictStr
    name: StrictStr
    status: ControlTagStatus
    description: Optional[StrictStr] = None
    display_color: Optional[StrictStr] = None
    upstream_remote_info: Optional[UpstreamRemoteInfo] = None
    __properties: ClassVar[List[str]] = ["id", "created", "created_by_id", "name", "status", "description", "display_color", "upstream_remote_info"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """
        Return the string representation of the model using field aliases.

        This method serializes the model to a JSON-formatted string, respecting any defined aliases
        for fields instead of their original attribute names.
        """

        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """
        Return the JSON string representation of the model using field aliases.

        This method serializes the model into a JSON-formatted string, using aliases for field names
        where defined instead of their raw attribute names.
        """

        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """
        Create an instance of the model from a JSON string.

        This method deserializes the given JSON string into a model instance. It expects the
        string to match the model's schema, using field aliases where applicable.

        :param json_str: JSON string representing the model.
        :type json_str: str
        """

        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """
        Return the dictionary representation of the model using field aliases.

        This method differs from calling `self.model_dump(by_alias=True)` in the following way:

        - Fields with a value of `None` are included in the output only if they are nullable and
          were explicitly set during model initialization. All other `None` fields are omitted.
        """

        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of upstream_remote_info
        if self.upstream_remote_info:
            _dict['upstream_remote_info'] = self.upstream_remote_info.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if display_color (nullable) is None
        # and model_fields_set contains the field
        if self.display_color is None and "display_color" in self.model_fields_set:
            _dict['display_color'] = None

        # set to None if upstream_remote_info (nullable) is None
        # and model_fields_set contains the field
        if self.upstream_remote_info is None and "upstream_remote_info" in self.model_fields_set:
            _dict['upstream_remote_info'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ControlTag from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created": obj.get("created"),
            "created_by_id": obj.get("created_by_id"),
            "name": obj.get("name"),
            "status": obj.get("status"),
            "description": obj.get("description"),
            "display_color": obj.get("display_color"),
            "upstream_remote_info": UpstreamRemoteInfo.from_dict(obj["upstream_remote_info"]) if obj.get("upstream_remote_info") is not None else None
        })
        return _obj
