# coding: utf-8

"""
    File Service v2

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from istari_digital_client.models.auth_integration import AuthIntegration
from istari_digital_client.models.integration_type import IntegrationType
from typing import Optional, Set
from typing_extensions import Self

class AppIntegration(BaseModel):
    """
    A class representing a Foreign Data Host.
    """ # noqa: E501
    id: StrictStr
    created: datetime
    created_by_id: StrictStr
    integration_type: IntegrationType
    tenant_id: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    auth_integrations: Optional[List[AuthIntegration]] = None
    __properties: ClassVar[List[str]] = ["id", "created", "created_by_id", "integration_type", "tenant_id", "description", "auth_integrations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """
        Return the string representation of the model using field aliases.

        This method serializes the model to a JSON-formatted string, respecting any defined aliases
        for fields instead of their original attribute names.
        """

        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """
        Return the JSON string representation of the model using field aliases.

        This method serializes the model into a JSON-formatted string, using aliases for field names
        where defined instead of their raw attribute names.
        """

        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """
        Create an instance of the model from a JSON string.

        This method deserializes the given JSON string into a model instance. It expects the
        string to match the model's schema, using field aliases where applicable.

        :param json_str: JSON string representing the model.
        :type json_str: str
        """

        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """
        Return the dictionary representation of the model using field aliases.

        This method differs from calling `self.model_dump(by_alias=True)` in the following way:

        - Fields with a value of `None` are included in the output only if they are nullable and
          were explicitly set during model initialization. All other `None` fields are omitted.
        """

        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in auth_integrations (list)
        _items = []
        if self.auth_integrations:
            for _item_auth_integrations in self.auth_integrations:
                if _item_auth_integrations:
                    _items.append(_item_auth_integrations.to_dict())
            _dict['auth_integrations'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppIntegration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created": obj.get("created"),
            "created_by_id": obj.get("created_by_id"),
            "integration_type": obj.get("integration_type"),
            "tenant_id": obj.get("tenant_id"),
            "description": obj.get("description"),
            "auth_integrations": [AuthIntegration.from_dict(_item) for _item in obj["auth_integrations"]] if obj.get("auth_integrations") is not None else None
        })
        return _obj
