# coding: utf-8

"""
    File Service v2

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from istari_digital_client.models.access_relation import AccessRelation
from istari_digital_client.models.access_resource_type import AccessResourceType
from istari_digital_client.models.access_subject_type import AccessSubjectType
from istari_digital_client.models.subject_info import SubjectInfo
from typing import Optional, Set
from typing_extensions import Self

class AccessRelationship(BaseModel):
    """
    PUBLIC: An access relationship that can be viewed/modified by a user of Istari.
    """ # noqa: E501
    subject_type: AccessSubjectType
    subject_id: StrictStr
    relation: AccessRelation
    resource_type: AccessResourceType
    resource_id: StrictStr
    subject_info: Optional[SubjectInfo] = None
    __properties: ClassVar[List[str]] = ["subject_type", "subject_id", "relation", "resource_type", "resource_id", "subject_info"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """
        Return the string representation of the model using field aliases.

        This method serializes the model to a JSON-formatted string, respecting any defined aliases
        for fields instead of their original attribute names.
        """

        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """
        Return the JSON string representation of the model using field aliases.

        This method serializes the model into a JSON-formatted string, using aliases for field names
        where defined instead of their raw attribute names.
        """

        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """
        Create an instance of the model from a JSON string.

        This method deserializes the given JSON string into a model instance. It expects the
        string to match the model's schema, using field aliases where applicable.

        :param json_str: JSON string representing the model.
        :type json_str: str
        """

        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """
        Return the dictionary representation of the model using field aliases.

        This method differs from calling `self.model_dump(by_alias=True)` in the following way:

        - Fields with a value of `None` are included in the output only if they are nullable and
          were explicitly set during model initialization. All other `None` fields are omitted.
        """

        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of subject_info
        if self.subject_info:
            _dict['subject_info'] = self.subject_info.to_dict()
        # set to None if subject_info (nullable) is None
        # and model_fields_set contains the field
        if self.subject_info is None and "subject_info" in self.model_fields_set:
            _dict['subject_info'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AccessRelationship from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "subject_type": obj.get("subject_type"),
            "subject_id": obj.get("subject_id"),
            "relation": obj.get("relation"),
            "resource_type": obj.get("resource_type"),
            "resource_id": obj.get("resource_id"),
            "subject_info": SubjectInfo.from_dict(obj["subject_info"]) if obj.get("subject_info") is not None else None
        })
        return _obj
