
from istari_digital_core import Client as StorageClient
from istari_digital_core import Revision
from istari_digital_core import Token as StorageToken
from istari_digital_core import Properties as StorageProperties
from istari_digital_client.models.token import Token
from istari_digital_client.models.properties import Properties
from istari_digital_client.models.pathlike import PathLike
from istari_digital_client.configuration import Configuration


class StorageApi:
    def __init__(self, configuration: Configuration):
        self.client = StorageClient(configuration=configuration.native_configuration)

    def read_contents(self, content_token: "Token") -> bytes:
        return self.client.read_contents(
            sha=content_token.sha,
            salt=content_token.salt,
        )

    def read_properties(self, properties_token: "Token") -> "Properties":
        return Properties(self.client.read_properties(
            sha=properties_token.sha,
            salt=properties_token.salt,
        ))

    def create_storage_revision(
        self,
        file_path: "PathLike",
        display_name: str | None = None,
        description: str | None = None,
        version_name: str | None = None,
        external_identifier: str | None = None,
    ) -> Revision:
        return self.client.create_revision(
            str(file_path),
            display_name=display_name,
            description=description,
            version_name=version_name,
            external_identifier=external_identifier,
        )

    def create_secret_storage_revision(
        self,
        file_path: "PathLike",
        display_name: str | None = None,
        description: str | None = None,
        version_name: str | None = None,
        external_identifier: str | None = None,
    ) -> Revision:
        return self.client.create_secret_revision(
            str(file_path),
            display_name=display_name,
            description=description,
            version_name=version_name,
            external_identifier=external_identifier,
        )

    def update_storage_revision_content(
        self,
        file_path: "PathLike",
        salt: str,
        display_name: str | None = None,
        description: str | None = None,
        version_name: str | None = None,
        external_identifier: str | None = None,
    ) -> Revision:
        return self.client.update_content(
            str(file_path),
            salt=salt,
            display_name=display_name,
            description=description,
            version_name=version_name,
            external_identifier=external_identifier,
        )

    def update_storage_revision_properties(
        self,
        name: str,
        extension: str,
        size: int,
        mime: str,
        display_name: str | None,
        description: str | None,
        external_identifier: str | None,
        version_name: str | None,
        properties_token_salt: str,
    ) -> StorageToken:
        storage_properties = StorageProperties(
            file_name=name,
            extension=extension,
            size=size,
            description=description,
            mime=mime,
            version_name=version_name,
            external_identifier=external_identifier,
            display_name=display_name,
        )

        return self.client.update_properties(
            properties=storage_properties,
            salt=properties_token_salt,
        )
