# coding: utf-8

"""
    File Service v2

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union

from datetime import date, datetime
from pydantic import Field, StrictBool, StrictBytes, StrictInt, StrictStr, field_validator
from typing import Any, List, Optional, Tuple, Union
from typing_extensions import Annotated
from istari_digital_client.models.access_relation import AccessRelation
from istari_digital_client.models.access_relationship import AccessRelationship
from istari_digital_client.models.access_resource_type import AccessResourceType
from istari_digital_client.models.access_subject_type import AccessSubjectType
from istari_digital_client.models.agent import Agent
from istari_digital_client.models.agent_display_name import AgentDisplayName
from istari_digital_client.models.agent_modules import AgentModules
from istari_digital_client.models.agent_pool import AgentPool
from istari_digital_client.models.agent_status import AgentStatus
from istari_digital_client.models.agent_status_name import AgentStatusName
from istari_digital_client.models.agent_status_retention_duration import AgentStatusRetentionDuration
from istari_digital_client.models.app_integration import AppIntegration
from istari_digital_client.models.archive import Archive
from istari_digital_client.models.archive_status import ArchiveStatus
from istari_digital_client.models.archive_status_name import ArchiveStatusName
from istari_digital_client.models.artifact import Artifact
from istari_digital_client.models.auth_integration import AuthIntegration
from istari_digital_client.models.auth_integration_type import AuthIntegrationType
from istari_digital_client.models.auth_integration_update import AuthIntegrationUpdate
from istari_digital_client.models.bulk_sharing_access_relation import BulkSharingAccessRelation
from istari_digital_client.models.comment import Comment
from istari_digital_client.models.control_tag import ControlTag
from istari_digital_client.models.control_tag_revision import ControlTagRevision
from istari_digital_client.models.control_tagging_object_type import ControlTaggingObjectType
from istari_digital_client.models.create_document_request import CreateDocumentRequest
from istari_digital_client.models.create_multipart_upload_request import CreateMultipartUploadRequest
from istari_digital_client.models.create_multipart_upload_response import CreateMultipartUploadResponse
from istari_digital_client.models.create_upstream_remote_sync import CreateUpstreamRemoteSync
from istari_digital_client.models.deprecation_reason import DeprecationReason
from istari_digital_client.models.document import Document
from istari_digital_client.models.file import File
from istari_digital_client.models.file_control_tagging import FileControlTagging
from istari_digital_client.models.file_revision import FileRevision
from istari_digital_client.models.filter_by import FilterBy
from istari_digital_client.models.finalize_multipart_upload_request import FinalizeMultipartUploadRequest
from istari_digital_client.models.full_text_search import FullTextSearch
from istari_digital_client.models.function_auth_secret import FunctionAuthSecret
from istari_digital_client.models.function_auth_type import FunctionAuthType
from istari_digital_client.models.function_schema import FunctionSchema
from istari_digital_client.models.function_version import FunctionVersion
from istari_digital_client.models.healthcheck_report import HealthcheckReport
from istari_digital_client.models.job import Job
from istari_digital_client.models.job_status_message import JobStatusMessage
from istari_digital_client.models.job_status_name import JobStatusName
from istari_digital_client.models.model import Model
from istari_digital_client.models.module import Module
from istari_digital_client.models.module_author import ModuleAuthor
from istari_digital_client.models.module_version import ModuleVersion
from istari_digital_client.models.new_agent import NewAgent
from istari_digital_client.models.new_agent_display_name import NewAgentDisplayName
from istari_digital_client.models.new_agent_information import NewAgentInformation
from istari_digital_client.models.new_agent_module_version import NewAgentModuleVersion
from istari_digital_client.models.new_agent_pool import NewAgentPool
from istari_digital_client.models.new_agent_pool_agent_membership import NewAgentPoolAgentMembership
from istari_digital_client.models.new_agent_pool_user_membership import NewAgentPoolUserMembership
from istari_digital_client.models.new_agent_status import NewAgentStatus
from istari_digital_client.models.new_agent_status_retention_duration import NewAgentStatusRetentionDuration
from istari_digital_client.models.new_app_integration import NewAppIntegration
from istari_digital_client.models.new_auth_integration import NewAuthIntegration
from istari_digital_client.models.new_control_tag import NewControlTag
from istari_digital_client.models.new_function_auth_secret import NewFunctionAuthSecret
from istari_digital_client.models.new_job_assigned_agent import NewJobAssignedAgent
from istari_digital_client.models.new_module_author import NewModuleAuthor
from istari_digital_client.models.new_module_manifest import NewModuleManifest
from istari_digital_client.models.new_operating_system import NewOperatingSystem
from istari_digital_client.models.new_snapshot import NewSnapshot
from istari_digital_client.models.new_snapshot_tag import NewSnapshotTag
from istari_digital_client.models.new_system import NewSystem
from istari_digital_client.models.new_system_configuration import NewSystemConfiguration
from istari_digital_client.models.new_tool import NewTool
from istari_digital_client.models.new_tool_version import NewToolVersion
from istari_digital_client.models.os import OS
from istari_digital_client.models.operating_system import OperatingSystem
from istari_digital_client.models.page_agent import PageAgent
from istari_digital_client.models.page_agent_pool import PageAgentPool
from istari_digital_client.models.page_agent_pool_agent_membership_with_agent import PageAgentPoolAgentMembershipWithAgent
from istari_digital_client.models.page_agent_pool_user_membership_with_user import PageAgentPoolUserMembershipWithUser
from istari_digital_client.models.page_agent_status import PageAgentStatus
from istari_digital_client.models.page_app_integration import PageAppIntegration
from istari_digital_client.models.page_artifact import PageArtifact
from istari_digital_client.models.page_auth_integration import PageAuthIntegration
from istari_digital_client.models.page_comment import PageComment
from istari_digital_client.models.page_document_list_item import PageDocumentListItem
from istari_digital_client.models.page_file import PageFile
from istari_digital_client.models.page_function_version import PageFunctionVersion
from istari_digital_client.models.page_job import PageJob
from istari_digital_client.models.page_model_list_item import PageModelListItem
from istari_digital_client.models.page_module import PageModule
from istari_digital_client.models.page_module_author import PageModuleAuthor
from istari_digital_client.models.page_module_version import PageModuleVersion
from istari_digital_client.models.page_operating_system import PageOperatingSystem
from istari_digital_client.models.page_personal_access_token import PagePersonalAccessToken
from istari_digital_client.models.page_resource_search_item import PageResourceSearchItem
from istari_digital_client.models.page_snapshot import PageSnapshot
from istari_digital_client.models.page_snapshot_item import PageSnapshotItem
from istari_digital_client.models.page_snapshot_revision_search_item import PageSnapshotRevisionSearchItem
from istari_digital_client.models.page_snapshot_tag import PageSnapshotTag
from istari_digital_client.models.page_system import PageSystem
from istari_digital_client.models.page_system_configuration import PageSystemConfiguration
from istari_digital_client.models.page_tenant import PageTenant
from istari_digital_client.models.page_tool import PageTool
from istari_digital_client.models.page_tool_version import PageToolVersion
from istari_digital_client.models.page_tracked_file import PageTrackedFile
from istari_digital_client.models.page_type_var_customized_resource_search_item import PageTypeVarCustomizedResourceSearchItem
from istari_digital_client.models.page_upstream_remote import PageUpstreamRemote
from istari_digital_client.models.patch_op import PatchOp
from istari_digital_client.models.permission import Permission
from istari_digital_client.models.permission_resource_type import PermissionResourceType
from istari_digital_client.models.permission_subject_type import PermissionSubjectType
from istari_digital_client.models.permissionship import Permissionship
from istari_digital_client.models.personal_access_token import PersonalAccessToken
from istari_digital_client.models.resource_control_tagging import ResourceControlTagging
from istari_digital_client.models.resource_type import ResourceType
from istari_digital_client.models.response_create_snapshot import ResponseCreateSnapshot
from istari_digital_client.models.restore import Restore
from istari_digital_client.models.snapshot import Snapshot
from istari_digital_client.models.snapshot_tag import SnapshotTag
from istari_digital_client.models.system import System
from istari_digital_client.models.system_baseline import SystemBaseline
from istari_digital_client.models.system_configuration import SystemConfiguration
from istari_digital_client.models.temporary_url import TemporaryURL
from istari_digital_client.models.tenant_public_key import TenantPublicKey
from istari_digital_client.models.token_with_properties import TokenWithProperties
from istari_digital_client.models.tool import Tool
from istari_digital_client.models.tool_include import ToolInclude
from istari_digital_client.models.tool_version import ToolVersion
from istari_digital_client.models.update_access_relationship import UpdateAccessRelationship
from istari_digital_client.models.update_access_relationship_list import UpdateAccessRelationshipList
from istari_digital_client.models.update_control_tag import UpdateControlTag
from istari_digital_client.models.update_document_request import UpdateDocumentRequest
from istari_digital_client.models.update_system import UpdateSystem
from istari_digital_client.models.update_tag import UpdateTag
from istari_digital_client.models.update_tool import UpdateTool
from istari_digital_client.models.upstream_remote_sync import UpstreamRemoteSync
from istari_digital_client.models.usability_status_params import UsabilityStatusParams
from istari_digital_client.models.user import User
from istari_digital_client.models.user_control_tagging import UserControlTagging
from istari_digital_client.models.user_model_inputs import UserModelInputs
from istari_digital_client.models.user_state_option import UserStateOption
from istari_digital_client.models.user_type import UserType
from istari_digital_client.api_client import ApiClient, RequestSerialized
from istari_digital_client.configuration import Configuration
from istari_digital_client.models.token import Token
from istari_digital_client.models.properties import Properties
from istari_digital_client.models.new_source import NewSource
from istari_digital_client.models.source import Source
from istari_digital_client.models.client_having import ClientHaving
from istari_digital_client.models.pageable import Pageable
from istari_digital_client.models.json_type import JSON
from istari_digital_client.models.pathlike import PathLike
from istari_digital_client.log_utils import log_method
from istari_digital_client.api.storage_api import StorageApi

import tempfile
import json
from pathlib import Path
import uuid
from datetime import datetime, timezone

import istari_digital_core

Resource = Union[Artifact, Comment, Model, Job, FunctionAuthSecret]


class ClientApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, config: Configuration, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client
        self.config = config
        self.storage_api = StorageApi(self.config)

    @log_method
    def get_resource(self, resource_type: str, resource_id: str) -> Resource:
        """
        Retrieve a resource by type and ID.

        This method fetches a resource of the specified type using its unique identifier.
        Supported resource types may include models, artifacts, files, jobs, and others
        registered in the system.

        :param resource_type: Type of the resource to retrieve (e.g., "model", "artifact").
        :type resource_type: str
        :param resource_id: Unique identifier of the resource.
        :type resource_id: str
        """

        if resource_type == "Artifact":
            return self.get_artifact(resource_id)
        elif resource_type == "Comment":
            return self.get_comment(resource_id)
        elif resource_type == "Model":
            return self.get_model(resource_id)
        elif resource_type == "Job":
            return self.get_job(resource_id)
        elif resource_type == "FunctionAuthSecretEntity":
            return self.fetch_function_auth_secret(resource_id)
        else:
            raise TypeError(
                f"Unsupported resource type for get_resource(): {resource_type}"
            )

    @log_method
    def create_revision(
        self,
        file_path: PathLike,
        sources: list[NewSource | str] | None = None,
        display_name: str | None = None,
        description: str | None = None,
        version_name: str | None = None,
        external_identifier: str | None = None,
    ) -> FileRevision:
        """
        Create a new file revision from a given file path and optional metadata.

        This method uploads a file as a new revision and optionally attaches metadata such as
        sources, display name, description, version name, and an external identifier.

        :param file_path: Filesystem path to the file being uploaded as a revision.
        :type file_path: PathLike
        :param sources: Optional list of sources associated with the revision. Each item may be a
                        NewSource instance or a string source name.
        :type sources: list[NewSource | str] | None
        :param display_name: Optional human-readable name for the revision.
        :type display_name: str | None
        :param description: Optional text describing the revision's contents or purpose.
        :type description: str | None
        :param version_name: Optional user-defined version label for the revision.
        :type version_name: str | None
        :param external_identifier: Optional external system identifier for the revision.
        :type external_identifier: str | None
        """

        storage_revision = self.storage_api.create_storage_revision(
            str(file_path),
            display_name=display_name,
            description=description,
            version_name=version_name,
            external_identifier=external_identifier,
        )

        source_list = [
            Source(
                revision_id=source if isinstance(source, str) else source.revision_id,
                file_id=None,
                resource_type=None,
                resource_id=None,
                relationship_identifier=None if isinstance(source, str) else source.relationship_identifier,
            )
            for source in (sources or [])
        ]

        return FileRevision.from_storage_revision(
            storage_revision,
            sources=source_list,
        )

    @log_method
    def create_secret_revision(
        self,
        file_path: PathLike,
        sources: list[NewSource | str] | None = None,
        display_name: str | None = None,
        description: str | None = None,
        version_name: str | None = None,
        external_identifier: str | None = None,
    ) -> FileRevision:
        """
        Create a new secret file revision from a given file path and optional metadata.

        This method uploads a file containing secret content as a new revision, and optionally
        associates metadata such as sources, display name, description, version name, and an external identifier.

        :param file_path: Filesystem path to the secret file being uploaded as a revision.
        :type file_path: PathLike
        :param sources: Optional list of sources associated with the revision. Each item may be a
                        NewSource instance or a string source name.
        :type sources: list[NewSource | str] | None
        :param display_name: Optional human-readable name for the revision.
        :type display_name: str | None
        :param description: Optional text describing the revision's contents or purpose.
        :type description: str | None
        :param version_name: Optional user-defined version label for the revision.
        :type version_name: str | None
        :param external_identifier: Optional external system identifier for the revision.
        :type external_identifier: str | None
        """

        storage_revision = self.storage_api.create_secret_storage_revision(
            str(file_path),
            display_name=display_name,
            description=description,
            version_name=version_name,
            external_identifier=external_identifier,
        )

        source_list = [
            Source(
                revision_id=source if isinstance(source, str) else source.revision_id,
                file_id=None,
                resource_type=None,
                resource_id=None,
                relationship_identifier=None if isinstance(source, str) else source.relationship_identifier,
            )
            for source in (sources or [])
        ]

        return FileRevision.from_storage_revision(
            storage_revision,
            sources=source_list,
        )

    @log_method
    def update_revision_content(
        self,
        file_path: PathLike,
        salt: str,
        sources: list[NewSource | str] | None = None,
        display_name: str | None = None,
        description: str | None = None,
        version_name: str | None = None,
        external_identifier: str | None = None,
    ) -> FileRevision:
        """
        Update the contents of an existing file revision.

        This method uploads new content from the given file path to update an existing revision.
        A salt value must be provided to locate or identify the revision being updated.
        Optional metadata such as sources, display name, description, version name, and
        external identifier can also be modified.

        :param file_path: Filesystem path to the new file content for the revision.
        :type file_path: PathLike
        :param salt: Unique salt value used to identify or deduplicate the revision update.
        :type salt: str
        :param sources: Optional list of sources associated with the revision. Each item may be a
                        NewSource instance or a string source name.
        :type sources: list[NewSource | str] | None
        :param display_name: Optional human-readable name for the revision.
        :type display_name: str | None
        :param description: Optional text describing the updated revision content.
        :type description: str | None
        :param version_name: Optional user-defined version label for the revision.
        :type version_name: str | None
        :param external_identifier: Optional external system identifier for the revision.
        :type external_identifier: str | None
        """

        storage_revision = self.storage_api.update_storage_revision_content(
            str(file_path),
            salt=salt,
            display_name=display_name,
            description=description,
            version_name=version_name,
            external_identifier=external_identifier,
        )

        if sources:
            source_list = []
            for source in sources:
                if isinstance(source, str):
                    revision_id = source
                    relationship_identifier = None
                else:
                    revision_id = source.revision_id
                    relationship_identifier = source.relationship_identifier

                source_list.append(
                    Source(
                        revision_id=revision_id,
                        file_id=None,
                        resource_type=None,
                        resource_id=None,
                        relationship_identifier=relationship_identifier,
                    )
                )

        else:
            source_list = []

        return FileRevision.from_storage_revision(
            storage_revision,
            sources=source_list,
        )

    @log_method
    def update_revision_properties(
        self,
        file_revision: FileRevision,
        display_name: str | None = None,
        description: str | None = None,
        external_identifier: str | None = None,
        version_name: str | None = None,
    ) -> File:
        """
        Update metadata properties of an existing file revision.

        This method modifies the metadata associated with a file revision, such as display name,
        description, version name, or external identifier. The revision content itself is not changed.

        :param file_revision: The file revision object whose metadata will be updated.
        :type file_revision: FileRevision
        :param display_name: Optional human-readable name for the revision.
        :type display_name: str | None
        :param description: Optional text describing the revision.
        :type description: str | None
        :param external_identifier: Optional external system identifier for the revision.
        :type external_identifier: str | None
        :param version_name: Optional user-defined version label for the revision.
        :type version_name: str | None
        """

        storage_properties = istari_digital_core.Properties(
            file_name=file_revision.name or "",
            extension=file_revision.extension or "",
            size=file_revision.size or 0,
            description=description if description is not None else file_revision.description,
            mime=file_revision.mime or "",
            version_name=version_name if version_name is not None else file_revision.version_name,
            external_identifier=external_identifier if external_identifier is not None else file_revision.external_identifier,
            display_name=display_name if display_name is not None else file_revision.display_name,
        )

        updated_properties_token = self.storage_api.update_storage_revision_properties(
            name=file_revision.name if file_revision.name is not None else "",
            extension=file_revision.extension if file_revision.extension is not None else "",
            size=file_revision.size if file_revision.size is not None else 0,
            mime=file_revision.mime if file_revision.mime is not None else "",
            display_name=display_name if display_name is not None else file_revision.display_name,
            description=description if description is not None else file_revision.description,
            external_identifier=external_identifier if external_identifier is not None else file_revision.external_identifier,
            version_name=version_name if version_name is not None else file_revision.version_name,
            properties_token_salt=file_revision.properties_token.salt,
        )

        token_with_properties = TokenWithProperties(
            id=str(uuid.uuid4()),
            created=datetime.now(timezone.utc),
            sha=updated_properties_token.sha,
            salt=updated_properties_token.salt,
            name=storage_properties.file_name,
            extension=storage_properties.extension,
            size=storage_properties.size,
            description=storage_properties.description,
            mime=storage_properties.mime,
            version_name=storage_properties.version_name,
            external_identifier=storage_properties.external_identifier,
            display_name=storage_properties.display_name,
        )

        if file_revision.file_id is None:
            raise ValueError("File ID is required to update file properties.")

        return self._update_file_properties(
            file_id=file_revision.file_id,
            token_with_properties=token_with_properties,
        )

    @log_method
    def read_contents(self, token: Token) -> bytes:
        """
        Read and return the raw contents of a file associated with a token.

        This method retrieves the file data as a byte stream using the specified token,
        which grants access to the protected resource.

        :param token: Access token for retrieving the file contents.
        :type token: Token
        """

        return self.storage_api.read_contents(token)

    @log_method
    def read_properties(self, token: Token) -> Properties:
        """
        Retrieve metadata properties for a file associated with a token.

        This method returns descriptive metadata about the file identified by the provided access token.
        The returned `Properties` object includes non-content attributes such as file name, extension,
        size, MIME type, and optional descriptive metadata.

        Fields include:
        - `name`: Full file name with extension (e.g., "foo.JPG").
        - `stem`: File name without extension (e.g., "foo").
        - `extension`: Lowercased file extension without the dot (e.g., "jpg").
        - `suffix`: File suffix with original casing and a leading dot (e.g., ".JPG").
        - `size`: File size in bytes.
        - `mime_type`: MIME type of the file (e.g., "image/jpeg").
        - `description`: Optional description set on the file.
        - `version_name`: Optional version label.
        - `external_identifier`: Optional external reference ID.
        - `display_name`: Optional user-facing display name.

        :param token: Access token used to retrieve file properties.
        :type token: Token
        """

        return self.storage_api.read_properties(token)

    @log_method
    def add_job(
        self,
        model_id: str,
        function: str,
        *,
        parameters: JSON | None = None,
        parameters_file: PathLike | None = None,
        tool_name: str | None = None,
        tool_version: str | None = None,
        operating_system: OS | None = None,
        assigned_agent_id: str | None = None,
        agent_id: str | None = None,
        sources: list[NewSource | str] | None = None,
        description: str | None = None,
        version_name: str | None = None,
        external_identifier: str | None = None,
        display_name: str | None = None,
        **kwargs,
    ) -> "Job":
        """
        Add a new job to a model.

        This method creates and registers a new job associated with the specified model.
        You can define the job's function and optionally provide input parameters, execution
        environment details, and descriptive metadata.

        :param model_id: Unique identifier of the model to which the job will be attached.
        :type model_id: str
        :param function: Name of the function that the job will execute.
        :type function: str
        :param parameters: Optional structured input parameters to pass to the function.
        :type parameters: JSON | None
        :param parameters_file: Optional filesystem path to a file containing job parameters.
        :type parameters_file: PathLike | None
        :param tool_name: Optional name of the tool used in this job.
        :type tool_name: str | None
        :param tool_version: Optional version of the tool used in this job.
        :type tool_version: str | None
        :param operating_system: Optional enum describing the operating system of the target agent.
        :type operating_system: OS | None
        :param assigned_agent_id: Optional ID of the agent assigned to execute the job.
        :type assigned_agent_id: str | None
        :param agent_id: Optional identifier for the agent that created the job.
        :type agent_id: str | None
        :param sources: Optional list of sources associated with the job. Each item may be a
                        NewSource instance or a string source name.
        :type sources: list[NewSource | str] | None
        :param description: Optional description of the job.
        :type description: str | None
        :param version_name: Optional user-defined version label for the job.
        :type version_name: str | None
        :param external_identifier: Optional external system identifier for the job.
        :type external_identifier: str | None
        :param display_name: Optional human-readable name for the job.
        :type display_name: str | None
        """

        parameters_file_is_temp = False
        if parameters_file and (parameters or kwargs):
            raise ValueError(
                "Can't combine a parameters file with explicit parameters or parameter kwargs"
            )
        if not parameters_file:
            if parameters and kwargs:
                raise ValueError(
                    "Can't combine explicit parameters with parameters kwargs"
                )
            parameters = parameters or kwargs
            parameters_file = Path(
                tempfile.NamedTemporaryFile(
                    prefix="parameters", suffix=".json", delete=False
                ).name
            )
            parameters_file.write_text(json.dumps(parameters, indent=4))
            parameters_file_is_temp = True
        parameters_file = Path(parameters_file)
        try:
            file_revision = self.create_revision(
                file_path=str(parameters_file),
                sources=sources,
                display_name=display_name,
                description=description,
                version_name=version_name,
                external_identifier=external_identifier,
            )

            openapi_job = self._create_model_job(
                model_id=model_id,
                function_name=function,
                file_revision=file_revision,
                tool_name=tool_name,
                tool_version=tool_version,
                operating_system=operating_system,
                assigned_agent_id=assigned_agent_id,
                agent_id=agent_id,
            )
        finally:
            if parameters_file_is_temp:
                if parameters_file.exists():
                    parameters_file.unlink(missing_ok=True)

        return openapi_job


    @validate_call
    @log_method
    def _create_artifact(
        self,
        model_id: Annotated[StrictStr, Field(description="The id of the model to add the artifact to.")],
        file_revision: FileRevision,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Artifact:

        """
        Helper method to add an artifact to the database.  Use add_artifact instead.

        :param model_id: The id of the model to add the artifact to. (required)
        :type model_id: str
        :param file_revision: (required)
        :type file_revision: FileRevision
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self.__create_artifact_serialize(
            model_id=model_id,
            file_revision=file_revision,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Artifact",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Artifact = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self._create_artifact # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'model_id': model_id,
                'file_revision': file_revision,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def __create_artifact_serialize(
        self,
        model_id,
        file_revision,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if model_id is not None:
            _path_params['model_id'] = model_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if file_revision is not None:
            _body_params = file_revision


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/models/{model_id}/artifacts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def _create_auth_integration(
        self,
        new_auth_integration: NewAuthIntegration,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AuthIntegration:

        """
        This method creates a new AuthIntegration.

        :param new_auth_integration: (required)
        :type new_auth_integration: NewAuthIntegration
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self.__create_auth_integration_serialize(
            new_auth_integration=new_auth_integration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "AuthIntegration",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AuthIntegration = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self._create_auth_integration # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'new_auth_integration': new_auth_integration,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def __create_auth_integration_serialize(
        self,
        new_auth_integration,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_auth_integration is not None:
            _body_params = new_auth_integration


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/app_integrations/authintegrations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def _create_comment(
        self,
        resource_id: Annotated[StrictStr, Field(description="The ID of the resource to which the comment is attached.")],
        file_revision: FileRevision,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Comment:

        """
        Helper method to add a comment to the database.  Use add_comment instead.

        :param resource_id: The ID of the resource to which the comment is attached. (required)
        :type resource_id: str
        :param file_revision: (required)
        :type file_revision: FileRevision
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self.__create_comment_serialize(
            resource_id=resource_id,
            file_revision=file_revision,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Comment",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Comment = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self._create_comment # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'resource_id': resource_id,
                'file_revision': file_revision,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def __create_comment_serialize(
        self,
        resource_id,
        file_revision,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if resource_id is not None:

            _query_params.append(('resource_id', resource_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if file_revision is not None:
            _body_params = file_revision


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/comments',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def _create_file(
        self,
        file_revision: FileRevision,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> File:

        """
        Helper method to add a file to the database.  Use add_file instead.

        :param file_revision: (required)
        :type file_revision: FileRevision
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self.__create_file_serialize(
            file_revision=file_revision,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "File",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: File = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self._create_file # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'file_revision': file_revision,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def __create_file_serialize(
        self,
        file_revision,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if file_revision is not None:
            _body_params = file_revision


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/files',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def _create_function_auth_secret(
        self,
        new_function_auth_secret: NewFunctionAuthSecret,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> FunctionAuthSecret:

        """
        Helper method to add a Function Auth Secret to the database.  Use add_function_auth_secret instead.

        :param new_function_auth_secret: (required)
        :type new_function_auth_secret: NewFunctionAuthSecret
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self.__create_function_auth_secret_serialize(
            new_function_auth_secret=new_function_auth_secret,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FunctionAuthSecret",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: FunctionAuthSecret = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self._create_function_auth_secret # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'new_function_auth_secret': new_function_auth_secret,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def __create_function_auth_secret_serialize(
        self,
        new_function_auth_secret,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_function_auth_secret is not None:
            _body_params = new_function_auth_secret


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/app_integrations/authsecrets',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def _create_model(
        self,
        file_revision: FileRevision,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Model:

        """
        Helper method to add model to the database. Use add_model instead.

        :param file_revision: (required)
        :type file_revision: FileRevision
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self.__create_model_serialize(
            file_revision=file_revision,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Model",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Model = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self._create_model # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'file_revision': file_revision,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def __create_model_serialize(
        self,
        file_revision,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if file_revision is not None:
            _body_params = file_revision


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/models',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def _create_model_job(
        self,
        model_id: Annotated[StrictStr, Field(description="The id of the model to add the job to.")],
        function_name: Annotated[StrictStr, Field(description="The function name for the job.")],
        file_revision: FileRevision,
        function_version: Annotated[Optional[StrictStr], Field(description="The version of the function.")] = None,
        tool_name: Annotated[Optional[StrictStr], Field(description="The name of the tool to use for the applicable function")] = None,
        tool_version: Annotated[Optional[StrictStr], Field(description="The version of the tool to use.")] = None,
        operating_system: Annotated[Optional[OS], Field(description="The operating system the tool needs to run on.")] = None,
        assigned_agent_id: Annotated[Optional[StrictStr], Field(description="The agent id for the agent assigned to execute the job.")] = None,
        agent_id: Annotated[Optional[StrictStr], Field(description="The agent id for the agent that created the job.")] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Job:

        """
        Helper method to add a job to the database.  Use add_job instead.

        :param model_id: The id of the model to add the job to. (required)
        :type model_id: str
        :param function_name: The function name for the job. (required)
        :type function_name: str
        :param file_revision: (required)
        :type file_revision: FileRevision
        :param function_version: The version of the function.
        :type function_version: str
        :param tool_name: The name of the tool to use for the applicable function
        :type tool_name: str
        :param tool_version: The version of the tool to use.
        :type tool_version: str
        :param operating_system: The operating system the tool needs to run on.
        :type operating_system: OS
        :param assigned_agent_id: The agent id for the agent assigned to execute the job.
        :type assigned_agent_id: str
        :param agent_id: The agent id for the agent that created the job.
        :type agent_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self.__create_model_job_serialize(
            model_id=model_id,
            function_name=function_name,
            file_revision=file_revision,
            function_version=function_version,
            tool_name=tool_name,
            tool_version=tool_version,
            operating_system=operating_system,
            assigned_agent_id=assigned_agent_id,
            agent_id=agent_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Job = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self._create_model_job # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'model_id': model_id,
                'function_name': function_name,
                'file_revision': file_revision,
                'function_version': function_version,
                'tool_name': tool_name,
                'tool_version': tool_version,
                'operating_system': operating_system,
                'assigned_agent_id': assigned_agent_id,
                'agent_id': agent_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def __create_model_job_serialize(
        self,
        model_id,
        function_name,
        file_revision,
        function_version,
        tool_name,
        tool_version,
        operating_system,
        assigned_agent_id,
        agent_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if model_id is not None:
            _path_params['model_id'] = model_id
        # process the query parameters
        if function_name is not None:

            _query_params.append(('function_name', function_name))

        if function_version is not None:

            _query_params.append(('function_version', function_version))

        if tool_name is not None:

            _query_params.append(('tool_name', tool_name))

        if tool_version is not None:

            _query_params.append(('tool_version', tool_version))

        if operating_system is not None:

            _query_params.append(('operating_system', operating_system.value))

        if assigned_agent_id is not None:

            _query_params.append(('assigned_agent_id', assigned_agent_id))

        if agent_id is not None:

            _query_params.append(('agent_id', agent_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if file_revision is not None:
            _body_params = file_revision


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/models/{model_id}/jobs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def _update_artifact(
        self,
        artifact_id: Annotated[StrictStr, Field(description="The id of the artifact to update. This is a required field.")],
        file_revision: FileRevision,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Artifact:

        """
        Helper method to update an artifact in the database.  Use update_artifact instead.

        :param artifact_id: The id of the artifact to update. This is a required field. (required)
        :type artifact_id: str
        :param file_revision: (required)
        :type file_revision: FileRevision
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self.__update_artifact_serialize(
            artifact_id=artifact_id,
            file_revision=file_revision,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Artifact",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Artifact = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self._update_artifact # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'artifact_id': artifact_id,
                'file_revision': file_revision,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def __update_artifact_serialize(
        self,
        artifact_id,
        file_revision,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if artifact_id is not None:
            _path_params['artifact_id'] = artifact_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if file_revision is not None:
            _body_params = file_revision


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/artifacts/{artifact_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def _update_auth_integration(
        self,
        auth_integration_id: Annotated[StrictStr, Field(description="The unique name of the AuthIntegration to update")],
        auth_integration_update: AuthIntegrationUpdate,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AuthIntegration:

        """
        This method updates an AuthIntegration.

        :param auth_integration_id: The unique name of the AuthIntegration to update (required)
        :type auth_integration_id: str
        :param auth_integration_update: (required)
        :type auth_integration_update: AuthIntegrationUpdate
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self.__update_auth_integration_serialize(
            auth_integration_id=auth_integration_id,
            auth_integration_update=auth_integration_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AuthIntegration",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AuthIntegration = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self._update_auth_integration # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'auth_integration_id': auth_integration_id,
                'auth_integration_update': auth_integration_update,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def __update_auth_integration_serialize(
        self,
        auth_integration_id,
        auth_integration_update,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if auth_integration_id is not None:
            _path_params['auth_integration_id'] = auth_integration_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if auth_integration_update is not None:
            _body_params = auth_integration_update


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/app_integrations/authintegrations/{auth_integration_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def _update_comment(
        self,
        comment_id: Annotated[StrictStr, Field(description="The ID of the comment to update.")],
        file_revision: FileRevision,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Comment:

        """
        Helper method to update a comment in the database.  Use update_comment instead.

        :param comment_id: The ID of the comment to update. (required)
        :type comment_id: str
        :param file_revision: (required)
        :type file_revision: FileRevision
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self.__update_comment_serialize(
            comment_id=comment_id,
            file_revision=file_revision,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Comment",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Comment = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self._update_comment # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'comment_id': comment_id,
                'file_revision': file_revision,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def __update_comment_serialize(
        self,
        comment_id,
        file_revision,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if comment_id is not None:
            _path_params['comment_id'] = comment_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if file_revision is not None:
            _body_params = file_revision


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/comments/{comment_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def _update_file(
        self,
        file_id: Annotated[StrictStr, Field(description="The id of the file to update.")],
        file_revision: FileRevision,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> File:

        """
        Helper method to update a file in the database.  Use update_file instead.

        :param file_id: The id of the file to update. (required)
        :type file_id: str
        :param file_revision: (required)
        :type file_revision: FileRevision
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self.__update_file_serialize(
            file_id=file_id,
            file_revision=file_revision,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "File",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: File = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self._update_file # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'file_id': file_id,
                'file_revision': file_revision,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def __update_file_serialize(
        self,
        file_id,
        file_revision,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['file_id'] = file_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if file_revision is not None:
            _body_params = file_revision


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/files/{file_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def _update_file_properties(
        self,
        file_id: Annotated[StrictStr, Field(description="The id of the file to update.")],
        token_with_properties: TokenWithProperties,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> File:

        """
        Helper method to update a file's properties in the database.  Use update_file_properties instead.

        :param file_id: The id of the file to update. (required)
        :type file_id: str
        :param token_with_properties: (required)
        :type token_with_properties: TokenWithProperties
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self.__update_file_properties_serialize(
            file_id=file_id,
            token_with_properties=token_with_properties,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "File",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: File = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self._update_file_properties # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'file_id': file_id,
                'token_with_properties': token_with_properties,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def __update_file_properties_serialize(
        self,
        file_id,
        token_with_properties,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['file_id'] = file_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if token_with_properties is not None:
            _body_params = token_with_properties


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/files/{file_id}/properties',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def _update_job(
        self,
        job_id: Annotated[StrictStr, Field(description="The id of the job to update.")],
        file_revision: FileRevision,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Job:

        """
        Helper method to update a job in the database.  Use update_job instead.

        :param job_id: The id of the job to update. (required)
        :type job_id: str
        :param file_revision: (required)
        :type file_revision: FileRevision
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self.__update_job_serialize(
            job_id=job_id,
            file_revision=file_revision,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Job = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self._update_job # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'job_id': job_id,
                'file_revision': file_revision,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def __update_job_serialize(
        self,
        job_id,
        file_revision,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['job_id'] = job_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if file_revision is not None:
            _body_params = file_revision


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/jobs/{job_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def _update_model(
        self,
        model_id: Annotated[StrictStr, Field(description="The id of the model to update.")],
        file_revision: FileRevision,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Model:

        """
        Helper method to update a model in the database. Use update_model instead.

        :param model_id: The id of the model to update. (required)
        :type model_id: str
        :param file_revision: (required)
        :type file_revision: FileRevision
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self.__update_model_serialize(
            model_id=model_id,
            file_revision=file_revision,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Model",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Model = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self._update_model # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'model_id': model_id,
                'file_revision': file_revision,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def __update_model_serialize(
        self,
        model_id,
        file_revision,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if model_id is not None:
            _path_params['model_id'] = model_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if file_revision is not None:
            _body_params = file_revision


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/models/{model_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def archive_artifact(
        self,
        artifact_id: Annotated[StrictStr, Field(description="The id of the artifact to archive. This is a required field.")],
        archive: Optional[Archive] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Artifact:

        """
        This method archives an artifact by updating it's archive status to Archived.

        :param artifact_id: The id of the artifact to archive. This is a required field. (required)
        :type artifact_id: str
        :param archive:
        :type archive: Archive
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._archive_artifact_serialize(
            artifact_id=artifact_id,
            archive=archive,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Artifact",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Artifact = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.archive_artifact # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'artifact_id': artifact_id,
                'archive': archive,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _archive_artifact_serialize(
        self,
        artifact_id,
        archive,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if artifact_id is not None:
            _path_params['artifact_id'] = artifact_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if archive is not None:
            _body_params = archive


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/artifacts/{artifact_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def archive_comment(
        self,
        comment_id: Annotated[StrictStr, Field(description="The ID of the comment to archive.")],
        archive: Optional[Archive] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Comment:

        """
        This method archives a comment by updating it's archive status to Archived.

        :param comment_id: The ID of the comment to archive. (required)
        :type comment_id: str
        :param archive:
        :type archive: Archive
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._archive_comment_serialize(
            comment_id=comment_id,
            archive=archive,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Comment",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Comment = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.archive_comment # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'comment_id': comment_id,
                'archive': archive,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _archive_comment_serialize(
        self,
        comment_id,
        archive,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if comment_id is not None:
            _path_params['comment_id'] = comment_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if archive is not None:
            _body_params = archive


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/comments/{comment_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def archive_configuration(
        self,
        configuration_id: Annotated[StrictStr, Field(description="The id of the configuration to archive.")],
        archive: Optional[Archive] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> SystemConfiguration:

        """
        This method archives a configuration by updating it's archive status to Archived.

        :param configuration_id: The id of the configuration to archive. (required)
        :type configuration_id: str
        :param archive:
        :type archive: Archive
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._archive_configuration_serialize(
            configuration_id=configuration_id,
            archive=archive,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SystemConfiguration",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: SystemConfiguration = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.archive_configuration # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'configuration_id': configuration_id,
                'archive': archive,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _archive_configuration_serialize(
        self,
        configuration_id,
        archive,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if configuration_id is not None:
            _path_params['configuration_id'] = configuration_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if archive is not None:
            _body_params = archive


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/systems/configurations/{configuration_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def archive_document(
        self,
        document_id: Annotated[StrictStr, Field(description="The id of the document to archive.")],
        archive: Optional[Archive] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Document:

        """
        This method archives a document by updating its archive status to Archived.

        :param document_id: The id of the document to archive. (required)
        :type document_id: str
        :param archive:
        :type archive: Archive
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._archive_document_serialize(
            document_id=document_id,
            archive=archive,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Document",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Document = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.archive_document # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'document_id': document_id,
                'archive': archive,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _archive_document_serialize(
        self,
        document_id,
        archive,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if document_id is not None:
            _path_params['document_id'] = document_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if archive is not None:
            _body_params = archive


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/documents/{document_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def archive_file(
        self,
        file_id: Annotated[StrictStr, Field(description="The id of the file to archive.")],
        archive: Optional[Archive] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> File:

        """
        This method archives a file by updating it's archive status to Archived.

        :param file_id: The id of the file to archive. (required)
        :type file_id: str
        :param archive:
        :type archive: Archive
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._archive_file_serialize(
            file_id=file_id,
            archive=archive,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "File",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: File = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.archive_file # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'file_id': file_id,
                'archive': archive,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _archive_file_serialize(
        self,
        file_id,
        archive,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['file_id'] = file_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if archive is not None:
            _body_params = archive


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/files/{file_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def archive_file_revision(
        self,
        revision_id: Annotated[StrictStr, Field(description="The id of the file revision to archive.")],
        archive: Optional[Archive] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> FileRevision:

        """
        This method archives a FileRevision by updating it's archive status to Archived.

        :param revision_id: The id of the file revision to archive. (required)
        :type revision_id: str
        :param archive:
        :type archive: Archive
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._archive_file_revision_serialize(
            revision_id=revision_id,
            archive=archive,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FileRevision",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: FileRevision = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.archive_file_revision # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'revision_id': revision_id,
                'archive': archive,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _archive_file_revision_serialize(
        self,
        revision_id,
        archive,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if revision_id is not None:
            _path_params['revision_id'] = revision_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if archive is not None:
            _body_params = archive


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/revisions/{revision_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def archive_job(
        self,
        job_id: Annotated[StrictStr, Field(description="The id of the job to archive.")],
        archive: Optional[Archive] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Job:

        """
        This method archives a job by updating it's archive status to Archived.

        :param job_id: The id of the job to archive. (required)
        :type job_id: str
        :param archive:
        :type archive: Archive
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._archive_job_serialize(
            job_id=job_id,
            archive=archive,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Job = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.archive_job # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'job_id': job_id,
                'archive': archive,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _archive_job_serialize(
        self,
        job_id,
        archive,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['job_id'] = job_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if archive is not None:
            _body_params = archive


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/jobs/{job_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def archive_model(
        self,
        model_id: Annotated[StrictStr, Field(description="The id of the model to archive.")],
        archive: Optional[Archive] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Model:

        """
        This method archives a model by updating it's archive status to Archived.

        :param model_id: The id of the model to archive. (required)
        :type model_id: str
        :param archive:
        :type archive: Archive
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._archive_model_serialize(
            model_id=model_id,
            archive=archive,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Model",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Model = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.archive_model # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'model_id': model_id,
                'archive': archive,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _archive_model_serialize(
        self,
        model_id,
        archive,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if model_id is not None:
            _path_params['model_id'] = model_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if archive is not None:
            _body_params = archive


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/models/{model_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def archive_system(
        self,
        system_id: Annotated[StrictStr, Field(description="The id of the system to archive.")],
        archive: Optional[Archive] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> System:

        """
        This method archives a system by updating it's archive status to Archived.

        :param system_id: The id of the system to archive. (required)
        :type system_id: str
        :param archive:
        :type archive: Archive
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._archive_system_serialize(
            system_id=system_id,
            archive=archive,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "System",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: System = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.archive_system # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'system_id': system_id,
                'archive': archive,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _archive_system_serialize(
        self,
        system_id,
        archive,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if system_id is not None:
            _path_params['system_id'] = system_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if archive is not None:
            _body_params = archive


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/systems/{system_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def archive_tag(
        self,
        tag_id: Annotated[StrictStr, Field(description="The id of the tag to archive.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> SnapshotTag:

        """
        This method archives a snapshot tag by updating it's archive status to Archived.

        :param tag_id: The id of the tag to archive. (required)
        :type tag_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._archive_tag_serialize(
            tag_id=tag_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SnapshotTag",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: SnapshotTag = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.archive_tag # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'tag_id': tag_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _archive_tag_serialize(
        self,
        tag_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tag_id is not None:
            _path_params['tag_id'] = tag_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/systems/configurations/snapshots/tags/{tag_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def bulk_create_access(
        self,
        access_relationship: List[AccessRelationship],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[AccessRelationship]:

        """
        This bulk method shares resources with users by granting new access relationships.

        :param access_relationship: (required)
        :type access_relationship: List[AccessRelationship]
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._bulk_create_access_serialize(
            access_relationship=access_relationship,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AccessRelationship]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[AccessRelationship] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.bulk_create_access # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'access_relationship': access_relationship,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _bulk_create_access_serialize(
        self,
        access_relationship,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'AccessRelationship': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if access_relationship is not None:
            _body_params = access_relationship


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/bulk/access',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def copy_revision_to_existing_file(
        self,
        revision_id: Annotated[StrictStr, Field(description="The id of the revision to copy")],
        file_id: Annotated[StrictStr, Field(description="The id of the file to copy the revision to")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> File:

        """
        This method copies a revision to an existing file.

        :param revision_id: The id of the revision to copy (required)
        :type revision_id: str
        :param file_id: The id of the file to copy the revision to (required)
        :type file_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._copy_revision_to_existing_file_serialize(
            revision_id=revision_id,
            file_id=file_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "File",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: File = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.copy_revision_to_existing_file # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'revision_id': revision_id,
                'file_id': file_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _copy_revision_to_existing_file_serialize(
        self,
        revision_id,
        file_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if revision_id is not None:
            _path_params['revision_id'] = revision_id
        if file_id is not None:
            _path_params['file_id'] = file_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/revisions/{revision_id}/copy/file/{file_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def copy_revision_to_new_file(
        self,
        revision_id: Annotated[StrictStr, Field(description="The id of the revision to copy")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> File:

        """
        This method copies a revision to a new file.

        :param revision_id: The id of the revision to copy (required)
        :type revision_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._copy_revision_to_new_file_serialize(
            revision_id=revision_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "File",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: File = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.copy_revision_to_new_file # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'revision_id': revision_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _copy_revision_to_new_file_serialize(
        self,
        revision_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if revision_id is not None:
            _path_params['revision_id'] = revision_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/revisions/{revision_id}/copy/file',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_access(
        self,
        access_relationship: AccessRelationship,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AccessRelationship:

        """
        This method shares a resource or file with a user by updating the resource or file's access.

        :param access_relationship: (required)
        :type access_relationship: AccessRelationship
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_access_serialize(
            access_relationship=access_relationship,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AccessRelationship",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AccessRelationship = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_access # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'access_relationship': access_relationship,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_access_serialize(
        self,
        access_relationship,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if access_relationship is not None:
            _body_params = access_relationship


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/access',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_access_by_email_for_other_tenants(
        self,
        subject_type: Annotated[AccessSubjectType, Field(description="The type of the subject to create.")],
        email: Annotated[StrictStr, Field(description="The email of the subject to create access for.")],
        resource_type: Annotated[AccessResourceType, Field(description="The type of the resource to create access for.")],
        resource_id: Annotated[StrictStr, Field(description="The id of the resource to create access for.")],
        access_relationship: Annotated[AccessRelation, Field(description="The access relationship to create.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AccessRelationship:

        """
        This method shares a resource or file across tenants by the applicable user's email.

        :param subject_type: The type of the subject to create. (required)
        :type subject_type: AccessSubjectType
        :param email: The email of the subject to create access for. (required)
        :type email: str
        :param resource_type: The type of the resource to create access for. (required)
        :type resource_type: AccessResourceType
        :param resource_id: The id of the resource to create access for. (required)
        :type resource_id: str
        :param access_relationship: The access relationship to create. (required)
        :type access_relationship: AccessRelation
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_access_by_email_for_other_tenants_serialize(
            subject_type=subject_type,
            email=email,
            resource_type=resource_type,
            resource_id=resource_id,
            access_relationship=access_relationship,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AccessRelationship",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AccessRelationship = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_access_by_email_for_other_tenants # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'subject_type': subject_type,
                'email': email,
                'resource_type': resource_type,
                'resource_id': resource_id,
                'access_relationship': access_relationship,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_access_by_email_for_other_tenants_serialize(
        self,
        subject_type,
        email,
        resource_type,
        resource_id,
        access_relationship,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if subject_type is not None:
            _path_params['subject_type'] = subject_type.value
        if email is not None:
            _path_params['email'] = email
        if resource_type is not None:
            _path_params['resource_type'] = resource_type.value
        if resource_id is not None:
            _path_params['resource_id'] = resource_id
        # process the query parameters
        if access_relationship is not None:

            _query_params.append(('access_relationship', access_relationship.value))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/access/{subject_type}/{email}/{resource_type}/{resource_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_agent_personal_access_token(
        self,
        name: Annotated[StrictStr, Field(description="The name of the personal access token.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PersonalAccessToken:

        """
        This method creates an agent personal access token.

        :param name: The name of the personal access token. (required)
        :type name: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_agent_personal_access_token_serialize(
            name=name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PersonalAccessToken",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PersonalAccessToken = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_agent_personal_access_token # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'name': name,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_agent_personal_access_token_serialize(
        self,
        name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if name is not None:

            _query_params.append(('name', name))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/pat/agent',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_agent_pool(
        self,
        new_agent_pool: NewAgentPool,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AgentPool:

        """
        This method creates a new agent pool.

        :param new_agent_pool: (required)
        :type new_agent_pool: NewAgentPool
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_agent_pool_serialize(
            new_agent_pool=new_agent_pool,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AgentPool",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AgentPool = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_agent_pool # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'new_agent_pool': new_agent_pool,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_agent_pool_serialize(
        self,
        new_agent_pool,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_agent_pool is not None:
            _body_params = new_agent_pool


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/agent_pools',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_app_integration(
        self,
        new_app_integration: NewAppIntegration,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AppIntegration:

        """
        This method creates a data integration.

        :param new_app_integration: (required)
        :type new_app_integration: NewAppIntegration
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_app_integration_serialize(
            new_app_integration=new_app_integration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AppIntegration",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AppIntegration = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_app_integration # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'new_app_integration': new_app_integration,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_app_integration_serialize(
        self,
        new_app_integration,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_app_integration is not None:
            _body_params = new_app_integration


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/app_integrations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_author(
        self,
        new_module_author: NewModuleAuthor,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> ModuleAuthor:

        """
        This method creates a new author.

        :param new_module_author: (required)
        :type new_module_author: NewModuleAuthor
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_author_serialize(
            new_module_author=new_module_author,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ModuleAuthor",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: ModuleAuthor = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_author # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'new_module_author': new_module_author,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_author_serialize(
        self,
        new_module_author,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_module_author is not None:
            _body_params = new_module_author


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/author',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_configuration(
        self,
        system_id: Annotated[StrictStr, Field(description="The id of the system to create a configuration for.")],
        new_system_configuration: NewSystemConfiguration,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> SystemConfiguration:

        """
        This method creates a new configuration for a system.

        :param system_id: The id of the system to create a configuration for. (required)
        :type system_id: str
        :param new_system_configuration: (required)
        :type new_system_configuration: NewSystemConfiguration
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_configuration_serialize(
            system_id=system_id,
            new_system_configuration=new_system_configuration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SystemConfiguration",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: SystemConfiguration = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_configuration # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'system_id': system_id,
                'new_system_configuration': new_system_configuration,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_configuration_serialize(
        self,
        system_id,
        new_system_configuration,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if system_id is not None:
            _path_params['system_id'] = system_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_system_configuration is not None:
            _body_params = new_system_configuration


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/systems/{system_id}/configurations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_control_tag(
        self,
        new_control_tag: NewControlTag,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> ControlTag:

        """
        This method creates a new control tag.

        :param new_control_tag: (required)
        :type new_control_tag: NewControlTag
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_control_tag_serialize(
            new_control_tag=new_control_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ControlTag",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: ControlTag = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_control_tag # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'new_control_tag': new_control_tag,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_control_tag_serialize(
        self,
        new_control_tag,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_control_tag is not None:
            _body_params = new_control_tag


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/controls/tags',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_document(
        self,
        create_document_request: CreateDocumentRequest,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Document:

        """
        Create a new document.

        :param create_document_request: (required)
        :type create_document_request: CreateDocumentRequest
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_document_serialize(
            create_document_request=create_document_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Document",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Document = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_document # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'create_document_request': create_document_request,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_document_serialize(
        self,
        create_document_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_document_request is not None:
            _body_params = create_document_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/documents',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_module(
        self,
        new_module_manifest: NewModuleManifest,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Module:

        """
        This methods creates a new module.

        :param new_module_manifest: (required)
        :type new_module_manifest: NewModuleManifest
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_module_serialize(
            new_module_manifest=new_module_manifest,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Module",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Module = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_module # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'new_module_manifest': new_module_manifest,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_module_serialize(
        self,
        new_module_manifest,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_module_manifest is not None:
            _body_params = new_module_manifest


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/modules',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_multipart_upload(
        self,
        create_multipart_upload_request: CreateMultipartUploadRequest,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> CreateMultipartUploadResponse:

        """
        Returns the metadata needed to perform a multipart upload for a given token with the SHA

        :param create_multipart_upload_request: (required)
        :type create_multipart_upload_request: CreateMultipartUploadRequest
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_multipart_upload_serialize(
            create_multipart_upload_request=create_multipart_upload_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateMultipartUploadResponse",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: CreateMultipartUploadResponse = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_multipart_upload # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'create_multipart_upload_request': create_multipart_upload_request,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_multipart_upload_serialize(
        self,
        create_multipart_upload_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_multipart_upload_request is not None:
            _body_params = create_multipart_upload_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/tokens/multipart-upload',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_operating_system(
        self,
        new_operating_system: NewOperatingSystem,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> OperatingSystem:

        """
        This method creates a new operating system.

        :param new_operating_system: (required)
        :type new_operating_system: NewOperatingSystem
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_operating_system_serialize(
            new_operating_system=new_operating_system,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OperatingSystem",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: OperatingSystem = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_operating_system # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'new_operating_system': new_operating_system,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_operating_system_serialize(
        self,
        new_operating_system,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_operating_system is not None:
            _body_params = new_operating_system


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/modules/operatingsystems',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_personal_access_token(
        self,
        name: Annotated[StrictStr, Field(description="The name of the personal access token.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PersonalAccessToken:

        """
        This method creates a personal access token.

        :param name: The name of the personal access token. (required)
        :type name: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_personal_access_token_serialize(
            name=name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PersonalAccessToken",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PersonalAccessToken = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_personal_access_token # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'name': name,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_personal_access_token_serialize(
        self,
        name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if name is not None:

            _query_params.append(('name', name))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/pat',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_snapshot(
        self,
        configuration_id: Annotated[StrictStr, Field(description="The id of the configuration to create a snapshot for.")],
        new_snapshot: NewSnapshot,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> ResponseCreateSnapshot:

        """
        This methods creates a new snapshot.

        :param configuration_id: The id of the configuration to create a snapshot for. (required)
        :type configuration_id: str
        :param new_snapshot: (required)
        :type new_snapshot: NewSnapshot
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_snapshot_serialize(
            configuration_id=configuration_id,
            new_snapshot=new_snapshot,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResponseCreateSnapshot",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: ResponseCreateSnapshot = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_snapshot # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'configuration_id': configuration_id,
                'new_snapshot': new_snapshot,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_snapshot_serialize(
        self,
        configuration_id,
        new_snapshot,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if configuration_id is not None:
            _path_params['configuration_id'] = configuration_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_snapshot is not None:
            _body_params = new_snapshot


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/systems/configurations/{configuration_id}/snapshots',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_system(
        self,
        new_system: NewSystem,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> System:

        """
        This method creates a new system.

        :param new_system: (required)
        :type new_system: NewSystem
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_system_serialize(
            new_system=new_system,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "System",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: System = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_system # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'new_system': new_system,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_system_serialize(
        self,
        new_system,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_system is not None:
            _body_params = new_system


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/systems',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_tag(
        self,
        snapshot_id: Annotated[StrictStr, Field(description="The id of the snapshot to create a tag for.")],
        new_snapshot_tag: NewSnapshotTag,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> SnapshotTag:

        """
        This method creates a new snapshot tag.

        :param snapshot_id: The id of the snapshot to create a tag for. (required)
        :type snapshot_id: str
        :param new_snapshot_tag: (required)
        :type new_snapshot_tag: NewSnapshotTag
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_tag_serialize(
            snapshot_id=snapshot_id,
            new_snapshot_tag=new_snapshot_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SnapshotTag",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: SnapshotTag = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_tag # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'snapshot_id': snapshot_id,
                'new_snapshot_tag': new_snapshot_tag,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_tag_serialize(
        self,
        snapshot_id,
        new_snapshot_tag,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if snapshot_id is not None:
            _path_params['snapshot_id'] = snapshot_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_snapshot_tag is not None:
            _body_params = new_snapshot_tag


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/systems/configurations/snapshots/{snapshot_id}/tags',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_tenant_public_key(
        self,
        public_key_file: Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> TenantPublicKey:

        """
        Creates a tenant public key.

        :param public_key_file: (required)
        :type public_key_file: bytearray
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_tenant_public_key_serialize(
            public_key_file=public_key_file,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "TenantPublicKey",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: TenantPublicKey = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_tenant_public_key # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'public_key_file': public_key_file,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_tenant_public_key_serialize(
        self,
        public_key_file,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if public_key_file is not None:
            _files['public_key_file'] = public_key_file
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/tenant/publickey',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_tool(
        self,
        new_tool: NewTool,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Tool:

        """
        This method creates a new tool.

        :param new_tool: (required)
        :type new_tool: NewTool
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_tool_serialize(
            new_tool=new_tool,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Tool",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Tool = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_tool # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'new_tool': new_tool,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_tool_serialize(
        self,
        new_tool,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_tool is not None:
            _body_params = new_tool


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/tools',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def create_tool_versions(
        self,
        tool_id: Annotated[StrictStr, Field(description="The ID of the tool to add a version to.")],
        new_tool_version: NewToolVersion,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> ToolVersion:

        """
        This method creates a new tool version.

        :param tool_id: The ID of the tool to add a version to. (required)
        :type tool_id: str
        :param new_tool_version: (required)
        :type new_tool_version: NewToolVersion
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._create_tool_versions_serialize(
            tool_id=tool_id,
            new_tool_version=new_tool_version,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ToolVersion",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: ToolVersion = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.create_tool_versions # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'tool_id': tool_id,
                'new_tool_version': new_tool_version,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _create_tool_versions_serialize(
        self,
        tool_id,
        new_tool_version,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tool_id is not None:
            _path_params['tool_id'] = tool_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_tool_version is not None:
            _body_params = new_tool_version


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/tools-versions/{tool_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def customer_usage_metrics(
        self,
        start: Annotated[date, Field(description="YYYY-MM-DD")],
        end: Annotated[date, Field(description="YYYY-MM-DD")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> str:

        """
        This method is for customers to query their data for usage metrics.

        :param start: YYYY-MM-DD (required)
        :type start: date
        :param end: YYYY-MM-DD (required)
        :type end: date
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._customer_usage_metrics_serialize(
            start=start,
            end=end,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: str = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.customer_usage_metrics # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'start': start,
                'end': end,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _customer_usage_metrics_serialize(
        self,
        start,
        end,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if start is not None:
            if isinstance(start, date):
                _query_params.append(
                    (
                        'start',
                        start.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('start', start))

        if end is not None:
            if isinstance(end, date):
                _query_params.append(
                    (
                        'end',
                        end.strftime(
                            self.api_client.configuration.date_format
                        )
                    )
                )
            else:
                _query_params.append(('end', end))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/csv',
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/admin/metrics/customer-usage',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def delete_agent_pool(
        self,
        agent_pool_id: Annotated[StrictStr, Field(description="The ID of the agent pool to delete.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AgentPool:

        """
        This method deletes an agent pool.

        :param agent_pool_id: The ID of the agent pool to delete. (required)
        :type agent_pool_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._delete_agent_pool_serialize(
            agent_pool_id=agent_pool_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AgentPool",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AgentPool = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.delete_agent_pool # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_pool_id': agent_pool_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _delete_agent_pool_serialize(
        self,
        agent_pool_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_pool_id is not None:
            _path_params['agent_pool_id'] = agent_pool_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/agent_pools/{agent_pool_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def delete_app_integration(
        self,
        app_integration_id: Annotated[StrictStr, Field(description="ID of the data integration to delete. This is a required field.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AppIntegration:

        """
        This method deletes a data integration by id.

        :param app_integration_id: ID of the data integration to delete. This is a required field. (required)
        :type app_integration_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._delete_app_integration_serialize(
            app_integration_id=app_integration_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AppIntegration",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AppIntegration = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.delete_app_integration # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'app_integration_id': app_integration_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _delete_app_integration_serialize(
        self,
        app_integration_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if app_integration_id is not None:
            _path_params['app_integration_id'] = app_integration_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/app_integrations/{app_integration_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def delete_personal_access_token(
        self,
        pat_id: Annotated[StrictStr, Field(description="The personal access token id.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> object:

        """
        This method deletes a personal access token.

        :param pat_id: The personal access token id. (required)
        :type pat_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._delete_personal_access_token_serialize(
            pat_id=pat_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: object = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.delete_personal_access_token # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'pat_id': pat_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _delete_personal_access_token_serialize(
        self,
        pat_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pat_id is not None:
            _path_params['pat_id'] = pat_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/pat/{pat_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def deprecate_module(
        self,
        module_id: Annotated[StrictStr, Field(description="The id of the module to deprecate")],
        deprecation_reason: DeprecationReason,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Module:

        """
        This method deprecates all versions of a module.

        :param module_id: The id of the module to deprecate (required)
        :type module_id: str
        :param deprecation_reason: (required)
        :type deprecation_reason: DeprecationReason
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._deprecate_module_serialize(
            module_id=module_id,
            deprecation_reason=deprecation_reason,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Module",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Module = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.deprecate_module # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'module_id': module_id,
                'deprecation_reason': deprecation_reason,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _deprecate_module_serialize(
        self,
        module_id,
        deprecation_reason,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if module_id is not None:
            _path_params['module_id'] = module_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if deprecation_reason is not None:
            _body_params = deprecation_reason


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/modules/{module_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def deprecate_module_version(
        self,
        module_version_id: Annotated[StrictStr, Field(description="The id of the module version to deprecate")],
        deprecation_reason: DeprecationReason,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> ModuleVersion:

        """
        This method deprecates a module version.

        :param module_version_id: The id of the module version to deprecate (required)
        :type module_version_id: str
        :param deprecation_reason: (required)
        :type deprecation_reason: DeprecationReason
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._deprecate_module_version_serialize(
            module_version_id=module_version_id,
            deprecation_reason=deprecation_reason,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ModuleVersion",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: ModuleVersion = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.deprecate_module_version # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'module_version_id': module_version_id,
                'deprecation_reason': deprecation_reason,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _deprecate_module_version_serialize(
        self,
        module_version_id,
        deprecation_reason,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if module_version_id is not None:
            _path_params['module_version_id'] = module_version_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if deprecation_reason is not None:
            _body_params = deprecation_reason


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/modules/versions/{module_version_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def export_document(
        self,
        document_id: Annotated[StrictStr, Field(description="The id of the document to export.")],
        output_format: Annotated[Optional[StrictStr], Field(description="The output format (json, markdown, docx, pdf).")] = None,
        snapshot_id: Annotated[Optional[StrictStr], Field(description="Optional snapshot ID for point-in-time export. Resolves resource links using snapshot context.")] = None,
        revision_id: Annotated[Optional[StrictStr], Field(description="Optional revision ID to export a specific version of the document. Resource links resolve to current versions. If both revision_id and snapshot_id are provided, snapshot_id takes precedence and revision_id is ignored.")] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> object:

        """
        Export a document to a specific format.

        :param document_id: The id of the document to export. (required)
        :type document_id: str
        :param output_format: The output format (json, markdown, docx, pdf).
        :type output_format: str
        :param snapshot_id: Optional snapshot ID for point-in-time export. Resolves resource links using snapshot context.
        :type snapshot_id: str
        :param revision_id: Optional revision ID to export a specific version of the document. Resource links resolve to current versions. If both revision_id and snapshot_id are provided, snapshot_id takes precedence and revision_id is ignored.
        :type revision_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._export_document_serialize(
            document_id=document_id,
            output_format=output_format,
            snapshot_id=snapshot_id,
            revision_id=revision_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: object = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.export_document # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'document_id': document_id,
                'output_format': output_format,
                'snapshot_id': snapshot_id,
                'revision_id': revision_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _export_document_serialize(
        self,
        document_id,
        output_format,
        snapshot_id,
        revision_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if document_id is not None:
            _path_params['document_id'] = document_id
        # process the query parameters
        if output_format is not None:

            _query_params.append(('output_format', output_format))

        if snapshot_id is not None:

            _query_params.append(('snapshot_id', snapshot_id))

        if revision_id is not None:

            _query_params.append(('revision_id', revision_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/documents/{document_id}:export',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def fetch_function_auth_secret(
        self,
        auth_secret_id: Annotated[StrictStr, Field(description="The function auth secret ID to get.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> FunctionAuthSecret:

        """
        This method gets a function auth secret by id.

        :param auth_secret_id: The function auth secret ID to get. (required)
        :type auth_secret_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._fetch_function_auth_secret_serialize(
            auth_secret_id=auth_secret_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FunctionAuthSecret",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: FunctionAuthSecret = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.fetch_function_auth_secret # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'auth_secret_id': auth_secret_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _fetch_function_auth_secret_serialize(
        self,
        auth_secret_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if auth_secret_id is not None:
            _path_params['auth_secret_id'] = auth_secret_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/app_integrations/authsecrets/{auth_secret_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def finalize_multipart_upload(
        self,
        finalize_multipart_upload_request: FinalizeMultipartUploadRequest,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> object:

        """
        Finalize a multipart upload for a given token with the SHA

        :param finalize_multipart_upload_request: (required)
        :type finalize_multipart_upload_request: FinalizeMultipartUploadRequest
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._finalize_multipart_upload_serialize(
            finalize_multipart_upload_request=finalize_multipart_upload_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: object = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.finalize_multipart_upload # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'finalize_multipart_upload_request': finalize_multipart_upload_request,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _finalize_multipart_upload_serialize(
        self,
        finalize_multipart_upload_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if finalize_multipart_upload_request is not None:
            _body_params = finalize_multipart_upload_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/tokens/multipart-upload',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def find_function_auth_secret(
        self,
        app_integration_id: Optional[StrictStr] = None,
        auth_integration_type: Optional[AuthIntegrationType] = None,
        function_auth_type: Optional[FunctionAuthType] = None,
        expiration: Optional[datetime] = None,
        latest: Optional[StrictBool] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[FunctionAuthSecret]:

        """
        This method lists all function auth secrets that a user has access to.

        :param app_integration_id:
        :type app_integration_id: str
        :param auth_integration_type:
        :type auth_integration_type: AuthIntegrationType
        :param function_auth_type:
        :type function_auth_type: FunctionAuthType
        :param expiration:
        :type expiration: datetime
        :param latest:
        :type latest: bool
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._find_function_auth_secret_serialize(
            app_integration_id=app_integration_id,
            auth_integration_type=auth_integration_type,
            function_auth_type=function_auth_type,
            expiration=expiration,
            latest=latest,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[FunctionAuthSecret]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[FunctionAuthSecret] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.find_function_auth_secret # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'app_integration_id': app_integration_id,
                'auth_integration_type': auth_integration_type,
                'function_auth_type': function_auth_type,
                'expiration': expiration,
                'latest': latest,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _find_function_auth_secret_serialize(
        self,
        app_integration_id,
        auth_integration_type,
        function_auth_type,
        expiration,
        latest,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if app_integration_id is not None:

            _query_params.append(('app_integration_id', app_integration_id))

        if auth_integration_type is not None:

            _query_params.append(('auth_integration_type', auth_integration_type.value))

        if function_auth_type is not None:

            _query_params.append(('function_auth_type', function_auth_type.value))

        if expiration is not None:
            if isinstance(expiration, datetime):
                _query_params.append(
                    (
                        'expiration',
                        expiration.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('expiration', expiration))

        if latest is not None:

            _query_params.append(('latest', latest))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/app_integrations/authsecrets',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def generate_download_url(
        self,
        sha: StrictStr,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> TemporaryURL:

        """
        Returns a temporary download url for tokenized resource with SHA value

        :param sha: (required)
        :type sha: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._generate_download_url_serialize(
            sha=sha,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TemporaryURL",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: TemporaryURL = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.generate_download_url # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'sha': sha,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _generate_download_url_serialize(
        self,
        sha,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if sha is not None:
            _path_params['sha'] = sha
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/tokens/{sha}/download-url',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def generate_upload_url(
        self,
        sha: StrictStr,
        model_id: Optional[StrictStr] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> TemporaryURL:

        """
        Returns a temporary upload url for token with sha

        :param sha: (required)
        :type sha: str
        :param model_id:
        :type model_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._generate_upload_url_serialize(
            sha=sha,
            model_id=model_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TemporaryURL",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: TemporaryURL = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.generate_upload_url # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'sha': sha,
                'model_id': model_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _generate_upload_url_serialize(
        self,
        sha,
        model_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if sha is not None:
            _path_params['sha'] = sha
        # process the query parameters
        if model_id is not None:

            _query_params.append(('model_id', model_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/tokens/{sha}/upload-url',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_agent(
        self,
        agent_id: Annotated[StrictStr, Field(description="The ID of the agent to get.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Agent:

        """
        This method gets an agent by id.

        :param agent_id: The ID of the agent to get. (required)
        :type agent_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_agent_serialize(
            agent_id=agent_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Agent",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Agent = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_agent # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_id': agent_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_agent_serialize(
        self,
        agent_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_id is not None:
            _path_params['agent_id'] = agent_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/agents/{agent_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_agent_available_jobs(
        self,
        agent_id: Annotated[StrictStr, Field(description="The identifier for the agent")],
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageJob:

        """
        This method gets the list of available jobs for an agent.

        :param agent_id: The identifier for the agent (required)
        :type agent_id: str
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_agent_available_jobs_serialize(
            agent_id=agent_id,
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageJob",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageJob = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_agent_available_jobs # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_id': agent_id,
                'page': page,
                'size': size,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_agent_available_jobs_serialize(
        self,
        agent_id,
        page,
        size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_id is not None:
            _path_params['agent_id'] = agent_id
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/agents/{agent_id}/available_jobs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_agent_display_name(
        self,
        agent_id: Annotated[StrictStr, Field(description="The ID of the agent to get.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AgentDisplayName:

        """
        This method gets an agent's display name.

        :param agent_id: The ID of the agent to get. (required)
        :type agent_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_agent_display_name_serialize(
            agent_id=agent_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AgentDisplayName",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AgentDisplayName = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_agent_display_name # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_id': agent_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_agent_display_name_serialize(
        self,
        agent_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_id is not None:
            _path_params['agent_id'] = agent_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/agents/{agent_id}/display_name',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_agent_modules(
        self,
        agent_id: Annotated[StrictStr, Field(description="The ID of the agent to get.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AgentModules:

        """
        This method gets an agent's loaded modules.

        :param agent_id: The ID of the agent to get. (required)
        :type agent_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_agent_modules_serialize(
            agent_id=agent_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AgentModules",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AgentModules = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_agent_modules # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_id': agent_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_agent_modules_serialize(
        self,
        agent_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_id is not None:
            _path_params['agent_id'] = agent_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/agents/{agent_id}/modules',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_agent_pool(
        self,
        agent_pool_id: Annotated[StrictStr, Field(description="The ID of the agent pool to get.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AgentPool:

        """
        This method gets an agent pool by id.

        :param agent_pool_id: The ID of the agent pool to get. (required)
        :type agent_pool_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_agent_pool_serialize(
            agent_pool_id=agent_pool_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AgentPool",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AgentPool = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_agent_pool # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_pool_id': agent_pool_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_agent_pool_serialize(
        self,
        agent_pool_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_pool_id is not None:
            _path_params['agent_pool_id'] = agent_pool_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/agent_pools/{agent_pool_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_agent_status(
        self,
        agent_id: Annotated[StrictStr, Field(description="The ID of the agent to get.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AgentStatus:

        """
        This method gets an agent's status.

        :param agent_id: The ID of the agent to get. (required)
        :type agent_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_agent_status_serialize(
            agent_id=agent_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AgentStatus",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AgentStatus = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_agent_status # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_id': agent_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_agent_status_serialize(
        self,
        agent_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_id is not None:
            _path_params['agent_id'] = agent_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/agents/{agent_id}/status',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_agent_status_retention_policy(
        self,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AgentStatusRetentionDuration:

        """
        This method gets status retention policy duration in the registry for all agents

        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_agent_status_retention_policy_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AgentStatusRetentionDuration",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AgentStatusRetentionDuration = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_agent_status_retention_policy # type: ignore[assignment]
            list_args: Dict[str, Any] = {
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_agent_status_retention_policy_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/agents/status/retention_policy',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_app_integration(
        self,
        app_integration_id: Annotated[StrictStr, Field(description="ID of the data integration to get. This is a required field.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AppIntegration:

        """
        This method gets data integration info by id.

        :param app_integration_id: ID of the data integration to get. This is a required field. (required)
        :type app_integration_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_app_integration_serialize(
            app_integration_id=app_integration_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AppIntegration",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AppIntegration = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_app_integration # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'app_integration_id': app_integration_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_app_integration_serialize(
        self,
        app_integration_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if app_integration_id is not None:
            _path_params['app_integration_id'] = app_integration_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/app_integrations/{app_integration_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_artifact(
        self,
        artifact_id: Annotated[StrictStr, Field(description="The id of the artifact to get. This is a required field.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Artifact:

        """
        This method gets an artifact from the database.

        :param artifact_id: The id of the artifact to get. This is a required field. (required)
        :type artifact_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_artifact_serialize(
            artifact_id=artifact_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Artifact",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Artifact = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_artifact # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'artifact_id': artifact_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_artifact_serialize(
        self,
        artifact_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if artifact_id is not None:
            _path_params['artifact_id'] = artifact_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/artifacts/{artifact_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_artifact_control_tagging_history(
        self,
        artifact_id: Annotated[StrictStr, Field(description="The ID of the artifact to get. This is a required field.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[ResourceControlTagging]:

        """
        This method gets the full history of control taggings added to and removed from an artifact.

        :param artifact_id: The ID of the artifact to get. This is a required field. (required)
        :type artifact_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_artifact_control_tagging_history_serialize(
            artifact_id=artifact_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ResourceControlTagging]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[ResourceControlTagging] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_artifact_control_tagging_history # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'artifact_id': artifact_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_artifact_control_tagging_history_serialize(
        self,
        artifact_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if artifact_id is not None:
            _path_params['artifact_id'] = artifact_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/controls/taggings/artifact/{artifact_id}/history',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_artifact_control_taggings(
        self,
        artifact_id: Annotated[StrictStr, Field(description="The ID of the artifact to get. This is a required field.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[ResourceControlTagging]:

        """
        This method gets a artifact's active control taggings.

        :param artifact_id: The ID of the artifact to get. This is a required field. (required)
        :type artifact_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_artifact_control_taggings_serialize(
            artifact_id=artifact_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ResourceControlTagging]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[ResourceControlTagging] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_artifact_control_taggings # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'artifact_id': artifact_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_artifact_control_taggings_serialize(
        self,
        artifact_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if artifact_id is not None:
            _path_params['artifact_id'] = artifact_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/controls/taggings/artifact/{artifact_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_auth_integration(
        self,
        auth_integration_id: Annotated[StrictStr, Field(description="The unique name of the AuthIntegration to update")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AuthIntegration:

        """
        This method retrieves an AuthIntegration.

        :param auth_integration_id: The unique name of the AuthIntegration to update (required)
        :type auth_integration_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_auth_integration_serialize(
            auth_integration_id=auth_integration_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AuthIntegration",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AuthIntegration = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_auth_integration # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'auth_integration_id': auth_integration_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_auth_integration_serialize(
        self,
        auth_integration_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if auth_integration_id is not None:
            _path_params['auth_integration_id'] = auth_integration_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/app_integrations/authintegrations/{auth_integration_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_author(
        self,
        author_id: Annotated[StrictStr, Field(description="The author ID to get.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> ModuleAuthor:

        """
        This method gets an author by id.

        :param author_id: The author ID to get. (required)
        :type author_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_author_serialize(
            author_id=author_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ModuleAuthor",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: ModuleAuthor = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_author # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'author_id': author_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_author_serialize(
        self,
        author_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if author_id is not None:
            _path_params['author_id'] = author_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/author/{author_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_comment(
        self,
        comment_id: Annotated[StrictStr, Field(description="The ID of the comment to retrieve.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Comment:

        """
        This method gets a comment by id

        :param comment_id: The ID of the comment to retrieve. (required)
        :type comment_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_comment_serialize(
            comment_id=comment_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Comment",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Comment = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_comment # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'comment_id': comment_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_comment_serialize(
        self,
        comment_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if comment_id is not None:
            _path_params['comment_id'] = comment_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/comments/{comment_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_configuration(
        self,
        configuration_id: Annotated[StrictStr, Field(description="The id of the configuration to get.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> SystemConfiguration:

        """
        This method gets a configuration by id.

        :param configuration_id: The id of the configuration to get. (required)
        :type configuration_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_configuration_serialize(
            configuration_id=configuration_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SystemConfiguration",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: SystemConfiguration = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_configuration # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'configuration_id': configuration_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_configuration_serialize(
        self,
        configuration_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if configuration_id is not None:
            _path_params['configuration_id'] = configuration_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/systems/configurations/{configuration_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_control_tag(
        self,
        control_tag_id: Annotated[StrictStr, Field(description="The ID of the control tag to get. This is a required field.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> ControlTag:

        """
        This method gets a control tag by id.

        :param control_tag_id: The ID of the control tag to get. This is a required field. (required)
        :type control_tag_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_control_tag_serialize(
            control_tag_id=control_tag_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ControlTag",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: ControlTag = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_control_tag # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'control_tag_id': control_tag_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_control_tag_serialize(
        self,
        control_tag_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if control_tag_id is not None:
            _path_params['control_tag_id'] = control_tag_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/controls/tags/{control_tag_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_control_tag_revision_history(
        self,
        control_tag_id: StrictStr,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[ControlTagRevision]:

        """
        Control tag revision history.

        :param control_tag_id: (required)
        :type control_tag_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_control_tag_revision_history_serialize(
            control_tag_id=control_tag_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ControlTagRevision]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[ControlTagRevision] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_control_tag_revision_history # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'control_tag_id': control_tag_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_control_tag_revision_history_serialize(
        self,
        control_tag_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if control_tag_id is not None:
            _path_params['control_tag_id'] = control_tag_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/controls/tags/{control_tag_id}/revisions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_current_user(
        self,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> User:

        """
        This method gets the current user.

        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_current_user_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "User",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: User = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_current_user # type: ignore[assignment]
            list_args: Dict[str, Any] = {
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_current_user_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/users/me',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_document(
        self,
        document_id: Annotated[StrictStr, Field(description="The document ID to get. This is a required field.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Document:

        """
        This method gets a document by id.

        :param document_id: The document ID to get. This is a required field. (required)
        :type document_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_document_serialize(
            document_id=document_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Document",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Document = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_document # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'document_id': document_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_document_serialize(
        self,
        document_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if document_id is not None:
            _path_params['document_id'] = document_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/documents/{document_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_document_by_revision_id(
        self,
        revision_id: Annotated[StrictStr, Field(description="The file revision ID to retrieve the document at.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Document:

        """
        Get a document by revision ID.

        :param revision_id: The file revision ID to retrieve the document at. (required)
        :type revision_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_document_by_revision_id_serialize(
            revision_id=revision_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Document",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Document = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_document_by_revision_id # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'revision_id': revision_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_document_by_revision_id_serialize(
        self,
        revision_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if revision_id is not None:
            _path_params['revision_id'] = revision_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/documents/revisions/{revision_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_file(
        self,
        file_id: Annotated[StrictStr, Field(description="The id of the file to get.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> File:

        """
        This method gets a file by id.

        :param file_id: The id of the file to get. (required)
        :type file_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_file_serialize(
            file_id=file_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "File",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: File = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_file # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'file_id': file_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_file_serialize(
        self,
        file_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['file_id'] = file_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/files/{file_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_file_by_revision_id(
        self,
        revision_id: Annotated[StrictStr, Field(description="The revision id of the file to get.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> File:

        """
        This method gets a file by revision id.

        :param revision_id: The revision id of the file to get. (required)
        :type revision_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_file_by_revision_id_serialize(
            revision_id=revision_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "File",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: File = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_file_by_revision_id # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'revision_id': revision_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_file_by_revision_id_serialize(
        self,
        revision_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if revision_id is not None:
            _path_params['revision_id'] = revision_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/files/revisions/{revision_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_file_control_tagging_history(
        self,
        file_id: Annotated[StrictStr, Field(description="The ID of the file to get. This is a required field.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[FileControlTagging]:

        """
        This method gets the full history of control taggings added to and removed from a file.

        :param file_id: The ID of the file to get. This is a required field. (required)
        :type file_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_file_control_tagging_history_serialize(
            file_id=file_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[FileControlTagging]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[FileControlTagging] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_file_control_tagging_history # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'file_id': file_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_file_control_tagging_history_serialize(
        self,
        file_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['file_id'] = file_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/controls/taggings/file/{file_id}/history',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_file_control_taggings(
        self,
        file_id: Annotated[StrictStr, Field(description="The ID of the file to get. This is a required field.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[FileControlTagging]:

        """
        This method gets a file's active control taggings.

        :param file_id: The ID of the file to get. This is a required field. (required)
        :type file_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_file_control_taggings_serialize(
            file_id=file_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[FileControlTagging]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[FileControlTagging] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_file_control_taggings # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'file_id': file_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_file_control_taggings_serialize(
        self,
        file_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['file_id'] = file_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/controls/taggings/file/{file_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_function(
        self,
        function_id: Annotated[StrictStr, Field(description="ID of the function to get")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> FunctionVersion:

        """
        This method gets a function by id.

        :param function_id: ID of the function to get (required)
        :type function_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_function_serialize(
            function_id=function_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FunctionVersion",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: FunctionVersion = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_function # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'function_id': function_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_function_serialize(
        self,
        function_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if function_id is not None:
            _path_params['function_id'] = function_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/modules/versions/functions/{function_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_function_schema(
        self,
        function_schema_id: Annotated[StrictStr, Field(description="ID of the function schema to get")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> FunctionSchema:

        """
        This method gets a function schema by id.

        :param function_schema_id: ID of the function schema to get (required)
        :type function_schema_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_function_schema_serialize(
            function_schema_id=function_schema_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FunctionSchema",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: FunctionSchema = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_function_schema # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'function_schema_id': function_schema_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_function_schema_serialize(
        self,
        function_schema_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if function_schema_id is not None:
            _path_params['function_schema_id'] = function_schema_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/modules/versions/function_schemas/{function_schema_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_job(
        self,
        job_id: Annotated[StrictStr, Field(description="The id of the job to get.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Job:

        """
        This method gets a job by id.

        :param job_id: The id of the job to get. (required)
        :type job_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_job_serialize(
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Job = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_job # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'job_id': job_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_job_serialize(
        self,
        job_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['job_id'] = job_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/jobs/{job_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_model(
        self,
        model_id: Annotated[StrictStr, Field(description="The model ID to get. This is a required field.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Model:

        """
        This method gets a model by id.

        :param model_id: The model ID to get. This is a required field. (required)
        :type model_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_model_serialize(
            model_id=model_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Model",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Model = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_model # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'model_id': model_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_model_serialize(
        self,
        model_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if model_id is not None:
            _path_params['model_id'] = model_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/models/{model_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_model_control_tagging_history(
        self,
        model_id: Annotated[StrictStr, Field(description="The ID of the model to get. This is a required field.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[ResourceControlTagging]:

        """
        This method gets the full history of control taggings added to and removed from a model.

        :param model_id: The ID of the model to get. This is a required field. (required)
        :type model_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_model_control_tagging_history_serialize(
            model_id=model_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ResourceControlTagging]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[ResourceControlTagging] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_model_control_tagging_history # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'model_id': model_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_model_control_tagging_history_serialize(
        self,
        model_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if model_id is not None:
            _path_params['model_id'] = model_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/controls/taggings/model/{model_id}/history',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_model_control_taggings(
        self,
        model_id: Annotated[StrictStr, Field(description="The ID of the model to get. This is a required field.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[ResourceControlTagging]:

        """
        This method gets a model's active control taggings.

        :param model_id: The ID of the model to get. This is a required field. (required)
        :type model_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_model_control_taggings_serialize(
            model_id=model_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ResourceControlTagging]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[ResourceControlTagging] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_model_control_taggings # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'model_id': model_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_model_control_taggings_serialize(
        self,
        model_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if model_id is not None:
            _path_params['model_id'] = model_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/controls/taggings/model/{model_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_module(
        self,
        module_id: Annotated[StrictStr, Field(description="The id of the module to get")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Module:

        """
        This method gets a module by id

        :param module_id: The id of the module to get (required)
        :type module_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_module_serialize(
            module_id=module_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Module",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Module = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_module # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'module_id': module_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_module_serialize(
        self,
        module_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if module_id is not None:
            _path_params['module_id'] = module_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/modules/{module_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_module_version(
        self,
        module_version_id: Annotated[StrictStr, Field(description="The id of the module version to get")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> ModuleVersion:

        """
        This method gets a module version by id.

        :param module_version_id: The id of the module version to get (required)
        :type module_version_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_module_version_serialize(
            module_version_id=module_version_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ModuleVersion",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: ModuleVersion = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_module_version # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'module_version_id': module_version_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_module_version_serialize(
        self,
        module_version_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if module_version_id is not None:
            _path_params['module_version_id'] = module_version_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/modules/versions/{module_version_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_object_control_tags(
        self,
        object_type: Annotated[ControlTaggingObjectType, Field(description="Type of object to get control tags for. This is a required field.")],
        object_id: Annotated[StrictStr, Field(description="ID of the object to get control tags for. This is a required field.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[ControlTag]:

        """
        Get the active control tag assignments for an object

        :param object_type: Type of object to get control tags for. This is a required field. (required)
        :type object_type: ControlTaggingObjectType
        :param object_id: ID of the object to get control tags for. This is a required field. (required)
        :type object_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_object_control_tags_serialize(
            object_type=object_type,
            object_id=object_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ControlTag]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[ControlTag] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_object_control_tags # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'object_type': object_type,
                'object_id': object_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_object_control_tags_serialize(
        self,
        object_type,
        object_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if object_type is not None:
            _path_params['object_type'] = object_type.value
        if object_id is not None:
            _path_params['object_id'] = object_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/controls/tags/object/{object_type}/{object_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_operating_system(
        self,
        operating_system_id: Annotated[StrictStr, Field(description="The operating system ID to get.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> OperatingSystem:

        """
        This method gets an operating system by id.

        :param operating_system_id: The operating system ID to get. (required)
        :type operating_system_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_operating_system_serialize(
            operating_system_id=operating_system_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OperatingSystem",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: OperatingSystem = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_operating_system # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'operating_system_id': operating_system_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_operating_system_serialize(
        self,
        operating_system_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if operating_system_id is not None:
            _path_params['operating_system_id'] = operating_system_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/modules/operatingsystems/{operating_system_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_revision(
        self,
        revision_id: Annotated[StrictStr, Field(description="The id of the revision to get")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> FileRevision:

        """
        This method gets a revision by id.

        :param revision_id: The id of the revision to get (required)
        :type revision_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_revision_serialize(
            revision_id=revision_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FileRevision",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: FileRevision = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_revision # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'revision_id': revision_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_revision_serialize(
        self,
        revision_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if revision_id is not None:
            _path_params['revision_id'] = revision_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/revisions/{revision_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_snapshot(
        self,
        snapshot_id: Annotated[StrictStr, Field(description="The id of the snapshot to get.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Snapshot:

        """
        This method gets a snapshot by id.

        :param snapshot_id: The id of the snapshot to get. (required)
        :type snapshot_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_snapshot_serialize(
            snapshot_id=snapshot_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Snapshot",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Snapshot = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_snapshot # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'snapshot_id': snapshot_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_snapshot_serialize(
        self,
        snapshot_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if snapshot_id is not None:
            _path_params['snapshot_id'] = snapshot_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/systems/configurations/snapshots/{snapshot_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_system(
        self,
        system_id: Annotated[StrictStr, Field(description="The id of the system to get.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> System:

        """
        This method gets a system by id.

        :param system_id: The id of the system to get. (required)
        :type system_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_system_serialize(
            system_id=system_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "System",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: System = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_system # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'system_id': system_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_system_serialize(
        self,
        system_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if system_id is not None:
            _path_params['system_id'] = system_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/systems/{system_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_system_baseline(
        self,
        system_id: Annotated[StrictStr, Field(description="The id of the system to get the baseline for.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> SystemBaseline:

        """
        This method gets the system baseline by system id.

        :param system_id: The id of the system to get the baseline for. (required)
        :type system_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_system_baseline_serialize(
            system_id=system_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SystemBaseline",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: SystemBaseline = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_system_baseline # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'system_id': system_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_system_baseline_serialize(
        self,
        system_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if system_id is not None:
            _path_params['system_id'] = system_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/systems/{system_id}/baseline',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_tag(
        self,
        tag_id: Annotated[StrictStr, Field(description="The id of the tag to get.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> SnapshotTag:

        """
        This method gets a snapshot tag by id.

        :param tag_id: The id of the tag to get. (required)
        :type tag_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_tag_serialize(
            tag_id=tag_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SnapshotTag",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: SnapshotTag = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_tag # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'tag_id': tag_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_tag_serialize(
        self,
        tag_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tag_id is not None:
            _path_params['tag_id'] = tag_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/systems/configurations/snapshots/tags/{tag_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_tenant_public_key(
        self,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> TenantPublicKey:

        """
        Gets a tenant public key.

        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_tenant_public_key_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TenantPublicKey",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: TenantPublicKey = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_tenant_public_key # type: ignore[assignment]
            list_args: Dict[str, Any] = {
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_tenant_public_key_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/tenant/publickey',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_tool(
        self,
        tool_id: Annotated[StrictStr, Field(description="The ID of the tool to get.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Tool:

        """
        This method gets a tool by id

        :param tool_id: The ID of the tool to get. (required)
        :type tool_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_tool_serialize(
            tool_id=tool_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Tool",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Tool = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_tool # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'tool_id': tool_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_tool_serialize(
        self,
        tool_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tool_id is not None:
            _path_params['tool_id'] = tool_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/tools/{tool_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_tool_version(
        self,
        tool_version_id: Annotated[StrictStr, Field(description="The tool version ID to get")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> ToolVersion:

        """
        This method gets a tool version by id.

        :param tool_version_id: The tool version ID to get (required)
        :type tool_version_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_tool_version_serialize(
            tool_version_id=tool_version_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ToolVersion",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: ToolVersion = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_tool_version # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'tool_version_id': tool_version_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_tool_version_serialize(
        self,
        tool_version_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tool_version_id is not None:
            _path_params['tool_version_id'] = tool_version_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/tools-versions/{tool_version_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_upstream_remote_sync(
        self,
        upstream_remote_sync_id: StrictStr,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> UpstreamRemoteSync:

        """
        This method retrieves the status of an upstream remote sync.

        :param upstream_remote_sync_id: (required)
        :type upstream_remote_sync_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_upstream_remote_sync_serialize(
            upstream_remote_sync_id=upstream_remote_sync_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpstreamRemoteSync",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: UpstreamRemoteSync = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_upstream_remote_sync # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'upstream_remote_sync_id': upstream_remote_sync_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_upstream_remote_sync_serialize(
        self,
        upstream_remote_sync_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if upstream_remote_sync_id is not None:
            _path_params['upstream_remote_sync_id'] = upstream_remote_sync_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/upstream-remotes/sync/{upstream_remote_sync_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_user_by_id(
        self,
        user_id: Annotated[StrictStr, Field(description="The id of the user.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> User:

        """
        This method gets a user by id.

        :param user_id: The id of the user. (required)
        :type user_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_user_by_id_serialize(
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "User",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: User = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_user_by_id # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'user_id': user_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_user_by_id_serialize(
        self,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/users/{user_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_user_control_tagging_history(
        self,
        user_id: Annotated[StrictStr, Field(description="The ID of the user to get. This is a required field.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[UserControlTagging]:

        """
        This method gets the full history of control taggings added to and removed from a user.

        :param user_id: The ID of the user to get. This is a required field. (required)
        :type user_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_user_control_tagging_history_serialize(
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[UserControlTagging]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[UserControlTagging] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_user_control_tagging_history # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'user_id': user_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_user_control_tagging_history_serialize(
        self,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/controls/taggings/user/{user_id}/history',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def get_user_control_taggings(
        self,
        user_id: Annotated[StrictStr, Field(description="The ID of the user to get. This is a required field.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[UserControlTagging]:

        """
        This method gets a user's active control taggings.

        :param user_id: The ID of the user to get. This is a required field. (required)
        :type user_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._get_user_control_taggings_serialize(
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[UserControlTagging]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[UserControlTagging] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.get_user_control_taggings # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'user_id': user_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _get_user_control_taggings_serialize(
        self,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/controls/taggings/user/{user_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_access(
        self,
        resource_type: Annotated[AccessResourceType, Field(description="The type of the resource.")],
        resource_id: Annotated[StrictStr, Field(description="The id of the resource.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[AccessRelationship]:

        """
        This method lists access for a resource or file.

        :param resource_type: The type of the resource. (required)
        :type resource_type: AccessResourceType
        :param resource_id: The id of the resource. (required)
        :type resource_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_access_serialize(
            resource_type=resource_type,
            resource_id=resource_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AccessRelationship]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[AccessRelationship] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_access # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'resource_type': resource_type,
                'resource_id': resource_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_access_serialize(
        self,
        resource_type,
        resource_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if resource_type is not None:
            _path_params['resource_type'] = resource_type.value
        if resource_id is not None:
            _path_params['resource_id'] = resource_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/access/{resource_type}/{resource_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_agent_pool_agents(
        self,
        agent_pool_id: Annotated[StrictStr, Field(description="The id of the agent pool to list agents for")],
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageAgentPoolAgentMembershipWithAgent:

        """
        This method lists agent memberships in detail for an agent pool.

        :param agent_pool_id: The id of the agent pool to list agents for (required)
        :type agent_pool_id: str
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_agent_pool_agents_serialize(
            agent_pool_id=agent_pool_id,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageAgentPoolAgentMembershipWithAgent",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageAgentPoolAgentMembershipWithAgent = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_agent_pool_agents # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_pool_id': agent_pool_id,
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_agent_pool_agents_serialize(
        self,
        agent_pool_id,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_pool_id is not None:
            _path_params['agent_pool_id'] = agent_pool_id
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/agent_pools/{agent_pool_id}/agents',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_agent_pool_users(
        self,
        agent_pool_id: Annotated[StrictStr, Field(description="The id of the agent pool to list users for")],
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageAgentPoolUserMembershipWithUser:

        """
        This method lists user memberships in detail for an agent pool.

        :param agent_pool_id: The id of the agent pool to list users for (required)
        :type agent_pool_id: str
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_agent_pool_users_serialize(
            agent_pool_id=agent_pool_id,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageAgentPoolUserMembershipWithUser",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageAgentPoolUserMembershipWithUser = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_agent_pool_users # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_pool_id': agent_pool_id,
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_agent_pool_users_serialize(
        self,
        agent_pool_id,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_pool_id is not None:
            _path_params['agent_pool_id'] = agent_pool_id
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/agent_pools/{agent_pool_id}/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_agent_pools(
        self,
        all_users: Annotated[Optional[StrictBool], Field(description="Show agent pools owned by all users (requires admin privileges)")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageAgentPool:

        """
        This method lists all agent pools a user has access to.

        :param all_users: Show agent pools owned by all users (requires admin privileges)
        :type all_users: bool
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_agent_pools_serialize(
            all_users=all_users,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageAgentPool",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageAgentPool = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_agent_pools # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'all_users': all_users,
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_agent_pools_serialize(
        self,
        all_users,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if all_users is not None:

            _query_params.append(('all_users', all_users))

        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/agent_pools',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_agent_status_history(
        self,
        agent_id: Annotated[StrictStr, Field(description="The ID of the agent to get.")],
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageAgentStatus:

        """
        This method lists an agent's status history.

        :param agent_id: The ID of the agent to get. (required)
        :type agent_id: str
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_agent_status_history_serialize(
            agent_id=agent_id,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageAgentStatus",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageAgentStatus = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_agent_status_history # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_id': agent_id,
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_agent_status_history_serialize(
        self,
        agent_id,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_id is not None:
            _path_params['agent_id'] = agent_id
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/agents/{agent_id}/status/history',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_agents(
        self,
        agent_version: Annotated[Optional[StrictStr], Field(description="Filter by the agent version")] = None,
        host_os: Annotated[Optional[StrictStr], Field(description="Filter by the host OS")] = None,
        updated_since: Annotated[Optional[datetime], Field(description="Filter by last update time of agent")] = None,
        module_name: Annotated[Optional[StrictStr], Field(description="Filter by name of module loaded on the agent")] = None,
        module_version: Annotated[Optional[StrictStr], Field(description="Filter by version of module loaded on the agent")] = None,
        status_name: Annotated[Optional[AgentStatusName], Field(description="Filter by the agent status name")] = None,
        tenant_id: Annotated[Optional[StrictStr], Field(description="Filter by tenant ID")] = None,
        all_tenants: Annotated[Optional[StrictBool], Field(description="Show agents across all tenants (customer admin only)")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageAgent:

        """
        This method lists all agents a user has access to.

        :param agent_version: Filter by the agent version
        :type agent_version: str
        :param host_os: Filter by the host OS
        :type host_os: str
        :param updated_since: Filter by last update time of agent
        :type updated_since: datetime
        :param module_name: Filter by name of module loaded on the agent
        :type module_name: str
        :param module_version: Filter by version of module loaded on the agent
        :type module_version: str
        :param status_name: Filter by the agent status name
        :type status_name: AgentStatusName
        :param tenant_id: Filter by tenant ID
        :type tenant_id: str
        :param all_tenants: Show agents across all tenants (customer admin only)
        :type all_tenants: bool
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_agents_serialize(
            agent_version=agent_version,
            host_os=host_os,
            updated_since=updated_since,
            module_name=module_name,
            module_version=module_version,
            status_name=status_name,
            tenant_id=tenant_id,
            all_tenants=all_tenants,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageAgent",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageAgent = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_agents # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_version': agent_version,
                'host_os': host_os,
                'updated_since': updated_since,
                'module_name': module_name,
                'module_version': module_version,
                'status_name': status_name,
                'tenant_id': tenant_id,
                'all_tenants': all_tenants,
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_agents_serialize(
        self,
        agent_version,
        host_os,
        updated_since,
        module_name,
        module_version,
        status_name,
        tenant_id,
        all_tenants,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if agent_version is not None:

            _query_params.append(('agent_version', agent_version))

        if host_os is not None:

            _query_params.append(('host_os', host_os))

        if updated_since is not None:
            if isinstance(updated_since, datetime):
                _query_params.append(
                    (
                        'updated_since',
                        updated_since.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('updated_since', updated_since))

        if module_name is not None:

            _query_params.append(('module_name', module_name))

        if module_version is not None:

            _query_params.append(('module_version', module_version))

        if status_name is not None:

            _query_params.append(('status_name', status_name.value))

        if tenant_id is not None:

            _query_params.append(('tenant_id', tenant_id))

        if all_tenants is not None:

            _query_params.append(('all_tenants', all_tenants))

        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/agents',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_app_integrations(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageAppIntegration:

        """
        This method lists data integration info a use has access to.

        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_app_integrations_serialize(
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageAppIntegration",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageAppIntegration = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_app_integrations # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_app_integrations_serialize(
        self,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/app_integrations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_artifact_access(
        self,
        artifact_id: Annotated[StrictStr, Field(description="The id of the artifact to get access for. This is a required field.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[AccessRelationship]:

        """(Deprecated)
        This method lists all access to an artifact. It is deprecated. Use list_access instead.

        :param artifact_id: The id of the artifact to get access for. This is a required field. (required)
        :type artifact_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501
        warnings.warn("GET /api/v2/artifacts/{artifact_id}/access is deprecated.", DeprecationWarning)

        _param = self._list_artifact_access_serialize(
            artifact_id=artifact_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AccessRelationship]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[AccessRelationship] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_artifact_access # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'artifact_id': artifact_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_artifact_access_serialize(
        self,
        artifact_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if artifact_id is not None:
            _path_params['artifact_id'] = artifact_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/artifacts/{artifact_id}/access',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_artifact_comments(
        self,
        artifact_id: Annotated[StrictStr, Field(description="The id of the artifact to get comments for. This is a required field.")],
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        archive_status: Annotated[Optional[ArchiveStatus], Field(description="Filter results by archive status (active, archived, all)")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageComment:

        """
        This method lists all comments a user has access to for an artifact.

        :param artifact_id: The id of the artifact to get comments for. This is a required field. (required)
        :type artifact_id: str
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param archive_status: Filter results by archive status (active, archived, all)
        :type archive_status: ArchiveStatus
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_artifact_comments_serialize(
            artifact_id=artifact_id,
            page=page,
            size=size,
            archive_status=archive_status,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageComment",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageComment = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_artifact_comments # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'artifact_id': artifact_id,
                'page': page,
                'size': size,
                'archive_status': archive_status,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_artifact_comments_serialize(
        self,
        artifact_id,
        page,
        size,
        archive_status,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if artifact_id is not None:
            _path_params['artifact_id'] = artifact_id
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if archive_status is not None:

            _query_params.append(('archive_status', archive_status.value))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/artifacts/{artifact_id}/comments',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_artifacts(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        filter_by: Annotated[Optional[FilterBy], Field(description="Filter artifacts by created by user or shared with user. (created_by_id, -created_by_id)")] = None,
        archive_status: Annotated[Optional[ArchiveStatus], Field(description="Filter results by archive status (active, archived, all)")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageArtifact:

        """
        This method lists all artifacts a user has access to.

        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param filter_by: Filter artifacts by created by user or shared with user. (created_by_id, -created_by_id)
        :type filter_by: FilterBy
        :param archive_status: Filter results by archive status (active, archived, all)
        :type archive_status: ArchiveStatus
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_artifacts_serialize(
            page=page,
            size=size,
            filter_by=filter_by,
            archive_status=archive_status,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageArtifact",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageArtifact = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_artifacts # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'page': page,
                'size': size,
                'filter_by': filter_by,
                'archive_status': archive_status,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_artifacts_serialize(
        self,
        page,
        size,
        filter_by,
        archive_status,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if filter_by is not None:

            _query_params.append(('filter_by', filter_by.value))

        if archive_status is not None:

            _query_params.append(('archive_status', archive_status.value))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/artifacts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_auth_integrations(
        self,
        auth_integration_type: Optional[AuthIntegrationType] = None,
        auth_type: Optional[FunctionAuthType] = None,
        archive_status: Annotated[Optional[ArchiveStatus], Field(description="Filter results by archive status (active, archived, all)")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageAuthIntegration:

        """
        This method lists all AuthIntegrations a user has access to.

        :param auth_integration_type:
        :type auth_integration_type: AuthIntegrationType
        :param auth_type:
        :type auth_type: FunctionAuthType
        :param archive_status: Filter results by archive status (active, archived, all)
        :type archive_status: ArchiveStatus
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_auth_integrations_serialize(
            auth_integration_type=auth_integration_type,
            auth_type=auth_type,
            archive_status=archive_status,
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageAuthIntegration",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageAuthIntegration = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_auth_integrations # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'auth_integration_type': auth_integration_type,
                'auth_type': auth_type,
                'archive_status': archive_status,
                'page': page,
                'size': size,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_auth_integrations_serialize(
        self,
        auth_integration_type,
        auth_type,
        archive_status,
        page,
        size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if auth_integration_type is not None:

            _query_params.append(('auth_integration_type', auth_integration_type.value))

        if auth_type is not None:

            _query_params.append(('auth_type', auth_type.value))

        if archive_status is not None:

            _query_params.append(('archive_status', archive_status.value))

        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/app_integrations/authintegrations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_authors(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageModuleAuthor:

        """
        This method lists all authors a user has access to.

        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_authors_serialize(
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageModuleAuthor",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageModuleAuthor = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_authors # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_authors_serialize(
        self,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/author',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_configuration_documents(
        self,
        configuration_id: Annotated[StrictStr, Field(description="The id of the configuration to list documents for.")],
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        archive_status: Annotated[Optional[ArchiveStatus], Field(description="Filter results by archive status (active, archived, all)")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageDocumentListItem:

        """
        This method lists all the documents for a configuration that the user has access to.

        :param configuration_id: The id of the configuration to list documents for. (required)
        :type configuration_id: str
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param archive_status: Filter results by archive status (active, archived, all)
        :type archive_status: ArchiveStatus
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_configuration_documents_serialize(
            configuration_id=configuration_id,
            page=page,
            size=size,
            archive_status=archive_status,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageDocumentListItem",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageDocumentListItem = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_configuration_documents # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'configuration_id': configuration_id,
                'page': page,
                'size': size,
                'archive_status': archive_status,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_configuration_documents_serialize(
        self,
        configuration_id,
        page,
        size,
        archive_status,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if configuration_id is not None:
            _path_params['configuration_id'] = configuration_id
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if archive_status is not None:

            _query_params.append(('archive_status', archive_status.value))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/systems/configurations/{configuration_id}/documents',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_control_tags(
        self,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[ControlTag]:

        """
        List all control tags

        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_control_tags_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ControlTag]",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[ControlTag] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_control_tags # type: ignore[assignment]
            list_args: Dict[str, Any] = {
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_control_tags_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/controls/tags/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_documents(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        filter_by: Annotated[Optional[FilterBy], Field(description="Filter results by documents created by the user (created_by_id) or shared with the user (-created_by_id).")] = None,
        archive_status: Annotated[Optional[ArchiveStatus], Field(description="Filter results by archive status (active, archived, all)")] = None,
        configuration_id: Annotated[Optional[StrictStr], Field(description="Filter by configuration ID")] = None,
        system_id: Annotated[Optional[StrictStr], Field(description="Filter by system ID (returns documents across all configurations in the system)")] = None,
        search: Annotated[Optional[StrictStr], Field(description="Search documents by name (case-insensitive substring match)")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageDocumentListItem:

        """
        This method lists all documents a user has access to.

        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param filter_by: Filter results by documents created by the user (created_by_id) or shared with the user (-created_by_id).
        :type filter_by: FilterBy
        :param archive_status: Filter results by archive status (active, archived, all)
        :type archive_status: ArchiveStatus
        :param configuration_id: Filter by configuration ID
        :type configuration_id: str
        :param system_id: Filter by system ID (returns documents across all configurations in the system)
        :type system_id: str
        :param search: Search documents by name (case-insensitive substring match)
        :type search: str
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_documents_serialize(
            page=page,
            size=size,
            filter_by=filter_by,
            archive_status=archive_status,
            configuration_id=configuration_id,
            system_id=system_id,
            search=search,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageDocumentListItem",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageDocumentListItem = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_documents # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'page': page,
                'size': size,
                'filter_by': filter_by,
                'archive_status': archive_status,
                'configuration_id': configuration_id,
                'system_id': system_id,
                'search': search,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_documents_serialize(
        self,
        page,
        size,
        filter_by,
        archive_status,
        configuration_id,
        system_id,
        search,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if filter_by is not None:

            _query_params.append(('filter_by', filter_by.value))

        if archive_status is not None:

            _query_params.append(('archive_status', archive_status.value))

        if configuration_id is not None:

            _query_params.append(('configuration_id', configuration_id))

        if system_id is not None:

            _query_params.append(('system_id', system_id))

        if search is not None:

            _query_params.append(('search', search))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/documents',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_files(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        filter_by: Annotated[Optional[FilterBy], Field(description="Filter results by models that were created by the user (created_by_id) or shared with the user (-created_by_id).")] = None,
        archive_status: Annotated[Optional[ArchiveStatus], Field(description="Filter results by archive status (active, archived, all)")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageFile:

        """
        This method lists all files that a user has access to.

        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param filter_by: Filter results by models that were created by the user (created_by_id) or shared with the user (-created_by_id).
        :type filter_by: FilterBy
        :param archive_status: Filter results by archive status (active, archived, all)
        :type archive_status: ArchiveStatus
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_files_serialize(
            page=page,
            size=size,
            filter_by=filter_by,
            archive_status=archive_status,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageFile",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageFile = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_files # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'page': page,
                'size': size,
                'filter_by': filter_by,
                'archive_status': archive_status,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_files_serialize(
        self,
        page,
        size,
        filter_by,
        archive_status,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if filter_by is not None:

            _query_params.append(('filter_by', filter_by.value))

        if archive_status is not None:

            _query_params.append(('archive_status', archive_status.value))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/files',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_functions(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Filter functions by name")] = None,
        module_version: Annotated[Optional[StrictStr], Field(description="Filter functions by module version")] = None,
        tool: Annotated[Optional[StrictStr], Field(description="Filter functions by tool name")] = None,
        tool_version: Annotated[Optional[StrictStr], Field(description="Filter functions by tool version")] = None,
        operating_system: Annotated[Optional[StrictStr], Field(description="Filter functions by operating system")] = None,
        input_extension: Annotated[Optional[StrictStr], Field(description="Filter functions by input file extension")] = None,
        input_user_models: Annotated[Optional[UserModelInputs], Field(description="Filter functions by input user models (single, multiple)")] = None,
        status: Annotated[Optional[UsabilityStatusParams], Field(description="Filter functions by usability status (supported, deprecated, all)")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageFunctionVersion:

        """
        This method lists all functions a user has access to.

        :param name: Filter functions by name
        :type name: str
        :param module_version: Filter functions by module version
        :type module_version: str
        :param tool: Filter functions by tool name
        :type tool: str
        :param tool_version: Filter functions by tool version
        :type tool_version: str
        :param operating_system: Filter functions by operating system
        :type operating_system: str
        :param input_extension: Filter functions by input file extension
        :type input_extension: str
        :param input_user_models: Filter functions by input user models (single, multiple)
        :type input_user_models: UserModelInputs
        :param status: Filter functions by usability status (supported, deprecated, all)
        :type status: UsabilityStatusParams
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_functions_serialize(
            name=name,
            module_version=module_version,
            tool=tool,
            tool_version=tool_version,
            operating_system=operating_system,
            input_extension=input_extension,
            input_user_models=input_user_models,
            status=status,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageFunctionVersion",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageFunctionVersion = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_functions # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'name': name,
                'module_version': module_version,
                'tool': tool,
                'tool_version': tool_version,
                'operating_system': operating_system,
                'input_extension': input_extension,
                'input_user_models': input_user_models,
                'status': status,
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_functions_serialize(
        self,
        name,
        module_version,
        tool,
        tool_version,
        operating_system,
        input_extension,
        input_user_models,
        status,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if name is not None:

            _query_params.append(('name', name))

        if module_version is not None:

            _query_params.append(('module_version', module_version))

        if tool is not None:

            _query_params.append(('tool', tool))

        if tool_version is not None:

            _query_params.append(('tool_version', tool_version))

        if operating_system is not None:

            _query_params.append(('operating_system', operating_system))

        if input_extension is not None:

            _query_params.append(('input_extension', input_extension))

        if input_user_models is not None:

            _query_params.append(('input_user_models', input_user_models.value))

        if status is not None:

            _query_params.append(('status', status.value))

        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/modules/versions/functions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_job_access(
        self,
        job_id: Annotated[StrictStr, Field(description="The id of the job to list access permissions for.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[AccessRelationship]:

        """(Deprecated)
        This method lists all access to a job.  It is deprecated. Use list_access instead.

        :param job_id: The id of the job to list access permissions for. (required)
        :type job_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501
        warnings.warn("GET /api/v2/jobs/{job_id}/access is deprecated.", DeprecationWarning)

        _param = self._list_job_access_serialize(
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AccessRelationship]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[AccessRelationship] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_job_access # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'job_id': job_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_job_access_serialize(
        self,
        job_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['job_id'] = job_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/jobs/{job_id}/access',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_jobs(
        self,
        model_id: Annotated[Optional[StrictStr], Field(description="Filter jobs by model id")] = None,
        status_name: Annotated[Optional[JobStatusName], Field(description="Filter jobs by status name")] = None,
        all_users: Annotated[Optional[StrictBool], Field(description="Show jobs owned by all users (requires admin privileges)")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        archive_status: Annotated[Optional[ArchiveStatus], Field(description="Filter jobs by archive status")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageJob:

        """
        This method lists the jobs that a user has access to.

        :param model_id: Filter jobs by model id
        :type model_id: str
        :param status_name: Filter jobs by status name
        :type status_name: JobStatusName
        :param all_users: Show jobs owned by all users (requires admin privileges)
        :type all_users: bool
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param archive_status: Filter jobs by archive status
        :type archive_status: ArchiveStatus
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_jobs_serialize(
            model_id=model_id,
            status_name=status_name,
            all_users=all_users,
            page=page,
            size=size,
            archive_status=archive_status,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageJob",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageJob = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_jobs # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'model_id': model_id,
                'status_name': status_name,
                'all_users': all_users,
                'page': page,
                'size': size,
                'archive_status': archive_status,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_jobs_serialize(
        self,
        model_id,
        status_name,
        all_users,
        page,
        size,
        archive_status,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if model_id is not None:

            _query_params.append(('model_id', model_id))

        if status_name is not None:

            _query_params.append(('status_name', status_name.value))

        if all_users is not None:

            _query_params.append(('all_users', all_users))

        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if archive_status is not None:

            _query_params.append(('archive_status', archive_status.value))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/jobs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_model_access(
        self,
        model_id: Annotated[StrictStr, Field(description="The id of the model to list access permissions for.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[AccessRelationship]:

        """(Deprecated)
        This method lists all access to a model. It is deprecated. Use list_access instead.

        :param model_id: The id of the model to list access permissions for. (required)
        :type model_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501
        warnings.warn("GET /api/v2/models/{model_id}/access is deprecated.", DeprecationWarning)

        _param = self._list_model_access_serialize(
            model_id=model_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AccessRelationship]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[AccessRelationship] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_model_access # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'model_id': model_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_model_access_serialize(
        self,
        model_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if model_id is not None:
            _path_params['model_id'] = model_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/models/{model_id}/access',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_model_artifacts(
        self,
        model_id: Annotated[StrictStr, Field(description="The id of the model to list artifacts for.")],
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        filter_by: Annotated[Optional[FilterBy], Field(description="Filter model artifacts by created by user or shared with user (created_by_id, -created_by_id)")] = None,
        archive_status: Annotated[Optional[ArchiveStatus], Field(description="Filter results by archive status (active, archived, all)")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageArtifact:

        """
        This method lists all artifacts a user has access to for a model.

        :param model_id: The id of the model to list artifacts for. (required)
        :type model_id: str
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param filter_by: Filter model artifacts by created by user or shared with user (created_by_id, -created_by_id)
        :type filter_by: FilterBy
        :param archive_status: Filter results by archive status (active, archived, all)
        :type archive_status: ArchiveStatus
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_model_artifacts_serialize(
            model_id=model_id,
            page=page,
            size=size,
            filter_by=filter_by,
            archive_status=archive_status,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageArtifact",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageArtifact = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_model_artifacts # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'model_id': model_id,
                'page': page,
                'size': size,
                'filter_by': filter_by,
                'archive_status': archive_status,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_model_artifacts_serialize(
        self,
        model_id,
        page,
        size,
        filter_by,
        archive_status,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if model_id is not None:
            _path_params['model_id'] = model_id
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if filter_by is not None:

            _query_params.append(('filter_by', filter_by.value))

        if archive_status is not None:

            _query_params.append(('archive_status', archive_status.value))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/models/{model_id}/artifacts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_model_comments(
        self,
        model_id: Annotated[StrictStr, Field(description="The model ID to which the comment belongs.")],
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        archive_status: Annotated[Optional[ArchiveStatus], Field(description="Filter results by archive status (active, archived, all)")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageComment:

        """
        This method lists all comments a user has access to for a model.

        :param model_id: The model ID to which the comment belongs. (required)
        :type model_id: str
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param archive_status: Filter results by archive status (active, archived, all)
        :type archive_status: ArchiveStatus
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_model_comments_serialize(
            model_id=model_id,
            page=page,
            size=size,
            archive_status=archive_status,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageComment",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageComment = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_model_comments # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'model_id': model_id,
                'page': page,
                'size': size,
                'archive_status': archive_status,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_model_comments_serialize(
        self,
        model_id,
        page,
        size,
        archive_status,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if model_id is not None:
            _path_params['model_id'] = model_id
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if archive_status is not None:

            _query_params.append(('archive_status', archive_status.value))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/models/{model_id}/comments',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_model_jobs(
        self,
        model_id: Annotated[StrictStr, Field(description="The id of the model to list jobs for.")],
        status_name: Annotated[Optional[JobStatusName], Field(description="Filter results by job status name")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        archive_status: Annotated[Optional[ArchiveStatus], Field(description="Filter results by archive status (active, archived, all)")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageJob:

        """
        This method lists all jobs a user has access to for a model.

        :param model_id: The id of the model to list jobs for. (required)
        :type model_id: str
        :param status_name: Filter results by job status name
        :type status_name: JobStatusName
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param archive_status: Filter results by archive status (active, archived, all)
        :type archive_status: ArchiveStatus
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_model_jobs_serialize(
            model_id=model_id,
            status_name=status_name,
            page=page,
            size=size,
            archive_status=archive_status,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageJob",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageJob = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_model_jobs # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'model_id': model_id,
                'status_name': status_name,
                'page': page,
                'size': size,
                'archive_status': archive_status,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_model_jobs_serialize(
        self,
        model_id,
        status_name,
        page,
        size,
        archive_status,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if model_id is not None:
            _path_params['model_id'] = model_id
        # process the query parameters
        if status_name is not None:

            _query_params.append(('status_name', status_name.value))

        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if archive_status is not None:

            _query_params.append(('archive_status', archive_status.value))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/models/{model_id}/jobs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_models(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        filter_by: Annotated[Optional[FilterBy], Field(description="Filter results by models that were created by the user (created_by_id) or shared with the user (-created_by_id).")] = None,
        archive_status: Annotated[Optional[ArchiveStatus], Field(description="Filter results by archive status (active, archived, all)")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageModelListItem:

        """
        This methods lists all models a user has access to.

        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param filter_by: Filter results by models that were created by the user (created_by_id) or shared with the user (-created_by_id).
        :type filter_by: FilterBy
        :param archive_status: Filter results by archive status (active, archived, all)
        :type archive_status: ArchiveStatus
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_models_serialize(
            page=page,
            size=size,
            filter_by=filter_by,
            archive_status=archive_status,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageModelListItem",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageModelListItem = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_models # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'page': page,
                'size': size,
                'filter_by': filter_by,
                'archive_status': archive_status,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_models_serialize(
        self,
        page,
        size,
        filter_by,
        archive_status,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if filter_by is not None:

            _query_params.append(('filter_by', filter_by.value))

        if archive_status is not None:

            _query_params.append(('archive_status', archive_status.value))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/models',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_module_versions(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageModuleVersion:

        """
        This method list all module versions a user has access to.

        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_module_versions_serialize(
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageModuleVersion",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageModuleVersion = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_module_versions # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_module_versions_serialize(
        self,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/modules/versions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_modules(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageModule:

        """
        This method lists all modules a user has access to.

        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_modules_serialize(
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageModule",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageModule = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_modules # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_modules_serialize(
        self,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/modules',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_operating_systems(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageOperatingSystem:

        """
        This method lists all operating systems a user has access to.

        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_operating_systems_serialize(
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageOperatingSystem",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageOperatingSystem = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_operating_systems # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_operating_systems_serialize(
        self,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/modules/operatingsystems',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_personal_access_tokens(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PagePersonalAccessToken:

        """
        This method lists all personal access tokens a user has access to.

        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_personal_access_tokens_serialize(
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PagePersonalAccessToken",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PagePersonalAccessToken = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_personal_access_tokens # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_personal_access_tokens_serialize(
        self,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/pat',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_resource_type_permissions(
        self,
        subject_type: Annotated[PermissionSubjectType, Field(description="The type of the subject to get permissions for.")],
        subject_id: Annotated[StrictStr, Field(description="The id of the subject to get permissions for.")],
        resource_type: Annotated[PermissionResourceType, Field(description="The type of the resources to get permissions for.")],
        permission: Annotated[Permission, Field(description="The type of the permissions to list.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[Permissionship]:

        """
        This method lists all permissions of a type for a user for all resources of a type.

        :param subject_type: The type of the subject to get permissions for. (required)
        :type subject_type: PermissionSubjectType
        :param subject_id: The id of the subject to get permissions for. (required)
        :type subject_id: str
        :param resource_type: The type of the resources to get permissions for. (required)
        :type resource_type: PermissionResourceType
        :param permission: The type of the permissions to list. (required)
        :type permission: Permission
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_resource_type_permissions_serialize(
            subject_type=subject_type,
            subject_id=subject_id,
            resource_type=resource_type,
            permission=permission,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Permissionship]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[Permissionship] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_resource_type_permissions # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'subject_type': subject_type,
                'subject_id': subject_id,
                'resource_type': resource_type,
                'permission': permission,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_resource_type_permissions_serialize(
        self,
        subject_type,
        subject_id,
        resource_type,
        permission,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if subject_type is not None:
            _path_params['subject_type'] = subject_type.value
        if subject_id is not None:
            _path_params['subject_id'] = subject_id
        if resource_type is not None:
            _path_params['resource_type'] = resource_type.value
        # process the query parameters
        if permission is not None:

            _query_params.append(('permission', permission.value))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/access/{subject_type}/{subject_id}/{resource_type}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_resources(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        id: Annotated[Optional[List[Optional[StrictStr]]], Field(description="A list of resource IDs to filter on")] = None,
        file_name: Annotated[Optional[List[Optional[StrictStr]]], Field(description="A list of file names to filter on (single value performs a like comparison)")] = None,
        type_name: Annotated[Optional[List[ResourceType]], Field(description="A list of resource types to filer on")] = None,
        description: Annotated[Optional[List[StrictStr]], Field(description="A list of file descriptions to filter on (single value performs a like comparison)")] = None,
        version_name: Annotated[Optional[List[StrictStr]], Field(description="A list of file version names to filter on (single value performs a like comparison)")] = None,
        external_identifier: Annotated[Optional[List[StrictStr]], Field(description="A list of file external identifiers to filter on (single value performs a like comparison)")] = None,
        display_name: Annotated[Optional[List[StrictStr]], Field(description="A list of file display names to filter on (single value performs a like comparison)")] = None,
        mime_type: Annotated[Optional[List[StrictStr]], Field(description="A list of file mime types to filter on")] = None,
        file_size: Annotated[Optional[List[StrictInt]], Field(description="A list of file sizes to filter on")] = None,
        created_timestamp: Annotated[Optional[List[Optional[datetime]]], Field(description="A list of file creation timestamps to filter on")] = None,
        updated_timestamp: Annotated[Optional[List[datetime]], Field(description="A list of file update timestamps to filter on")] = None,
        created_by_id: Annotated[Optional[List[StrictStr]], Field(description="A list of user IDs that created the file to filter on")] = None,
        updated_by_id: Annotated[Optional[List[StrictStr]], Field(description="A list of user IDs that updated the file to filter on")] = None,
        archive_status: Annotated[Optional[List[ArchiveStatusName]], Field(description="A list of archive statuses to filter on")] = None,
        access_type: Annotated[Optional[BulkSharingAccessRelation], Field(description="Filter resources by access type - only show resources where user has VIEWER or EDITOR access")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageResourceSearchItem:

        """
        This method lists all resources a user has access to.

        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param id: A list of resource IDs to filter on
        :type id: List[Optional[str]]
        :param file_name: A list of file names to filter on (single value performs a like comparison)
        :type file_name: List[Optional[str]]
        :param type_name: A list of resource types to filer on
        :type type_name: List[ResourceType]
        :param description: A list of file descriptions to filter on (single value performs a like comparison)
        :type description: List[str]
        :param version_name: A list of file version names to filter on (single value performs a like comparison)
        :type version_name: List[str]
        :param external_identifier: A list of file external identifiers to filter on (single value performs a like comparison)
        :type external_identifier: List[str]
        :param display_name: A list of file display names to filter on (single value performs a like comparison)
        :type display_name: List[str]
        :param mime_type: A list of file mime types to filter on
        :type mime_type: List[str]
        :param file_size: A list of file sizes to filter on
        :type file_size: List[int]
        :param created_timestamp: A list of file creation timestamps to filter on
        :type created_timestamp: List[Optional[datetime]]
        :param updated_timestamp: A list of file update timestamps to filter on
        :type updated_timestamp: List[datetime]
        :param created_by_id: A list of user IDs that created the file to filter on
        :type created_by_id: List[str]
        :param updated_by_id: A list of user IDs that updated the file to filter on
        :type updated_by_id: List[str]
        :param archive_status: A list of archive statuses to filter on
        :type archive_status: List[ArchiveStatusName]
        :param access_type: Filter resources by access type - only show resources where user has VIEWER or EDITOR access
        :type access_type: BulkSharingAccessRelation
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_resources_serialize(
            page=page,
            size=size,
            id=id,
            file_name=file_name,
            type_name=type_name,
            description=description,
            version_name=version_name,
            external_identifier=external_identifier,
            display_name=display_name,
            mime_type=mime_type,
            file_size=file_size,
            created_timestamp=created_timestamp,
            updated_timestamp=updated_timestamp,
            created_by_id=created_by_id,
            updated_by_id=updated_by_id,
            archive_status=archive_status,
            access_type=access_type,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageResourceSearchItem",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageResourceSearchItem = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_resources # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'page': page,
                'size': size,
                'id': id,
                'file_name': file_name,
                'type_name': type_name,
                'description': description,
                'version_name': version_name,
                'external_identifier': external_identifier,
                'display_name': display_name,
                'mime_type': mime_type,
                'file_size': file_size,
                'created_timestamp': created_timestamp,
                'updated_timestamp': updated_timestamp,
                'created_by_id': created_by_id,
                'updated_by_id': updated_by_id,
                'archive_status': archive_status,
                'access_type': access_type,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_resources_serialize(
        self,
        page,
        size,
        id,
        file_name,
        type_name,
        description,
        version_name,
        external_identifier,
        display_name,
        mime_type,
        file_size,
        created_timestamp,
        updated_timestamp,
        created_by_id,
        updated_by_id,
        archive_status,
        access_type,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'id': 'multi',
            'file_name': 'multi',
            'type_name': 'multi',
            'description': 'multi',
            'version_name': 'multi',
            'external_identifier': 'multi',
            'display_name': 'multi',
            'mime_type': 'multi',
            'file_size': 'multi',
            'created_timestamp': 'multi',
            'updated_timestamp': 'multi',
            'created_by_id': 'multi',
            'updated_by_id': 'multi',
            'archive_status': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if id is not None:

            _query_params.append(('id', id))

        if file_name is not None:

            _query_params.append(('file_name', file_name))

        if type_name is not None:

            _query_params.append(('type_name', type_name))

        if description is not None:

            _query_params.append(('description', description))

        if version_name is not None:

            _query_params.append(('version_name', version_name))

        if external_identifier is not None:

            _query_params.append(('external_identifier', external_identifier))

        if display_name is not None:

            _query_params.append(('display_name', display_name))

        if mime_type is not None:

            _query_params.append(('mime_type', mime_type))

        if file_size is not None:

            _query_params.append(('file_size', file_size))

        if created_timestamp is not None:

            _query_params.append(('created_timestamp', created_timestamp))

        if updated_timestamp is not None:

            _query_params.append(('updated_timestamp', updated_timestamp))

        if created_by_id is not None:

            _query_params.append(('created_by_id', created_by_id))

        if updated_by_id is not None:

            _query_params.append(('updated_by_id', updated_by_id))

        if archive_status is not None:

            _query_params.append(('archive_status', archive_status))

        if access_type is not None:

            _query_params.append(('access_type', access_type.value))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/resources',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_snapshot_items(
        self,
        snapshot_id: Annotated[StrictStr, Field(description="The id of the snapshot to list items for.")],
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageSnapshotItem:

        """
        This method lists all the snapshot items a user has access to.

        :param snapshot_id: The id of the snapshot to list items for. (required)
        :type snapshot_id: str
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_snapshot_items_serialize(
            snapshot_id=snapshot_id,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageSnapshotItem",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageSnapshotItem = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_snapshot_items # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'snapshot_id': snapshot_id,
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_snapshot_items_serialize(
        self,
        snapshot_id,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if snapshot_id is not None:
            _path_params['snapshot_id'] = snapshot_id
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/systems/configurations/snapshots/{snapshot_id}/snapshot-items',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_snapshot_revisions(
        self,
        snapshot_id: Annotated[StrictStr, Field(description="The id of the system snapshot to list revisions for.")],
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        name: Annotated[Optional[List[StrictStr]], Field(description="A list of file names to filter on (single value performs a like comparison)")] = None,
        extension: Annotated[Optional[List[StrictStr]], Field(description="A list of file extensions to filter on (single value performs a like comparison)")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageSnapshotRevisionSearchItem:

        """
        This method gets a snapshot's revisions.

        :param snapshot_id: The id of the system snapshot to list revisions for. (required)
        :type snapshot_id: str
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param name: A list of file names to filter on (single value performs a like comparison)
        :type name: List[str]
        :param extension: A list of file extensions to filter on (single value performs a like comparison)
        :type extension: List[str]
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_snapshot_revisions_serialize(
            snapshot_id=snapshot_id,
            page=page,
            size=size,
            name=name,
            extension=extension,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageSnapshotRevisionSearchItem",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageSnapshotRevisionSearchItem = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_snapshot_revisions # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'snapshot_id': snapshot_id,
                'page': page,
                'size': size,
                'name': name,
                'extension': extension,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_snapshot_revisions_serialize(
        self,
        snapshot_id,
        page,
        size,
        name,
        extension,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'name': 'multi',
            'extension': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if snapshot_id is not None:
            _path_params['snapshot_id'] = snapshot_id
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if name is not None:

            _query_params.append(('name', name))

        if extension is not None:

            _query_params.append(('extension', extension))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/systems/configurations/snapshots/{snapshot_id}/revisions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_snapshots(
        self,
        system_id: Annotated[Optional[StrictStr], Field(description="The id of the system to filter snapshots by")] = None,
        configuration_id: Annotated[Optional[StrictStr], Field(description="The id of the configuration to filter snapshots by")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="The tag to filter snapshots by")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageSnapshot:

        """
        This method lists all the snapshots a user has access to

        :param system_id: The id of the system to filter snapshots by
        :type system_id: str
        :param configuration_id: The id of the configuration to filter snapshots by
        :type configuration_id: str
        :param tag: The tag to filter snapshots by
        :type tag: str
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_snapshots_serialize(
            system_id=system_id,
            configuration_id=configuration_id,
            tag=tag,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageSnapshot",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageSnapshot = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_snapshots # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'system_id': system_id,
                'configuration_id': configuration_id,
                'tag': tag,
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_snapshots_serialize(
        self,
        system_id,
        configuration_id,
        tag,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if system_id is not None:

            _query_params.append(('system_id', system_id))

        if configuration_id is not None:

            _query_params.append(('configuration_id', configuration_id))

        if tag is not None:

            _query_params.append(('tag', tag))

        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/systems/configurations/snapshots',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_system_configurations(
        self,
        system_id: Annotated[StrictStr, Field(description="The id of the system to list configurations for.")],
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        archive_status: Annotated[Optional[ArchiveStatus], Field(description="Filter results by archive status (active, archived, all)")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageSystemConfiguration:

        """
        This method lists all the system configurations a user has access to.

        :param system_id: The id of the system to list configurations for. (required)
        :type system_id: str
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param archive_status: Filter results by archive status (active, archived, all)
        :type archive_status: ArchiveStatus
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_system_configurations_serialize(
            system_id=system_id,
            page=page,
            size=size,
            archive_status=archive_status,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageSystemConfiguration",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageSystemConfiguration = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_system_configurations # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'system_id': system_id,
                'page': page,
                'size': size,
                'archive_status': archive_status,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_system_configurations_serialize(
        self,
        system_id,
        page,
        size,
        archive_status,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if system_id is not None:
            _path_params['system_id'] = system_id
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if archive_status is not None:

            _query_params.append(('archive_status', archive_status.value))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/systems/{system_id}/configurations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_systems(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        filter_by: Annotated[Optional[FilterBy], Field(description="Filter results by systems that were created by the user (created_by_id) or shared with the user (-created_by_id).")] = None,
        archive_status: Annotated[Optional[ArchiveStatus], Field(description="Filter results by archive status (active, archived, all)")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageSystem:

        """
        This method lists all the systems a user has access to.

        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param filter_by: Filter results by systems that were created by the user (created_by_id) or shared with the user (-created_by_id).
        :type filter_by: FilterBy
        :param archive_status: Filter results by archive status (active, archived, all)
        :type archive_status: ArchiveStatus
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_systems_serialize(
            page=page,
            size=size,
            filter_by=filter_by,
            archive_status=archive_status,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageSystem",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageSystem = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_systems # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'page': page,
                'size': size,
                'filter_by': filter_by,
                'archive_status': archive_status,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_systems_serialize(
        self,
        page,
        size,
        filter_by,
        archive_status,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if filter_by is not None:

            _query_params.append(('filter_by', filter_by.value))

        if archive_status is not None:

            _query_params.append(('archive_status', archive_status.value))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/systems',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_tags(
        self,
        system_id: Annotated[Optional[StrictStr], Field(description="The id of the system to filter tags by")] = None,
        configuration_id: Annotated[Optional[StrictStr], Field(description="The id of the configuration to filter tags by")] = None,
        snapshot_id: Annotated[Optional[StrictStr], Field(description="The id of the snapshot to filter tags by")] = None,
        archive_status: Optional[ArchiveStatus] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageSnapshotTag:

        """
        This method lists all the snapshot tags a user has access to.

        :param system_id: The id of the system to filter tags by
        :type system_id: str
        :param configuration_id: The id of the configuration to filter tags by
        :type configuration_id: str
        :param snapshot_id: The id of the snapshot to filter tags by
        :type snapshot_id: str
        :param archive_status:
        :type archive_status: ArchiveStatus
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_tags_serialize(
            system_id=system_id,
            configuration_id=configuration_id,
            snapshot_id=snapshot_id,
            archive_status=archive_status,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageSnapshotTag",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageSnapshotTag = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_tags # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'system_id': system_id,
                'configuration_id': configuration_id,
                'snapshot_id': snapshot_id,
                'archive_status': archive_status,
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_tags_serialize(
        self,
        system_id,
        configuration_id,
        snapshot_id,
        archive_status,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if system_id is not None:

            _query_params.append(('system_id', system_id))

        if configuration_id is not None:

            _query_params.append(('configuration_id', configuration_id))

        if snapshot_id is not None:

            _query_params.append(('snapshot_id', snapshot_id))

        if archive_status is not None:

            _query_params.append(('archive_status', archive_status.value))

        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/systems/configurations/snapshots/tags',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_tenants(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageTenant:

        """
        This method lists all tenants (admin only).

        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_tenants_serialize(
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageTenant",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageTenant = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_tenants # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'page': page,
                'size': size,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_tenants_serialize(
        self,
        page,
        size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/tenants',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_tool_versions(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageToolVersion:

        """
        This method lists all tool versions a user has access to.

        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_tool_versions_serialize(
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageToolVersion",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageToolVersion = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_tool_versions # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_tool_versions_serialize(
        self,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/tools-versions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_tools(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        include: Annotated[Optional[List[ToolInclude]], Field(description="Whether to include functions in response")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageTool:

        """
        This method list all tools a user has access to

        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param include: Whether to include functions in response
        :type include: List[ToolInclude]
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_tools_serialize(
            page=page,
            size=size,
            include=include,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageTool",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageTool = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_tools # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'page': page,
                'size': size,
                'include': include,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_tools_serialize(
        self,
        page,
        size,
        include,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'include': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if include is not None:

            _query_params.append(('include', include))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/tools',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_tracked_files(
        self,
        configuration_id: Annotated[StrictStr, Field(description="The id of the configuration to list tracked files for.")],
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageTrackedFile:

        """
        This methods list all the tracked files for a configuration that the user has access to.

        :param configuration_id: The id of the configuration to list tracked files for. (required)
        :type configuration_id: str
        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_tracked_files_serialize(
            configuration_id=configuration_id,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageTrackedFile",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageTrackedFile = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_tracked_files # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'configuration_id': configuration_id,
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_tracked_files_serialize(
        self,
        configuration_id,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if configuration_id is not None:
            _path_params['configuration_id'] = configuration_id
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/systems/configurations/{configuration_id}/tracked-files',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_upstream_remotes(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Page size")] = None,
        sort: Optional[Annotated[str, Field(strict=True)]] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageUpstreamRemote:

        """
        This method retrieves a list of upstream remotes that a user has access to.

        :param page: Page number
        :type page: int
        :param size: Page size
        :type size: int
        :param sort:
        :type sort: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_upstream_remotes_serialize(
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageUpstreamRemote",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageUpstreamRemote = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_upstream_remotes # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'page': page,
                'size': size,
                'sort': sort,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_upstream_remotes_serialize(
        self,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(('page', page))

        if size is not None:

            _query_params.append(('size', size))

        if sort is not None:

            _query_params.append(('sort', sort))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/upstream-remotes',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def list_users(
        self,
        user_state: Annotated[Optional[UserStateOption], Field(description="Filter users by state (active or all).")] = None,
        user_type: Annotated[Optional[UserType], Field(description="Filter users by type (human, agent or all).")] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[User]:

        """
        This method lists all users a user has access to.

        :param user_state: Filter users by state (active or all).
        :type user_state: UserStateOption
        :param user_type: Filter users by type (human, agent or all).
        :type user_type: UserType
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._list_users_serialize(
            user_state=user_state,
            user_type=user_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[User]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[User] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.list_users # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'user_state': user_state,
                'user_type': user_type,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _list_users_serialize(
        self,
        user_state,
        user_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_state is not None:

            _query_params.append(('user_state', user_state.value))

        if user_type is not None:

            _query_params.append(('user_type', user_type.value))

        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def liveness_check(
        self,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> HealthcheckReport:

        """
        Liveness probe

        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._liveness_check_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "HealthcheckReport",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: HealthcheckReport = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.liveness_check # type: ignore[assignment]
            list_args: Dict[str, Any] = {
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _liveness_check_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/health/liveness',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def patch_artifact_access(
        self,
        artifact_id: Annotated[StrictStr, Field(description="The id of the artifact to update access for. This is a required field.")],
        access_relationship: AccessRelationship,
        patch_op: Annotated[Optional[PatchOp], Field(description="The operation to perform on the access relationship. This is a required field.")] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[AccessRelationship]:

        """(Deprecated)
        This method updates access to an artifact. It is deprecated. Use update_access instead.

        :param artifact_id: The id of the artifact to update access for. This is a required field. (required)
        :type artifact_id: str
        :param access_relationship: (required)
        :type access_relationship: AccessRelationship
        :param patch_op: The operation to perform on the access relationship. This is a required field.
        :type patch_op: PatchOp
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501
        warnings.warn("PATCH /api/v2/artifacts/{artifact_id}/access is deprecated.", DeprecationWarning)

        _param = self._patch_artifact_access_serialize(
            artifact_id=artifact_id,
            access_relationship=access_relationship,
            patch_op=patch_op,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AccessRelationship]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[AccessRelationship] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.patch_artifact_access # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'artifact_id': artifact_id,
                'access_relationship': access_relationship,
                'patch_op': patch_op,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _patch_artifact_access_serialize(
        self,
        artifact_id,
        access_relationship,
        patch_op,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if artifact_id is not None:
            _path_params['artifact_id'] = artifact_id
        # process the query parameters
        if patch_op is not None:

            _query_params.append(('patch_op', patch_op.value))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if access_relationship is not None:
            _body_params = access_relationship


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/v2/artifacts/{artifact_id}/access',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def patch_artifact_control_taggings(
        self,
        artifact_id: Annotated[StrictStr, Field(description="The ID of the artifact to get. This is a required field.")],
        request_body: List[StrictStr],
        patch_op: Annotated[Optional[PatchOp], Field(description="The operation to perform. This is a required field.")] = None,
        reason: Annotated[Optional[StrictStr], Field(description="The reason for the change. This is an optional field.")] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[ResourceControlTagging]:

        """
        This method adds or removes control tags on a artifact.

        :param artifact_id: The ID of the artifact to get. This is a required field. (required)
        :type artifact_id: str
        :param request_body: (required)
        :type request_body: List[str]
        :param patch_op: The operation to perform. This is a required field.
        :type patch_op: PatchOp
        :param reason: The reason for the change. This is an optional field.
        :type reason: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._patch_artifact_control_taggings_serialize(
            artifact_id=artifact_id,
            request_body=request_body,
            patch_op=patch_op,
            reason=reason,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ResourceControlTagging]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[ResourceControlTagging] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.patch_artifact_control_taggings # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'artifact_id': artifact_id,
                'request_body': request_body,
                'patch_op': patch_op,
                'reason': reason,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _patch_artifact_control_taggings_serialize(
        self,
        artifact_id,
        request_body,
        patch_op,
        reason,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'request_body': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if artifact_id is not None:
            _path_params['artifact_id'] = artifact_id
        # process the query parameters
        if patch_op is not None:

            _query_params.append(('patch_op', patch_op.value))

        if reason is not None:

            _query_params.append(('reason', reason))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if request_body is not None:
            _body_params = request_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/v2/controls/taggings/artifact/{artifact_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def patch_file_control_taggings(
        self,
        file_id: Annotated[StrictStr, Field(description="The ID of the file to get. This is a required field.")],
        request_body: List[Optional[StrictStr]],
        patch_op: Annotated[Optional[PatchOp], Field(description="The operation to perform. This is a required field.")] = None,
        reason: Annotated[Optional[StrictStr], Field(description="The reason for the change. This is an optional field.")] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[FileControlTagging]:

        """
        This method adds or removes control tags on a file.

        :param file_id: The ID of the file to get. This is a required field. (required)
        :type file_id: str
        :param request_body: (required)
        :type request_body: List[Optional[str]]
        :param patch_op: The operation to perform. This is a required field.
        :type patch_op: PatchOp
        :param reason: The reason for the change. This is an optional field.
        :type reason: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._patch_file_control_taggings_serialize(
            file_id=file_id,
            request_body=request_body,
            patch_op=patch_op,
            reason=reason,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[FileControlTagging]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[FileControlTagging] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.patch_file_control_taggings # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'file_id': file_id,
                'request_body': request_body,
                'patch_op': patch_op,
                'reason': reason,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _patch_file_control_taggings_serialize(
        self,
        file_id,
        request_body,
        patch_op,
        reason,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'request_body': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['file_id'] = file_id
        # process the query parameters
        if patch_op is not None:

            _query_params.append(('patch_op', patch_op.value))

        if reason is not None:

            _query_params.append(('reason', reason))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if request_body is not None:
            _body_params = request_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/v2/controls/taggings/file/{file_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def patch_job_access(
        self,
        job_id: Annotated[StrictStr, Field(description="The id of the job to modify access permissions on")],
        access_relationship: AccessRelationship,
        patch_op: Annotated[Optional[PatchOp], Field(description="The operation to perform on the access relationship.")] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[AccessRelationship]:

        """(Deprecated)
        This method updates access to a job.  It is deprecated. Use update_access instead.

        :param job_id: The id of the job to modify access permissions on (required)
        :type job_id: str
        :param access_relationship: (required)
        :type access_relationship: AccessRelationship
        :param patch_op: The operation to perform on the access relationship.
        :type patch_op: PatchOp
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501
        warnings.warn("PATCH /api/v2/jobs/{job_id}/access is deprecated.", DeprecationWarning)

        _param = self._patch_job_access_serialize(
            job_id=job_id,
            access_relationship=access_relationship,
            patch_op=patch_op,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AccessRelationship]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[AccessRelationship] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.patch_job_access # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'job_id': job_id,
                'access_relationship': access_relationship,
                'patch_op': patch_op,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _patch_job_access_serialize(
        self,
        job_id,
        access_relationship,
        patch_op,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['job_id'] = job_id
        # process the query parameters
        if patch_op is not None:

            _query_params.append(('patch_op', patch_op.value))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if access_relationship is not None:
            _body_params = access_relationship


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/v2/jobs/{job_id}/access',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def patch_model_access(
        self,
        model_id: Annotated[StrictStr, Field(description="The id of the model to update access for.")],
        access_relationship: AccessRelationship,
        patch_op: Annotated[Optional[PatchOp], Field(description="The operation to perform on the access relationship.")] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[AccessRelationship]:

        """(Deprecated)
        This method updates access to a model. It is deprecated. Use update_access instead.

        :param model_id: The id of the model to update access for. (required)
        :type model_id: str
        :param access_relationship: (required)
        :type access_relationship: AccessRelationship
        :param patch_op: The operation to perform on the access relationship.
        :type patch_op: PatchOp
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501
        warnings.warn("PATCH /api/v2/models/{model_id}/access is deprecated.", DeprecationWarning)

        _param = self._patch_model_access_serialize(
            model_id=model_id,
            access_relationship=access_relationship,
            patch_op=patch_op,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AccessRelationship]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[AccessRelationship] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.patch_model_access # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'model_id': model_id,
                'access_relationship': access_relationship,
                'patch_op': patch_op,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _patch_model_access_serialize(
        self,
        model_id,
        access_relationship,
        patch_op,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if model_id is not None:
            _path_params['model_id'] = model_id
        # process the query parameters
        if patch_op is not None:

            _query_params.append(('patch_op', patch_op.value))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if access_relationship is not None:
            _body_params = access_relationship


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/v2/models/{model_id}/access',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def patch_model_control_taggings(
        self,
        model_id: Annotated[StrictStr, Field(description="The ID of the model to add or remove taggings. This is a required field.")],
        request_body: List[StrictStr],
        patch_op: Annotated[Optional[PatchOp], Field(description="The operation to perform. This is a required field.")] = None,
        reason: Annotated[Optional[StrictStr], Field(description="The reason for the change. This is an optional field.")] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[ResourceControlTagging]:

        """
        This method adds or removes control tags on a model.

        :param model_id: The ID of the model to add or remove taggings. This is a required field. (required)
        :type model_id: str
        :param request_body: (required)
        :type request_body: List[str]
        :param patch_op: The operation to perform. This is a required field.
        :type patch_op: PatchOp
        :param reason: The reason for the change. This is an optional field.
        :type reason: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._patch_model_control_taggings_serialize(
            model_id=model_id,
            request_body=request_body,
            patch_op=patch_op,
            reason=reason,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ResourceControlTagging]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[ResourceControlTagging] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.patch_model_control_taggings # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'model_id': model_id,
                'request_body': request_body,
                'patch_op': patch_op,
                'reason': reason,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _patch_model_control_taggings_serialize(
        self,
        model_id,
        request_body,
        patch_op,
        reason,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'request_body': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if model_id is not None:
            _path_params['model_id'] = model_id
        # process the query parameters
        if patch_op is not None:

            _query_params.append(('patch_op', patch_op.value))

        if reason is not None:

            _query_params.append(('reason', reason))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if request_body is not None:
            _body_params = request_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/v2/controls/taggings/model/{model_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def patch_user_control_taggings(
        self,
        user_id: Annotated[StrictStr, Field(description="The ID of the user to get. This is a required field.")],
        request_body: List[StrictStr],
        patch_op: Annotated[Optional[PatchOp], Field(description="The operation to perform. This is a required field.")] = None,
        reason: Annotated[Optional[StrictStr], Field(description="The reason for the change. This is an optional field.")] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[UserControlTagging]:

        """
        This method adds or removes control tags on a user.

        :param user_id: The ID of the user to get. This is a required field. (required)
        :type user_id: str
        :param request_body: (required)
        :type request_body: List[str]
        :param patch_op: The operation to perform. This is a required field.
        :type patch_op: PatchOp
        :param reason: The reason for the change. This is an optional field.
        :type reason: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._patch_user_control_taggings_serialize(
            user_id=user_id,
            request_body=request_body,
            patch_op=patch_op,
            reason=reason,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[UserControlTagging]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[UserControlTagging] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.patch_user_control_taggings # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'user_id': user_id,
                'request_body': request_body,
                'patch_op': patch_op,
                'reason': reason,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _patch_user_control_taggings_serialize(
        self,
        user_id,
        request_body,
        patch_op,
        reason,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'request_body': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if patch_op is not None:

            _query_params.append(('patch_op', patch_op.value))

        if reason is not None:

            _query_params.append(('reason', reason))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if request_body is not None:
            _body_params = request_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/v2/controls/taggings/user/{user_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def readiness_check(
        self,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> HealthcheckReport:

        """
        Readiness probe

        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._readiness_check_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "HealthcheckReport",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: HealthcheckReport = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.readiness_check # type: ignore[assignment]
            list_args: Dict[str, Any] = {
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _readiness_check_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v2/health/readiness',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def register_agent(
        self,
        new_agent: NewAgent,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Agent:

        """
        This method registers a new agent.

        :param new_agent: (required)
        :type new_agent: NewAgent
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._register_agent_serialize(
            new_agent=new_agent,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Agent",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Agent = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.register_agent # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'new_agent': new_agent,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _register_agent_serialize(
        self,
        new_agent,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_agent is not None:
            _body_params = new_agent


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/agents',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def remove_access(
        self,
        subject_type: Annotated[AccessSubjectType, Field(description="The type of the subject to remove.")],
        subject_id: Annotated[StrictStr, Field(description="The id of the subject to remove.")],
        resource_type: Annotated[AccessResourceType, Field(description="The type of the resource to remove.")],
        resource_id: Annotated[StrictStr, Field(description="The id of the resource to remove.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> object:

        """
        This method removes access to a resource or file.

        :param subject_type: The type of the subject to remove. (required)
        :type subject_type: AccessSubjectType
        :param subject_id: The id of the subject to remove. (required)
        :type subject_id: str
        :param resource_type: The type of the resource to remove. (required)
        :type resource_type: AccessResourceType
        :param resource_id: The id of the resource to remove. (required)
        :type resource_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._remove_access_serialize(
            subject_type=subject_type,
            subject_id=subject_id,
            resource_type=resource_type,
            resource_id=resource_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: object = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.remove_access # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'subject_type': subject_type,
                'subject_id': subject_id,
                'resource_type': resource_type,
                'resource_id': resource_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _remove_access_serialize(
        self,
        subject_type,
        subject_id,
        resource_type,
        resource_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if subject_type is not None:
            _path_params['subject_type'] = subject_type.value
        if subject_id is not None:
            _path_params['subject_id'] = subject_id
        if resource_type is not None:
            _path_params['resource_type'] = resource_type.value
        if resource_id is not None:
            _path_params['resource_id'] = resource_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/access/{subject_type}/{subject_id}/{resource_type}/{resource_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def remove_agent_pool_agent(
        self,
        agent_pool_id: Annotated[StrictStr, Field(description="The ID of the agent pool to remove the agent from.")],
        agent_id: Annotated[StrictStr, Field(description="The ID of the agent to delete.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AgentPool:

        """
        This method deletes an agent's membership in an agent pool.

        :param agent_pool_id: The ID of the agent pool to remove the agent from. (required)
        :type agent_pool_id: str
        :param agent_id: The ID of the agent to delete. (required)
        :type agent_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._remove_agent_pool_agent_serialize(
            agent_pool_id=agent_pool_id,
            agent_id=agent_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AgentPool",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AgentPool = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.remove_agent_pool_agent # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_pool_id': agent_pool_id,
                'agent_id': agent_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _remove_agent_pool_agent_serialize(
        self,
        agent_pool_id,
        agent_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_pool_id is not None:
            _path_params['agent_pool_id'] = agent_pool_id
        if agent_id is not None:
            _path_params['agent_id'] = agent_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/agent_pools/{agent_pool_id}/agents/{agent_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def remove_agent_pool_user(
        self,
        agent_pool_id: Annotated[StrictStr, Field(description="The ID of the agent pool to remove the user from.")],
        user_id: Annotated[StrictStr, Field(description="The ID of the user to delete.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AgentPool:

        """
        This method deletes a user's membership in an agent pool.

        :param agent_pool_id: The ID of the agent pool to remove the user from. (required)
        :type agent_pool_id: str
        :param user_id: The ID of the user to delete. (required)
        :type user_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._remove_agent_pool_user_serialize(
            agent_pool_id=agent_pool_id,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AgentPool",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AgentPool = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.remove_agent_pool_user # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_pool_id': agent_pool_id,
                'user_id': user_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _remove_agent_pool_user_serialize(
        self,
        agent_pool_id,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_pool_id is not None:
            _path_params['agent_pool_id'] = agent_pool_id
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/agent_pools/{agent_pool_id}/users/{user_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def remove_job_assigned_agent(
        self,
        job_id: Annotated[StrictStr, Field(description="The id of the job to remove the assigned agent from.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Job:

        """
        This method removes the assigned agent from a job.

        :param job_id: The id of the job to remove the assigned agent from. (required)
        :type job_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._remove_job_assigned_agent_serialize(
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Job = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.remove_job_assigned_agent # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'job_id': job_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _remove_job_assigned_agent_serialize(
        self,
        job_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['job_id'] = job_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/jobs/{job_id}/assigned_agent',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def restore_artifact(
        self,
        artifact_id: Annotated[StrictStr, Field(description="The id of the artifact to restore. This is a required field.")],
        restore: Optional[Restore] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Artifact:

        """
        This method restores an artifact by updating it's archive status to Active.

        :param artifact_id: The id of the artifact to restore. This is a required field. (required)
        :type artifact_id: str
        :param restore:
        :type restore: Restore
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._restore_artifact_serialize(
            artifact_id=artifact_id,
            restore=restore,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Artifact",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Artifact = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.restore_artifact # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'artifact_id': artifact_id,
                'restore': restore,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _restore_artifact_serialize(
        self,
        artifact_id,
        restore,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if artifact_id is not None:
            _path_params['artifact_id'] = artifact_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if restore is not None:
            _body_params = restore


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/artifacts/{artifact_id}:restore',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def restore_comment(
        self,
        comment_id: Annotated[StrictStr, Field(description="The ID of the comment to restore.")],
        restore: Optional[Restore] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Comment:

        """
        This method restores a comment by updating it's archive status to Active.

        :param comment_id: The ID of the comment to restore. (required)
        :type comment_id: str
        :param restore:
        :type restore: Restore
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._restore_comment_serialize(
            comment_id=comment_id,
            restore=restore,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Comment",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Comment = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.restore_comment # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'comment_id': comment_id,
                'restore': restore,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _restore_comment_serialize(
        self,
        comment_id,
        restore,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if comment_id is not None:
            _path_params['comment_id'] = comment_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if restore is not None:
            _body_params = restore


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/comments/{comment_id}:restore',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def restore_configuration(
        self,
        configuration_id: Annotated[StrictStr, Field(description="The id of the configuration to restore.")],
        restore: Optional[Restore] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> SystemConfiguration:

        """
        This method restores a configuration by updating it's archive status to Active.

        :param configuration_id: The id of the configuration to restore. (required)
        :type configuration_id: str
        :param restore:
        :type restore: Restore
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._restore_configuration_serialize(
            configuration_id=configuration_id,
            restore=restore,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SystemConfiguration",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: SystemConfiguration = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.restore_configuration # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'configuration_id': configuration_id,
                'restore': restore,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _restore_configuration_serialize(
        self,
        configuration_id,
        restore,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if configuration_id is not None:
            _path_params['configuration_id'] = configuration_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if restore is not None:
            _body_params = restore


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/systems/configurations/{configuration_id}:restore',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def restore_file(
        self,
        file_id: Annotated[StrictStr, Field(description="The id of the file to restore.")],
        restore: Optional[Restore] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> File:

        """
        This method restores a file by updating it's archive status to Active.

        :param file_id: The id of the file to restore. (required)
        :type file_id: str
        :param restore:
        :type restore: Restore
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._restore_file_serialize(
            file_id=file_id,
            restore=restore,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "File",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: File = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.restore_file # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'file_id': file_id,
                'restore': restore,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _restore_file_serialize(
        self,
        file_id,
        restore,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['file_id'] = file_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if restore is not None:
            _body_params = restore


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/files/{file_id}:restore',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def restore_file_revision(
        self,
        revision_id: Annotated[StrictStr, Field(description="The id of the file revision to restore.")],
        restore: Optional[Restore] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> FileRevision:

        """
        This method restores a FileRevision by updating it's archive status to Active.

        :param revision_id: The id of the file revision to restore. (required)
        :type revision_id: str
        :param restore:
        :type restore: Restore
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._restore_file_revision_serialize(
            revision_id=revision_id,
            restore=restore,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FileRevision",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: FileRevision = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.restore_file_revision # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'revision_id': revision_id,
                'restore': restore,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _restore_file_revision_serialize(
        self,
        revision_id,
        restore,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if revision_id is not None:
            _path_params['revision_id'] = revision_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if restore is not None:
            _body_params = restore


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/revisions/{revision_id}:restore',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def restore_job(
        self,
        job_id: Annotated[StrictStr, Field(description="The id of the job to restore.")],
        restore: Optional[Restore] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Job:

        """
        This method restores a job by updating it's archive status to Active.

        :param job_id: The id of the job to restore. (required)
        :type job_id: str
        :param restore:
        :type restore: Restore
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._restore_job_serialize(
            job_id=job_id,
            restore=restore,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Job = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.restore_job # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'job_id': job_id,
                'restore': restore,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _restore_job_serialize(
        self,
        job_id,
        restore,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['job_id'] = job_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if restore is not None:
            _body_params = restore


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/jobs/{job_id}:restore',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def restore_model(
        self,
        model_id: Annotated[StrictStr, Field(description="The id of the model to restore.")],
        restore: Optional[Restore] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Model:

        """
        This method restores a model by updating it's archive status to Active.

        :param model_id: The id of the model to restore. (required)
        :type model_id: str
        :param restore:
        :type restore: Restore
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._restore_model_serialize(
            model_id=model_id,
            restore=restore,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Model",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Model = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.restore_model # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'model_id': model_id,
                'restore': restore,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _restore_model_serialize(
        self,
        model_id,
        restore,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if model_id is not None:
            _path_params['model_id'] = model_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if restore is not None:
            _body_params = restore


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/models/{model_id}:restore',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def restore_system(
        self,
        system_id: Annotated[StrictStr, Field(description="The id of the system to restore.")],
        restore: Optional[Restore] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> System:

        """
        This method restores a system by updating it's archive status to Active.

        :param system_id: The id of the system to restore. (required)
        :type system_id: str
        :param restore:
        :type restore: Restore
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._restore_system_serialize(
            system_id=system_id,
            restore=restore,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "System",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: System = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.restore_system # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'system_id': system_id,
                'restore': restore,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _restore_system_serialize(
        self,
        system_id,
        restore,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if system_id is not None:
            _path_params['system_id'] = system_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if restore is not None:
            _body_params = restore


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/systems/{system_id}:restore',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def restore_tag(
        self,
        tag_id: Annotated[StrictStr, Field(description="The id of the tag to restore.")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> SnapshotTag:

        """
        This method restores a snapshot tag by updating it's archive status to Active.

        :param tag_id: The id of the tag to restore. (required)
        :type tag_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._restore_tag_serialize(
            tag_id=tag_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SnapshotTag",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: SnapshotTag = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.restore_tag # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'tag_id': tag_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _restore_tag_serialize(
        self,
        tag_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tag_id is not None:
            _path_params['tag_id'] = tag_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/systems/configurations/snapshots/tags/{tag_id}:restore',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def revoke_all_personal_access_tokens(
        self,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> object:

        """
        This method revokes all personal access tokens.

        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._revoke_all_personal_access_tokens_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: object = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.revoke_all_personal_access_tokens # type: ignore[assignment]
            list_args: Dict[str, Any] = {
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _revoke_all_personal_access_tokens_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v2/pat',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def search_resources(
        self,
        full_text_search: FullTextSearch,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> PageTypeVarCustomizedResourceSearchItem:

        """
        This method does a full text search on resources.

        :param full_text_search: (required)
        :type full_text_search: FullTextSearch
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._search_resources_serialize(
            full_text_search=full_text_search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PageTypeVarCustomizedResourceSearchItem",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: PageTypeVarCustomizedResourceSearchItem = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.search_resources # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'full_text_search': full_text_search,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _search_resources_serialize(
        self,
        full_text_search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if full_text_search is not None:
            _body_params = full_text_search


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/resources/search',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def set_agent_status_retention_policy(
        self,
        new_agent_status_retention_duration: NewAgentStatusRetentionDuration,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AgentStatusRetentionDuration:

        """
        This method sets status retention policy duration in the registry for all agents

        :param new_agent_status_retention_duration: (required)
        :type new_agent_status_retention_duration: NewAgentStatusRetentionDuration
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._set_agent_status_retention_policy_serialize(
            new_agent_status_retention_duration=new_agent_status_retention_duration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AgentStatusRetentionDuration",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AgentStatusRetentionDuration = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.set_agent_status_retention_policy # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'new_agent_status_retention_duration': new_agent_status_retention_duration,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _set_agent_status_retention_policy_serialize(
        self,
        new_agent_status_retention_duration,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_agent_status_retention_duration is not None:
            _body_params = new_agent_status_retention_duration


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/agents/status/retention_policy',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def sync_upstream_remotes(
        self,
        create_upstream_remote_sync: CreateUpstreamRemoteSync,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> UpstreamRemoteSync:

        """
        This method triggers a data sync with an upstream remote.

        :param create_upstream_remote_sync: (required)
        :type create_upstream_remote_sync: CreateUpstreamRemoteSync
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._sync_upstream_remotes_serialize(
            create_upstream_remote_sync=create_upstream_remote_sync,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpstreamRemoteSync",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: UpstreamRemoteSync = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.sync_upstream_remotes # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'create_upstream_remote_sync': create_upstream_remote_sync,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _sync_upstream_remotes_serialize(
        self,
        create_upstream_remote_sync,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_upstream_remote_sync is not None:
            _body_params = create_upstream_remote_sync


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/upstream-remotes/sync',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def transfer_revision_to_existing_artifact(
        self,
        revision_id: Annotated[StrictStr, Field(description="The id of the revision to transfer")],
        artifact_id: Annotated[StrictStr, Field(description="The id of the artifact to transfer the revision to")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> FileRevision:

        """
        This method transfers a revision to an existing artifact. The original revision that was copied will be archived and no longer active.

        :param revision_id: The id of the revision to transfer (required)
        :type revision_id: str
        :param artifact_id: The id of the artifact to transfer the revision to (required)
        :type artifact_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._transfer_revision_to_existing_artifact_serialize(
            revision_id=revision_id,
            artifact_id=artifact_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FileRevision",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: FileRevision = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.transfer_revision_to_existing_artifact # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'revision_id': revision_id,
                'artifact_id': artifact_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _transfer_revision_to_existing_artifact_serialize(
        self,
        revision_id,
        artifact_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if revision_id is not None:
            _path_params['revision_id'] = revision_id
        if artifact_id is not None:
            _path_params['artifact_id'] = artifact_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/revisions/{revision_id}/transfer/artifact/{artifact_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def transfer_revision_to_existing_file(
        self,
        revision_id: Annotated[StrictStr, Field(description="The id of the revision to transfer")],
        file_id: Annotated[StrictStr, Field(description="The id of the file to transfer the revision to")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> File:

        """
        This method transfers a file revision to an existing file. The original revision that was copied will be archived and no longer active.

        :param revision_id: The id of the revision to transfer (required)
        :type revision_id: str
        :param file_id: The id of the file to transfer the revision to (required)
        :type file_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._transfer_revision_to_existing_file_serialize(
            revision_id=revision_id,
            file_id=file_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "File",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: File = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.transfer_revision_to_existing_file # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'revision_id': revision_id,
                'file_id': file_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _transfer_revision_to_existing_file_serialize(
        self,
        revision_id,
        file_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if revision_id is not None:
            _path_params['revision_id'] = revision_id
        if file_id is not None:
            _path_params['file_id'] = file_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/revisions/{revision_id}/transfer/file/{file_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def transfer_revision_to_new_artifact(
        self,
        revision_id: Annotated[StrictStr, Field(description="The id of the revision to transfer")],
        model_id: Annotated[StrictStr, Field(description="The id of the model to transfer the revision to")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> FileRevision:

        """
        This method transfers a revision to a new artifact. The original revision that was copied will be archived and no longer active.

        :param revision_id: The id of the revision to transfer (required)
        :type revision_id: str
        :param model_id: The id of the model to transfer the revision to (required)
        :type model_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._transfer_revision_to_new_artifact_serialize(
            revision_id=revision_id,
            model_id=model_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FileRevision",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: FileRevision = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.transfer_revision_to_new_artifact # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'revision_id': revision_id,
                'model_id': model_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _transfer_revision_to_new_artifact_serialize(
        self,
        revision_id,
        model_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if revision_id is not None:
            _path_params['revision_id'] = revision_id
        if model_id is not None:
            _path_params['model_id'] = model_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/revisions/{revision_id}/transfer/model/{model_id}/artifact',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def transfer_revision_to_new_file(
        self,
        revision_id: Annotated[StrictStr, Field(description="The id of the revision to transfer")],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> File:

        """
        This method transfers a file revision to a new file. The original revision that was copied will be archived and no longer active.

        :param revision_id: The id of the revision to transfer (required)
        :type revision_id: str
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._transfer_revision_to_new_file_serialize(
            revision_id=revision_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "File",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: File = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.transfer_revision_to_new_file # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'revision_id': revision_id,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _transfer_revision_to_new_file_serialize(
        self,
        revision_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if revision_id is not None:
            _path_params['revision_id'] = revision_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v2/revisions/{revision_id}/transfer/file',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_access(
        self,
        subject_type: Annotated[AccessSubjectType, Field(description="The type of the subject to update.")],
        subject_id: Annotated[StrictStr, Field(description="The id of the subject to update.")],
        resource_type: Annotated[AccessResourceType, Field(description="The type of the resource to update.")],
        resource_id: Annotated[StrictStr, Field(description="The id of the resource to update.")],
        update_access_relationship: UpdateAccessRelationship,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AccessRelationship:

        """
        This method updates access to a resource or file.

        :param subject_type: The type of the subject to update. (required)
        :type subject_type: AccessSubjectType
        :param subject_id: The id of the subject to update. (required)
        :type subject_id: str
        :param resource_type: The type of the resource to update. (required)
        :type resource_type: AccessResourceType
        :param resource_id: The id of the resource to update. (required)
        :type resource_id: str
        :param update_access_relationship: (required)
        :type update_access_relationship: UpdateAccessRelationship
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_access_serialize(
            subject_type=subject_type,
            subject_id=subject_id,
            resource_type=resource_type,
            resource_id=resource_id,
            update_access_relationship=update_access_relationship,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AccessRelationship",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AccessRelationship = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_access # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'subject_type': subject_type,
                'subject_id': subject_id,
                'resource_type': resource_type,
                'resource_id': resource_id,
                'update_access_relationship': update_access_relationship,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_access_serialize(
        self,
        subject_type,
        subject_id,
        resource_type,
        resource_id,
        update_access_relationship,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if subject_type is not None:
            _path_params['subject_type'] = subject_type.value
        if subject_id is not None:
            _path_params['subject_id'] = subject_id
        if resource_type is not None:
            _path_params['resource_type'] = resource_type.value
        if resource_id is not None:
            _path_params['resource_id'] = resource_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_access_relationship is not None:
            _body_params = update_access_relationship


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/access/{subject_type}/{subject_id}/{resource_type}/{resource_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_access_for_resource_type(
        self,
        subject_type: Annotated[AccessSubjectType, Field(description="The type of the subject to update.")],
        subject_id: Annotated[StrictStr, Field(description="The id of the subject to update.")],
        resource_type: Annotated[AccessResourceType, Field(description="The type of the resources to update.")],
        update_access_relationship_list: UpdateAccessRelationshipList,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> List[AccessRelationship]:

        """
        This method updates access to resources of a type.

        :param subject_type: The type of the subject to update. (required)
        :type subject_type: AccessSubjectType
        :param subject_id: The id of the subject to update. (required)
        :type subject_id: str
        :param resource_type: The type of the resources to update. (required)
        :type resource_type: AccessResourceType
        :param update_access_relationship_list: (required)
        :type update_access_relationship_list: UpdateAccessRelationshipList
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_access_for_resource_type_serialize(
            subject_type=subject_type,
            subject_id=subject_id,
            resource_type=resource_type,
            update_access_relationship_list=update_access_relationship_list,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AccessRelationship]",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: List[AccessRelationship] = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_access_for_resource_type # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'subject_type': subject_type,
                'subject_id': subject_id,
                'resource_type': resource_type,
                'update_access_relationship_list': update_access_relationship_list,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_access_for_resource_type_serialize(
        self,
        subject_type,
        subject_id,
        resource_type,
        update_access_relationship_list,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if subject_type is not None:
            _path_params['subject_type'] = subject_type.value
        if subject_id is not None:
            _path_params['subject_id'] = subject_id
        if resource_type is not None:
            _path_params['resource_type'] = resource_type.value
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_access_relationship_list is not None:
            _body_params = update_access_relationship_list


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/access/{subject_type}/{subject_id}/{resource_type}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_agent_display_name(
        self,
        agent_id: Annotated[StrictStr, Field(description="The ID of the agent to update.")],
        new_agent_display_name: NewAgentDisplayName,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Agent:

        """
        This method updates an agent's display name.

        :param agent_id: The ID of the agent to update. (required)
        :type agent_id: str
        :param new_agent_display_name: (required)
        :type new_agent_display_name: NewAgentDisplayName
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_agent_display_name_serialize(
            agent_id=agent_id,
            new_agent_display_name=new_agent_display_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Agent",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Agent = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_agent_display_name # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_id': agent_id,
                'new_agent_display_name': new_agent_display_name,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_agent_display_name_serialize(
        self,
        agent_id,
        new_agent_display_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_id is not None:
            _path_params['agent_id'] = agent_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_agent_display_name is not None:
            _body_params = new_agent_display_name


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/agents/{agent_id}/display_name',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_agent_information(
        self,
        agent_id: Annotated[StrictStr, Field(description="The ID of the agent to update.")],
        new_agent_information: NewAgentInformation,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Agent:

        """
        This method updates an agent's information.

        :param agent_id: The ID of the agent to update. (required)
        :type agent_id: str
        :param new_agent_information: (required)
        :type new_agent_information: NewAgentInformation
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_agent_information_serialize(
            agent_id=agent_id,
            new_agent_information=new_agent_information,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Agent",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Agent = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_agent_information # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_id': agent_id,
                'new_agent_information': new_agent_information,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_agent_information_serialize(
        self,
        agent_id,
        new_agent_information,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_id is not None:
            _path_params['agent_id'] = agent_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_agent_information is not None:
            _body_params = new_agent_information


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/agents/{agent_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_agent_modules(
        self,
        agent_id: Annotated[StrictStr, Field(description="The ID of the agent to update.")],
        new_agent_module_version: List[NewAgentModuleVersion],
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Agent:

        """
        This method updates an agent's loaded modules.

        :param agent_id: The ID of the agent to update. (required)
        :type agent_id: str
        :param new_agent_module_version: (required)
        :type new_agent_module_version: List[NewAgentModuleVersion]
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_agent_modules_serialize(
            agent_id=agent_id,
            new_agent_module_version=new_agent_module_version,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Agent",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Agent = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_agent_modules # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_id': agent_id,
                'new_agent_module_version': new_agent_module_version,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_agent_modules_serialize(
        self,
        agent_id,
        new_agent_module_version,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'NewAgentModuleVersion': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_id is not None:
            _path_params['agent_id'] = agent_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_agent_module_version is not None:
            _body_params = new_agent_module_version


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/agents/{agent_id}/modules',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_agent_pool(
        self,
        agent_pool_id: Annotated[StrictStr, Field(description="The id of the agent pool to update")],
        new_agent_pool: NewAgentPool,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AgentPool:

        """
        This method updates an agent pool's information.

        :param agent_pool_id: The id of the agent pool to update (required)
        :type agent_pool_id: str
        :param new_agent_pool: (required)
        :type new_agent_pool: NewAgentPool
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_agent_pool_serialize(
            agent_pool_id=agent_pool_id,
            new_agent_pool=new_agent_pool,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AgentPool",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AgentPool = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_agent_pool # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_pool_id': agent_pool_id,
                'new_agent_pool': new_agent_pool,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_agent_pool_serialize(
        self,
        agent_pool_id,
        new_agent_pool,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_pool_id is not None:
            _path_params['agent_pool_id'] = agent_pool_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_agent_pool is not None:
            _body_params = new_agent_pool


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/agent_pools/{agent_pool_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_agent_pool_agent(
        self,
        agent_pool_id: Annotated[StrictStr, Field(description="The id of the agent pool to update")],
        new_agent_pool_agent_membership: NewAgentPoolAgentMembership,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AgentPool:

        """
        This method adds or updates an agent's membership in an agent pool.

        :param agent_pool_id: The id of the agent pool to update (required)
        :type agent_pool_id: str
        :param new_agent_pool_agent_membership: (required)
        :type new_agent_pool_agent_membership: NewAgentPoolAgentMembership
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_agent_pool_agent_serialize(
            agent_pool_id=agent_pool_id,
            new_agent_pool_agent_membership=new_agent_pool_agent_membership,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AgentPool",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AgentPool = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_agent_pool_agent # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_pool_id': agent_pool_id,
                'new_agent_pool_agent_membership': new_agent_pool_agent_membership,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_agent_pool_agent_serialize(
        self,
        agent_pool_id,
        new_agent_pool_agent_membership,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_pool_id is not None:
            _path_params['agent_pool_id'] = agent_pool_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_agent_pool_agent_membership is not None:
            _body_params = new_agent_pool_agent_membership


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/agent_pools/{agent_pool_id}/agents',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_agent_pool_user(
        self,
        agent_pool_id: Annotated[StrictStr, Field(description="The id of the agent pool to update")],
        new_agent_pool_user_membership: NewAgentPoolUserMembership,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AgentPool:

        """
        This method adds or updates a user's membership in an agent pool.

        :param agent_pool_id: The id of the agent pool to update (required)
        :type agent_pool_id: str
        :param new_agent_pool_user_membership: (required)
        :type new_agent_pool_user_membership: NewAgentPoolUserMembership
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_agent_pool_user_serialize(
            agent_pool_id=agent_pool_id,
            new_agent_pool_user_membership=new_agent_pool_user_membership,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AgentPool",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AgentPool = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_agent_pool_user # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_pool_id': agent_pool_id,
                'new_agent_pool_user_membership': new_agent_pool_user_membership,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_agent_pool_user_serialize(
        self,
        agent_pool_id,
        new_agent_pool_user_membership,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_pool_id is not None:
            _path_params['agent_pool_id'] = agent_pool_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_agent_pool_user_membership is not None:
            _body_params = new_agent_pool_user_membership


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/agent_pools/{agent_pool_id}/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_agent_status(
        self,
        agent_id: Annotated[StrictStr, Field(description="The ID of the agent to update.")],
        new_agent_status: NewAgentStatus,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Agent:

        """
        This method updates an agent's status.

        :param agent_id: The ID of the agent to update. (required)
        :type agent_id: str
        :param new_agent_status: (required)
        :type new_agent_status: NewAgentStatus
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_agent_status_serialize(
            agent_id=agent_id,
            new_agent_status=new_agent_status,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Agent",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Agent = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_agent_status # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'agent_id': agent_id,
                'new_agent_status': new_agent_status,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_agent_status_serialize(
        self,
        agent_id,
        new_agent_status,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if agent_id is not None:
            _path_params['agent_id'] = agent_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_agent_status is not None:
            _body_params = new_agent_status


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/agents/{agent_id}/status',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_app_integration(
        self,
        app_integration_id: Annotated[StrictStr, Field(description="ID of the data integration to update. This is a required field.")],
        new_app_integration: NewAppIntegration,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> AppIntegration:

        """
        This method updates a data integration.

        :param app_integration_id: ID of the data integration to update. This is a required field. (required)
        :type app_integration_id: str
        :param new_app_integration: (required)
        :type new_app_integration: NewAppIntegration
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_app_integration_serialize(
            app_integration_id=app_integration_id,
            new_app_integration=new_app_integration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AppIntegration",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: AppIntegration = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_app_integration # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'app_integration_id': app_integration_id,
                'new_app_integration': new_app_integration,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_app_integration_serialize(
        self,
        app_integration_id,
        new_app_integration,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if app_integration_id is not None:
            _path_params['app_integration_id'] = app_integration_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_app_integration is not None:
            _body_params = new_app_integration


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/app_integrations/{app_integration_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_author(
        self,
        author_id: Annotated[StrictStr, Field(description="The author ID to update.")],
        new_module_author: NewModuleAuthor,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> ModuleAuthor:

        """
        This method updates an author.

        :param author_id: The author ID to update. (required)
        :type author_id: str
        :param new_module_author: (required)
        :type new_module_author: NewModuleAuthor
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_author_serialize(
            author_id=author_id,
            new_module_author=new_module_author,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ModuleAuthor",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: ModuleAuthor = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_author # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'author_id': author_id,
                'new_module_author': new_module_author,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_author_serialize(
        self,
        author_id,
        new_module_author,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if author_id is not None:
            _path_params['author_id'] = author_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_module_author is not None:
            _body_params = new_module_author


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/author/{author_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_control_tag(
        self,
        update_control_tag: UpdateControlTag,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> ControlTag:

        """
        This method updates an existing control tag.

        :param update_control_tag: (required)
        :type update_control_tag: UpdateControlTag
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_control_tag_serialize(
            update_control_tag=update_control_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ControlTag",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: ControlTag = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_control_tag # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'update_control_tag': update_control_tag,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_control_tag_serialize(
        self,
        update_control_tag,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_control_tag is not None:
            _body_params = update_control_tag


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/v2/controls/tags',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_document(
        self,
        document_id: Annotated[StrictStr, Field(description="The ID of the document to update.")],
        update_document_request: UpdateDocumentRequest,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Document:

        """
        Update a document.

        :param document_id: The ID of the document to update. (required)
        :type document_id: str
        :param update_document_request: (required)
        :type update_document_request: UpdateDocumentRequest
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_document_serialize(
            document_id=document_id,
            update_document_request=update_document_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Document",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Document = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_document # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'document_id': document_id,
                'update_document_request': update_document_request,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_document_serialize(
        self,
        document_id,
        update_document_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if document_id is not None:
            _path_params['document_id'] = document_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_document_request is not None:
            _body_params = update_document_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/documents/{document_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_job_assigned_agent(
        self,
        job_id: Annotated[StrictStr, Field(description="The id of the job to update the assigned agent for.")],
        new_job_assigned_agent: NewJobAssignedAgent,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Job:

        """
        This method updates the assigned agent for a job.

        :param job_id: The id of the job to update the assigned agent for. (required)
        :type job_id: str
        :param new_job_assigned_agent: (required)
        :type new_job_assigned_agent: NewJobAssignedAgent
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_job_assigned_agent_serialize(
            job_id=job_id,
            new_job_assigned_agent=new_job_assigned_agent,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Job = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_job_assigned_agent # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'job_id': job_id,
                'new_job_assigned_agent': new_job_assigned_agent,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_job_assigned_agent_serialize(
        self,
        job_id,
        new_job_assigned_agent,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['job_id'] = job_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_job_assigned_agent is not None:
            _body_params = new_job_assigned_agent


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/jobs/{job_id}/assigned_agent',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_job_status(
        self,
        job_id: Annotated[StrictStr, Field(description="The id of the job to update")],
        status_name: Annotated[JobStatusName, Field(description="The new status name to update the job with.")],
        agent_id: Annotated[Optional[StrictStr], Field(description="An optional id for the agent.")] = None,
        job_status_message: Optional[JobStatusMessage] = None,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Job:

        """
        This method updates the status of a job.

        :param job_id: The id of the job to update (required)
        :type job_id: str
        :param status_name: The new status name to update the job with. (required)
        :type status_name: JobStatusName
        :param agent_id: An optional id for the agent.
        :type agent_id: str
        :param job_status_message:
        :type job_status_message: JobStatusMessage
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_job_status_serialize(
            job_id=job_id,
            status_name=status_name,
            agent_id=agent_id,
            job_status_message=job_status_message,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Job",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Job = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_job_status # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'job_id': job_id,
                'status_name': status_name,
                'agent_id': agent_id,
                'job_status_message': job_status_message,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_job_status_serialize(
        self,
        job_id,
        status_name,
        agent_id,
        job_status_message,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['job_id'] = job_id
        # process the query parameters
        if status_name is not None:

            _query_params.append(('status_name', status_name.value))

        if agent_id is not None:

            _query_params.append(('agent_id', agent_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if job_status_message is not None:
            _body_params = job_status_message


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/jobs/{job_id}/status',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_operating_system(
        self,
        operating_system_id: Annotated[StrictStr, Field(description="The id of the operating system to update.")],
        new_operating_system: NewOperatingSystem,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> OperatingSystem:

        """
        This method updates an existing operating system.

        :param operating_system_id: The id of the operating system to update. (required)
        :type operating_system_id: str
        :param new_operating_system: (required)
        :type new_operating_system: NewOperatingSystem
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_operating_system_serialize(
            operating_system_id=operating_system_id,
            new_operating_system=new_operating_system,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OperatingSystem",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: OperatingSystem = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_operating_system # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'operating_system_id': operating_system_id,
                'new_operating_system': new_operating_system,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_operating_system_serialize(
        self,
        operating_system_id,
        new_operating_system,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if operating_system_id is not None:
            _path_params['operating_system_id'] = operating_system_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if new_operating_system is not None:
            _body_params = new_operating_system


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/modules/operatingsystems/{operating_system_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_system(
        self,
        system_id: Annotated[StrictStr, Field(description="The id of the system to update.")],
        update_system: UpdateSystem,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> System:

        """
        This method updates an existing system.

        :param system_id: The id of the system to update. (required)
        :type system_id: str
        :param update_system: (required)
        :type update_system: UpdateSystem
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_system_serialize(
            system_id=system_id,
            update_system=update_system,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "System",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: System = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_system # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'system_id': system_id,
                'update_system': update_system,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_system_serialize(
        self,
        system_id,
        update_system,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if system_id is not None:
            _path_params['system_id'] = system_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_system is not None:
            _body_params = update_system


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/systems/{system_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_tag(
        self,
        tag_id: Annotated[StrictStr, Field(description="The id of the tag to update.")],
        update_tag: UpdateTag,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> SnapshotTag:

        """
        This method updates an existing snapshot tag by moving it to a different snapshot.

        :param tag_id: The id of the tag to update. (required)
        :type tag_id: str
        :param update_tag: (required)
        :type update_tag: UpdateTag
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_tag_serialize(
            tag_id=tag_id,
            update_tag=update_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SnapshotTag",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: SnapshotTag = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_tag # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'tag_id': tag_id,
                'update_tag': update_tag,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_tag_serialize(
        self,
        tag_id,
        update_tag,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tag_id is not None:
            _path_params['tag_id'] = tag_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_tag is not None:
            _body_params = update_tag


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/systems/configurations/snapshots/tags/{tag_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )

    @validate_call
    @log_method
    def update_tool(
        self,
        tool_id: Annotated[StrictStr, Field(description="The ID of the tool to update.")],
        update_tool: UpdateTool,
        http_request_timeout_secs: Annotated[StrictInt | None, Field(ge=0)] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0
    ) -> Tool:

        """
        This method updates a tool.

        :param tool_id: The ID of the tool to update. (required)
        :type tool_id: str
        :param update_tool: (required)
        :type update_tool: UpdateTool
        :param http_request_timeout_secs: timeout setting for this request
        :type http_request_timeout_secs: int, optional

        """ # noqa: E501

        _param = self._update_tool_serialize(
            tool_id=tool_id,
            update_tool=update_tool,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Tool",
            '422': "HTTPValidationError",
        }

        request_timeout = (
            http_request_timeout_secs if http_request_timeout_secs is not None
            else self.config.http_request_timeout_secs
        )
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=request_timeout,
        )
        response_data.read()

        resp_obj: Tool = self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

        if isinstance(resp_obj, ClientHaving):
            resp_obj.client = self

        if isinstance(resp_obj, Pageable):
            resp_obj._list_method = self.update_tool # type: ignore[assignment]
            list_args: Dict[str, Any] = {
                'tool_id': tool_id,
                'update_tool': update_tool,
            }
            resp_obj._list_method_args = list_args

        return resp_obj

    def _update_tool_serialize(
        self,
        tool_id,
        update_tool,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tool_id is not None:
            _path_params['tool_id'] = tool_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_tool is not None:
            _body_params = update_tool


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'RequestAuthenticator'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v2/tools/{tool_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )
