from typing_extensions import Literal, TypeAlias

_AtomicToken: TypeAlias = Literal[0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
_ManifestIndex: TypeAlias = int
_ElementIndex: TypeAlias = int
_TypeIndex: TypeAlias = int
_FunctionIndex: TypeAlias = int
_FunctionWrapperIndex: TypeAlias = int
_MakeSeqIndex: TypeAlias = int

def interrogate_add_search_directory(dirname: str) -> None: ...
def interrogate_add_search_path(pathstring: str) -> None: ...
def interrogate_element_comment(element: _ElementIndex) -> str: ...
def interrogate_element_getter(element: _ElementIndex) -> _FunctionIndex: ...
def interrogate_element_has_comment(element: _ElementIndex) -> bool: ...
def interrogate_element_has_getter(element: _ElementIndex) -> bool: ...
def interrogate_element_has_setter(element: _ElementIndex) -> bool: ...
def interrogate_element_is_mapping(element: _ElementIndex) -> bool: ...
def interrogate_element_is_sequence(element: _ElementIndex) -> bool: ...
def interrogate_element_name(element: _ElementIndex) -> str: ...
def interrogate_element_scoped_name(element: _ElementIndex) -> str: ...
def interrogate_element_setter(element: _ElementIndex) -> _FunctionIndex: ...
def interrogate_element_type(element: _ElementIndex) -> _TypeIndex: ...
def interrogate_error_flag() -> bool: ...
def interrogate_function_c_wrapper(function: _FunctionIndex, n: int) -> _FunctionWrapperIndex: ...
def interrogate_function_class(function: _FunctionIndex) -> _TypeIndex: ...
def interrogate_function_comment(function: _FunctionIndex) -> str: ...
def interrogate_function_has_comment(function: _FunctionIndex) -> bool: ...
def interrogate_function_has_library_name(function: _FunctionIndex) -> bool: ...
def interrogate_function_has_module_name(function: _FunctionIndex) -> bool: ...
def interrogate_function_is_constructor(function: _FunctionIndex) -> bool: ...
def interrogate_function_is_destructor(function: _FunctionIndex) -> bool: ...
def interrogate_function_is_method(function: _FunctionIndex) -> bool: ...
def interrogate_function_is_operator_typecast(function: _FunctionIndex) -> bool: ...
def interrogate_function_is_unary_op(function: _FunctionIndex) -> bool: ...
def interrogate_function_is_virtual(function: _FunctionIndex) -> bool: ...
def interrogate_function_library_name(function: _FunctionIndex) -> str: ...
def interrogate_function_module_name(function: _FunctionIndex) -> str: ...
def interrogate_function_name(function: _FunctionIndex) -> str: ...
def interrogate_function_number_of_c_wrappers(function: _FunctionIndex) -> int: ...
def interrogate_function_number_of_python_wrappers(function: _FunctionIndex) -> int: ...
def interrogate_function_prototype(function: _FunctionIndex) -> str: ...
def interrogate_function_python_wrapper(function: _FunctionIndex, n: int) -> _FunctionWrapperIndex: ...
def interrogate_function_scoped_name(function: _FunctionIndex) -> str: ...
def interrogate_get_element_by_name(element_name: str) -> _ElementIndex: ...
def interrogate_get_element_by_scoped_name(element_name: str) -> _ElementIndex: ...
def interrogate_get_function(n: int) -> _FunctionIndex: ...
def interrogate_get_global(n: int) -> _ElementIndex: ...
def interrogate_get_global_function(n: int) -> _FunctionIndex: ...
def interrogate_get_global_type(n: int) -> _TypeIndex: ...
def interrogate_get_manifest(n: int) -> _ManifestIndex: ...
def interrogate_get_manifest_by_name(manifest_name: str) -> _ManifestIndex: ...
def interrogate_get_type(n: int) -> _TypeIndex: ...
def interrogate_get_type_by_name(type_name: str) -> _TypeIndex: ...
def interrogate_get_type_by_scoped_name(type_name: str) -> _TypeIndex: ...
def interrogate_get_type_by_true_name(type_name: str) -> _TypeIndex: ...
def interrogate_get_wrapper_by_unique_name(unique_name: str) -> _FunctionWrapperIndex: ...
def interrogate_make_seq_comment(make_seq: _MakeSeqIndex) -> str: ...
def interrogate_make_seq_element_name(make_seq: _MakeSeqIndex) -> str: ...
def interrogate_make_seq_element_getter(make_seq: _MakeSeqIndex) -> _FunctionIndex: ...
def interrogate_make_seq_has_comment(make_seq: _MakeSeqIndex) -> bool: ...
def interrogate_make_seq_num_getter(make_seq: _MakeSeqIndex) -> _FunctionIndex: ...
def interrogate_make_seq_num_name(make_seq: _MakeSeqIndex) -> str: ...
def interrogate_make_seq_scoped_name(make_seq: _MakeSeqIndex) -> str: ...
def interrogate_make_seq_seq_name(make_seq: _MakeSeqIndex) -> str: ...
def interrogate_manifest_definition(manifest: _ManifestIndex) -> str: ...
def interrogate_manifest_get_int_value(manifest: _ManifestIndex) -> int: ...
def interrogate_manifest_get_type(manifest: _ManifestIndex) -> _TypeIndex: ...
def interrogate_manifest_getter(manifest: _ManifestIndex) -> _FunctionIndex: ...
def interrogate_manifest_has_getter(manifest: _ManifestIndex) -> bool: ...
def interrogate_manifest_has_int_value(manifest: _ManifestIndex) -> bool: ...
def interrogate_manifest_has_type(manifest: _ManifestIndex) -> bool: ...
def interrogate_manifest_name(manifest: _ManifestIndex) -> str: ...
def interrogate_number_of_functions() -> int: ...
def interrogate_number_of_global_functions() -> int: ...
def interrogate_number_of_global_types() -> int: ...
def interrogate_number_of_globals() -> int: ...
def interrogate_number_of_manifests() -> int: ...
def interrogate_number_of_types() -> int: ...
def interrogate_request_database(database_filename: str) -> None: ...
def interrogate_request_module(def_: int) -> None: ...
def interrogate_type_array_size(type: _TypeIndex) -> int: ...
def interrogate_type_atomic_token(type: _TypeIndex) -> _AtomicToken: ...
def interrogate_type_comment(type: _TypeIndex) -> str: ...
def interrogate_type_derivation_downcast_is_impossible(type: _TypeIndex, n: int) -> bool: ...
def interrogate_type_derivation_has_downcast(type: _TypeIndex, n: int) -> bool: ...
def interrogate_type_derivation_has_upcast(type: _TypeIndex, n: int) -> bool: ...
def interrogate_type_destructor_is_inherited(type: _TypeIndex) -> bool: ...
def interrogate_type_enum_value(type: _TypeIndex, n: int) -> int: ...
def interrogate_type_enum_value_comment(type: _TypeIndex, n: int) -> str: ...
def interrogate_type_enum_value_name(type: _TypeIndex, n: int) -> str: ...
def interrogate_type_enum_value_scoped_name(type: _TypeIndex, n: int) -> str: ...
def interrogate_type_get_cast(type: _TypeIndex, n: int) -> _FunctionIndex: ...
def interrogate_type_get_constructor(type: _TypeIndex, n: int) -> _FunctionIndex: ...
def interrogate_type_get_derivation(type: _TypeIndex, n: int) -> _TypeIndex: ...
def interrogate_type_get_destructor(type: _TypeIndex) -> _FunctionIndex: ...
def interrogate_type_get_downcast(type: _TypeIndex, n: int) -> _FunctionIndex: ...
def interrogate_type_get_element(type: _TypeIndex, n: int) -> _ElementIndex: ...
def interrogate_type_get_make_seq(type: _TypeIndex, n: int) -> _MakeSeqIndex: ...
def interrogate_type_get_method(type: _TypeIndex, n: int) -> _FunctionIndex: ...
def interrogate_type_get_nested_type(type: _TypeIndex, n: int) -> _TypeIndex: ...
def interrogate_type_get_upcast(type: _TypeIndex, n: int) -> _FunctionIndex: ...
def interrogate_type_has_comment(type: _TypeIndex) -> bool: ...
def interrogate_type_has_destructor(type: _TypeIndex) -> bool: ...
def interrogate_type_has_library_name(type: _TypeIndex) -> bool: ...
def interrogate_type_has_module_name(type: _TypeIndex) -> bool: ...
def interrogate_type_is_array(type: _TypeIndex) -> bool: ...
def interrogate_type_is_atomic(type: _TypeIndex) -> bool: ...
def interrogate_type_is_class(type: _TypeIndex) -> bool: ...
def interrogate_type_is_const(type: _TypeIndex) -> bool: ...
def interrogate_type_is_enum(type: _TypeIndex) -> bool: ...
def interrogate_type_is_final(type: _TypeIndex) -> bool: ...
def interrogate_type_is_fully_defined(type: _TypeIndex) -> bool: ...
def interrogate_type_is_global(type: _TypeIndex) -> bool: ...
def interrogate_type_is_long(type: _TypeIndex) -> bool: ...
def interrogate_type_is_longlong(type: _TypeIndex) -> bool: ...
def interrogate_type_is_nested(type: _TypeIndex) -> bool: ...
def interrogate_type_is_pointer(type: _TypeIndex) -> bool: ...
def interrogate_type_is_scoped_enum(type: _TypeIndex) -> bool: ...
def interrogate_type_is_short(type: _TypeIndex) -> bool: ...
def interrogate_type_is_signed(type: _TypeIndex) -> bool: ...
def interrogate_type_is_struct(type: _TypeIndex) -> bool: ...
def interrogate_type_is_typedef(type: _TypeIndex) -> bool: ...
def interrogate_type_is_union(type: _TypeIndex) -> bool: ...
def interrogate_type_is_unpublished(type: _TypeIndex) -> bool: ...
def interrogate_type_is_unsigned(type: _TypeIndex) -> bool: ...
def interrogate_type_is_wrapped(type: _TypeIndex) -> bool: ...
def interrogate_type_library_name(type: _TypeIndex) -> str: ...
def interrogate_type_module_name(type: _TypeIndex) -> str: ...
def interrogate_type_name(type: _TypeIndex) -> str: ...
def interrogate_type_number_of_casts(type: _TypeIndex) -> int: ...
def interrogate_type_number_of_constructors(type: _TypeIndex) -> int: ...
def interrogate_type_number_of_derivations(type: _TypeIndex) -> int: ...
def interrogate_type_number_of_elements(type: _TypeIndex) -> int: ...
def interrogate_type_number_of_enum_values(type: _TypeIndex) -> int: ...
def interrogate_type_number_of_make_seqs(type: _TypeIndex) -> int: ...
def interrogate_type_number_of_methods(type: _TypeIndex) -> int: ...
def interrogate_type_number_of_nested_types(type: _TypeIndex) -> int: ...
def interrogate_type_outer_class(type: _TypeIndex) -> _TypeIndex: ...
def interrogate_type_scoped_name(type: _TypeIndex) -> str: ...
def interrogate_type_true_name(type: _TypeIndex) -> str: ...
def interrogate_type_wrapped_type(type: _TypeIndex) -> _TypeIndex: ...
def interrogate_wrapper_caller_manages_return_value(wrapper: _FunctionWrapperIndex) -> bool: ...
def interrogate_wrapper_comment(wrapper: _FunctionWrapperIndex) -> str: ...
def interrogate_wrapper_has_comment(wrapper: _FunctionWrapperIndex) -> bool: ...
def interrogate_wrapper_has_pointer(wrapper: _FunctionWrapperIndex) -> bool: ...
def interrogate_wrapper_has_return_value(wrapper: _FunctionWrapperIndex) -> bool: ...
def interrogate_wrapper_is_callable_by_name(wrapper: _FunctionWrapperIndex) -> bool: ...
def interrogate_wrapper_name(wrapper: _FunctionWrapperIndex) -> str: ...
def interrogate_wrapper_number_of_parameters(wrapper: _FunctionWrapperIndex) -> int: ...
def interrogate_wrapper_parameter_has_name(wrapper: _FunctionWrapperIndex, n: int) -> bool: ...
def interrogate_wrapper_parameter_is_optional(wrapper: _FunctionWrapperIndex, n: int) -> bool: ...
def interrogate_wrapper_parameter_is_this(wrapper: _FunctionWrapperIndex, n: int) -> bool: ...
def interrogate_wrapper_parameter_name(wrapper: _FunctionWrapperIndex, n: int) -> str: ...
def interrogate_wrapper_parameter_type(wrapper: _FunctionWrapperIndex, n: int) -> _TypeIndex: ...
def interrogate_wrapper_pointer(wrapper: _FunctionWrapperIndex) -> None: ...
def interrogate_wrapper_return_type(wrapper: _FunctionWrapperIndex) -> _TypeIndex: ...
def interrogate_wrapper_return_value_destructor(wrapper: _FunctionWrapperIndex) -> _FunctionIndex: ...
def interrogate_wrapper_unique_name(wrapper: _FunctionWrapperIndex) -> str: ...
