from collections.abc import Iterable
from typing import ClassVar, NoReturn

from direct.directnotify.Notifier import Notifier
from .DirectObject import DirectObject
from .ObjectPool import Diff, ObjectPool

class ExclusiveObjectPool(DirectObject):
    @classmethod
    def addExclObjs(cls, *objs: object) -> None: ...
    @classmethod
    def removeExclObjs(cls, *objs: object) -> None: ...
    def __init__(self, objects: Iterable[object]) -> None: ...
    def destroy(self) -> None: ...
    def getObjsOfType(self, type: type) -> NoReturn: ...
    def printObjsOfType(self, type: type) -> NoReturn: ...
    def diff(self, other: ExclusiveObjectPool) -> NoReturn: ...
    def typeFreqStr(self) -> NoReturn: ...
    def __len__(self) -> NoReturn: ...

class ObjectReport:
    notify: ClassVar[Notifier]
    def __init__(self, name: str, log: bool = ...) -> None: ...
    def destroy(self) -> None: ...
    def typeFreqStr(self) -> str: ...
    def diff(self, other: ObjectReport) -> Diff: ...
    def getObjectPool(self) -> ObjectPool: ...
