__all__ = ['Diff', 'ObjectPool']

from collections.abc import Iterable
from typing import Any, ClassVar, TypeVar, overload

from direct.directnotify.Notifier import Notifier

_T = TypeVar('_T')

class Diff:
    lost: ObjectPool
    gained: ObjectPool
    def __init__(self, lost: ObjectPool, gained: ObjectPool) -> None: ...
    def printOut(self, full: bool = ...) -> None: ...

class ObjectPool:
    notify: ClassVar[Notifier]
    def __init__(self, objects: Iterable[object]) -> None: ...
    def destroy(self) -> None: ...
    def getTypes(self) -> list: ...
    @overload
    def getObjsOfType(self, type: type[_T]) -> list[_T]: ...
    @overload
    def getObjsOfType(self, type: str) -> list[Any]: ...
    def printObjsOfType(self, type: type | str) -> None: ...
    def diff(self, other: ObjectPool) -> Diff: ...
    def typeFreqStr(self) -> str: ...
    def printObjsByType(self) -> None: ...
    def printReferrers(self, numEach: int = ...) -> None: ...
    def __len__(self) -> int: ...
