from _typeshed import SupportsWrite
from typing import ClassVar

from direct.directnotify.Notifier import Notifier
from direct.showbase.DirectObject import DirectObject
from panda3d.core import NodePath
from panda3d.physics import BaseForce, ForceNode
from .ParticleEffect import ParticleEffect

class ForceGroup(DirectObject):
    notify: ClassVar[Notifier]
    id: ClassVar[int]
    node: ForceGroup
    nodePath: NodePath[ForceNode]
    fEnabled: bool
    particleEffect: ParticleEffect | None
    def __init__(self, name: str | None = ...) -> None: ...
    def cleanup(self) -> None: ...
    def enable(self) -> None: ...
    def disable(self) -> None: ...
    def is_enabled(self) -> bool: ...
    def addForce(self, force: BaseForce) -> None: ...
    def removeForce(self, force: BaseForce) -> None: ...
    def getName(self) -> str: ...
    def get_node(self) -> ForceGroup: ...
    def get_node_path(self) -> NodePath[ForceNode]: ...
    def __getitem__(self, index: int) -> BaseForce: ...
    def __len__(self) -> int: ...
    def as_list(self) -> list[BaseForce]: ...
    def print_params(self, file: SupportsWrite[str] = ..., targ: str = ...) -> None: ...
    isEnabled = is_enabled
    getNode = get_node
    getNodePath = get_node_path
    asList = as_list
    printParams = print_params
