from abc import ABCMeta, abstractmethod

import wx  # type: ignore[import]
from panda3d.core import NodePath
from .LevelEditor import LevelEditor

class SceneGraphUIDropTarget(wx.TextDropTarget):
    editor: LevelEditor
    def __init__(self, editor: LevelEditor) -> None: ...
    def OnDropText(self, x, y, text) -> None: ...

class SceneGraphUIBase(wx.Panel, metaclass=ABCMeta):
    editor: LevelEditor
    tree: wx.TreeCtrl
    root = ...
    shouldShowPandaObjChildren: bool
    currItem = ...
    currObj = ...
    menu: wx.Menu
    def __init__(self, parent, editor: LevelEditor) -> None: ...
    def reset(self) -> None: ...
    def traversePandaObjects(self, parent, objNodePath: NodePath) -> None: ...
    def addPandaObjectChildren(self, parent) -> None: ...
    def removePandaObjectChildren(self, parent) -> None: ...
    def add(self, item, parentNP: NodePath | None = ...) -> None: ...
    def traverse(self, parent, itemId): ...
    def reParentTree(self, parent, newParent) -> None: ...
    def reParentData(self, parent, child) -> None: ...
    def reParent(self, oldParent, newParent, child) -> None: ...
    def isChildOrGrandChild(self, parent, child): ...
    def changeHierarchy(self, data: str, x, y) -> None: ...
    def parent(self, oldParentId, newParentId, childName) -> None: ...
    def showPandaObjectChildren(self) -> None: ...
    def delete(self, itemId) -> None: ...
    def select(self, itemId) -> None: ...
    def changeLabel(self, itemId, newName) -> None: ...
    def deSelect(self, itemId) -> None: ...
    def onSelected(self, event) -> None: ...
    def onBeginDrag(self, event) -> None: ...
    def onShowPopup(self, event) -> None: ...
    def populateMenu(self) -> None: ...
    @abstractmethod
    def populateExtraMenu(self) -> None: ...
    def onCollapseAllChildren(self, evt=...) -> None: ...
    def onExpandAllChildren(self, evt=...) -> None: ...
    def onDelete(self, evt=...) -> None: ...
    def onRename(self, evt=...) -> None: ...
