from collections.abc import Iterable
from typing import SupportsInt, TypeVar

from direct._typing import Unused
from panda3d.core import NodePath, PandaNode
from .LevelEditor import LevelEditor

_N = TypeVar('_N', bound=PandaNode)

class PythonNodePath(NodePath[_N]):
    def __init__(self, node: _N) -> None: ...

class ObjectMgrBase:
    editor: LevelEditor
    objects: dict
    npIndex: dict
    saveData: list
    objectsLastXform: dict
    lastUid: str
    lastUidMode: int
    currNodePath: NodePath | None
    currLiveNP = ...
    Actor: list
    Nodes: list
    def __init__(self, editor: LevelEditor) -> None: ...
    def reset(self) -> None: ...
    def genUniqueId(self) -> str: ...
    def addNewCurveFromFile(
        self, curveInfo: Iterable, degree, uid=..., parent=..., fSelectObject: bool = ..., nodePath: Unused = ...
    ) -> NodePath: ...
    def addNewCurve(
        self, curveInfo, degree, uid=..., parent=..., fSelectObject: bool = ..., nodePath: NodePath | None = ...
    ) -> NodePath: ...
    def addNewObject(
        self,
        typeName,
        uid=...,
        model=...,
        parent=...,
        anim=...,
        fSelectObject: bool = ...,
        nodePath=...,
        nameStr: str | None = ...,
    ) -> NodePath | None: ...
    def removeObjectById(self, uid) -> None: ...
    def removeObjectByNodePath(self, nodePath: NodePath) -> None: ...
    def findObjectById(self, uid): ...
    def findObjectByNodePath(self, nodePath: NodePath): ...
    def findObjectByNodePathBelow(self, nodePath: NodePath): ...
    def findObjectsByTypeName(self, typeName: str) -> list: ...
    def deselectAll(self) -> None: ...
    def selectObject(self, nodePath: NodePath, fLEPane: bool = ...) -> None: ...
    def selectObjectCB(self, obj, fLEPane: bool) -> None: ...
    def updateObjectPropertyUI(self, obj) -> None: ...
    def onEnterObjectPropUI(self, event) -> None: ...
    def onLeaveObjectPropUI(self, event) -> None: ...
    def spawnUpdateObjectUITask(self) -> None: ...
    def updateObjectUITask(self, state): ...
    def updateObjectTransform(self, event) -> None: ...
    def setObjectTransform(self, uid, xformMat) -> None: ...
    def updateObjectColor(self, r: float, g: float, b: float, a: float, np: NodePath | None = ...) -> None: ...
    def updateObjectModel(self, model, obj, fSelectObject: bool = ...) -> None: ...
    def updateObjectAnim(self, anim, obj, fSelectObject: bool = ...) -> None: ...
    def updateObjectModelFromUI(self, event, obj) -> None: ...
    def updateObjectAnimFromUI(self, event, obj) -> None: ...
    def updateObjectProperty(self, event, obj, propName: str) -> None: ...
    def updateObjectPropValue(self, obj, propName, val, fSelectObject: bool = ..., fUndo: bool = ...) -> None: ...
    def updateCurve(self, val: SupportsInt, obj) -> None: ...
    def updateObjectProperties(self, nodePath: NodePath, propValues: Iterable[str]) -> None: ...
    def traverse(self, parent, parentId=...) -> None: ...
    def getSaveData(self) -> list: ...
    def getPreSaveData(self) -> None: ...
    def getPostSaveData(self) -> None: ...
    def duplicateObject(self, nodePath: NodePath, parent=...) -> NodePath: ...
    def duplicateChild(self, nodePath: NodePath, parent) -> None: ...
    def duplicateSelected(self) -> None: ...
    def makeSelectedLive(self) -> None: ...
    def replaceObjectWithTypeName(self, obj, typeName: str) -> None: ...
    def flatten(self, newobjModel, model, objDef, uid) -> None: ...
    def findActors(self, parent) -> None: ...
    def findNodes(self, parent) -> None: ...
