from typing import SupportsFloat
from typing_extensions import Final, Literal

import wx  # type: ignore[import]
from direct._typing import Unused
from direct.wxwidgets.WxPandaShell import WxPandaShell
from direct.wxwidgets.WxSlider import WxSlider
from .AnimControlUI import AnimControlUI
from .CurveAnimUI import CurveAnimUI
from .GraphEditorUI import GraphEditorUI
from .LevelEditor import LevelEditor

class PandaTextDropTarget(wx.TextDropTarget):
    editor: LevelEditor
    view = ...
    def __init__(self, editor: LevelEditor, view) -> None: ...
    def OnDropText(self, x: float, y: float, text) -> bool | None: ...

ID_NEW: Final[Literal[101]]
ID_OPEN: Final[Literal[102]]
ID_SAVE: Final[Literal[103]]
ID_SAVE_AS: Final[Literal[104]]
ID_EXPORT_TO_MAYA: Final[Literal[105]]
ID_DUPLICATE: Final[Literal[201]]
ID_MAKE_LIVE: Final[Literal[202]]
ID_UNDO: Final[Literal[203]]
ID_REDO: Final[Literal[204]]
ID_SHOW_GRID: Final[Literal[301]]
ID_GRID_SIZE: Final[Literal[302]]
ID_GRID_SNAP: Final[Literal[303]]
ID_SHOW_PANDA_OBJECT: Final[Literal[304]]
ID_HOT_KEYS: Final[Literal[305]]
ID_PARENT_TO_SELECTED: Final[Literal[306]]
ID_CREATE_CURVE: Final[Literal[601]]
ID_EDIT_CURVE: Final[Literal[602]]
ID_CURVE_ANIM: Final[Literal[603]]
ID_ANIM: Final[Literal[701]]
ID_GRAPH: Final[Literal[702]]

class LevelEditorUIBase(WxPandaShell):
    editor: LevelEditor
    contextMenu: ViewportMenu
    menuEdit: wx.Menu
    menuOptions: wx.Menu
    showGridMenuItem = ...
    gridSizeMenuItem = ...
    gridSnapMenuItem = ...
    showPandaObjectsMenuItem = ...
    parentToSelectedMenuItem = ...
    hotKeysMenuItem = ...
    menuCurve: wx.Menu
    createCurveMenuItem = ...
    editCurveMenuItem = ...
    curveAnimMenuItem = ...
    menuAnim: wx.Menu
    editAnimMenuItem = ...
    graphEditorMenuItem = ...
    graphEditorUI: GraphEditorUI
    animUI: AnimControlUI
    curveAnimUI: CurveAnimUI
    def __init__(self, editor: LevelEditor) -> None: ...
    def bindKeyEvents(self, toBind: bool = ...) -> None: ...
    def onGraphEditor(self, e) -> None: ...
    def onAnimation(self, e) -> None: ...
    def onCurveAnim(self, e) -> None: ...
    def onCreateCurve(self, e) -> None: ...
    def onEditCurve(self, e) -> None: ...
    def updateMenu(self) -> None: ...
    def onRightDown(self, evt=...) -> None: ...
    def onKeyDownEvent(self, evt) -> None: ...
    def onKeyUpEvent(self, evt) -> None: ...
    def onKeyEvent(self, evt) -> None: ...
    def reset(self) -> None: ...
    def onNew(self, evt=...) -> None: ...
    def onOpen(self, evt=...) -> None: ...
    def onSave(self, evt=...) -> bool | None: ...
    def onSaveAs(self, evt) -> bool: ...
    def onExportToMaya(self, evt) -> None: ...
    def onDuplicate(self, evt) -> None: ...
    def onMakeLive(self, evt) -> None: ...
    def toggleGrid(self, evt) -> None: ...
    def toggleGridSnap(self, evt) -> None: ...
    def onGridSize(self, evt) -> None: ...
    def onShowPandaObjects(self, evt) -> None: ...
    def onDestroy(self, evt) -> None: ...
    def updateGrids(self, newSize, newSpacing) -> None: ...
    def onHotKeys(self, evt) -> None: ...
    def buildContextMenu(self, nodePath: Unused): ...
    def replaceObject(self, evt, all: bool = ...) -> None: ...

class GridSizeUI(wx.Dialog):
    parent = ...
    gridSizeSlider: WxSlider
    gridSpacingSlider: WxSlider
    def __init__(self, parent, id, title, gridSize: SupportsFloat, gridSpacing: SupportsFloat) -> None: ...
    def onApply(self, evt) -> None: ...

class ViewportMenu(wx.Menu):
    def __init__(self) -> None: ...
    def addItem(self, name, parent=..., call=..., id=...) -> None: ...
    def addMenu(self, name, parent=..., id=...) -> wx.Menu: ...

class CurveDegreeUI(wx.Dialog):
    parent = ...
    degree: wx.RadioBox
    def __init__(self, parent, id, title) -> None: ...
    def onApply(self, evt) -> None: ...
