from typing import Union
from typing_extensions import Literal, TypeAlias

from direct.showbase.DirectObject import DirectObject
from direct.showutil.Rope import Rope
from direct.task.Task import Task
from panda3d.core import LVecBase3f, LVecBase4f
from .LevelEditor import LevelEditor

_Vert: TypeAlias = Union[LVecBase3f, LVecBase4f, tuple[float, float, float], tuple[float, float, float, float]]

class CurveEditor(DirectObject):
    editor: LevelEditor
    i: int
    ropeNum: int
    curve: list
    curveControl: list
    currentRope: Rope | None
    degree: int
    def __init__(self, editor: LevelEditor) -> None: ...
    def createCurve(self) -> None: ...
    def editCurve(self, task: Task) -> Literal[1] | None: ...
    def onControlerDelete(self) -> None: ...
    def ropeUpdate(self, curve: _Vert) -> None: ...
    def onBaseMode(self) -> None: ...
    def updateScene(self) -> None: ...
    def doneEdit(self) -> None: ...
    def createControler(self, x: float, y: float) -> None: ...
