from collections.abc import Callable
from typing import Any, TypeVar

from direct.showbase.PythonUtil import Functor
from panda3d.core import LMatrix4f
from .LevelEditor import LevelEditor

_T = TypeVar('_T')

class ActionMgr:
    undoList: list[ActionBase]
    redoList: list[ActionBase]
    def __init__(self) -> None: ...
    def reset(self) -> None: ...
    def push(self, action: ActionBase) -> None: ...
    def undo(self) -> None: ...
    def redo(self) -> None: ...

class ActionBase(Functor[_T]):
    function: Callable[..., _T]
    result: _T | None
    def redo(self) -> _T | None: ...
    def saveStatus(self) -> None: ...
    def postCall(self) -> None: ...
    def undo(self) -> None: ...

class ActionAddNewObj(ActionBase):
    editor: LevelEditor
    uid = ...
    def __init__(self, editor: LevelEditor, *args: Any, **kargs: Any) -> None: ...

class ActionDeleteObj(ActionBase):
    editor: LevelEditor
    selectedUIDs: list
    hierarchy: dict
    objInfos: dict
    objTransforms: dict
    def __init__(self, editor: LevelEditor, *args: Any, **kargs: Any) -> None: ...

class ActionDeleteObjById(ActionBase):
    editor: LevelEditor
    uid = ...
    hierarchy: dict
    objInfos: dict
    objTransforms: dict
    def __init__(self, editor: LevelEditor, uid) -> None: ...

class ActionChangeHierarchy(ActionBase):
    editor: LevelEditor
    oldGrandParentId = ...
    oldParentId = ...
    newParentId = ...
    childName = ...
    def __init__(self, editor: LevelEditor, oldGrandParentId, oldParentId, newParentId, childName, *args, **kargs) -> None: ...

class ActionSelectObj(ActionBase):
    editor: LevelEditor
    selectedUIDs: list
    def __init__(self, editor: LevelEditor, *args: Any, **kargs: Any) -> None: ...

class ActionTransformObj(ActionBase):
    editor: LevelEditor
    uid = ...
    origMat: LMatrix4f | None
    def __init__(self, editor: LevelEditor, *args, **kargs: Any) -> None: ...

class ActionDeselectAll(ActionBase):
    editor: LevelEditor
    selectedUIDs: list
    def __init__(self, editor: LevelEditor, *args: Any, **kargs: Any) -> None: ...

class ActionUpdateObjectProp(ActionBase[_T]):
    editor: LevelEditor
    fSelectObject: bool
    obj = ...
    propName = ...
    newVal = ...
    oldVal = ...
    undoFunc = ...
    def __init__(
        self,
        editor: LevelEditor,
        fSelectObject: bool,
        obj,
        propName,
        val,
        oldVal,
        function: Callable[..., _T],
        undoFunc,
        *args: Any,
        **kargs: Any,
    ) -> None: ...
    def redo(self) -> _T: ...
