__all__ = ['BlackOnWhite', 'NameConfirm', 'OnscreenText', 'Plain', 'ScreenPrompt', 'ScreenTitle']

from typing import Any, Union, overload
from typing_extensions import Final, Literal, TypeAlias

from direct._typing import Unused
from panda3d.core import LColor, NodePath, TextFont, TextNode

_Alignment: TypeAlias = Literal[0, 1, 2, 3, 4, 5]
_Color: TypeAlias = Union[LColor, tuple[float, float, float, float]]
_OrderedPair: TypeAlias = tuple[float, float]

Plain: Final[Literal[1]]
ScreenTitle: Final[Literal[2]]
ScreenPrompt: Final[Literal[3]]
NameConfirm: Final[Literal[4]]
BlackOnWhite: Final[Literal[5]]

class OnscreenText(NodePath[TextNode]):
    textNode: TextNode
    mayChange: bool
    isClean: bool
    decal: bool
    font: TextFont
    text: str
    text_pos: _OrderedPair
    text_r: float
    roll: float
    text_scale: _OrderedPair
    scale: _OrderedPair
    wordwrap: float
    fg: LColor
    bg: LColor
    shadow: LColor
    frame: LColor
    align: _Alignment
    unicodeText: Literal[True]
    def __init__(
        self,
        text: str = ...,
        style: int = ...,
        pos: _OrderedPair = ...,
        roll: float = ...,
        scale: float | _OrderedPair | None = ...,
        fg: _Color | None = ...,
        bg: _Color | None = ...,
        shadow: _Color | None = ...,
        shadowOffset: _OrderedPair = ...,
        frame: _Color | None = ...,
        align: _Alignment | None = ...,
        wordwrap: float | None = ...,
        drawOrder: int | None = ...,
        decal: bool = ...,
        font: TextFont | None = ...,
        parent: NodePath | None = ...,
        sort: int = ...,
        mayChange: bool = ...,
        direction: Literal['LTR', 'RTL', 'ltr', 'rtl', None] = ...,
    ) -> None: ...
    def cleanup(self) -> None: ...
    def destroy(self) -> None: ...
    def freeze(self) -> None: ...
    def thaw(self) -> None: ...
    def setDecal(self, decal: bool) -> None: ...
    def getDecal(self) -> bool: ...
    def setFont(self, font: TextFont) -> None: ...
    def getFont(self) -> TextFont: ...
    def clearText(self) -> None: ...
    def setText(self, text: str) -> None: ...
    def appendText(self, text: str) -> None: ...
    def getText(self) -> str: ...
    def setTextX(self, x: float) -> None: ...
    def setX(self, x: float) -> None: ...  # type: ignore[override]
    def setTextY(self, y: float) -> None: ...
    def setY(self, y: float) -> None: ...  # type: ignore[override]
    @overload
    def setTextPos(self, x: float, y: float) -> None: ...
    @overload
    def setTextPos(self, x: _OrderedPair, y: None = ...) -> None: ...
    def getTextPos(self) -> _OrderedPair: ...
    def setPos(self, x: float, y: float) -> None: ...  # type: ignore[override]
    def getPos(self) -> _OrderedPair: ...  # type: ignore[override]
    @property
    def pos(self) -> _OrderedPair: ...
    def setTextR(self, r: float) -> None: ...
    def getTextR(self) -> float: ...
    def setRoll(self, roll: float) -> None: ...
    def getRoll(self) -> float: ...
    @overload
    def setTextScale(self, sx: float | _OrderedPair, sy: None = ...) -> None: ...
    @overload
    def setTextScale(self, sx: float, sy: float) -> None: ...
    def getTextScale(self) -> _OrderedPair: ...
    @overload  # type: ignore[override]
    def setScale(self, sx: float | _OrderedPair, sy: None = ...) -> None: ...
    @overload
    def setScale(self, sx: float, sy: float) -> None: ...
    def getScale(self) -> _OrderedPair: ...  # type: ignore[override]
    def updateTransformMat(self) -> None: ...
    def setWordwrap(self, wordwrap: float) -> None: ...
    def getWordwrap(self) -> float: ...
    def setFg(self, fg: _Color) -> None: ...
    def setBg(self, bg: _Color) -> None: ...
    def setShadow(self, shadow: _Color) -> None: ...
    def setFrame(self, frame: _Color) -> None: ...
    def configure(self, option: Unused = ..., **kw: Any) -> None: ...
    def __setitem__(self, key: str, value: Any) -> None: ...
    def setAlign(self, align: float) -> None: ...
    def __getitem__(self, option: str) -> Any: ...
    cget = __getitem__
