from typing import ClassVar, Protocol

from direct.directnotify.Notifier import Notifier
from direct.showbase.DirectObject import DirectObject
from panda3d.direct import DCClass
from .ClientRepository import ClientRepository
from .GridParent import GridParent

class _HasGridParent(Protocol):
    gridParent: GridParent | None

class DistributedObjectBase(DirectObject):
    notify: ClassVar[Notifier]
    cr: ClientRepository
    parentId: int | None
    zoneId: int | None
    doId: int
    dclass: DCClass
    def __init__(self, cr: ClientRepository) -> None: ...
    def getLocation(self) -> tuple[int | None, int | None] | None: ...
    def handleChildArrive(self, childObj: _HasGridParent, zoneId: int) -> None: ...
    def handleChildArriveZone(self, childObj: _HasGridParent, zoneId: int) -> None: ...
    def handleChildLeave(self, childObj: _HasGridParent, zoneId: int) -> None: ...
    def handleChildLeaveZone(self, childObj: _HasGridParent, zoneId: int) -> None: ...
    def handleQueryObjectChildrenLocalDone(self, context) -> None: ...
    def getParentObj(self) -> DistributedObjectBase | None: ...
    def hasParentingRules(self) -> bool: ...
    def delete(self) -> None: ...
