from typing import Union, overload
from typing_extensions import Literal, TypeAlias

from direct._typing import AnyReal, Unused
from panda3d.core import LVecBase2f

_Vec2f: TypeAlias = Union[LVecBase2f, tuple[float, float]]

class CartesianGridBase:
    def isValidZone(self, zoneId: int) -> bool: ...
    @overload
    def getZoneFromXYZ(self, pos: _Vec2f, wantRowAndCol: Literal[False] = ...) -> int: ...
    @overload
    def getZoneFromXYZ(self, pos: _Vec2f, wantRowAndCol: Literal[True]) -> tuple[int, float, float]: ...
    def getGridSizeFromSphereRadius(self, sphereRadius: AnyReal, cellWidth: AnyReal, gridRadius: AnyReal) -> AnyReal: ...
    def getGridSizeFromSphere(self, sphereRadius: float, spherePos: _Vec2f, cellWidth: float, gridRadius: Unused) -> float: ...
    def getZoneCellOrigin(self, zoneId: int) -> tuple[float, float, Literal[0]]: ...
    def getZoneCellOriginCenter(self, zoneId: int) -> tuple[float, float, Literal[0]]: ...
    def getConcentricZones(self, zoneId: int, radius: float) -> list[int]: ...
