from collections.abc import Iterable
from typing import Any, ClassVar
from typing_extensions import Final, Literal

from direct._typing import Unused
from direct.directdevices.DirectDeviceManager import DirectDeviceManager
from direct.directdevices.DirectFastrak import DirectFastrak
from direct.directdevices.DirectJoybox import DirectJoybox
from direct.directdevices.DirectRadamec import DirectRadamec
from direct.gui.OnscreenText import OnscreenText
from direct.showbase.DirectObject import DirectObject
from direct.task.Task import Task
from direct.tkpanels.DirectSessionPanel import DirectSessionPanel
from panda3d.core import Camera, DisplayRegion, Lens, LVecBase3f, NodePath, TextFont, TransformState
from .DirectCameraControl import DirectCameraControl
from .DirectGrid import DirectGrid
from .DirectLights import DirectLights
from .DirectManipulation import DirectManipulationControl
from .DirectSelection import SelectedNodePaths, SelectionRay

class DirectSession(DirectObject):
    DIRECTdisablePost: Final[Literal['disableDIRECT']]
    group: NodePath
    font: TextFont
    fEnabled: bool
    fEnabledLight: bool
    fScaleWidgetByCam: bool
    fIgnoreDirectOnlyKeyMap: bool
    drList: DisplayRegionList
    iRayList: list[SelectionRay]
    dr: DisplayRegionContext
    camera: NodePath
    cam: NodePath[Camera]
    camNode: Camera
    trueCamera: NodePath
    iRay: SelectionRay
    coaMode: int
    cameraControl: DirectCameraControl
    manipulationControl: DirectManipulationControl
    grid: DirectGrid
    lights: DirectLights
    selected: SelectedNodePaths
    ancestry: list
    ancestryIndex: int
    activeParent: NodePath | None
    selectedNPReadout: OnscreenText
    activeParentReadout: OnscreenText
    directMessageReadout: OnscreenText
    deviceManager: DirectDeviceManager | None
    joybox: DirectJoybox | None
    radamec: DirectRadamec | None
    fastrak: list[DirectFastrak]
    fControl: bool
    fAlt: bool
    fShift: bool
    fMouse1: bool
    fMouse2: bool
    fMouse3: bool
    pos: LVecBase3f
    hpr: LVecBase3f
    scale: LVecBase3f
    undoList: list[list[tuple[NodePath, TransformState]]]
    redoList: list[list[tuple[NodePath, TransformState]]]
    actionEvents: list
    modifierEvents: list[str]
    specialKeys: list[str]
    keyEvents: list[str]
    mouseEvents: list[str]
    directiOnlyKeyMap: dict[str, tuple[str, str]]
    hotKeyMap: dict[str, tuple[str, str]]
    specialKeyMap: dict[str, str]
    passThroughKeys: list[str]
    panel: DirectSessionPanel
    clusterMode: str
    def __init__(self) -> None: ...
    def addPassThroughKey(self, key: str) -> None: ...
    def enable(self) -> None: ...
    def enableLight(self) -> None: ...
    def disable(self) -> None: ...
    def toggleDirect(self) -> None: ...
    def minimumConfiguration(self) -> None: ...
    def oobe(self) -> None: ...
    def beginOOBE(self) -> None: ...
    def endOOBE(self) -> None: ...
    def destroy(self) -> None: ...
    def reset(self) -> None: ...
    def enableActionEvents(self) -> None: ...
    def enableModifierEvents(self) -> None: ...
    def enableKeyEvents(self) -> None: ...
    def enableMouseEvents(self) -> None: ...
    def disableActionEvents(self) -> None: ...
    def disableModifierEvents(self) -> None: ...
    def disableKeyEvents(self) -> None: ...
    def disableMouseEvents(self) -> None: ...
    def inputHandler(self, input: str) -> None: ...
    def doSetActiveParent(self) -> None: ...
    def doReparent(self) -> None: ...
    def doWrtReparent(self) -> None: ...
    def doSelect(self) -> None: ...
    def getModifiers(self, input: str, base: str) -> int: ...
    def gotShift(self, modifiers: int) -> int: ...
    def gotControl(self, modifiers: int) -> int: ...
    def gotAlt(self, modifiers: int) -> int: ...
    def setFScaleWidgetByCam(self, flag: bool) -> None: ...
    def widgetResizeTask(self, state: Unused) -> Literal[1]: ...
    def select(
        self,
        nodePath: NodePath,
        fMultiSelect: bool = ...,
        fSelectTag: bool = ...,
        fResetAncestry: bool = ...,
        fLEPane: bool = ...,
        fUndo: bool = ...,
    ) -> None: ...
    def selectCB(
        self,
        nodePath: NodePath,
        fMultiSelect: bool = ...,
        fSelectTag: bool = ...,
        fResetAncestry: bool = ...,
        fLEPane: bool = ...,
        fUndo: bool = ...,
    ) -> None: ...
    def followSelectedNodePathTask(self, state: Task) -> Literal[1]: ...
    def deselect(self, nodePath: NodePath) -> None: ...
    def deselectAll(self) -> None: ...
    def deselectAllCB(self) -> None: ...
    def setActiveParent(self, nodePath: NodePath | None = ...) -> None: ...
    def reparent(self, nodePath: NodePath | None = ..., fWrt: bool = ...) -> None: ...
    def isNotCycle(self, nodePath: NodePath, parent: NodePath) -> bool: ...
    def flash(self, nodePath: NodePath | Literal['None Given'] | None = ...) -> None: ...
    def flashDummy(self, state: Unused) -> Literal[1]: ...
    def flashDone(self, state: Task) -> None: ...
    def fitOnNodePath(self, nodePath: NodePath | Literal['None Given'] = ...) -> None: ...
    def isolate(self, nodePath: NodePath | Literal['None Given'] | None = ...) -> None: ...
    def toggleVis(self, nodePath: NodePath | Literal['None Given'] | None = ...) -> None: ...
    def removeNodePath(self, nodePath: NodePath | Literal['None Given'] | None = ...) -> None: ...
    def removeAllSelected(self) -> None: ...
    def showAllDescendants(self, nodePath: NodePath | None = ...) -> None: ...
    def upAncestry(self) -> None: ...
    def downAncestry(self) -> None: ...
    def getAndSetName(self, nodePath: NodePath) -> None: ...
    def pushUndo(self, nodePathList: Iterable[NodePath], fResetRedo: bool = ...) -> None: ...
    def popUndoGroup(self) -> list[tuple[NodePath, TransformState]]: ...
    def pushRedo(self, nodePathList: Iterable[NodePath]) -> None: ...
    def popRedoGroup(self) -> list[tuple[NodePath, TransformState]]: ...
    def undo(self) -> None: ...
    def redo(self) -> None: ...
    def message(self, text: str) -> None: ...
    def hideDirectMessageLater(self) -> None: ...
    def hideDirectMessage(self, state: Unused) -> Literal[0]: ...
    def useObjectHandles(self) -> None: ...
    def hideSelectedNPReadout(self) -> None: ...
    def hideActiveParentReadout(self) -> None: ...
    def toggleWidgetVis(self) -> None: ...
    def setCOAMode(self, mode: int) -> None: ...
    def isEnabled(self) -> bool: ...
    def addUnpickable(self, item: str) -> None: ...
    def removeUnpickable(self, item: str) -> None: ...

class DisplayRegionContext(DirectObject):
    regionCount: ClassVar[int]
    cam: NodePath[Camera]
    camNode: Camera
    camLens: Lens
    iRay: SelectionRay
    nearVec: LVecBase3f
    mouseX: float
    mouseY: float
    orthoFactor: float
    dr: DisplayRegion
    originX: float
    originY: float
    scaleX: float
    scaleY: float
    isSideways: bool
    near: float
    far: float
    fovH: float
    fovV: float
    nearWidth: float
    nearHeight: float
    left: float
    right: float
    top: float
    bottom: float
    mouseLastX: float
    mouseLastY: float
    def __init__(self, cam: NodePath[Camera]) -> None: ...
    def __getitem__(self, key: str) -> Any: ...
    def setOrientation(self) -> None: ...
    def getHfov(self) -> float: ...
    def getVfov(self) -> float: ...
    def setHfov(self, hfov: float) -> None: ...
    def setVfov(self, vfov: float) -> None: ...
    def setFov(self, hfov: float, vfov: float) -> None: ...
    def getWidth(self) -> int: ...
    def getHeight(self) -> int: ...
    def updateFilmSize(self, width: float, height: float) -> None: ...
    def camUpdate(self, lens: Unused = ...) -> None: ...
    def mouseUpdate(self) -> None: ...

class DisplayRegionList(DirectObject):
    displayRegionList: list[DisplayRegionContext]
    tryToGetCurrentDr: bool
    def __init__(self) -> None: ...
    def __getitem__(self, index: int) -> DisplayRegionContext: ...
    def __len__(self) -> int: ...
    def updateContext(self) -> None: ...
    def setNearFar(self, near: float, far: float) -> None: ...
    def setNear(self, near: float) -> None: ...
    def setFar(self, far: float) -> None: ...
    def setFov(self, hfov: float, vfov: float) -> None: ...
    def setHfov(self, fov: float) -> None: ...
    def setVfov(self, fov: float) -> None: ...
    def mouseUpdate(self, modifiers: int = ...) -> None: ...
    def getCurrentDr(self) -> DisplayRegionContext: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...
    def spawnContextTask(self) -> None: ...
    def removeContextTask(self) -> None: ...
    def contextTask(self, state: Unused) -> Literal[1]: ...
    def addDisplayRegionContext(self, cam: NodePath[Camera]) -> None: ...
    def removeDisplayRegionContext(self, cam: NodePath[Camera]) -> None: ...
