from typing import Any, ClassVar
from typing_extensions import Literal

from direct._typing import Unused
from direct.directnotify.Notifier import Notifier
from direct.showbase.DirectObject import DirectObject
from panda3d.core import (
    BitMask32,
    CollisionHandlerEvent,
    CollisionHandlerFluidPusher,
    CollisionHandlerGravity,
    CollisionHandlerPusher,
    CollisionNode,
    CollisionRay,
    CollisionTraverser,
    ConfigVariableBool,
    LVecBase3f,
    LVector3f,
    NodePath,
    PythonTask,
)

class GravityWalker(DirectObject):
    notify: ClassVar[Notifier]
    wantDebugIndicator: ClassVar[ConfigVariableBool]
    wantFloorSphere: ClassVar[ConfigVariableBool]
    earlyEventSphere: ClassVar[ConfigVariableBool]
    DiagonalFactor: ClassVar[float]
    mayJump: bool
    jumpDelayTask: PythonTask | None
    controlsTask: PythonTask | None
    indicatorTask: PythonTask | None
    falling: bool
    needToDeltaPos: bool
    physVelocityIndicator: Any | None
    avatarControlForwardSpeed: float
    avatarControlJumpForce: float
    avatarControlReverseSpeed: float
    avatarControlRotateSpeed: float
    priorParent: LVector3f
    moving: bool
    speed: float
    rotationSpeed: float
    slideSpeed: float
    vel: LVector3f
    collisionsActive: bool
    isAirborne: bool
    highMark: float
    avatar: Any
    cRay: CollisionRay
    cRayNodePath: NodePath[CollisionNode]
    lifter: CollisionHandlerGravity
    avatarRadius: float
    pusher: CollisionHandlerPusher | CollisionHandlerFluidPusher
    cWallSphereNodePath: NodePath[CollisionNode]
    event: CollisionHandlerEvent
    cEventSphereNodePath: NodePath[CollisionNode]
    pusherFloorhandler: CollisionHandlerPusher
    cFloorSphereNodePath: NodePath[CollisionNode]
    wallBitmask: BitMask32
    floorBitmask: BitMask32
    avatarNodePath: NodePath
    cTrav: CollisionTraverser
    def __init__(
        self, gravity: float = ..., standableGround: float = ..., hardLandingForce: float = ..., legacyLifter: bool = ...
    ) -> None: ...
    def setWalkSpeed(self, forward: float, jump: float, reverse: float, rotate: float) -> None: ...
    def getSpeeds(self) -> tuple[float, float, float]: ...
    def getIsAirborne(self) -> bool: ...
    def setAvatar(self, avatar: Any) -> None: ...
    def setupRay(self, bitmask: BitMask32, floorOffset: float, reach: float) -> None: ...
    def setupWallSphere(self, bitmask: BitMask32, avatarRadius: float) -> None: ...
    def setupEventSphere(self, bitmask: BitMask32, avatarRadius: float) -> None: ...
    def setupFloorSphere(self, bitmask: BitMask32, avatarRadius: float) -> None: ...
    def setWallBitMask(self, bitMask: BitMask32) -> None: ...
    def setFloorBitMask(self, bitMask: BitMask32) -> None: ...
    def swapFloorBitMask(self, oldMask: BitMask32, newMask: BitMask32) -> None: ...
    def setGravity(self, gravity: float) -> None: ...
    def getGravity(self, gravity: Unused) -> float: ...
    def initializeCollisions(
        self,
        collisionTraverser: CollisionTraverser,
        avatarNodePath: NodePath,
        avatarRadius: float = ...,
        floorOffset: float = ...,
        reach: float = ...,
    ) -> None: ...
    def setTag(self, key: str, value: str) -> None: ...
    def setAirborneHeightFunc(self, unused_parameter: Unused) -> None: ...
    def getAirborneHeight(self) -> float: ...
    def setAvatarPhysicsIndicator(self, indicator: NodePath) -> None: ...
    def deleteCollisions(self) -> None: ...
    def setCollisionsActive(self, active: bool = ...) -> None: ...
    def getCollisionsActive(self) -> bool: ...
    def placeOnFloor(self) -> None: ...
    def oneTimeCollide(self) -> None: ...
    def setMayJump(self, task: Unused) -> Literal[1]: ...
    def startJumpDelay(self, delay: float) -> None: ...
    def addBlastForce(self, vector: LVecBase3f) -> None: ...
    def displayDebugInfo(self) -> None: ...
    def handleAvatarControls(self, task: Unused) -> Literal[1]: ...
    def doDeltaPos(self) -> None: ...
    def setPriorParentVector(self) -> None: ...
    def reset(self) -> None: ...
    def getVelocity(self) -> LVector3f: ...
    def enableAvatarControls(self) -> None: ...
    def disableAvatarControls(self) -> None: ...
    def flushEventHandlers(self) -> None: ...
    def setCollisionRayHeight(self, height: float) -> None: ...
