class Activity(dict):
    fields = [
        'start_index',
        'distance',
        "moving_time",
        "elapsed_time",
        "average_watts",
        "min_watts",
        "max_watts",
        "average_watts_kg",
        "max_watts_kg",
        "intensity",
        "w5s_variability",
        "weighted_average_watts",
        "training_load",
        "joules",
        "decoupling",
        "zone",
        "zone_min_watts",
        "zone_max_watts",
        "average_speed",
        "min_speed",
        "max_speed",
        "average_heartrate",
        "min_heartrate",
        "max_heartrate",
        "average_cadence",
        "min_cadence",
        "max_cadence",
        "average_torque",
        "min_torque",
        "max_torque",
        "total_elevation_gain",
        "min_altitude",
        "max_altitude",
        "average_gradient",
        "id",
        "type",
        "end_index",
        "group_id",
        "segment_effort_ids",
        "estimated_cp",
        "start_time",
        "end_time",
        "start_date_local",
        "icu_ignore_time",
        "icu_pm_cp",
        'icu_pm_w_prime',
        'icu_pm_p_max',
        'icu_pm_ftp',
        'icu_ignore_power',
        'icu_rolling_cp',
        'icu_rolling_w_prime',
        'icu_rolling_p_max',
        'icu_rolling_ftp',
        'icu_rolling_ftp_delta',
        'icu_training_load',
        'icu_atl',
        'icu_ctl',
        'name',
        'description',
        'start_date',
        'icu_distance',
        'coasting_time',
        'timezone',
        'trainer',
        'commute',
        'device_watts',
        'has_heartrate',
        'calories',
        'average_temp',
        'avg_lr_balance',
        'workout_type',
        'gear',
        'perceived_exertion',
        'device_name',
        'power_meter',
        'power_meter_serial',
        'power_meter_battery',
        'file_type',
        'icu_athlete_id',
        'icu_sync_date',
        'analyzed',
        'icu_ftp',
        'icu_w_prime',
        'icu_swim_ftp',
        'icu_hr_zones',
        'icu_resting_hr',
        'icu_weight',
        'icu_power_zones',
        'icu_sweet_spot_min',
        'icu_sweet_spot_max',
        'icu_power_spike_threshold',
        'icu_warmup_time',
        'icu_cooldown_time',
        'icu_chat_id',
        'icu_ignore_hr',
        'icu_weighted_avg_watts',
        'icu_training_load_data',
        'interval_summary',
        'stream_types',
        'icu_streams',
        'icu_zone_times',
        'icu_hr_zone_times',
        'icu_achievements',
        'icu_intervals_edited',
        'icu_lap_count',
        'icu_joules',
        'icu_joules_above_ftp',
        'icu_max_wbal_depletion',
        'icu_recording_time',
        'icu_hrr',
        'icu_sync_error',
        'icu_color',
        'icu_power_hr_z2',
        'icu_power_hr_z2_mins',
        'icu_cadence_z2',
        'icu_rpe',
        'source',
        'oauth_client_id',
        'oauth_client_name',
        'icu_median_time_delta',
        'icu_power_hr',
        'icu_intensity',
        'icu_average_watts',
        'icu_variability_index',
        'icu_efficiency_factor',
    ]

    def __init__(self, **kwargs):
        for field in kwargs.keys():
            if field not in Activity.fields:
                raise TypeError("Unknown property {}".format(field))

        dict.__init__(self, **kwargs)
