# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['gvmtools', 'scripts', 'tests', 'tests.scripts']

package_data = \
{'': ['*']}

install_requires = \
['python-gvm>=21.5']

entry_points = \
{'console_scripts': ['gvm-cli = gvmtools.cli:main',
                     'gvm-pyshell = gvmtools.pyshell:main',
                     'gvm-script = gvmtools.script:main']}

setup_kwargs = {
    'name': 'gvm-tools',
    'version': '22.6.1',
    'description': 'Tools to control a GSM/GVM over GMP or OSP',
    'long_description': '![Greenbone Logo](https://www.greenbone.net/wp-content/uploads/gb_logo_resilience_horizontal.png)\n\n# Greenbone Vulnerability Management Tools <!-- omit in toc -->\n[![GitHub releases](https://img.shields.io/github/release-pre/greenbone/gvm-tools.svg)](https://github.com/greenbone/gvm-tools/releases)\n[![PyPI release](https://img.shields.io/pypi/v/gvm-tools.svg)](https://pypi.org/project/gvm-tools/)\n[![Scrutinizer Code Quality](https://scrutinizer-ci.com/g/greenbone/gvm-tools/badges/quality-score.png?b=master)](https://scrutinizer-ci.com/g/greenbone/gvm-tools/?branch=master)\n[![code test coverage](https://codecov.io/gh/greenbone/gvm-tools/branch/master/graph/badge.svg)](https://codecov.io/gh/greenbone/gvm-tools)\n[![Build and test](https://github.com/greenbone/gvm-tools/actions/workflows/ci-python.yml/badge.svg)](https://github.com/greenbone/gvm-tools/actions/workflows/ci-python.yml)\n\nThe Greenbone Vulnerability Management Tools `gvm-tools`\nare a collection of tools that help with remote controlling a\nGreenbone Security Manager (GSM) appliance and its underlying Greenbone\nVulnerability Management (GVM) framework. The tools aid in accessing the\ncommunication protocols GMP (Greenbone Management Protocol) and OSP\n(Open Scanner Protocol).\n\nThis module is comprised of interactive and non-interactive clients.\nThe programming language Python is supported directly for interactive scripting.\nBut it is also possible to issue remote GMP/OSP commands without programming in\nPython.\n\n\n## Table of Contents <!-- omit in toc -->\n- [Documentation](#documentation)\n- [Installation](#installation)\n  - [Version](#version)\n  - [Requirements](#requirements)\n  - [Install using pip](#install-using-pip)\n- [Usage](#usage)\n  - [gvm-cli](#gvm-cli)\n    - [Examples](#examples)\n  - [gvm-script](#gvm-script)\n    - [Example script](#example-script)\n    - [More example scripts](#more-example-scripts)\n  - [gvm-pyshell](#gvm-pyshell)\n    - [Example program use](#example-program-use)\n- [Support](#support)\n- [Maintainer](#maintainer)\n- [Contributing](#contributing)\n- [License](#license)\n\n## Documentation\n\nThe documentation for `gvm-tools` can be found at\n[https://gvm-tools.readthedocs.io/](https://gvm-tools.readthedocs.io/). Please\nrefer to the documentation for more details as this README just\ngives a short overview.\n\n## Installation\n\nSee the [documentation](https://gvm-tools.readthedocs.io/en/latest/install.html)\nfor all supported installation options.\n\n### Version\n\nPlease consider to always use the **newest** version of `gvm-tools` and `python-gvm`.\nWe freqently update this projects to add features and keep them free from bugs.\nThis is why installing `gvm-tools` using pip is recommended.\n\n**To use `gvm-tools` with an old GMP version (7, 8, 9) you must use a release version**\n**that is `<21.06`, combined with an `python-gvm` version `<21.05`.**\n**In the `21.06` release the support of these older versions has been dropped.**\n\n### Requirements\n\nPython 3.7 and later is supported.\n\n### Install using pip\n\nYou can install the latest stable release of gvm-tools from the Python Package\nIndex using [pip](https://pip.pypa.io/):\n\n    pip install --user gvm-tools\n\n## Usage\n\nThere are several clients to communicate via GMP/OSP.\n\nAll clients have the ability to build a connection in various ways:\n\n    * Unix Socket\n    * TLS Connection\n    * SSH Connection\n\n### gvm-cli\n\nThis tool sends plain GMP/OSP commands and prints the result to the standard\noutput.\n\n#### Examples\n\nReturn the current protocol version used by the server:\n\n```\ngvm-cli socket --xml "<get_version/>"\n```\n\nReturn all tasks visible to the GMP user with the provided credentials:\n\n```\ngvm-cli --gmp-username foo --gmp-password bar socket --xml "<get_tasks/>"\n```\n\nRead a file with GMP commands and return the result:\n\n```\ngvm-cli --gmp-username foo --gmp-password bar socket myfile.xml\n```\n\nNote that `gvm-cli` will by default print an error message and exit with a\nnon-zero exit code when a command is rejected by the server. If this kind of\nerror handling is not desired, the unparsed XML response can be requested using\nthe `--raw` parameter:\n\n```\ngvm-cli socket --raw --xml "<authenticate/>"\n\n```\n\n### gvm-script\n\nThis tool has a lot more features than the simple `gvm-cli` client. You\nhave the possibility to create your own custom gmp or osp scripts with commands\nfrom the [python-gvm library](https://github.com/greenbone/python-gvm) and from\nPython 3 itself.\n\n#### Example script\n\n```\n# Retrieve current GMP version\nversion = gmp.get_version()\n\n# Prints the XML in beautiful form\nfrom gvmtools.helper import pretty_print\npretty_print(version)\n\n# Retrieve all tasks\ntasks = gmp.get_tasks()\n\n# Get names of tasks\ntask_names = tasks.xpath(\'task/name/text()\')\npretty_print(task_names)\n```\n\n#### More example scripts\n\nThere is a growing collection of gmp-scripts in the\n["scripts/"](scripts/) folder.\nSome of them might be exactly what you need and all of them help writing\nyour own gmp scripts.\n\n### gvm-pyshell\n\nThis tool is for running gmp or osp scripts interactively. It provides the same\nAPI as [gvm-script](#gvm-script) using the\n[python-gvm library](https://github.com/greenbone/python-gvm).\n\n#### Example program use\n\nConnect with given credentials via a unix domain socket and open an interactive\nshell:\n\n```\ngvm-pyshell --gmp-username user --gmp-password pass socket\n```\n\nConnect through SSH connection and open the interactive shell:\n\n```\ngvm-pyshell --hostname 127.0.0.1 ssh\n```\n\n## Support\n\nFor any question on the usage of `gvm-tools` or gmp scripts please use the\n[Greenbone Community Portal](https://community.greenbone.net/c/gmp). If you\nfound a problem with the software, please\n[create an issue](https://github.com/greenbone/gvm-tools/issues) on GitHub.\n\n## Maintainer\n\nThis project is maintained by [Greenbone Networks GmbH](https://www.greenbone.net/).\n\n## Contributing\n\nYour contributions are highly appreciated. Please\n[create a pull request](https://github.com/greenbone/gvm-tools/pulls) on GitHub.\nFor bigger changes, please discuss it first in the\n[issues](https://github.com/greenbone/gvm-tools/issues).\n\nFor development you should use [poetry](https://python-poetry.org/)\nto keep you python packages separated in different environments. First install\npoetry via pip\n\n    pip install --user poetry\n\nAfterwards run\n\n    poetry install\n\nin the checkout directory of `gvm-tools` (the directory containing the\n`pyproject.toml` file) to install all dependencies including the packages only\nrequired for development.\n\nAfterwards active the git hooks for auto-formatting and linting via\n[autohooks](https://github.com/greenbone/autohooks).\n\n    poetry run autohooks activate --force\n\n## License\n\nCopyright (C) 2017-2021 [Greenbone Networks GmbH](https://www.greenbone.net/)\n\nLicensed under the [GNU General Public License v3.0 or later](LICENSE).\n',
    'author': 'Greenbone Networks GmbH',
    'author_email': 'info@greenbone.net',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/greenbone/gvm-tools/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7.0,<4.0.0',
}


setup(**setup_kwargs)
