from .common import AbsolutePath
from typing import Tuple, List
import argparse

class Config:
    def __init__(self, 
        package: AbsolutePath | None, 
        stub: AbsolutePath | None, 
        current: AbsolutePath | None = None, 
        exclude: List[AbsolutePath] | None = None
    ) -> None: ...
    def __repr__(self) -> str: ...

class ConfigLoader:
    class _Tracer:
        def __init__(self) -> None: ...
        def set(self, name: str, value: AbsolutePath | None) -> None: ...
        def integrate(self, config: Config | None) -> None: ...
        def check(self) -> bool: ...
        @property
        def missing(self) -> List[str]: ...

    @staticmethod
    def pyproject(file: AbsolutePath) -> Config: ...
    @staticmethod
    def setupcfg(file: AbsolutePath) -> Config | None: ...
    @staticmethod
    def cli(args: argparse.Namespace) -> Config | None: ...
    @staticmethod
    def loadAllFiles(file: AbsolutePath) -> Config | None: ...
    @staticmethod
    def loadAll(file: AbsolutePath, args: argparse.Namespace) -> Config: ...
    @staticmethod
    def process_config_data(
        root: AbsolutePath, 
        package: AbsolutePath | None, 
        stub: AbsolutePath | None, 
        exclude: List[AbsolutePath]
    ) -> Tuple[AbsolutePath | None, AbsolutePath | None, List[AbsolutePath]]: ...