from .common import AbsolutePath, RelativePath
from _typeshed import StrPath
from pathlib import Path
from typing import List, Any

class Builder:
    def __init__(self, 
        package: AbsolutePath, 
        stub: AbsolutePath, 
        current: AbsolutePath | None = None, 
        exclude: List[AbsolutePath] | None = None
    ) -> None: ...
    @property
    def pyproject(self) -> AbsolutePath | None: ...
    @property
    def setupcfg(self) -> AbsolutePath | None: ...
    @staticmethod
    def check_directory_argument(name: str, value: Any) -> None: ...
    @staticmethod
    def remove_build_from_path(path: Path | StrPath, build: Path | StrPath) -> RelativePath: ...
    @staticmethod
    def get_relative_stub_path(stub: Path | StrPath, base: Path | StrPath) -> RelativePath: ...
    def get_build_path_for_stub(self, original_stub: AbsolutePath) -> AbsolutePath: ...
    def get_build_directory(self) -> AbsolutePath: ...    
    def create_build_directory(self, path: AbsolutePath) -> None: ...
    def delete_build_directory(self, path: AbsolutePath) -> None: ...
    def collect_stub_files(self) -> List[AbsolutePath]: ...
    def construct_file_source(self, path: RelativePath) -> AbsolutePath: ...
    def construct_file_dest(self, root: AbsolutePath, filename: RelativePath) -> AbsolutePath: ...
    @staticmethod
    def create_copy(src: AbsolutePath, dst: AbsolutePath, logging: bool = False) -> None: ...
    def create(self) -> StrPath: ...