"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchResult = exports.Matcher = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Represents a matcher that can perform special data matching capabilities between a given pattern and a target.
 *
 * @experimental
 */
class Matcher {
    /**
     * (experimental) Check whether the provided object is a subtype of the `IMatcher`.
     *
     * @experimental
     */
    static isMatcher(x) {
        return x && x instanceof Matcher;
    }
}
exports.Matcher = Matcher;
_a = JSII_RTTI_SYMBOL_1;
Matcher[_a] = { fqn: "@aws-cdk/assertions.Matcher", version: "1.117.0" };
/**
 * (experimental) The result of `Match.test()`.
 *
 * @experimental
 */
class MatchResult {
    constructor() {
        this.failures = [];
    }
    /**
     * (experimental) Push a new failure into this result at a specific path.
     *
     * If the failure occurred at root of the match tree, set the path to an empty list.
     * If it occurs in the 5th index of an array nested within the 'foo' key of an object,
     * set the path as `['/foo', '[5]']`.
     *
     * @param path the path at which the failure occurred.
     * @param message the failure.
     * @experimental
     */
    push(matcher, path, message) {
        this.failures.push({ matcher, path, message });
        return this;
    }
    /**
     * (experimental) Does the result contain any failures.
     *
     * If not, the result is a success
     *
     * @experimental
     */
    hasFailed() {
        return this.failures.length !== 0;
    }
    /**
     * (experimental) The number of failures.
     *
     * @experimental
     */
    get failCount() {
        return this.failures.length;
    }
    /**
     * (experimental) Compose the results of a previous match as a subtree.
     *
     * @param id the id of the parent tree.
     * @experimental
     */
    compose(id, inner) {
        const innerF = inner.failures;
        this.failures.push(...innerF.map(f => {
            return { path: [id, ...f.path], message: f.message, matcher: f.matcher };
        }));
        return this;
    }
    /**
     * (experimental) Get the list of failures as human readable strings.
     *
     * @experimental
     */
    toHumanStrings() {
        return this.failures.map(r => {
            const loc = r.path.length === 0 ? '' : ` at ${r.path.join('')}`;
            return '' + r.message + loc + ` (using ${r.matcher.name} matcher)`;
        });
    }
}
exports.MatchResult = MatchResult;
_b = JSII_RTTI_SYMBOL_1;
MatchResult[_b] = { fqn: "@aws-cdk/assertions.MatchResult", version: "1.117.0" };
//# sourceMappingURL=data:application/json;base64,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