# Copyright © 2022 Intel Corporation
#
# SPDX-License-Identifier: Apache 2.0
import os
import sys
import warnings
from codecs import open

from setuptools import find_packages, setup


if sys.version_info < (3, 6):
  warnings.warn(
    'Python versions lower than 3.6 are no longer supported.'
    ' Please upgrade to Python 3.6 or newer or use an older version of the sigopt-python client.',
    DeprecationWarning
  )

# NOTE: We can't `import {src}.version` directly, because that
# will cause us to execute `{src}/__init__.py`, which may transitively import
# packages that may not have been installed yet. So jump straight to {src}/version.py
# and execute that directly, which should be simple enough that it doesn't import anything
# Learned from https://github.com/stripe/stripe-python (MIT licensed)
version_contents = {}
here = os.path.abspath(os.path.dirname(__file__))
with open(os.path.join(here, 'sigoptlite', 'version.py'), encoding='utf-8') as f:
  exec(f.read(), version_contents)
VERSION = version_contents['VERSION']

with open(os.path.join(here, 'requirements.txt')) as requirements_fp:
  install_requires = requirements_fp.read().split('\n')

setup(
  name='sigoptlite',
  version=VERSION,
  description='SigOpt Server - Lite',
  author='SigOpt',
  author_email='sigopt.support@intel.com',
  url='https://sigopt.com/',
  packages=find_packages(exclude=['tests*']),
  package_data={
    '': ['*.ms', '*.txt', '*.yml', '*.yaml'],
  },
  install_requires=install_requires,
  classifiers=[
    "Development Status :: 1 - Planning",
    "Intended Audience :: Developers",
    "License :: OSI Approved :: Apache Software License",
    "Operating System :: OS Independent",
    "Programming Language :: Python",
    "Topic :: Software Development :: Libraries :: Python Modules",
  ],
)
