import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * (experimental) Properties for EmrCancelStep.
 *
 * @experimental
 */
export interface EmrCancelStepProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) The ClusterId to update.
     *
     * @experimental
     */
    readonly clusterId: string;
    /**
     * (experimental) The StepId to cancel.
     *
     * @experimental
     */
    readonly stepId: string;
}
/**
 * (experimental) A Step Functions Task to to cancel a Step on an EMR Cluster.
 *
 * @experimental
 */
export declare class EmrCancelStep extends sfn.TaskStateBase {
    private readonly props;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: EmrCancelStepProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
}
