# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['paroxython',
 'paroxython.cli',
 'paroxython.docs_developer_manual',
 'paroxython.docs_user_manual']

package_data = \
{'': ['*'], 'paroxython': ['resources/*']}

install_requires = \
['docopt>=0.6.2,<0.7.0',
 'regex>=2020.7.14,<2021.0.0',
 'typed-ast>=1.4.1,<2.0.0',
 'typing-extensions>=3.7.4.2,<4.0.0.0']

entry_points = \
{'console_scripts': ['paroxython = paroxython.cli.cli:main']}

setup_kwargs = {
    'name': 'paroxython',
    'version': '0.4.5',
    'description': 'Search Python code for algorithmic features',
    'long_description': '[![Build Status](https://travis-ci.com/laowantong/paroxython.svg?branch=master)](https://travis-ci.com/laowantong/paroxython)\n[![codecov](https://img.shields.io/codecov/c/github/laowantong/paroxython/master)](https://codecov.io/gh/laowantong/paroxython)\n[![Checked with mypy](https://img.shields.io/badge/typing-mypy-brightgreen)](http://mypy-lang.org/)\n[![Codacy Badge](https://api.codacy.com/project/badge/Grade/73432ed4c5294326ba6279bbbb0fe2e6)](https://www.codacy.com/manual/laowantong/paroxython)\n[![Updates](https://pyup.io/repos/github/laowantong/paroxython/shield.svg)](https://pyup.io/repos/github/laowantong/paroxython/)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/paroxython)\n[![GitHub Release](https://img.shields.io/github/release/laowantong/paroxython.svg?style=flat)]()\n![GitHub code size in bytes](https://img.shields.io/github/languages/code-size/laowantong/paroxython)\n![paroxython SLOC](https://img.shields.io/badge/main%20program-~1700%20SLOC-blue)\n![tests SLOC](https://img.shields.io/badge/tests-~2700%20SLOC-blue)\n![helpers SLOC](https://img.shields.io/badge/helpers-~800%20SLOC-blue)\n[![GitHub commit activity](https://img.shields.io/github/commit-activity/y/laowantong/paroxython.svg?style=flat)]()\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)\n![Band-aid](https://img.shields.io/badge/not%C2%A0%C2%A0%F0%9F%85%B3%F0%9F%85%B4%F0%9F%85%B0%F0%9F%85%B3-yet-%23F3D9C5?labelColor=%23F3D9C5)\n\n<p align="center">\n  <img src="docs/resources/logo.png">\n</p>\n\n### Introduction\n\nParoxython is a set of command line tools which **tag** a collection of Python programming exercises and **filter** them by algorithmic features.\n\n#### Audience\n\nYou are a teacher, in charge of an introductory programming course in an educational institution. Over the years, you have accumulated many—far too many—programs and code snippets that may be of interest to your students.\n\nOr, as a seasoned developer, you would like to share your knowledge by helping a loved one learn how to code. A cursory search for pedagogical material yields an overwhelming amount of websites and repositories stuffed with Python programs of various levels (e.g.,\n[1](https://github.com/TheAlgorithms/Python),\n[2](http://rosettacode.org/wiki/Category:Python),\n[3](https://www.programming-idioms.org/about#about-block-language-coverage),\n[4](https://github.com/codebasics/py),\n[5](https://github.com/keon/algorithms),\n[6](https://github.com/OmkarPathak/Python-Programs),\nand a lot more from [Awesome Python in Education](https://github.com/quobit/awesome-python-in-education)).\n\nIn any case, the Python source codes you have gathered are typically\n**numerous** (hundreds or even thousands),\n**reasonably sized** (anything below 1000 SLOC),\nand **educational** in nature (e.g., snippets, examples, quizzes, exercise solutions, classic algorithms).\nThe programming concepts you plan to teach remain relatively **low level** (e.g. assignments, nested loops, accumulation patterns, tail-recursive functions, etc.).\n\nIf all that sounds familiar, keep reading me.\n\n#### Main goals\n\nParoxython aims to help you select, from your collection, the one program that best suits your needs. For instance, it will gladly answer the following questions:\n\n> - How can this concept be illustrated?\n> - What problems use the same algorithmic and data structures as this one?\n> - What homework assignment should I give my students so they can practice the content of the last lesson?\n\nMoreover, since Paroxython knows what your class knows, it can recommend the right program at the right time:\n\n> - What would make a good review exercise?\n> - Which exercises can I give on this exam?\n> - What is the current learning cost of this example?\n\nIn the long run, Paroxython may guide you and somehow make you rethink your course outline:\n\n> - What are the prerequisites for the concept of assignment?\n> - Do I have enough material to introduce subroutines before I even talk about conditionals and loops?\n> - Among the loops, which must come first: the most powerful (`while`), or the most useful (`for`)?\n> - How to logically structure this bunch of usual iterative patterns?\n> - What are the _basics_, exactly?\n\nAll issues on which the author changed his mind since he started to work on this project!\n\nIn an ideal world, Paroxython could even put an end to the deadliest religious wars, with rational, data-driven arguments:\n\n> - Father, is it a sin to exit early?\n> - Should a real byte use a mask?\n\n#### How it works\n\nParoxython starts from a given folder of **programs**.\n\n<p align="center">\n  <img src="docs/resources/waterfall.png">\n</p>\n\nIts contents is parsed, and all features that meet the provided **specifications** are labelled and associated with their spanning lines (e.g., `"assignment_lhs_identifier:a": 4, 6, 18` or `"loop_with_late_exit:while": 3-7, 20-29`).\n\nThese **labels** constitute a scattered knowledge. The next step is to map them onto a **taxonomy** designed with basic hierarchical constraints in mind (e.g., the fact that the introduction of the concept of early exit must come after that of loop, which itself requires that of control flow, is expressed by the _taxon_ `"flow/loop/exit/early"`).\n\n<p align="center">\n  <a href="https://laowantong.github.io/paroxython/docs_user_manual/index.html#taxonomy">\n  <img src="docs/resources/tree.png" alt="A taxonomy.">\n  </a>\n  <br>\n  <em>Taxonomy generated from <a href="https://github.com/TheAlgorithms/Python">The Algorithms - Python</a>.<br>Click to jump to its dynamic version in the user manual.</em>\n</p>\n\nEverything is then persisted in a tag **database**, which can later be filtered through a **pipeline** of commands, for instance:\n\n- _include_ only the programs which feature a recursive function;\n- _exclude_ this or that program you want to set aside for the exam;\n- “_impart_” all programs studied so far, _i.e_, consider that all the notions they implement are acquired.\n\nThe result is a list of program **recommendations** ordered by increasing learning cost.\n\n#### Example\n\nSuppose that the `programs` directory contains [these simple programs](https://wiki.python.org/moin/SimplePrograms). First, build [this tag database](https://github.com/laowantong/paroxython/blob/master/examples/simple/programs_db.json):\n\n```shell\n> paroxython collect programs\nLabelling 21 programs.\nMapping taxonomy on 21 programs.\nWriting programs_db.json.\n```\n\nThen, filter it through [this pipeline](https://github.com/laowantong/paroxython/blob/master/examples/simple/programs_pipe.py):\n\n```shell\n> paroxython recommend -p programs_pipe.py programs_db.json\nProcessing 5 commands on 21 programs.\n  19 programs remaining after operation 1 (impart).\n  18 programs remaining after operation 2 (exclude).\n  12 programs remaining after operation 3 (exclude).\n  10 programs remaining after operation 4 (include).\n  10 programs remaining after operation 5 (hide).\nDumped: programs_recommendations.md.\n```\n\nEt voilà, [your recommendation report](https://github.com/laowantong/paroxython/blob/master/examples/simple/programs_recommendations.md)!\n\n\n### Installation and test-drive\n\n#### Command line\n\nMuch to no one\'s surprise:\n\n```\npip install paroxython\n```\n\nThe following command should print a help message and exit:\n\n```\nparoxython --help\n```\n\n#### IPython magic command\n\nIf you use Jupyter notebook/lab, you\'ve also just installed a so-called magic command. Load it like this:\n\n```python\n%load_ext paroxython\n```\n\nThis should print `"paroxython 0.4.5 loaded."`. Run it on a cell of Python code (line numbers added for clarity):\n\n```python\n1   %%paroxython\n2   def fibonacci(n):\n3       result = []\n4       (a, b) = (0, 1)\n5       while a < n:\n6           result.append(a)\n7           (a, b) = (b, a + b)\n8       return result\n```\n\n| Taxon | Lines |\n|:--|:--|\n| `call/method/sequence/list/append` | 6 |\n| `condition/inequality` | 5 |\n| `def/argument/arg` | 2 |\n| `def/function` | 2-8 |\n| `flow/loop/exit/late` | 5-7 |\n| `flow/loop/while` | 5-7 |\n| `meta/program` | 2-8 |\n| `meta/sloc/8` | 2-8 |\n| `operator/arithmetic/addition` | 7 |\n| `type/number/integer/literal` | 4 |\n| `type/number/integer/literal/zero` | 4 |\n| `type/sequence/list` | 6 |\n| `type/sequence/list/literal/empty` | 3 |\n| `type/sequence/tuple/literal` | 4, 4, 7, 7 |\n| `var/assignment/parallel` | 4 |\n| `var/assignment/parallel/slide` | 7 |\n| `var/assignment/single` | 3 |\n\n## Further reading\n\n- [User manual](https://laowantong.github.io/paroxython/docs_user_manual/index.html)\n- [Developer manual](https://laowantong.github.io/paroxython/docs_developer_manual/index.html)\n- [Module reference](https://laowantong.github.io/paroxython/#header-submodules)\n',
    'author': 'Aristide Grange',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/laowantong/paroxython/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
