# coding: utf-8

"""
    Hydrogen Integration API

    The Hydrogen Integration API  # noqa: E501

    OpenAPI spec version: 1.3.1
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from integration_api.api_client import ApiClient


class KMSApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_kms_using_post(self, kms_config, **kwargs):  # noqa: E501
        """Create an secret key  # noqa: E501

        Create an secret key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_kms_using_post(kms_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param KmsConfig kms_config: kmsConfig (required)
        :return: KmsConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_kms_using_post_with_http_info(kms_config, **kwargs)  # noqa: E501
        else:
            (data) = self.create_kms_using_post_with_http_info(kms_config, **kwargs)  # noqa: E501
            return data

    def create_kms_using_post_with_http_info(self, kms_config, **kwargs):  # noqa: E501
        """Create an secret key  # noqa: E501

        Create an secret key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_kms_using_post_with_http_info(kms_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param KmsConfig kms_config: kmsConfig (required)
        :return: KmsConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['kms_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_kms_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'kms_config' is set
        if self.api_client.client_side_validation and ('kms_config' not in params or
                                                       params['kms_config'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `kms_config` when calling `create_kms_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'kms_config' in params:
            body_params = params['kms_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/kms', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KmsConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_kms_using_delete(self, kms_id, **kwargs):  # noqa: E501
        """Delete an secret key value  # noqa: E501

        Permanently delete an secret key value under a tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_kms_using_delete(kms_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str kms_id: KMS Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_kms_using_delete_with_http_info(kms_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_kms_using_delete_with_http_info(kms_id, **kwargs)  # noqa: E501
            return data

    def delete_kms_using_delete_with_http_info(self, kms_id, **kwargs):  # noqa: E501
        """Delete an secret key value  # noqa: E501

        Permanently delete an secret key value under a tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_kms_using_delete_with_http_info(kms_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str kms_id: KMS Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['kms_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_kms_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'kms_id' is set
        if self.api_client.client_side_validation and ('kms_id' not in params or
                                                       params['kms_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `kms_id` when calling `delete_kms_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'kms_id' in params:
            path_params['kms_id'] = params['kms_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/kms/{kms_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_kms_all_using_get(self, **kwargs):  # noqa: E501
        """List all KMS Clients  # noqa: E501

        Get details for all clients registered with your business.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kms_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageKmsConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_kms_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_kms_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_kms_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all KMS Clients  # noqa: E501

        Get details for all clients registered with your business.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kms_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageKmsConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_kms_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/kms', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageKmsConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_kms_using_get(self, kms_id, **kwargs):  # noqa: E501
        """Retrieve an secret key value  # noqa: E501

        Retrieve the information for a specific value associated with a Secret key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kms_using_get(kms_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str kms_id: KMS Id (required)
        :return: KmsConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_kms_using_get_with_http_info(kms_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_kms_using_get_with_http_info(kms_id, **kwargs)  # noqa: E501
            return data

    def get_kms_using_get_with_http_info(self, kms_id, **kwargs):  # noqa: E501
        """Retrieve an secret key value  # noqa: E501

        Retrieve the information for a specific value associated with a Secret key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kms_using_get_with_http_info(kms_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str kms_id: KMS Id (required)
        :return: KmsConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['kms_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_kms_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'kms_id' is set
        if self.api_client.client_side_validation and ('kms_id' not in params or
                                                       params['kms_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `kms_id` when calling `get_kms_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'kms_id' in params:
            path_params['kms_id'] = params['kms_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/kms/{kms_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KmsConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_kms_using_put(self, kms_config, kms_id, **kwargs):  # noqa: E501
        """Update an Key Value  # noqa: E501

        Update the information for an key value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_kms_using_put(kms_config, kms_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param KmsConfig kms_config: kmsConfig (required)
        :param str kms_id: kms_id (required)
        :return: KmsConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_kms_using_put_with_http_info(kms_config, kms_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_kms_using_put_with_http_info(kms_config, kms_id, **kwargs)  # noqa: E501
            return data

    def update_kms_using_put_with_http_info(self, kms_config, kms_id, **kwargs):  # noqa: E501
        """Update an Key Value  # noqa: E501

        Update the information for an key value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_kms_using_put_with_http_info(kms_config, kms_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param KmsConfig kms_config: kmsConfig (required)
        :param str kms_id: kms_id (required)
        :return: KmsConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['kms_config', 'kms_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_kms_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'kms_config' is set
        if self.api_client.client_side_validation and ('kms_config' not in params or
                                                       params['kms_config'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `kms_config` when calling `update_kms_using_put`")  # noqa: E501
        # verify the required parameter 'kms_id' is set
        if self.api_client.client_side_validation and ('kms_id' not in params or
                                                       params['kms_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `kms_id` when calling `update_kms_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'kms_id' in params:
            path_params['kms_id'] = params['kms_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'kms_config' in params:
            body_params = params['kms_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/kms/{kms_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KmsConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
