# coding: utf-8

"""
    Hydrogen Integration API

    The Hydrogen Integration API  # noqa: E501

    OpenAPI spec version: 1.3.1
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from integration_api.api_client import ApiClient


class AsyncApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_async_data(self, integration_type, service, **kwargs):  # noqa: E501
        """Create async transaction for GET endpoints for bulk data  # noqa: E501

        Create async transaction for GET endpoints for bulk data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_async_data(integration_type, service, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str integration_type: String integration_type (required)
        :param str service: String service (required)
        :return: AsyncTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_async_data_with_http_info(integration_type, service, **kwargs)  # noqa: E501
        else:
            (data) = self.get_async_data_with_http_info(integration_type, service, **kwargs)  # noqa: E501
            return data

    def get_async_data_with_http_info(self, integration_type, service, **kwargs):  # noqa: E501
        """Create async transaction for GET endpoints for bulk data  # noqa: E501

        Create async transaction for GET endpoints for bulk data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_async_data_with_http_info(integration_type, service, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str integration_type: String integration_type (required)
        :param str service: String service (required)
        :return: AsyncTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_type', 'service']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_async_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'integration_type' is set
        if self.api_client.client_side_validation and ('integration_type' not in params or
                                                       params['integration_type'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `integration_type` when calling `get_async_data`")  # noqa: E501
        # verify the required parameter 'service' is set
        if self.api_client.client_side_validation and ('service' not in params or
                                                       params['service'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `service` when calling `get_async_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'integration_type' in params:
            path_params['integration_type'] = params['integration_type']  # noqa: E501
        if 'service' in params:
            path_params['service'] = params['service']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/async/{integration_type}/{service}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_async_data_bulk_using_post(self, data, integration_type, service, **kwargs):  # noqa: E501
        """Create async transaction for POST endpoints for bulk data  # noqa: E501

        Create async transaction for POST endpoints for bulk data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_async_data_bulk_using_post(data, integration_type, service, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param JsonNode data: data (required)
        :param str integration_type: String integration_type (required)
        :param str service: String service (required)
        :return: AsyncTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_async_data_bulk_using_post_with_http_info(data, integration_type, service, **kwargs)  # noqa: E501
        else:
            (data) = self.get_async_data_bulk_using_post_with_http_info(data, integration_type, service, **kwargs)  # noqa: E501
            return data

    def get_async_data_bulk_using_post_with_http_info(self, data, integration_type, service, **kwargs):  # noqa: E501
        """Create async transaction for POST endpoints for bulk data  # noqa: E501

        Create async transaction for POST endpoints for bulk data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_async_data_bulk_using_post_with_http_info(data, integration_type, service, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param JsonNode data: data (required)
        :param str integration_type: String integration_type (required)
        :param str service: String service (required)
        :return: AsyncTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data', 'integration_type', 'service']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_async_data_bulk_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in params or
                                                       params['data'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `data` when calling `get_async_data_bulk_using_post`")  # noqa: E501
        # verify the required parameter 'integration_type' is set
        if self.api_client.client_side_validation and ('integration_type' not in params or
                                                       params['integration_type'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `integration_type` when calling `get_async_data_bulk_using_post`")  # noqa: E501
        # verify the required parameter 'service' is set
        if self.api_client.client_side_validation and ('service' not in params or
                                                       params['service'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `service` when calling `get_async_data_bulk_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'integration_type' in params:
            path_params['integration_type'] = params['integration_type']  # noqa: E501
        if 'service' in params:
            path_params['service'] = params['service']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/async/{integration_type}/{service}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_async_data_by_id(self, id, integration_type, service, **kwargs):  # noqa: E501
        """Create async transaction for GET endpoints for bulk data  # noqa: E501

        Create async transaction for GET endpoints for bulk data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_async_data_by_id(id, integration_type, service, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: UUID id (required)
        :param str integration_type: String integration_type (required)
        :param str service: String service (required)
        :return: AsyncTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_async_data_by_id_with_http_info(id, integration_type, service, **kwargs)  # noqa: E501
        else:
            (data) = self.get_async_data_by_id_with_http_info(id, integration_type, service, **kwargs)  # noqa: E501
            return data

    def get_async_data_by_id_with_http_info(self, id, integration_type, service, **kwargs):  # noqa: E501
        """Create async transaction for GET endpoints for bulk data  # noqa: E501

        Create async transaction for GET endpoints for bulk data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_async_data_by_id_with_http_info(id, integration_type, service, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: UUID id (required)
        :param str integration_type: String integration_type (required)
        :param str service: String service (required)
        :return: AsyncTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'integration_type', 'service']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_async_data_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_async_data_by_id`")  # noqa: E501
        # verify the required parameter 'integration_type' is set
        if self.api_client.client_side_validation and ('integration_type' not in params or
                                                       params['integration_type'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `integration_type` when calling `get_async_data_by_id`")  # noqa: E501
        # verify the required parameter 'service' is set
        if self.api_client.client_side_validation and ('service' not in params or
                                                       params['service'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `service` when calling `get_async_data_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'integration_type' in params:
            path_params['integration_type'] = params['integration_type']  # noqa: E501
        if 'service' in params:
            path_params['service'] = params['service']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/async/{integration_type}/{service}/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_async_status(self, id, **kwargs):  # noqa: E501
        """Get Status of async transaction created through GET/POST endpoints  # noqa: E501

        Get Status of async transaction created through GET/POST endpoints  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_async_status(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: UUID Async Transaction Id (required)
        :return: AsyncTransactionVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_async_status_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_async_status_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_async_status_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get Status of async transaction created through GET/POST endpoints  # noqa: E501

        Get Status of async transaction created through GET/POST endpoints  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_async_status_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: UUID Async Transaction Id (required)
        :return: AsyncTransactionVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_async_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_async_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/async/status/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncTransactionVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
