# coding: utf-8

"""
    Hydrogen Integration API

    The Hydrogen Integration API  # noqa: E501

    OpenAPI spec version: 1.3.1
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from integration_api.api_client import ApiClient


class ACHApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cancel_ach_transfer_using_delete(self, nucleus_funding_id, **kwargs):  # noqa: E501
        """Cancel the ACH transfer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_ach_transfer_using_delete(nucleus_funding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_funding_id: nucleus_funding_id (required)
        :return: AchTransferResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_ach_transfer_using_delete_with_http_info(nucleus_funding_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_ach_transfer_using_delete_with_http_info(nucleus_funding_id, **kwargs)  # noqa: E501
            return data

    def cancel_ach_transfer_using_delete_with_http_info(self, nucleus_funding_id, **kwargs):  # noqa: E501
        """Cancel the ACH transfer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_ach_transfer_using_delete_with_http_info(nucleus_funding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_funding_id: nucleus_funding_id (required)
        :return: AchTransferResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nucleus_funding_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_ach_transfer_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nucleus_funding_id' is set
        if self.api_client.client_side_validation and ('nucleus_funding_id' not in params or
                                                       params['nucleus_funding_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `nucleus_funding_id` when calling `cancel_ach_transfer_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nucleus_funding_id' in params:
            path_params['nucleus_funding_id'] = params['nucleus_funding_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/{nucleus_funding_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AchTransferResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ach_bank_link_using_post(self, ach_bank_link_request_co, **kwargs):  # noqa: E501
        """Create bank link  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ach_bank_link_using_post(ach_bank_link_request_co, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchBankLinkRequestCO ach_bank_link_request_co: achBankLinkRequestCO (required)
        :return: AchBankLinkResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ach_bank_link_using_post_with_http_info(ach_bank_link_request_co, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ach_bank_link_using_post_with_http_info(ach_bank_link_request_co, **kwargs)  # noqa: E501
            return data

    def create_ach_bank_link_using_post_with_http_info(self, ach_bank_link_request_co, **kwargs):  # noqa: E501
        """Create bank link  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ach_bank_link_using_post_with_http_info(ach_bank_link_request_co, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchBankLinkRequestCO ach_bank_link_request_co: achBankLinkRequestCO (required)
        :return: AchBankLinkResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ach_bank_link_request_co']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ach_bank_link_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ach_bank_link_request_co' is set
        if self.api_client.client_side_validation and ('ach_bank_link_request_co' not in params or
                                                       params['ach_bank_link_request_co'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `ach_bank_link_request_co` when calling `create_ach_bank_link_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ach_bank_link_request_co' in params:
            body_params = params['ach_bank_link_request_co']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/bank_link', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AchBankLinkResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ach_beneficial_owner_using_post(self, beneficial_owner_request, **kwargs):  # noqa: E501
        """Create a beneficial owner  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ach_beneficial_owner_using_post(beneficial_owner_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchBeneficialOwnerRequestCO beneficial_owner_request: beneficialOwnerRequest (required)
        :return: AchBeneficialOwnerResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ach_beneficial_owner_using_post_with_http_info(beneficial_owner_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ach_beneficial_owner_using_post_with_http_info(beneficial_owner_request, **kwargs)  # noqa: E501
            return data

    def create_ach_beneficial_owner_using_post_with_http_info(self, beneficial_owner_request, **kwargs):  # noqa: E501
        """Create a beneficial owner  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ach_beneficial_owner_using_post_with_http_info(beneficial_owner_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchBeneficialOwnerRequestCO beneficial_owner_request: beneficialOwnerRequest (required)
        :return: AchBeneficialOwnerResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['beneficial_owner_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ach_beneficial_owner_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'beneficial_owner_request' is set
        if self.api_client.client_side_validation and ('beneficial_owner_request' not in params or
                                                       params['beneficial_owner_request'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `beneficial_owner_request` when calling `create_ach_beneficial_owner_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'beneficial_owner_request' in params:
            body_params = params['beneficial_owner_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/business/beneficial_owner', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AchBeneficialOwnerResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ach_business_using_post(self, business_request, **kwargs):  # noqa: E501
        """Create a business  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ach_business_using_post(business_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchBusinessRequestCO business_request: businessRequest (required)
        :return: AchBusinessResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ach_business_using_post_with_http_info(business_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ach_business_using_post_with_http_info(business_request, **kwargs)  # noqa: E501
            return data

    def create_ach_business_using_post_with_http_info(self, business_request, **kwargs):  # noqa: E501
        """Create a business  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ach_business_using_post_with_http_info(business_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchBusinessRequestCO business_request: businessRequest (required)
        :return: AchBusinessResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ach_business_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'business_request' is set
        if self.api_client.client_side_validation and ('business_request' not in params or
                                                       params['business_request'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `business_request` when calling `create_ach_business_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'business_request' in params:
            body_params = params['business_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/business', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AchBusinessResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ach_card_link_using_post(self, card_link_request_co, **kwargs):  # noqa: E501
        """Create an ACH card link  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ach_card_link_using_post(card_link_request_co, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchCardLinkRequestCO card_link_request_co: cardLinkRequestCO (required)
        :return: AchCardLinkResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ach_card_link_using_post_with_http_info(card_link_request_co, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ach_card_link_using_post_with_http_info(card_link_request_co, **kwargs)  # noqa: E501
            return data

    def create_ach_card_link_using_post_with_http_info(self, card_link_request_co, **kwargs):  # noqa: E501
        """Create an ACH card link  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ach_card_link_using_post_with_http_info(card_link_request_co, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchCardLinkRequestCO card_link_request_co: cardLinkRequestCO (required)
        :return: AchCardLinkResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['card_link_request_co']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ach_card_link_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'card_link_request_co' is set
        if self.api_client.client_side_validation and ('card_link_request_co' not in params or
                                                       params['card_link_request_co'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `card_link_request_co` when calling `create_ach_card_link_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'card_link_request_co' in params:
            body_params = params['card_link_request_co']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/card_link', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AchCardLinkResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ach_card_reserve_using_post(self, card_reserve_request_co, **kwargs):  # noqa: E501
        """Create an ACH card reserve  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ach_card_reserve_using_post(card_reserve_request_co, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchCardReserveRequestCO card_reserve_request_co: cardReserveRequestCO (required)
        :return: AchCardReserveResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ach_card_reserve_using_post_with_http_info(card_reserve_request_co, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ach_card_reserve_using_post_with_http_info(card_reserve_request_co, **kwargs)  # noqa: E501
            return data

    def create_ach_card_reserve_using_post_with_http_info(self, card_reserve_request_co, **kwargs):  # noqa: E501
        """Create an ACH card reserve  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ach_card_reserve_using_post_with_http_info(card_reserve_request_co, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchCardReserveRequestCO card_reserve_request_co: cardReserveRequestCO (required)
        :return: AchCardReserveResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['card_reserve_request_co']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ach_card_reserve_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'card_reserve_request_co' is set
        if self.api_client.client_side_validation and ('card_reserve_request_co' not in params or
                                                       params['card_reserve_request_co'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `card_reserve_request_co` when calling `create_ach_card_reserve_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'card_reserve_request_co' in params:
            body_params = params['card_reserve_request_co']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/card_reserve', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AchCardReserveResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ach_client_using_post(self, client_request, **kwargs):  # noqa: E501
        """Create a client  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ach_client_using_post(client_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchClientRequestCO client_request: clientRequest (required)
        :return: AchClientResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ach_client_using_post_with_http_info(client_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ach_client_using_post_with_http_info(client_request, **kwargs)  # noqa: E501
            return data

    def create_ach_client_using_post_with_http_info(self, client_request, **kwargs):  # noqa: E501
        """Create a client  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ach_client_using_post_with_http_info(client_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchClientRequestCO client_request: clientRequest (required)
        :return: AchClientResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ach_client_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_request' is set
        if self.api_client.client_side_validation and ('client_request' not in params or
                                                       params['client_request'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `client_request` when calling `create_ach_client_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'client_request' in params:
            body_params = params['client_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/client', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AchClientResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_ach_reserve_link_using_post(self, reserve_link_request_co, **kwargs):  # noqa: E501
        """Create an ACH reserve link  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ach_reserve_link_using_post(reserve_link_request_co, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchReserveLinkRequestCO reserve_link_request_co: reserveLinkRequestCO (required)
        :return: AchReserveLinkResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_ach_reserve_link_using_post_with_http_info(reserve_link_request_co, **kwargs)  # noqa: E501
        else:
            (data) = self.create_ach_reserve_link_using_post_with_http_info(reserve_link_request_co, **kwargs)  # noqa: E501
            return data

    def create_ach_reserve_link_using_post_with_http_info(self, reserve_link_request_co, **kwargs):  # noqa: E501
        """Create an ACH reserve link  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ach_reserve_link_using_post_with_http_info(reserve_link_request_co, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchReserveLinkRequestCO reserve_link_request_co: reserveLinkRequestCO (required)
        :return: AchReserveLinkResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['reserve_link_request_co']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ach_reserve_link_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'reserve_link_request_co' is set
        if self.api_client.client_side_validation and ('reserve_link_request_co' not in params or
                                                       params['reserve_link_request_co'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `reserve_link_request_co` when calling `create_ach_reserve_link_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'reserve_link_request_co' in params:
            body_params = params['reserve_link_request_co']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/reserve_link', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AchReserveLinkResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ach_bank_link_using_delete(self, nucleus_bank_link_id, **kwargs):  # noqa: E501
        """Delete bank link  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ach_bank_link_using_delete(nucleus_bank_link_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_bank_link_id: nucleus_bank_link_id (required)
        :return: AchBankLinkResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ach_bank_link_using_delete_with_http_info(nucleus_bank_link_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ach_bank_link_using_delete_with_http_info(nucleus_bank_link_id, **kwargs)  # noqa: E501
            return data

    def delete_ach_bank_link_using_delete_with_http_info(self, nucleus_bank_link_id, **kwargs):  # noqa: E501
        """Delete bank link  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ach_bank_link_using_delete_with_http_info(nucleus_bank_link_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_bank_link_id: nucleus_bank_link_id (required)
        :return: AchBankLinkResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nucleus_bank_link_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ach_bank_link_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nucleus_bank_link_id' is set
        if self.api_client.client_side_validation and ('nucleus_bank_link_id' not in params or
                                                       params['nucleus_bank_link_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `nucleus_bank_link_id` when calling `delete_ach_bank_link_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nucleus_bank_link_id' in params:
            path_params['nucleus_bank_link_id'] = params['nucleus_bank_link_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/bank_link/{nucleus_bank_link_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AchBankLinkResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fund_card_using_post(self, ach_card_request_co, **kwargs):  # noqa: E501
        """Fund card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fund_card_using_post(ach_card_request_co, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchCardRequestCO ach_card_request_co: achCardRequestCO (required)
        :return: AchCardResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.fund_card_using_post_with_http_info(ach_card_request_co, **kwargs)  # noqa: E501
        else:
            (data) = self.fund_card_using_post_with_http_info(ach_card_request_co, **kwargs)  # noqa: E501
            return data

    def fund_card_using_post_with_http_info(self, ach_card_request_co, **kwargs):  # noqa: E501
        """Fund card  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fund_card_using_post_with_http_info(ach_card_request_co, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchCardRequestCO ach_card_request_co: achCardRequestCO (required)
        :return: AchCardResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ach_card_request_co']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fund_card_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ach_card_request_co' is set
        if self.api_client.client_side_validation and ('ach_card_request_co' not in params or
                                                       params['ach_card_request_co'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `ach_card_request_co` when calling `fund_card_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ach_card_request_co' in params:
            body_params = params['ach_card_request_co']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/card', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AchCardResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ach_balance_using_get(self, portfolio_id, **kwargs):  # noqa: E501
        """Get balance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ach_balance_using_get(portfolio_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: portfolio_id (required)
        :param date end_date: end_date
        :param date start_date: start_date
        :return: AchBalanceResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ach_balance_using_get_with_http_info(portfolio_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ach_balance_using_get_with_http_info(portfolio_id, **kwargs)  # noqa: E501
            return data

    def get_ach_balance_using_get_with_http_info(self, portfolio_id, **kwargs):  # noqa: E501
        """Get balance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ach_balance_using_get_with_http_info(portfolio_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: portfolio_id (required)
        :param date end_date: end_date
        :param date start_date: start_date
        :return: AchBalanceResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_id', 'end_date', 'start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ach_balance_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_id' is set
        if self.api_client.client_side_validation and ('portfolio_id' not in params or
                                                       params['portfolio_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `portfolio_id` when calling `get_ach_balance_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_id' in params:
            path_params['portfolio_id'] = params['portfolio_id']  # noqa: E501

        query_params = []
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/balance/{portfolio_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AchBalanceResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ach_bank_link_using_get(self, nucleus_bank_link_id, **kwargs):  # noqa: E501
        """Get bank link  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ach_bank_link_using_get(nucleus_bank_link_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_bank_link_id: nucleus_bank_link_id (required)
        :return: AchBankLinkResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ach_bank_link_using_get_with_http_info(nucleus_bank_link_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ach_bank_link_using_get_with_http_info(nucleus_bank_link_id, **kwargs)  # noqa: E501
            return data

    def get_ach_bank_link_using_get_with_http_info(self, nucleus_bank_link_id, **kwargs):  # noqa: E501
        """Get bank link  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ach_bank_link_using_get_with_http_info(nucleus_bank_link_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_bank_link_id: nucleus_bank_link_id (required)
        :return: AchBankLinkResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nucleus_bank_link_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ach_bank_link_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nucleus_bank_link_id' is set
        if self.api_client.client_side_validation and ('nucleus_bank_link_id' not in params or
                                                       params['nucleus_bank_link_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `nucleus_bank_link_id` when calling `get_ach_bank_link_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nucleus_bank_link_id' in params:
            path_params['nucleus_bank_link_id'] = params['nucleus_bank_link_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/bank_link/{nucleus_bank_link_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AchBankLinkResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ach_bank_links_for_reserve_account_using_get(self, **kwargs):  # noqa: E501
        """Get bank links for a reserve account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ach_bank_links_for_reserve_account_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[AchBankLinkResponseVO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ach_bank_links_for_reserve_account_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_ach_bank_links_for_reserve_account_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_ach_bank_links_for_reserve_account_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get bank links for a reserve account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ach_bank_links_for_reserve_account_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[AchBankLinkResponseVO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ach_bank_links_for_reserve_account_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/bank_link/reserve', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AchBankLinkResponseVO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ach_business_balance_using_get(self, business_id, **kwargs):  # noqa: E501
        """Get business balance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ach_business_balance_using_get(business_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str business_id: business_id (required)
        :return: AchBalanceResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ach_business_balance_using_get_with_http_info(business_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ach_business_balance_using_get_with_http_info(business_id, **kwargs)  # noqa: E501
            return data

    def get_ach_business_balance_using_get_with_http_info(self, business_id, **kwargs):  # noqa: E501
        """Get business balance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ach_business_balance_using_get_with_http_info(business_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str business_id: business_id (required)
        :return: AchBalanceResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['business_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ach_business_balance_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'business_id' is set
        if self.api_client.client_side_validation and ('business_id' not in params or
                                                       params['business_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `business_id` when calling `get_ach_business_balance_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'business_id' in params:
            path_params['business_id'] = params['business_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/business/balance/{business_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AchBalanceResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ach_client_bank_links_using_get(self, nucleus_client_id, **kwargs):  # noqa: E501
        """Get client bank links  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ach_client_bank_links_using_get(nucleus_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_client_id: nucleus_client_id (required)
        :return: list[AchBankLinkResponseVO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ach_client_bank_links_using_get_with_http_info(nucleus_client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ach_client_bank_links_using_get_with_http_info(nucleus_client_id, **kwargs)  # noqa: E501
            return data

    def get_ach_client_bank_links_using_get_with_http_info(self, nucleus_client_id, **kwargs):  # noqa: E501
        """Get client bank links  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ach_client_bank_links_using_get_with_http_info(nucleus_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_client_id: nucleus_client_id (required)
        :return: list[AchBankLinkResponseVO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nucleus_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ach_client_bank_links_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nucleus_client_id' is set
        if self.api_client.client_side_validation and ('nucleus_client_id' not in params or
                                                       params['nucleus_client_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `nucleus_client_id` when calling `get_ach_client_bank_links_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nucleus_client_id' in params:
            path_params['nucleus_client_id'] = params['nucleus_client_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/bank_link/client/{nucleus_client_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AchBankLinkResponseVO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ach_status_using_get(self, nucleus_business_id, **kwargs):  # noqa: E501
        """Get the ACH status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ach_status_using_get(nucleus_business_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_business_id: nucleus_business_id (required)
        :return: AchTransferResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ach_status_using_get_with_http_info(nucleus_business_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ach_status_using_get_with_http_info(nucleus_business_id, **kwargs)  # noqa: E501
            return data

    def get_ach_status_using_get_with_http_info(self, nucleus_business_id, **kwargs):  # noqa: E501
        """Get the ACH status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ach_status_using_get_with_http_info(nucleus_business_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_business_id: nucleus_business_id (required)
        :return: AchTransferResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nucleus_business_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ach_status_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nucleus_business_id' is set
        if self.api_client.client_side_validation and ('nucleus_business_id' not in params or
                                                       params['nucleus_business_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `nucleus_business_id` when calling `get_ach_status_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'nucleus_business_id' in params:
            query_params.append(('nucleus_business_id', params['nucleus_business_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AchTransferResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ach_transfer_using_get(self, nucleus_funding_id, **kwargs):  # noqa: E501
        """Get the ACH transfer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ach_transfer_using_get(nucleus_funding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_funding_id: nucleus_funding_id (required)
        :return: AchTransferResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ach_transfer_using_get_with_http_info(nucleus_funding_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ach_transfer_using_get_with_http_info(nucleus_funding_id, **kwargs)  # noqa: E501
            return data

    def get_ach_transfer_using_get_with_http_info(self, nucleus_funding_id, **kwargs):  # noqa: E501
        """Get the ACH transfer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ach_transfer_using_get_with_http_info(nucleus_funding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_funding_id: nucleus_funding_id (required)
        :return: AchTransferResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nucleus_funding_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ach_transfer_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nucleus_funding_id' is set
        if self.api_client.client_side_validation and ('nucleus_funding_id' not in params or
                                                       params['nucleus_funding_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `nucleus_funding_id` when calling `get_ach_transfer_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nucleus_funding_id' in params:
            path_params['nucleus_funding_id'] = params['nucleus_funding_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/{nucleus_funding_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AchTransferResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_of_client_ach_transfers_using_get(self, nucleus_client_id, **kwargs):  # noqa: E501
        """Get a list of client's ACH transfers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_of_client_ach_transfers_using_get(nucleus_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_client_id: nucleus_client_id (required)
        :param int page: page
        :param int size: size
        :return: PageAchTransferResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_of_client_ach_transfers_using_get_with_http_info(nucleus_client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_of_client_ach_transfers_using_get_with_http_info(nucleus_client_id, **kwargs)  # noqa: E501
            return data

    def get_list_of_client_ach_transfers_using_get_with_http_info(self, nucleus_client_id, **kwargs):  # noqa: E501
        """Get a list of client's ACH transfers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_of_client_ach_transfers_using_get_with_http_info(nucleus_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_client_id: nucleus_client_id (required)
        :param int page: page
        :param int size: size
        :return: PageAchTransferResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nucleus_client_id', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_of_client_ach_transfers_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nucleus_client_id' is set
        if self.api_client.client_side_validation and ('nucleus_client_id' not in params or
                                                       params['nucleus_client_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `nucleus_client_id` when calling `get_list_of_client_ach_transfers_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nucleus_client_id' in params:
            path_params['nucleus_client_id'] = params['nucleus_client_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/client/{nucleus_client_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageAchTransferResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def submit_ach_transfer_using_post(self, transfer_request, **kwargs):  # noqa: E501
        """Submit an ACH transfer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit_ach_transfer_using_post(transfer_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchTransferRequestCO transfer_request: transferRequest (required)
        :return: AchTransferResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.submit_ach_transfer_using_post_with_http_info(transfer_request, **kwargs)  # noqa: E501
        else:
            (data) = self.submit_ach_transfer_using_post_with_http_info(transfer_request, **kwargs)  # noqa: E501
            return data

    def submit_ach_transfer_using_post_with_http_info(self, transfer_request, **kwargs):  # noqa: E501
        """Submit an ACH transfer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit_ach_transfer_using_post_with_http_info(transfer_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AchTransferRequestCO transfer_request: transferRequest (required)
        :return: AchTransferResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['transfer_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_ach_transfer_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'transfer_request' is set
        if self.api_client.client_side_validation and ('transfer_request' not in params or
                                                       params['transfer_request'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transfer_request` when calling `submit_ach_transfer_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'transfer_request' in params:
            body_params = params['transfer_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AchTransferResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ach_bank_link_using_put(self, nucleus_bank_link_id, **kwargs):  # noqa: E501
        """Update bank link  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ach_bank_link_using_put(nucleus_bank_link_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_bank_link_id: nucleus_bank_link_id (required)
        :return: AchBankLinkResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_ach_bank_link_using_put_with_http_info(nucleus_bank_link_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_ach_bank_link_using_put_with_http_info(nucleus_bank_link_id, **kwargs)  # noqa: E501
            return data

    def update_ach_bank_link_using_put_with_http_info(self, nucleus_bank_link_id, **kwargs):  # noqa: E501
        """Update bank link  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ach_bank_link_using_put_with_http_info(nucleus_bank_link_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str nucleus_bank_link_id: nucleus_bank_link_id (required)
        :return: AchBankLinkResponseVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nucleus_bank_link_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ach_bank_link_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nucleus_bank_link_id' is set
        if self.api_client.client_side_validation and ('nucleus_bank_link_id' not in params or
                                                       params['nucleus_bank_link_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `nucleus_bank_link_id` when calling `update_ach_bank_link_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nucleus_bank_link_id' in params:
            path_params['nucleus_bank_link_id'] = params['nucleus_bank_link_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/ach/bank_link/{nucleus_bank_link_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AchBankLinkResponseVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
