import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a git tag on GitHub
 *
 * @schema CfnTagProps
 */
export interface CfnTagProps {
    /**
     * The account owner of the repository. The name is not case sensitive.
     *
     * @schema CfnTagProps#Owner
     */
    readonly owner: string;
    /**
     * The name of the repository. The name is not case sensitive.
     *
     * @schema CfnTagProps#Repository
     */
    readonly repository: string;
    /**
     * The name of git tag.
     *
     * @schema CfnTagProps#Tag
     */
    readonly tag: string;
    /**
     * The SHA1 value for this reference.
     *
     * @schema CfnTagProps#Sha
     */
    readonly sha: string;
    /**
     * Indicates whether to force the update or to make sure the update is a fast-forward update. Leaving this out or setting it to false will make sure you're not overwriting work. This is used only during updates
     *
     * @schema CfnTagProps#Force
     */
    readonly force?: boolean;
}
/**
 * Converts an object of type 'CfnTagProps' to JSON representation.
 */
export declare function toJson_CfnTagProps(obj: CfnTagProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `GitHub::Git::Tag`
 *
 * @cloudformationResource GitHub::Git::Tag
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
 */
export declare class CfnTag extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "GitHub::Git::Tag";
    /**
     * Resource props.
     */
    readonly props: CfnTagProps;
    /**
     * Create a new `GitHub::Git::Tag`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnTagProps);
}
