"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchResult = exports.Matcher = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents a matcher that can perform special data matching
 * capabilities between a given pattern and a target.
 */
class Matcher {
    /**
     * Check whether the provided object is a subtype of the `IMatcher`.
     */
    static isMatcher(x) {
        return x && x instanceof Matcher;
    }
}
exports.Matcher = Matcher;
_a = JSII_RTTI_SYMBOL_1;
Matcher[_a] = { fqn: "@aws-cdk/assertions.Matcher", version: "1.146.0" };
/**
 * The result of `Match.test()`.
 */
class MatchResult {
    constructor(target) {
        this.failures = [];
        this.captures = new Map();
        this.finalized = false;
        this.target = target;
    }
    /**
     * DEPRECATED
     * @deprecated use recordFailure()
     */
    push(matcher, path, message) {
        jsiiDeprecationWarnings.print("@aws-cdk/assertions.MatchResult#push", "use recordFailure()");
        jsiiDeprecationWarnings._aws_cdk_assertions_Matcher(matcher);
        return this.recordFailure({ matcher, path, message });
    }
    /**
     * Record a new failure into this result at a specific path.
     */
    recordFailure(failure) {
        jsiiDeprecationWarnings._aws_cdk_assertions_MatchFailure(failure);
        this.failures.push(failure);
        return this;
    }
    /** Does the result contain any failures. If not, the result is a success */
    hasFailed() {
        return this.failures.length !== 0;
    }
    /** The number of failures */
    get failCount() {
        return this.failures.length;
    }
    /**
     * Compose the results of a previous match as a subtree.
     * @param id the id of the parent tree.
     */
    compose(id, inner) {
        jsiiDeprecationWarnings._aws_cdk_assertions_MatchResult(inner);
        const innerF = inner.failures;
        this.failures.push(...innerF.map(f => {
            return { path: [id, ...f.path], message: f.message, matcher: f.matcher };
        }));
        inner.captures.forEach((vals, capture) => {
            vals.forEach(value => this.recordCapture({ capture, value }));
        });
        return this;
    }
    /**
     * Prepare the result to be analyzed.
     * This API *must* be called prior to analyzing these results.
     */
    finished() {
        if (this.finalized) {
            return this;
        }
        if (this.failCount === 0) {
            this.captures.forEach((vals, cap) => cap._captured.push(...vals));
        }
        this.finalized = true;
        return this;
    }
    /**
     * Get the list of failures as human readable strings
     */
    toHumanStrings() {
        return this.failures.map(r => {
            const loc = r.path.length === 0 ? '' : ` at ${r.path.join('')}`;
            return '' + r.message + loc + ` (using ${r.matcher.name} matcher)`;
        });
    }
    /**
     * Record a capture against in this match result.
     */
    recordCapture(options) {
        jsiiDeprecationWarnings._aws_cdk_assertions_MatchCapture(options);
        let values = this.captures.get(options.capture);
        if (values === undefined) {
            values = [];
        }
        values.push(options.value);
        this.captures.set(options.capture, values);
    }
}
exports.MatchResult = MatchResult;
_b = JSII_RTTI_SYMBOL_1;
MatchResult[_b] = { fqn: "@aws-cdk/assertions.MatchResult", version: "1.146.0" };
//# sourceMappingURL=data:application/json;base64,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